<?php
/**
 * 🔧 CONFIGURADOR AUTOMÁTICO CPANEL
 * Este script cria automaticamente os arquivos necessários
 * Execute uma vez para configurar tudo
 */

echo "<h1>🔧 Configurador Automático cPanel/LiteSpeed</h1>";
echo "<style>
    body { font-family: Arial, sans-serif; margin: 20px; }
    .success { color: green; font-weight: bold; }
    .error { color: red; font-weight: bold; }
    .info { background: #e7f3ff; padding: 15px; border-left: 4px solid #2196f3; margin: 10px 0; }
    .step { background: #f8f9fa; padding: 15px; margin: 10px 0; border-radius: 5px; }
</style>";

$base_path = '/home12/kubonet/admin';
$errors = [];
$success = [];

// Verificar se diretório existe
if (!is_dir($base_path)) {
    echo "<div class='error'>❌ Diretório $base_path não existe!</div>";
    echo "<div class='info'>Execute este script no servidor correto.</div>";
    exit;
}

echo "<div class='info'>";
echo "<h2>📋 Configuração Automática Iniciada</h2>";
echo "<p>Criando arquivos de configuração para LiteSpeed...</p>";
echo "</div>";

// 1. Criar .user.ini
echo "<div class='step'>";
echo "<h3>1️⃣ Criando .user.ini</h3>";

$user_ini_content = '; .user.ini para LiteSpeed - kubonet.com.br/admin
; Configurações automáticas

memory_limit = 512M
max_execution_time = 300
max_input_time = 300
max_input_vars = 3000

upload_max_filesize = 100M
post_max_size = 100M
file_uploads = On

display_errors = On
log_errors = On
error_reporting = E_ALL & ~E_NOTICE & ~E_DEPRECATED
error_log = /home12/kubonet/admin/php_errors.log

session.save_path = /home12/kubonet/admin/sessions
session.gc_maxlifetime = 7200

date.timezone = "America/Sao_Paulo"

; auto_prepend_file será adicionado depois
';

if (file_put_contents($base_path . '/.user.ini', $user_ini_content)) {
    echo "<div class='success'>✅ .user.ini criado com sucesso</div>";
    $success[] = '.user.ini';
} else {
    echo "<div class='error'>❌ Erro ao criar .user.ini</div>";
    $errors[] = '.user.ini';
}
echo "</div>";

// 2. Criar prepend.php
echo "<div class='step'>";
echo "<h3>2️⃣ Criando prepend.php</h3>";

$prepend_content = '<?php
// PREPEND.PHP - Forçar configurações PHP
// Carregado automaticamente antes de qualquer script

// Configurações críticas
ini_set("memory_limit", "512M");
ini_set("max_execution_time", "300");
ini_set("upload_max_filesize", "100M");
ini_set("post_max_size", "100M");
ini_set("max_input_vars", "3000");
ini_set("display_errors", "1");
ini_set("log_errors", "1");
ini_set("error_reporting", E_ALL & ~E_NOTICE & ~E_DEPRECATED);
ini_set("date.timezone", "America/Sao_Paulo");

// Criar diretórios necessários
$dirs = [
    "/home12/kubonet/admin/sessions",
    "/home12/kubonet/admin/logs", 
    "/home12/kubonet/admin/temp"
];

foreach ($dirs as $dir) {
    if (!is_dir($dir)) {
        @mkdir($dir, 0755, true);
    }
}

// Log de ativação
$log_msg = "[" . date("Y-m-d H:i:s") . "] PREPEND: Configurações ativadas\\n";
@file_put_contents("/home12/kubonet/admin/php_errors.log", $log_msg, FILE_APPEND);
?>';

if (file_put_contents($base_path . '/prepend.php', $prepend_content)) {
    echo "<div class='success'>✅ prepend.php criado com sucesso</div>";
    $success[] = 'prepend.php';
} else {
    echo "<div class='error'>❌ Erro ao criar prepend.php</div>";
    $errors[] = 'prepend.php';
}
echo "</div>";

// 3. Criar .htaccess local
echo "<div class='step'>";
echo "<h3>3️⃣ Criando .htaccess local</h3>";

$htaccess_content = '# LiteSpeed Configuration - kubonet.com.br/admin
# Configurações específicas para esta pasta

# Configurações PHP diretas
php_value memory_limit 512M
php_value max_execution_time 300
php_value upload_max_filesize 100M
php_value post_max_size 100M
php_value max_input_vars 3000

# Erro e debug
php_flag display_errors On
php_flag log_errors On
php_value error_log /home12/kubonet/admin/php_errors.log

# Auto-prepend (será habilitado após criar prepend.php)
# php_value auto_prepend_file /home12/kubonet/admin/prepend.php

# Sessões
php_value session.save_path /home12/kubonet/admin/sessions

# Timezone
php_value date.timezone "America/Sao_Paulo"

# Segurança
<Files "*.log">
    Order allow,deny
    Deny from all
</Files>

<Files "prepend.php">
    Order allow,deny
    Deny from all
</Files>
';

if (file_put_contents($base_path . '/.htaccess', $htaccess_content)) {
    echo "<div class='success'>✅ .htaccess criado com sucesso</div>";
    $success[] = '.htaccess';
} else {
    echo "<div class='error'>❌ Erro ao criar .htaccess</div>";
    $errors[] = '.htaccess';
}
echo "</div>";

// 4. Criar diretórios necessários
echo "<div class='step'>";
echo "<h3>4️⃣ Criando diretórios</h3>";

$directories = [
    $base_path . '/sessions',
    $base_path . '/logs',
    $base_path . '/temp'
];

foreach ($directories as $dir) {
    if (!is_dir($dir)) {
        if (mkdir($dir, 0755, true)) {
            echo "<div class='success'>✅ Diretório criado: " . basename($dir) . "</div>";
        } else {
            echo "<div class='error'>❌ Erro ao criar: " . basename($dir) . "</div>";
        }
    } else {
        echo "<div class='success'>✅ Diretório já existe: " . basename($dir) . "</div>";
    }
}
echo "</div>";

// 5. Definir permissões
echo "<div class='step'>";
echo "<h3>5️⃣ Definindo permissões</h3>";

$files_to_chmod = [
    $base_path . '/.user.ini' => 0644,
    $base_path . '/prepend.php' => 0644,
    $base_path . '/.htaccess' => 0644
];

foreach ($files_to_chmod as $file => $perm) {
    if (file_exists($file)) {
        if (chmod($file, $perm)) {
            echo "<div class='success'>✅ Permissão definida: " . basename($file) . " (" . decoct($perm) . ")</div>";
        } else {
            echo "<div class='error'>❌ Erro de permissão: " . basename($file) . "</div>";
        }
    }
}
echo "</div>";

// 6. Ativar prepend.php após criação
echo "<div class='step'>";
echo "<h3>6️⃣ Ativando auto_prepend_file</h3>";

if (file_exists($base_path . '/prepend.php')) {
    // Atualizar .user.ini para incluir prepend
    $user_ini_updated = str_replace(
        '; auto_prepend_file será adicionado depois',
        'auto_prepend_file = /home12/kubonet/admin/prepend.php',
        file_get_contents($base_path . '/.user.ini')
    );
    
    if (file_put_contents($base_path . '/.user.ini', $user_ini_updated)) {
        echo "<div class='success'>✅ auto_prepend_file ativado no .user.ini</div>";
    }
    
    // Atualizar .htaccess para incluir prepend
    $htaccess_updated = str_replace(
        '# php_value auto_prepend_file /home12/kubonet/admin/prepend.php',
        'php_value auto_prepend_file /home12/kubonet/admin/prepend.php',
        file_get_contents($base_path . '/.htaccess')
    );
    
    if (file_put_contents($base_path . '/.htaccess', $htaccess_updated)) {
        echo "<div class='success'>✅ auto_prepend_file ativado no .htaccess</div>";
    }
} else {
    echo "<div class='error'>❌ prepend.php não foi criado, pulando ativação</div>";
}
echo "</div>";

// Resumo final
echo "<div class='step'>";
echo "<h2>📊 Resumo da Configuração</h2>";

if (count($success) >= 3) {
    echo "<div class='success'>";
    echo "<h3>🎉 CONFIGURAÇÃO CONCLUÍDA COM SUCESSO!</h3>";
    echo "<p>Arquivos criados: " . implode(', ', $success) . "</p>";
    echo "</div>";
    
    echo "<div class='info'>";
    echo "<h3>🚀 Próximos Passos:</h3>";
    echo "<ol>";
    echo "<li><strong>Aguarde 2-3 minutos</strong> (cache do LiteSpeed)</li>";
    echo "<li><strong>Acesse:</strong> <a href='https://kubonet.com.br/admin/info.php' target='_blank'>https://kubonet.com.br/admin/info.php</a></li>";
    echo "<li><strong>Verifique:</strong> memory_limit deve ser 512M</li>";
    echo "<li><strong>Se não funcionar:</strong> Use o MultiPHP INI Editor do cPanel</li>";
    echo "</ol>";
    echo "</div>";
    
} else {
    echo "<div class='error'>";
    echo "<h3>❌ PROBLEMAS NA CONFIGURAÇÃO</h3>";
    echo "<p>Erros em: " . implode(', ', $errors) . "</p>";
    echo "<p>Verifique permissões do diretório e tente novamente.</p>";
    echo "</div>";
}

echo "<div class='info'>";
echo "<h3>🛠️ Alternativas se não funcionar:</h3>";
echo "<ul>";
echo "<li><strong>cPanel → MultiPHP INI Editor:</strong> Configure manualmente</li>";
echo "<li><strong>LiteSpeed Cache:</strong> Limpe o cache (Purge All)</li>";
echo "<li><strong>Suporte:</strong> Abra ticket informando que precisa usar php.ini customizado</li>";
echo "</ul>";
echo "</div>";

echo "</div>";

echo "<hr>";
echo "<p><small>Configuração executada em: " . date('Y-m-d H:i:s') . "</small></p>";
?>