'use strict';

// Função principal que inicializa os gráficos com dados do banco
document.addEventListener('DOMContentLoaded', function () {
  setTimeout(function () {
    initializeCustomCharts();
  }, 500);
});

function initializeCustomCharts() {
  // Verificar se os elementos existem antes de renderizar
  if (document.querySelector('#usuarios-graph')) {
    renderUsuariosGraph();
  }
  
  if (document.querySelector('#agendas-graph')) {
    renderAgendasGraph();
  }
  
  if (document.querySelector('#produtos-graph')) {
    renderProdutosGraph();
  }
  
  if (document.querySelector('#blog-graph')) {
    renderBlogGraph();
  }
  
  if (document.querySelector('#agenda-situacao-graph')) {
    renderAgendaSituacaoGraph();
  }
}

function renderUsuariosGraph() {
  var options = {
    chart: { 
      type: 'area', 
      height: 50, 
      sparkline: { enabled: true },
      animations: {
        enabled: true,
        easing: 'easeinout',
        speed: 800
      }
    },
    colors: ['#4680FF'],
    fill: {
      type: 'gradient',
      gradient: {
        shadeIntensity: 1,
        type: 'vertical',
        inverseColors: false,
        opacityFrom: 0.5,
        opacityTo: 0.1
      }
    },
    stroke: { curve: 'smooth', width: 2 },
    series: [{ 
      name: 'Usuários',
      data: [1, 2, 2, 2, 2] 
    }],
    tooltip: {
      fixed: { enabled: false },
      x: { show: false },
      y: {
        title: {
          formatter: function (seriesName) {
            return 'Usuários: ';
          }
        }
      }
    }
  };
  
  var chart = new ApexCharts(document.querySelector('#usuarios-graph'), options);
  chart.render();
}

function renderAgendasGraph() {
  var options = {
    chart: { 
      type: 'area', 
      height: 50, 
      sparkline: { enabled: true },
      animations: {
        enabled: true,
        easing: 'easeinout',
        speed: 800
      }
    },
    colors: ['#E58A00'],
    fill: {
      type: 'gradient',
      gradient: {
        shadeIntensity: 1,
        type: 'vertical',
        inverseColors: false,
        opacityFrom: 0.5,
        opacityTo: 0.1
      }
    },
    stroke: { curve: 'smooth', width: 2 },
    series: [{ 
      name: 'Agendas',
      data: [2, 3, 4, 5, 5] 
    }],
    tooltip: {
      fixed: { enabled: false },
      x: { show: false },
      y: {
        title: {
          formatter: function (seriesName) {
            return 'Agendas: ';
          }
        }
      }
    }
  };
  
  var chart = new ApexCharts(document.querySelector('#agendas-graph'), options);
  chart.render();
}

function renderProdutosGraph() {
  var options = {
    chart: { 
      type: 'area', 
      height: 50, 
      sparkline: { enabled: true },
      animations: {
        enabled: true,
        easing: 'easeinout',
        speed: 800
      }
    },
    colors: ['#2CA87F'],
    fill: {
      type: 'gradient',
      gradient: {
        shadeIntensity: 1,
        type: 'vertical',
        inverseColors: false,
        opacityFrom: 0.5,
        opacityTo: 0.1
      }
    },
    stroke: { curve: 'smooth', width: 2 },
    series: [{ 
      name: 'Produtos',
      data: [1, 2, 2, 3, 3] 
    }],
    tooltip: {
      fixed: { enabled: false },
      x: { show: false },
      y: {
        title: {
          formatter: function (seriesName) {
            return 'Produtos: ';
          }
        }
      }
    }
  };
  
  var chart = new ApexCharts(document.querySelector('#produtos-graph'), options);
  chart.render();
}

function renderBlogGraph() {
  var options = {
    chart: { 
      type: 'area', 
      height: 50, 
      sparkline: { enabled: true },
      animations: {
        enabled: true,
        easing: 'easeinout',
        speed: 800
      }
    },
    colors: ['#DC2626'],
    fill: {
      type: 'gradient',
      gradient: {
        shadeIntensity: 1,
        type: 'vertical',
        inverseColors: false,
        opacityFrom: 0.5,
        opacityTo: 0.1
      }
    },
    stroke: { curve: 'smooth', width: 2 },
    series: [{ 
      name: 'Posts',
      data: [0, 0, 1, 1, 1] 
    }],
    tooltip: {
      fixed: { enabled: false },
      x: { show: false },
      y: {
        title: {
          formatter: function (seriesName) {
            return 'Posts: ';
          }
        }
      }
    }
  };
  
  var chart = new ApexCharts(document.querySelector('#blog-graph'), options);
  chart.render();
}

function renderAgendaSituacaoGraph() {
  // Dados baseados no banco: 1 Atendido, 1 Não compareceu, 1 Cancelado pelo profissional, 1 Remarcado, 1 Cancelado pelo paciente
  var agendaSituacaoData = [1, 1, 1, 1, 1];
  var agendaSituacaoLabels = ['Atendido', 'Não compareceu', 'Cancelado pelo profissional', 'Remarcado', 'Cancelado pelo paciente'];

  var options = {
    chart: {
      type: 'donut',
      height: 350,
      animations: {
        enabled: true,
        easing: 'easeinout',
        speed: 800
      }
    },
    series: agendaSituacaoData,
    colors: ['#2CA87F', '#DC2626', '#E58A00', '#4680FF', '#6c757d'],
    labels: agendaSituacaoLabels,
    legend: {
      position: 'bottom',
      fontSize: '12px',
      fontFamily: 'Inter, sans-serif'
    },
    plotOptions: {
      pie: {
        donut: {
          size: '65%',
          labels: {
            show: true,
            name: {
              show: true,
              fontSize: '14px',
              fontFamily: 'Inter, sans-serif',
              fontWeight: 600
            },
            value: {
              show: true,
              fontSize: '18px',
              fontFamily: 'Inter, sans-serif',
              fontWeight: 400,
              formatter: function (val) {
                return val
              }
            },
            total: {
              show: true,
              showAlways: false,
              label: 'Total',
              fontSize: '14px',
              fontFamily: 'Inter, sans-serif',
              fontWeight: 600,
              color: '#373d3f',
              formatter: function (w) {
                return w.globals.seriesTotals.reduce((a, b) => {
                  return a + b
                }, 0)
              }
            }
          }
        }
      }
    },
    dataLabels: {
      enabled: true,
      style: {
        fontSize: '12px',
        fontFamily: 'Inter, sans-serif',
        fontWeight: 'bold'
      },
      dropShadow: {
        enabled: false
      }
    },
    responsive: [{
      breakpoint: 480,
      options: {
        chart: {
          width: 300
        },
        legend: {
          position: 'bottom'
        }
      }
    }],
    tooltip: {
      style: {
        fontSize: '12px',
        fontFamily: 'Inter, sans-serif'
      }
    }
  };
  
  var chart = new ApexCharts(document.querySelector('#agenda-situacao-graph'), options);
  chart.render();
}

// Função para atualizar dados em tempo real (opcional)
function updateChartData() {
  // Esta função pode ser chamada via AJAX para atualizar os gráficos
  // com dados mais recentes do banco de dados
  console.log('Atualizando dados dos gráficos...');
}

// Exportar funções se necessário
if (typeof module !== 'undefined' && module.exports) {
  module.exports = {
    initializeCustomCharts,
    updateChartData
  };
}