<!DOCTYPE html>
<html lang="pt-br">

<head>
    <title>${config_site_title}
        <?php if (isset($data['config']->config_site_slogan) && !empty($data['config']->config_site_slogan)) : ?>
            - ${config_site_slogan}
        <?php endif; ?>
    </title>
    <!-- SEO -->
    @(tema.loja.partials.meta_tags)
    @(tema.loja.partials.og_tags)
    <!-- SEO -->
    <link rel="icon" type="image/png" sizes="32x32" href="${baseUri}/media/site/${config_site_favicon}">
    @(tema.loja.partials.css-padrao)
</head>

<body>
    <!-- SEO -->
    @(tema.loja.partials.google_analytics)
    @(tema.loja.partials.google_tag_manager)
    <!-- SEO -->

    @(tema.loja.partials.menu-superior)


    <div class="hide-on-desk" style="position: relative; margin-top: 100px !important"></div>


    <div class="${config_site_layout_custom} pt-5 pb-4" id="vm">
        <div class="page-title-wrapper" aria-label="Page title">
            <div class="container">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="mt-n1 mr-1"><i data-feather="home" class="custom_loja_texto"></i></li>
                        <li class="breadcrumb-item"><a class="custom_loja_texto" href="${baseUri}">Home</a>
                        </li>
                        <li class="breadcrumb-item active"><a class="custom_loja_texto" href="#">Checkout</a>
                        </li>
                    </ol>
                </nav>
            </div>
        </div>
        <!-- Steps (wizard)-->
        <div class="steps">
            <div class="steps-body">
                <a class="step step-completed custom_loja_texto" href="${baseUri}/carrinho">
                    <span class="step-indicator"><i data-feather="check"></i></span>
                    <span class="step-icon "><i data-feather="shopping-bag" class="custom_loja_texto"></i></span>1. Carrinho
                </a>
                <a class="step step-completed custom_loja_texto" href="#" v-on:click="goToFrete()">
                    <span class="step-indicator"><i data-feather="check"></i></span>
                    <span class="step-icon"><i data-feather="truck" class="custom_loja_texto"></i></span>2. Frete
                </a>
                <a class="step step-active custom_loja_texto">
                    <span class="step-icon"><i data-feather="credit-card" class="custom_loja_texto"></i></span>3. Pagamento
                </a>
                <a class="step custom_loja_texto" href="#" style="cursor: not-allowed	;"><span class="step-icon custom_loja_texto"><i data-feather="check-circle"></i></span>4. Detalhes do pedido</a>
            </div>
        </div>
        <div class="row pt-4 mt-2">
            <!-- Content-->
            <input type="hidden" id="pay_key" value="<?= $data['gateway']->pay_key; ?>">
            <input type="hidden" id="pay_user" value="<?= $data['gateway']->pay_user; ?>">
            <input type="hidden" id="maxInstallments" value="<?= $data['maxInstallments']; ?>">
            <input type="hidden" id="sessionPagseguro" value="<?= (string)$data['sessionPagseguro']; ?>">
            <input type="hidden" id="sender_hash" value="">
            <input type="hidden" id="installmentValue" value="">
            <input type="hidden" id="pagseguro_semjuros" value="<?= $data['pagseguro_semjuros']; ?>">



            <div class="col-xl-9 col-md-8">
                <!-- Possíveis campos extras -->
                <div v-if="campos_extras != null">
                    <h2 class="h6 px-4 py-3 bg-secondary mb-4 custom_menu_texto_no_hover">Preencha o formulário abaixo antes de realizar o pagamento</h2>
                    <div class="row" v-for="campo in campos_extras">
                        <div class="col-sm-12">
                            <label class="custom_loja_texto" :for="'campo-extra-' + campo.campo_checkout_id">{{ campo.campo_checkout_nome }} <span class="text-danger">*</span> </label>
                            <input type="text" class="form-control campos_checkout" :data-id="campo.campo_checkout_id" :data-pergunta="campo.campo_checkout_nome">
                            <br>
                        </div>
                    </div>

                </div>
                <!-- Possíveis campos extras -->
                <h2 class="h6 px-4 py-3 bg-secondary mb-4 custom_menu_fundo custom_menu_texto_no_hover">Opções de pagamento</h2>
                <div class="accordion mb-4" id="payment-method" role="tablist">
                    <!-- Card de cartão de crédito -->
                    <div class="card">
                        <div class="card-header custom_loja_fundo" role="tab">
                            <h3 class="accordion-heading">
                                <a href="#card" class="collapsed custom_loja_texto" data-toggle="collapse">
                                    <i class="fa fa-credit-card mr-2 mt-n1"></i>Pague com Cartão de Crédito
                                    <span class="accordion-indicator"><i data-feather="chevron-up"></i></span>

                                </a>
                            </h3>
                        </div>
                        <div class="collapse show" id="card" data-parent="#payment-method" role="tabpanel">
                            <div class="card-body custom_loja_fundo">
                                <div class="card-wrapper"></div>
                                <form class="interactive-credit-card row" method="post" action="${baseUri}/PagamentoFront/checkoutMercadoPago" role="form" id="pay" name="pay">
                                    <input type="hidden" id="card_token">
                                    <input type="hidden" id="card_brand">
                                    <div class="form-group col-sm-6">
                                        <input class="form-control cpfCnpj" id="docNumber2" type="text" placeholder="CPF/CNPJ do titular" onselectstart="return false" onpaste="return false" oncopy="return false" oncut="return false" ondrag="return false" ondrop="return false" autocomplete=off />
                                        <input class="form-control" id="docNumber" name="docNumber" data-checkout="docNumber" type="hidden" />
                                    </div>
                                    <div class="form-group col-sm-6">
                                        <input class="form-control cardField" name="cardNumber" id="cardNumber" data-checkout="cardNumber" onselectstart="return false" onpaste="return false" oncopy="return false" oncut="return false" ondrag="return false" ondrop="return false" autocomplete=off type="text" placeholder="Número do cartão" required>
                                    </div>
                                    <div class="form-group col-sm-6">
                                        <input class="form-control cardField" name="cardholderName" type="text" id="cardholderName" data-checkout="cardholderName" type="text" placeholder="Nome completo" required>
                                    </div>
                                    <div class="form-group col-sm-3">
                                        <!-- <input class="form-control cardField two-numbers" type="text" id="cardExpirationMonth" data-checkout="cardExpirationMonth" onselectstart="return false" onpaste="return false" oncopy="return false" oncut="return false" ondrag="return false" ondrop="return false" autocomplete=off placeholder="Mês (Ex: 05)" required> -->
                                        <select id="cardExpirationMonth" class="form-control">
                                            <option>Mês</option>
                                            <option value="01">01</option>
                                            <option value="02">02</option>
                                            <option value="03">03</option>
                                            <option value="04">04</option>
                                            <option value="05">05</option>
                                            <option value="06">06</option>
                                            <option value="07">07</option>
                                            <option value="08">08</option>
                                            <option value="09">09</option>
                                            <option value="10">10</option>
                                            <option value="11">11</option>
                                            <option value="12">12</option>
                                        </select>
                                    </div>
                                    <div class="form-group col-sm-3">
                                        <!-- <input class="form-control cardField four-numbers" type="text" id="cardExpirationYear" data-checkout="cardExpirationYear" onselectstart="return false" onpaste="return false" oncopy="return false" oncut="return false" ondrag="return false" ondrop="return false" autocomplete=off placeholder="Ano (Ex: 2030)" required> -->
                                        <select id="cardExpirationYear" class="form-control">
                                            <option checked>Ano</option>
                                            <option v-if="ano != []" v-for="ano of anos" :value="ano">{{ ano }}</option>
                                        </select>
                                    </div>
                                    <div class="col-sm-6">
                                        <input class="form-control cardField numbers" name="securityCode" id="securityCode" placeholder="CVC" data-checkout="securityCode" type="text" onselectstart="return false" onpaste="return false" oncopy="return false" oncut="return false" ondrag="return false" ondrop="return false" autocomplete=off>
                                    </div>
                                    <div class="col-sm-6">
                                        <select id="card_parcela" class="form-control">
                                            <option>Para ver as parcelas, digite os dados do cartão</option>
                                        </select>
                                    </div>

                                    <input type="hidden" name="transactionAmount" id="transactionAmount" />
                                    <input type="hidden" name="description" id="description" />
                                </form>
                                <div class="col-sm-12 text-center pt-3">
                                    <button v-if="!cardIsValid" class="btn btn-outline-primary mt-0" id="verificar-dados"> Aguardando Preenchimento...</button>
                                    <button v-else class="btn btn-success mt-0" v-on:click="payment()">Finalizar Compra</button>

                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Card de Boleto -->
                    <?php if (intval($data['boleto_ativo']) > 0) : ?>
                        <input type="hidden" id="desconto_boleto" value="<?= $data['desconto_boleto'] ?>">
                        <div class="card">
                            <div class="card-header custom_loja_fundo" role="tab">
                                <h3 class="accordion-heading">
                                    <a href="#boleto" data-toggle="collapse" class="custom_loja_texto">
                                        <i class="fa fa-barcode mr-2 custom_loja_texto"></i>Pague com Boleto
                                        <span class="accordion-indicator"><i data-feather="chevron-up"></i></span>
                                    </a>
                                </h3>
                            </div>
                            <div class="collapse" id="boleto" data-parent="#payment-method" role="tabpanel">
                                <div class="card-body custom_loja_fundo">
                                    <div class="row">
                                        <div class="col-sm-12 text-center" v-if="descontoBoleto">
                                            <h3 v-if="totalBoleto != null" class="custom_loja_texto">Total: {{ totalBoleto.toLocaleString('pt-BR', { style: 'currency', currency: 'BRL' }) }}</h3>
                                            <h5 class="text-success custom_loja_texto" v-if="valorDescontoBoleto != null">{{ valorDescontoBoleto }} % de Desconto</h5>
                                        </div>
                                        <div class="col-sm-12 text-center" v-else>
                                            <h3 v-if="totalBoleto != null">Total: {{ totalBoleto.toLocaleString('pt-BR', { style: 'currency', currency: 'BRL' }) }}</h3>
                                        </div>
                                        <div class="col-sm-12 text-center">
                                            <button class="btn btn-success" v-on:click="paymentBoleto()">Finalizar Compra</button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                    <!-- Card de depósito -->
                    <?php if (intval($data['deposito_ativo']) === 1) : ?>
                        <div class="card">
                            <div class="card-header custom_loja_fundo" role="tab">
                                <h3 class="accordion-heading"><a class="collapsed custom_loja_texto" href="#deposito" data-toggle="collapse"><i class="fa fa-exchange mr-2"></i>Pague via transferência bancária<span class="accordion-indicator"><i data-feather="chevron-up"></i></span></a></h3>
                            </div>
                            <div class="collapse" id="deposito" data-parent="#payment-method" role="tabpanel">
                                <div class="card-body custom_loja_fundo">
                                    <div class="row">
                                        <div class="col-sm-12 text-center">
                                            <h3 v-if="totalCompraSemFormatacao != null" class="custom_loja_texto">Total: {{ totalCompraSemFormatacao.toLocaleString('pt-BR', { style: 'currency', currency: 'BRL' }) }}</h3>
                                        </div>
                                        <div class="col-sm-12 text-center">
                                            <button class="btn btn-success" v-on:click="paymentDeposito()">Finalizar Compra</button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
            <!-- Sidebar-->
            <div class="col-xl-3 col-md-4 pt-4 mt-3 pt-md-0 mt-md-0">
                <!-- Loop carrinho -->
                <div v-for="cart in produtos_carrinho" class="mb-2">
                    <h2 class="h6 px-4 py-3 bg-secondary text-center custom_menu_fundo custom_menu_texto_no_hover"><i class="fa fa-shopping-cart pull-left"></i> Carrinho</h2>
                    <!-- Loop carrinho -->
                    <div v-for="cart in produtos_carrinho" class="mb-2">
                        <div class="media">
                            <div class="featured-entry-thumb mr-3">
                                <a :href="'${baseUri}/produto/' + cart.produto.produto_url">
                                    <img :src="'${baseUri}/thumb/resize/?w=100&h=100&f=' + cart.produto.produto_imagens[0].foto_produto_img" width="64" alt="Product thumb">
                                </a>
                            </div>
                            <div class="media-body">
                                <h6 class="featured-entry-title">
                                    <a class="custom_loja_texto" :href="'${baseUri}/produto/' + cart.produto.produto_url">{{ cart.produto.produto_titulo }}</a>
                                </h6>
                                <p class="featured-entry-meta custom_loja_texto"> {{ cart.produto.qtd }} <span class='text-muted'>x</span> R$ {{ cart.produto.produto_preco }}</p>
                            </div>

                        </div>
                        <!-- atributos -->
                        <div class="row" v-if="cart.produto.atributos_selecionados != null">
                            <div v-for="(att, index) in cart.produto.nomes_atributos" class="font-size-sm col-sm-6" style="font-size: .775rem !important;">
                                <span class="text-muted mr-2 custom_loja_texto">{{ att.atributo_nome }}:</span>{{ cart.produto.nomes_atributos_selecionados[index] }}
                            </div>
                            <hr>
                        </div>
                        <!-- atributos -->

                    </div>
                    <!-- Loop carrinho -->


                    <br>
                    <hr><br>
                    <h2 class="h6 px-4 py-3 bg-secondary text-center custom_menu_fundo custom_menu_texto_no_hover"><i class="fa fa-info-circle pull-left"></i> Detalhes da compra</h2>
                    <div class="font-size-sm border-bottom pt-2 pb-3">
                        <div class="d-flex justify-content-between mb-2 custom_loja_texto"><span>Subtotal:</span><span class="valorSubtotal"></span></div>
                        <div class="d-flex justify-content-between mb-2 custom_loja_texto"><span>Frete:</span><span class="valorFrete">&mdash;</span></div>
                        <div class="d-flex justify-content-between custom_loja_texto"><span>Desconto:</span><span class="valorCupom">&mdash;</span></div>
                    </div>
                    <div class="h3 font-weight-semibold text-center py-3 custom_loja_texto">{{ totalCompra }}</div>

                    <br>
                    <hr><br>
                    <h2 class="h6 px-4 py-3 bg-secondary text-center custom_menu_fundo custom_menu_texto_no_hover"><i class="fa fa-ticket pull-left"></i> Cupom de desconto</h2>
                    <div class="form-group">
                        <input class="form-control" type="text" id="cupomValue" placeholder="Cupom" required>
                        <div id="msgCupom" class="text-success">

                        </div>
                    </div>
                    <button class="btn btn-outline-primary btn-block" v-on:click="verifyCupom()"><i class="fa fa-ticket pull-left"></i> Aplicar cupom</button>


                </div>
            </div>
        </div>


        <!-- Modal realizando pagamento -->
        <div class="modal fade" id="modalProcessandoPagamento" tabindex="-1" role="dialog" aria-hidden="true">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-body">
                        <br>
                        <div class="text-center">
                            <h4>Aguarde, pagamento sendo processado...</h4>
                            &nbsp;
                            <img src="${baseUri}/media/default/loading.svg" alt="" width="80">
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Fim modal realizando pagamento -->
        @(tema.loja.partials.footer-checkout)

        <!-- JavaScript (jQuery) libraries, plugins and custom scripts-->
        <script>
            const baseUri = "${baseUri}";
        </script>
        <script src="assets/js/jquery.min.js"></script>

        <script src="assets/js/vendor.min.js"></script>
        <script src="assets/js/theme.min.js"></script>
        <script src="assets/js/toasts.js"></script>
        <script src="assets/js/template.js"></script>
        <script src="assets/js/vue.min.js"></script>
        <script src="assets/js/carrinho.js"></script>
        <script src="assets/js/validacoes.js"></script>
        <script src="assets/js/main.js?v=<?= rand(); ?>"></script>
        <script src="assets/js/jquery.mask.min.js"></script>
        <script src="assets/js/card.min.js"></script>
        <script type="text/javascript" src="https://stc.pagseguro.uol.com.br/pagseguro/api/v2/checkout/pagseguro.directpayment.js"></script>
        <script src="checkout/pagamento/pagseguro/index.js"></script>
</body>

</html>