var vm = new Vue({
    el: "#vm",
    data: {
        cupom: null,
        cupom_desconto: 0,
        desconto_total: 0,
        frete: null,
        totalProdutos: null,
        totalCompra: null,
        totalCompraSemFormatacao: null,
        cardIsValid: false,
        loadingPage: true, // pode ser usado para uma splash screen
        validandoCartao: false,
        descontoBoleto: false,
        valorDescontoBoleto: null,
        totalBoleto: null,
        // selects e opções adicionais
        anos: [],
        campos_extras: null,
        produtos_carrinho: null,
        carrinho: null,
        valorFrete: null,
        totalDescontoFrete: null,
        totalSemDescontoFrete: null,
        descontoReal: 0,
        parcelas: 0,
    },
    methods: {
        get_produtos_carrinho: () => {
            let url = baseUri + "/carrinho/getCarrinho";
            $.post(url).then((res) => {
                if (res) {
                    res = JSON.parse(res);
                    vm.carrinho = res;
                    vm.produtos_carrinho = res.carrinho;
                } else {
                    vm.produtos_carrinho = null;
                }
            });
        },
        get_campos_extras: () => {
            let url = baseUri + "/CamposExtras/get_campos_extras";
            $.post(url).then((res) => {
                res = JSON.parse(res);

                if (res.status != undefined && res.status == 200) {
                    vm.campos_extras = res.campos;
                } else {
                    // Redirect para tela de carrinho, pois não tem nenhum item no carrinho
                }
            });
        },
        get_respostas_campos_extras: () => {
            if (vm.campos_extras != null) {
                let respostas = [];
                $(".campos_checkout").each((i, el) => {
                    let id = $(el).data("id");
                    let pergunta = $(el).data("pergunta");
                    let resposta = $(el).val();
                    if (resposta.trim() == "") {
                        alert_error(
                            "Responda todas as perguntas para prosseguir"
                        );
                        $(el).focus();
                        return false;
                    }
                    respostas.push({
                        campo_checkout_id: id,
                        pergunta: pergunta,
                        resposta: resposta,
                    });
                });

                return respostas;
            }
        },

        // -- verifica se existe um cupom com os valores digitados pelo usuário
        verifyCupom: () => {
            var self = this;
            $("#msgCupom").html("");
            let cupom = $("#cupomValue").val().trim();
            let url = baseUri + "/CupomFront/getCupom";
            $.post(url, { cupom: cupom }).then((res) => {
                res = JSON.parse(res);
                if (res.error == null) {
                    vm.cupom = res.cupom;
                    if (vm.cupom.cupom_desconto > 0) {
                        window.location.reload();
                    }
                } else {
                    $("#cupomValue")
                        .attr("placeholder", res.error)
                        .val("")
                        .attr("style", "border: 1px solid red");
                    setTimeout(() => {
                        window.location.reload();
                    }, 700);
                }
            });
        },
        // Verifica se existe um cupom já setado para aplicar desconto
        getCupom: () => {
            let url = baseUri + "/FreteFront/getValorCupom";
            $.post(url).then((res) => {
                if (res != null && res != "") {
                    res = JSON.parse(res);
                    if (res.cupom != undefined) {
                        vm.cupom = res.cupom;
                        $("#cupomValue").val(vm.cupom.cupom_alfa);
                    }
                }
            });
        },

        // --frete
        getFrete: () => {
            let url = baseUri + "/FreteFront/getValorFrete";

            $.post(url).then((res) => {
                if (res != null && res != "") {
                    res = JSON.parse(res);
                    if (res.frete != undefined) {
                        vm.frete = res.frete;
                        $(".valorFrete").html(
                            `${Number(vm.frete.price).toLocaleString("pt-BR", {
                                style: "currency",
                                currency: "BRL",
                            })}`
                        );
                    }
                }
            });
        },

        goToFrete: () => {
            let url = baseUri + "/FreteFront/clearFrete";
            $.post(url).then((res) => {
                if (res.trim() == "1") {
                    window.location.href = baseUri + "/checkout";
                }
            });
        },
        paymentBoleto: () => {
            if (vm.campos_extras != null) {
                let respostas = vm.get_respostas_campos_extras();

                if (respostas.length == vm.campos_extras.length) {
                    let data = {
                        cupom: vm.cupom,
                        frete: vm.frete,
                        metodo: "boleto",
                        respostas: respostas,
                    };
                    let url = baseUri + "/PagamentoFront/payment";
                    $("#modalProcessandoPagamento").modal("show");
                    $.post(url, data).then((res) => {
                        if (res != null) {
                            res = JSON.parse(res);
                            if (res.redirect != null) {
                                window.location.href = res.redirect;
                            } else if (res.error) {
                                $("#modalProcessandoPagamento").modal("hide");
                                alert_warning(res.error);
                            } else if (res.pedido_id != undefined) {
                                window.location.href =
                                    baseUri +
                                    "/pedido-detalhes/" +
                                    res.pedido_id;
                            }
                        }
                    });
                }
            } else {
                let data = {
                    cupom: vm.cupom,
                    frete: vm.frete,
                    metodo: "boleto",
                };
                let url = baseUri + "/PagamentoFront/payment";
                $("#modalProcessandoPagamento").modal("show");
                $.post(url, data).then((res) => {
                    if (res != null) {
                        res = JSON.parse(res);
                        if (res.redirect != null) {
                            window.location.href = res.redirect;
                        } else if (res.error) {
                            $("#modalProcessandoPagamento").modal("hide");
                            alert_warning(res.error);
                        } else if (res.pedido_id != undefined) {
                            window.location.href =
                                baseUri + "/pedido-detalhes/" + res.pedido_id;
                        }
                    }
                });
            }
        },
        paymentDeposito: () => {
            if (vm.campos_extras != null) {
                let respostas = vm.get_respostas_campos_extras();

                if (respostas.length == vm.campos_extras.length) {
                    let data = {
                        cupom: vm.cupom,
                        frete: vm.frete,
                        metodo: "deposito",
                        respostas: respostas,
                    };
                    let url = baseUri + "/PagamentoFront/payment";
                    $("#modalProcessandoPagamento").modal("show");
                    $.post(url, data).then((res) => {
                        if (res != null) {
                            res = JSON.parse(res);
                            if (res.redirect != null) {
                                window.location.href = res.redirect;
                            } else if (res.error) {
                                $("#modalProcessandoPagamento").modal("hide");
                                alert_warning(res.error);
                            } else if (res.pedido_id != undefined) {
                                window.location.href =
                                    baseUri +
                                    "/pedido-detalhes/" +
                                    res.pedido_id;
                            }
                        }
                    });
                }
            } else {
                let data = {
                    cupom: vm.cupom,
                    frete: vm.frete,
                    metodo: "deposito",
                };
                let url = baseUri + "/PagamentoFront/payment";
                $("#modalProcessandoPagamento").modal("show");
                $.post(url, data).then((res) => {
                    if (res != null) {
                        res = JSON.parse(res);
                        if (res.redirect != null) {
                            window.location.href = res.redirect;
                        } else if (res.error) {
                            $("#modalProcessandoPagamento").modal("hide");
                            alert_warning(res.error);
                        } else if (res.pedido_id != undefined) {
                            window.location.href =
                                baseUri + "/pedido-detalhes/" + res.pedido_id;
                        }
                    }
                });
            }
        },
        paymentPix: () => {
            const data = {
                cupom: vm.cupom,
                frete: vm.frete,
                metodo: "pix",
            };
            const url = baseUri + "/PagamentoFront/payment";
            const processarPagamento = () => {
                $("#modalProcessandoPagamento").modal("show");
                $.post(url, data)
                    .then((res) => {
                        if (res != null) {
                            res = JSON.parse(res);
                            if (res.redirect != null) {
                                window.location.href = res.redirect;
                            } else if (res.error) {
                                $("#modalProcessandoPagamento").modal("hide");
                                alert_warning(res.error);
                            } else if (res.pedido_id != undefined) {
                                window.location.href =
                                    baseUri +
                                    "/pedido-pagar-pix/" +
                                    res.pedido_id;
                            }
                        } else {
                            console.log(res);
                            alert_warning("Erro ao processar pagamento!");
                        }
                    })
                    .fail(() => {
                        console.log(res);
                    });
            };

            if (vm.campos_extras != null) {
                const respostas = vm.get_respostas_campos_extras();
                if (respostas.length === vm.campos_extras.length) {
                    data.respostas = respostas;
                    processarPagamento();
                }
            } else {
                processarPagamento();
            }
        },
        payment: () => {
            $("#modalProcessandoPagamento").modal("show");
            const cardToken = $("#card_token").val();
            const parcelas = $("#card_parcela").val();
            const parcelasTotal = $("#card_parcela option:selected").data(
                "total"
            );
            const cardholderName = $("#cardholderName").val();
            const doc = $("#docNumber").val();
            const cvc = $("#securityCode").val();
            const cardNumber = $("#cardNumber").val().split(" ").join("");
            const paymentMethodId = $("#paymentMethodId").val();
            const cardExpirationYear = $("#cardExpirationYear").val();
            const cardExpirationMonth = $("#cardExpirationMonth").val();
            const respostas =
                vm.campos_extras != null
                    ? vm.get_respostas_campos_extras()
                    : [];

            const data = {
                card_token: cardToken,
                cardholderName: cardholderName,
                docNumberFake: doc,
                cardNumber: cardNumber,
                card_parcela: parcelas,
                parcelasTotal: parcelasTotal,
                cardExpirationYear: cardExpirationYear,
                cardExpirationMonth: cardExpirationMonth,
                paymentMethodId: paymentMethodId,
                cardCVC: cvc,
                cupom: vm.cupom,
                frete: vm.frete,
                metodo: "cartao",
                respostas: respostas,
            };

            const url = baseUri + "/PagamentoFront/payment";
            $.post(url, data)
                .then((res) => {
                    console.log(res);
                    if (res) {
                        try {
                            /*                             if (!isObject(res)) {
                                throw new Error("null");
                            } */
                            res = JSON.parse(res);
                            if (res.redirect) {
                                window.location.href = res.redirect;
                            } else if (res.error) {
                                throw new Error(res.error);
                            } else if (res.pedido_id !== undefined) {
                                window.location.href =
                                    baseUri +
                                    "/pedido-detalhes/" +
                                    res.pedido_id;
                            }
                        } catch (error) {
                            $("#modalProcessandoPagamento").modal("hide");
                            alert_warning(
                                "Erro no processamento do pagamento: " +
                                    error.message
                            );
                            $.post(
                                baseUri + "/pedidoStatus/processa_pagamento/",
                                { msg: error.message }
                            );
                        }
                    } else {
                        alert_warning("Resposta inválida do servidor.");
                    }
                })
                .fail(() => {
                    alert_warning(
                        "Falha na requisição ao servidor. Tente novamente mais tarde."
                    );
                })
                .always(() => {
                    $("#modalProcessandoPagamento").modal("hide");
                });
        },
        inicializaPagarMe: (reload = false) => {
            if (vm.frete == null) {
                vm.goToFrete();
            }
            vm.totalCompraSemFormatacao = vm.carrinho.info.total_desconto;
            vm.totalCompra = vm.carrinho.info.total_desconto;
            vm.totalCompras = Number(vm.totalCompra).toLocaleString("pt-BR", {
                style: "currency",
                currency: "BRL",
            });

            vm.valorFrete = Number(vm.carrinho.info.frete);
            vm.totalBoleto = vm.carrinho.info.subtotal_desconto;
            vm.totalDescontoFrete = vm.carrinho.info.total_desconto_frete;
            vm.totalSemDescontoFrete =
                vm.carrinho.info.total_sem_desconto_frete;
            vm.totalProdutos = Number(vm.carrinho.info.total).toLocaleString(
                "pt-BR",
                {
                    style: "currency",
                    currency: "BRL",
                }
            );
            vm.descontoReal =
                vm.carrinho.info.total.replace(".", "").replace(",", ".") -
                vm.carrinho.info.subtotal_desconto
                    .replace(".", "")
                    .replace(",", ".");

            let descontoPix = Number(vm.descontoReal);
            vm.descontoReal = Number(vm.descontoReal).toLocaleString("pt-BR", {
                style: "currency",
                currency: "BRL",
            });
            vm.parcelas = vm.carrinho.info.parcelas;
            vm.cupom_desconto = Number(vm.carrinho.info.cupom.desconto);
            vm.cupom = vm.carrinho.info.cupom;

            vm.valorDescontoBoleto = Number($("#desconto_boleto").val());
            $("#transactionAmount").val(vm.carrinho.info.total);

            vm.desconto_total = vm.carrinho.info.desconto_total;

            vm.desconto_total = Number(vm.desconto_total).toLocaleString(
                "pt-BR",
                {
                    style: "currency",
                    currency: "BRL",
                }
            );

            $(".updateCardTotal").on("click", function () {
                console.clear();
                let produtos = $(this).data("produtos");
                let total = $(this).data("total");
                let frete = $(this).data("frete");
                let desconto = $(this).data("desconto");

                $(".valorTotal").text(total);
                $(".valorFrete").text(frete);
                $(".valorCupom").text(desconto);
                //$(".valorProduto").text();

                console.log("Produtos: " + produtos);
                console.log("Total: " + total);
                console.log("Frete: " + frete);
                console.log("Cupom: " + vm.carrinho.info.cupom.desconto);
                console.log("Desconto Pix: " + desconto);
                console.log(
                    "Desconto Total: " + vm.carrinho.info.desconto_total
                );
            });

            var cpfCnpj = function (val) {
                    return val.replace(/\D/g, "").length > 11
                        ? "00.000.000/0000-00"
                        : "000.000.000-009";
                },
                cpfOptions = {
                    onKeyPress: function (val, e, field, options) {
                        field.mask(cpfCnpj.apply({}, arguments), options);
                    },
                };
            $(".cpfCnpj").mask(cpfCnpj, cpfOptions);
            if (reload) {
                var bin = $("#cardNumber").val();
                bin = bin.replace(/\s/g, "");
                return true;
            }

            $("#docNumber2").blur(function () {
                let documento = $("#docNumber2").val();
                documento = documento
                    .split(".")
                    .join("")
                    .split("-")
                    .join("")
                    .split("/")
                    .join("");
                $("#docNumber").val(documento);
            });

            $(".cardField").on("change", function () {
                vm.cardIsValid = false;
            });

            $("#docNumberFake").on("keyup", function () {
                var number = $("#docNumberFake").val();
                var desired = number.replace(/[^a-z0-9 -]/g, "");
                desired = desired.replace(/-/g, "");
                desired = desired.replace(/\s+/g, "");
                $("#docNumber").val(desired);
            });

            /*
            function fill_parcelas(parcelamento) {
                $("#card_parcela option").remove();
                let maxInstallments = $("#maxInstallments").val();
                $.each(parcelamento, function (k, v) {
                    if (k < maxInstallments) {
                        $("<option />")
                            .attr(
                                "data-amount",
                                parseFloat(v.total_amount).toFixed(2)
                            )
                            .val(v.installments)
                            .text(v.recommended_message)
                            .appendTo($("#card_parcela"));
                    }
                    $("#card_parcela").trigger("change");
                });
            }
            */

            $("#verificar-dados").on("click", function (event) {
                $("#msg-error").addClass("hide");
                $(".ipt-error").removeClass("ipt-error");

                let parcelas = $("#card_parcela").val();
                let cardYear = $("#cardExpirationYear").val();
                let cardMonth = $("#cardExpirationMonth").val();
                let cardNumber = $("#cardNumber").val();
                let cardCVV = $("#securityCode").val();
                let cardName = $("#cardholderName").val();
                let cardDoc = $("#docNumber").val();
                let CurYear = new Date().getFullYear();

                if (cardDoc == "" || validarCPF(cardDoc) == false) {
                    $("#docNumber2").focus();
                    $("#docNumber2").addClass("ipt-error");
                    return false;
                }
                $("#docNumber2").addClass("ipt-success");

                if (cardNumber == "") {
                    $("#cardNumber").focus();
                    $("#cardNumber").addClass("ipt-error");
                    return false;
                }
                if (cardName == "") {
                    $("#cardholderName").focus();
                    $("#cardholderName").addClass("ipt-error");
                    return false;
                }

                if (cardMonth == "") {
                    $("#cardExpirationMonth").focus();
                    $("#cardExpirationMonth").addClass("ipt-error");
                    return false;
                }

                if (cardYear == "") {
                    $("#cardExpirationYear").focus();
                    $("#cardExpirationYear").addClass("ipt-error");
                    return false;
                } else if (cardYear < CurYear) {
                    $("#cardExpirationYear").addClass("ipt-error");
                    $("#cardExpirationYear").focus();
                    return false;
                }

                if (cardCVV == "") {
                    $("#securityCode").focus();
                    $("#securityCode").addClass("ipt-error");
                    return false;
                }

                if (parcelas == "") {
                    $("#cielo_parcelas").focus();
                    $("#cielo_parcelas").addClass("ipt-error");
                    return false;
                }
                $("#msg-error").addClass("hide");
                $("#verificar-dados").toggleClass("hide");
                $("#comprar-creditos-true").toggleClass("hide");
                vm.cardIsValid = true;
            });

            new Card({
                form: document.getElementById("pay"),
                formSelectors: {
                    numberInput: 'input[name="cardNumber"]',
                    expiryInput: 'input[name="cardExpirationYear"]',
                    cvcInput: 'input[name="securityCode"]',
                    nameInput: 'input[name="cardholderName"]',
                },
                placeholders: {
                    number: "•••• •••• •••• ••••",
                    name: "Nome do Titular",
                    expiry: "••/••",
                    cvc: "•••",
                },
                container: ".card-wrapper",
            });

            if (!reload) {
                vm.loadingPage = false;
            }
        },
    },
    created: function () {
        this.get_campos_extras();
        this.get_produtos_carrinho();
        setTimeout(() => {
            this.getFrete();
            this.getCupom();
        }, 1200);

        setTimeout(() => {
            $("#cep").mask("99999-999");
            $(".two-numbers").mask("99");
            $(".numbers").mask("999999");
            this.totalProdutos = vmCarrinho.total;
            this.totalCompra = vmCarrinho.total_desconto;
            this.inicializaPagarMe();
        }, 1800);

        let anoAtual = new Date().getFullYear();
        for (let i = anoAtual; i < anoAtual + 10; i++) {
            this.anos.push(i);
        }
    },
});
