var vm = new Vue({
    el: "#vm",
    data: {
        cupom: null,
        frete: null,
        totalProdutos: null,
        totalCompra: null,
        totalCompraSemFormatacao: null,
        cardIsValid: false,
        loadingPage: true, // pode ser usado para uma splash screen
        validandoCartao: false,
        descontoBoleto: false,
        valorDescontoBoleto: null,
        totalBoleto: null,

        // selects e opções adicionais
        anos: [],
        campos_extras: null,
        produtos_carrinho: null,
    },
    methods: {
        get_produtos_carrinho: () => {
            let url = baseUri + "/carrinho/getCarrinho";
            $.post(url)
                .then(res => {
                    if (res) {
                        res = JSON.parse(res);
                        vm.produtos_carrinho = res.carrinho;
                    } else {
                        vm.produtos_carrinho = null;
                    }
                })
        },
        get_campos_extras: () => {
            let url = baseUri + "/CamposExtras/get_campos_extras";
            $.post(url)
                .then(res => {
                    res = JSON.parse(res);

                    if (res.status != undefined && res.status == 200) {
                        vm.campos_extras = res.campos;
                    } else {
                        // Redirect para tela de carrinho, pois não tem nenhum item no carrinho
                    }
                })
        },
        get_respostas_campos_extras: () => {
            if (vm.campos_extras != null) {
                let respostas = [];
                $(".campos_checkout").each((i, el) => {
                    let id = $(el).data('id');
                    let pergunta = $(el).data('pergunta');
                    let resposta = $(el).val();
                    if (resposta.trim() == '') {
                        alert_error("Responda todas as perguntas para prosseguir");
                        $(el).focus();
                        return false;
                    }
                    respostas.push({ campo_checkout_id: id, pergunta: pergunta, resposta: resposta });
                })

                return respostas;
            }
        },

        // -- verifica se existe um cupom com os valores digitados pelo usuário
        verifyCupom: () => {
            $("#msgCupom").html("");
            let cupom = $("#cupomValue").val().trim();
            if (cupom == "") {
                $("#cupomValue")
                    .attr("placeholder", "PREENCHA O CAMPO")
                    .val("")
                    .attr("style", "border: 1px solid red");
            } else {
                let url = baseUri + "/CupomFront/getCupom";

                $.post(url, { cupom: cupom }).then((res) => {
                    res = JSON.parse(res);
                    if (res.error == null) {
                        vm.cupom = res.cupom;
                        if (vm.cupom.cupom_desconto > 0) {
                            $(".valorCupom").html(`${vm.cupom.cupom_desconto} %`);
                            if (vm.frete != null) {
                                vm.totalCompraSemFormatacao =
                                    Number(vm.totalProdutos) -
                                    Number(vm.totalProdutos) * (vm.cupom.cupom_desconto / 100);
                                if (vm.totalCompra < 0) {
                                    vm.totalCompraSemFormatacao = Number(vm.frete.price);
                                } else {
                                    vm.totalCompraSemFormatacao += Number(vm.frete.price);
                                }
                            } else {
                                vm.totalCompraSemFormatacao =
                                    Number(vm.totalProdutos) -
                                    Number(vm.totalProdutos) * (vm.cupom.cupom_desconto / 100);
                                if (vm.totalCompraSemFormatacao < 0) {
                                    vm.totalCompraSemFormatacao = Number(0);
                                }
                            }
                        } else {
                            $(".valorCupom").html(
                                `${Number(vm.cupom.cupom_real).toLocaleString("pt-BR", {
                                    style: "currency",
                                    currency: "BRL",
                                })}`
                            );

                            if (vm.frete != null) {
                                vm.totalCompraSemFormatacao =
                                    Number(vm.totalProdutos) - Number(vm.cupom.cupom_real);
                                if (vm.totalCompraSemFormatacao < 0) {
                                    vm.totalCompraSemFormatacao = Number(vm.frete.price);
                                } else {
                                    vm.totalCompraSemFormatacao += Number(vm.frete.price);
                                }
                            } else {
                                vm.totalCompraSemFormatacao =
                                    Number(vm.totalProdutos) - Number(vm.cupom.cupom_real);
                                if (vm.totalCompraSemFormatacao < 0) {
                                    vm.totalCompraSemFormatacao = Number(0);
                                }
                            }
                        }
                        $("#cupomValue")
                            .attr("placeholder", "CUPOM APLICADO")
                            .val("")
                            .attr("style", "border: 1px solid green");
                    } else {
                        vm.cupom = null;
                        if (vm.frete != null) {
                            vm.totalCompraSemFormatacao =
                                Number(vm.totalProdutos) + Number(vm.frete.price);
                        } else {
                            vm.totalCompraSemFormatacao = Number(vm.totalProdutos);
                        }
                        $(".valorCupom").html("&mdash;");
                        $("#cupomValue")
                            .attr("placeholder", res.error)
                            .val("")
                            .attr("style", "border: 1px solid red");
                    }
                    if (!isNaN(vm.totalCompraSemFormatacao)) {
                        vm.totalCompra = Number(
                            vm.totalCompraSemFormatacao
                        ).toLocaleString("pt-BR", { style: "currency", currency: "BRL" });
                    }

                    // Reload de parcelas
                    vm.parcelamento();
                    vm.get_senderHash();
                });
            }
        },
        // Verifica se existe um cupom já setado para aplicar desconto
        getCupom: () => {
            let url = baseUri + "/FreteFront/getValorCupom";

            $.post(url).then((res) => {
                if (res != null && res != "") {
                    res = JSON.parse(res);
                    if (res.cupom != undefined) {
                        vm.cupom = res.cupom;

                        if (vm.cupom.cupom_desconto > 0) {
                            // Desconto percentual
                            $(".valorCupom").html(`${vm.cupom.cupom_desconto} %`);
                            if (vm.frete != null) {
                                vm.totalCompraSemFormatacao =
                                    Number(vm.totalProdutos) -
                                    Number(vm.totalProdutos) * (vm.cupom.cupom_desconto / 100) +
                                    Number(vm.frete.price);
                            } else {
                                vm.totalCompraSemFormatacao =
                                    Number(vm.totalProdutos) -
                                    Number(vm.totalProdutos) * (vm.cupom.cupom_desconto / 100);
                            }

                            vm.totalCompra = vm.totalCompraSemFormatacao.toLocaleString(
                                "pt-BR",
                                { style: "currency", currency: "BRL" }
                            );
                        } else {
                            // Desconto em real
                            $(".valorCupom").html(
                                `${Number(vm.cupom.cupom_real).toLocaleString("pt-BR", {
                                    style: "currency",
                                    currency: "BRL",
                                })}`
                            );
                            if (vm.frete != null) {
                                vm.totalCompra =
                                    Number(vm.totalProdutos) - Number(vm.cupom.cupom_real);
                                if (vm.totalCompra < 0) {
                                    vm.totalCompraSemFormatacao = Number(vm.frete.price);
                                } else {
                                    vm.totalCompraSemFormatacao += Number(vm.frete.price);
                                }
                            } else {
                                vm.totalCompraSemFormatacao =
                                    Number(vm.totalProdutos) - Number(vm.cupom.cupom_real);
                                if (vm.totalCompraSemFormatacao < 0) {
                                    vm.totalCompraSemFormatacao = 0;
                                }
                            }
                        }
                    }
                }
                vm.totalCompra = vm.totalCompraSemFormatacao.toLocaleString("pt-BR", {
                    style: "currency",
                    currency: "BRL",
                });
            });
        },

        // --frete
        getFrete: () => {
            let url = baseUri + "/FreteFront/getValorFrete";

            $.post(url).then((res) => {
                if (res != null && res != "") {
                    res = JSON.parse(res);
                    if (res.frete != undefined) {
                        vm.frete = res.frete;
                        $(".valorFrete").html(
                            `${Number(vm.frete.price).toLocaleString("pt-BR", {
                                style: "currency",
                                currency: "BRL",
                            })}`
                        );
                        vm.totalCompraSemFormatacao =
                            Number(vm.totalProdutos) + Number(vm.frete.price);
                        vm.totalCompra = vm.totalCompraSemFormatacao.toLocaleString(
                            "pt-BR",
                            { style: "currency", currency: "BRL" }
                        );
                    }
                }
            });
        },

        goToFrete: () => {
            let url = baseUri + "/FreteFront/clearFrete";
            $.post(url).then((res) => {
                if (res.trim() == "1") {
                    window.location.href = baseUri + "/checkout";
                }
            });
        },

        // Pré Payment
        bandeira: () => {
            PagSeguroDirectPayment.getBrand({
                cardBin: $.trim($("#cardNumber").val()),
                success: function (response) {
                    $("#card_brand").val(response.brand.name);
                    alert(response.brand.name);
                    var bandeira = response.brand.name;
                    $("<img />")
                        .attr(
                            "src",
                            "https://stc.pagseguro.uol.com.br/public/img/payment-methods-flags/68x30/" +
                            bandeira +
                            ".png"
                        )
                        .appendTo($("#brand_flag"));
                },
                error: function (response) {
                    console.log(response);
                    vm.cardIsValid = false;
                },
                complete: function (response) {
                    // console.log(response)
                },
            });
        },
        cardToken: () => {
            var param = {
                cardNumber: $("#cardNumber").val().split(" ").join(""),
                cvv: $("#securityCode").val(),
                expirationMonth: $("#cardExpirationMonth").val(),
                expirationYear: $("#cardExpirationYear").val(),
                success: function (response) {
                    console.log("card token: " + response.card.token);
                    $("#card_token").val(response.card.token);
                    vm.parcelamento();
                    vm.get_senderHash();
                },
                error: function (response) {
                    console.log(response);
                    vm.cardIsValid = false;
                },
                complete: function (response) {
                    console.log(response);
                },
            };
            PagSeguroDirectPayment.createCardToken(param);
        },
        parcelamento: () => {
            var parcelas_sem_juros = $("#pagseguro_semjuros").val();
            if (parcelas_sem_juros > 1) {
                PagSeguroDirectPayment.getInstallments({
                    amount: vm.totalCompraSemFormatacao
                        ? vm.totalCompraSemFormatacao
                        : vm.totalCompra,
                    brand: $("#card_brand").val(),
                    maxInstallmentNoInterest: parcelas_sem_juros,
                    success: function (response) {
                        console.log(response);
                        vm.parcelas(response.installments);
                    },
                    error: function (response) {
                        console.log(response);
                        vm.cardIsValid = false;
                    },
                    complete: function (response) {
                        console.log(response);
                    },
                });
            } else {
                PagSeguroDirectPayment.getInstallments({
                    amount: vm.totalCompraSemFormatacao
                        ? vm.totalCompraSemFormatacao
                        : vm.totalCompra,
                    brand: $("#card_brand").val(),
                    success: function (response) {
                        //console.log(response)
                        vm.parcelas(response.installments);
                    },
                    error: function (response) {
                        console.log(response);
                        vm.cardIsValid = false;
                    },
                    complete: function (response) {
                        //console.log(response)
                    },
                });
            }
        },
        parcelas: (parcelamento) => {
            let maxInstallments = $("#maxInstallments").val();
            $.each(parcelamento, function (brands, installments) {
                $("#card_parcela option").remove();
                $.each(installments, function (k, v) {
                    if (k < maxInstallments) {
                        $("<option />")
                            .attr("data-amount", parseFloat(v.installmentAmount).toFixed(2))
                            .val(v.quantity)
                            .text(
                                parseInt(v.quantity) +
                                " x " +
                                parseFloat(v.installmentAmount).toFixed(2) +
                                " = " +
                                (
                                    parseInt(v.quantity) * parseFloat(v.installmentAmount)
                                ).toFixed(2)
                            )
                            .appendTo($("#card_parcela"));
                    }
                });
                $("#card_parcela").trigger("change");
            });

            vm.cardIsValid = true;
        },
        get_senderHash: () => {
            PagSeguroDirectPayment.onSenderHashReady(function (response) {
                if (response.status == "error") {
                    console.log("erro");
                    console.log(response.message);
                    return false;
                }
                var hash = response.senderHash; //Hash estará disponível nesta variável.
                $("#sender_hash").val(hash);
            });
        },

        // Payment
        paymentBoleto: () => {
            if (vm.campos_extras != null) {
                let respostas = vm.get_respostas_campos_extras();

                if (respostas.length == vm.campos_extras.length) {
                    let data = {
                        cupom: vm.cupom,
                        frete: vm.frete,
                        metodo: "boleto",
                        respostas: respostas,
                    };
                    let url = baseUri + "/PagamentoFront/payment";
                    $("#modalProcessandoPagamento").modal("show");
                    $.post(url, data).then((res) => {
                        if (res != null) {
                            res = JSON.parse(res);
                            if (res.redirect != null) {
                                window.location.href = res.redirect;
                            } else if (res.error) {
                                $("#modalProcessandoPagamento").modal("hide");
                                alert_warning(res.error);
                            } else if (res.pedido_id != undefined) {
                                window.location.href =
                                    baseUri + "/pedido-detalhes/" + res.pedido_id;
                            }
                        }
                    });
                }
            } else {
                let data = {
                    cupom: vm.cupom,
                    frete: vm.frete,
                    metodo: "boleto",
                };
                let url = baseUri + "/PagamentoFront/payment";
                $("#modalProcessandoPagamento").modal("show");
                $.post(url, data).then((res) => {
                    if (res != null) {
                        res = JSON.parse(res);
                        if (res.redirect != null) {
                            window.location.href = res.redirect;
                        } else if (res.error) {
                            $("#modalProcessandoPagamento").modal("hide");
                            alert_warning(res.error);
                        } else if (res.pedido_id != undefined) {
                            window.location.href =
                                baseUri + "/pedido-detalhes/" + res.pedido_id;
                        }
                    }
                });
            }


        },
        paymentDeposito: () => {

            if (vm.campos_extras != null) {
                let respostas = vm.get_respostas_campos_extras();

                if (respostas.length == vm.campos_extras.length) {
                    let data = {
                        cupom: vm.cupom,
                        frete: vm.frete,
                        metodo: "deposito",
                        respostas: respostas,
                    };
                    let url = baseUri + "/PagamentoFront/payment";
                    $("#modalProcessandoPagamento").modal("show");
                    $.post(url, data).then((res) => {
                        if (res != null) {
                            res = JSON.parse(res);
                            if (res.redirect != null) {
                                window.location.href = res.redirect;
                            } else if (res.error) {
                                $("#modalProcessandoPagamento").modal("hide");
                                alert_warning(res.error);
                            } else if (res.pedido_id != undefined) {
                                window.location.href =
                                    baseUri + "/pedido-detalhes/" + res.pedido_id;
                            }
                        }
                    });
                }
            } else {
                let data = {
                    cupom: vm.cupom,
                    frete: vm.frete,
                    metodo: "deposito",
                };
                let url = baseUri + "/PagamentoFront/payment";
                $("#modalProcessandoPagamento").modal("show");
                $.post(url, data).then((res) => {
                    if (res != null) {
                        res = JSON.parse(res);
                        if (res.redirect != null) {
                            window.location.href = res.redirect;
                        } else if (res.error) {
                            $("#modalProcessandoPagamento").modal("hide");
                            alert_warning(res.error);
                        } else if (res.pedido_id != undefined) {
                            window.location.href =
                                baseUri + "/pedido-detalhes/" + res.pedido_id;
                        }
                    }
                });
            }

            
        },
        payment: () => {

            if (vm.campos_extras != null) {
                let respostas = vm.get_respostas_campos_extras();

                if (respostas.length == vm.campos_extras.length) {
                    $("#modalProcessandoPagamento").modal("show");
                    let parcelas = $("#card_parcela").val();
                    let cardholderName = $("#cardholderName").val();
                    let doc = $("#docNumber2").val();
        
                    // variavel enviada para o php
                    let data = {
                        cardholderName: cardholderName,
                        docNumberFake: doc,
                        cardNumber: $("#cardNumber").val().split(" ").join(""),
                        brand: $("#bandeira").val(),
                        cvv: $("#securityCode").val(),
                        expirationMonth: $("#cardExpirationMonth").val(),
                        expirationYear: $("#cardExpirationYear").val(),
                        card_parcela: parcelas,
                        valor_parcela: $("#installmentValue").val(),
                        cupom: vm.cupom,
                        frete: vm.frete,
                        metodo: "cartao",
                        respostas: respostas,
                    };
                    // request para salvar o pedido, efetuar o pagamento no mp e redireciona para o detalhes do pedido
                    let url = baseUri + "/PagamentoFront/payment";
                    $.post(url, data).then((res) => {
                        if (res != null) {
                            res = JSON.parse(res);
                            if (res.redirect != null) {
                                window.location.href = res.redirect;
                            } else if (res.error) {
                                $("#modalProcessandoPagamento").modal("hide");
                                alert_warning(res.error);
                            } else if (res.pedido_id != undefined) {
                                window.location.href =
                                    baseUri + "/pedido-detalhes/" + res.pedido_id;
                            }
                        }
                    });
                }
            } else {
                $("#modalProcessandoPagamento").modal("show");
                let parcelas = $("#card_parcela").val();
                let cardholderName = $("#cardholderName").val();
                let doc = $("#docNumber2").val();
    
                // variavel enviada para o php
                let data = {
                    cardholderName: cardholderName,
                    docNumberFake: doc,
                    cardNumber: $("#cardNumber").val().split(" ").join(""),
                    brand: $("#bandeira").val(),
                    cvv: $("#securityCode").val(),
                    expirationMonth: $("#cardExpirationMonth").val(),
                    expirationYear: $("#cardExpirationYear").val(),
                    card_parcela: parcelas,
                    valor_parcela: $("#installmentValue").val(),
                    cupom: vm.cupom,
                    frete: vm.frete,
                    metodo: "cartao",
                };
                // request para salvar o pedido, efetuar o pagamento no mp e redireciona para o detalhes do pedido
                let url = baseUri + "/PagamentoFront/payment";
                $.post(url, data).then((res) => {
                    if (res != null) {
                        res = JSON.parse(res);
                        if (res.redirect != null) {
                            window.location.href = res.redirect;
                        } else if (res.error) {
                            $("#modalProcessandoPagamento").modal("hide");
                            alert_warning(res.error);
                        } else if (res.pedido_id != undefined) {
                            window.location.href =
                                baseUri + "/pedido-detalhes/" + res.pedido_id;
                        }
                    }
                });
            }


           
        },
        inicializaCielo: (reload = false) => {
            // Transforma o total em numérico (float)
            let total = vm.totalCompraSemFormatacao;
            if (!total) total = vm.totalCompra;

            if (!isNaN(vm.totalCompra)) {
                vm.totalCompra = Number(vm.totalCompra).toLocaleString("pt-BR", {
                    style: "currency",
                    currency: "BRL",
                });
            }
            // Verificação se existe desconto no boleto
            if (Number($("#desconto_boleto").val()) > 0) {
                vm.descontoBoleto = true;
                vm.valorDescontoBoleto = Number($("#desconto_boleto").val());

                vm.totalBoleto = total - total * (vm.valorDescontoBoleto / 100);
            } else {
                vm.totalBoleto = total;
            }

            var cpfCnpj = function (val) {
                return val.replace(/\D/g, "").length > 11
                    ? "00.000.000/0000-00"
                    : "000.000.000-009";
            },
                cpfOptions = {
                    onKeyPress: function (val, e, field, options) {
                        field.mask(cpfCnpj.apply({}, arguments), options);
                    },
                };
            $(".cpfCnpj").mask(cpfCnpj, cpfOptions);
            // if (reload) {
            //     var bin = $('#cardNumber').val();
            //     bin = bin.replace(/\s/g, '');
            //     // var bin = bin.substring(0,3);
            //     getPaymentMethod(bin);
            //     return true;
            // }

            // Pagseguro
            PagSeguroDirectPayment.setSessionId($("#sessionPagseguro").val());

            vm.get_senderHash();

            console.log("Cielo iniciado"); // debug

            new Card({
                form: document.getElementById("pay"),
                formSelectors: {
                    numberInput: 'input[name="cardNumber"]',
                    expiryInput: 'input[name=""]',
                    cvcInput: 'input[name="securityCode"]',
                    nameInput: 'input[name="cardholderName"]',
                },
                placeholders: {
                    number: "•••• •••• •••• ••••",
                    name: "Nome do Titular",
                    expiry: "••/••",
                    cvc: "•••",
                },
                container: ".card-wrapper",
            });
            // $('#docNumberFake').mask('999.999.999-99 000');
            // $("#cardNumber").mask('9999 9999 9999 9999');
            // $('#documento').mask('999.999.999-99 000');

            if (!reload) {
                vm.loadingPage = false;
            }

            $("#card_parcela").on("change", function () {
                console.log("parcela escolhida");
                $("#parcelamento").show();
                var nparcelas = $("#card_parcela").val();
                var totalAmount = $("#card_parcela option:selected").data("amount");
                var total = Math.abs(nparcelas * totalAmount).toFixed(2);
                // $("#pedido_total_parcelado").val(total);
                // $(".total_parcelado").text("Valor Total Parcelado : R$ " + total);
                setTimeout(function () {
                    $("#btn-finaliza-credito").removeClass("disabled");
                }, 1000);
                $("#installmentValue").val(totalAmount);
                console.log(totalAmount);
            });

            $("#fakecartao_num").change(function () {
                $("#cartao_num").val(
                    $.trim($("#fakecartao_num").val().split(" ").join(""))
                );
                vm.bandeira();
                vm.cardToken();
            });

            $("#cardNumber").change(function () {
                vm.bandeira();
                vm.cardToken();
            });
            $("#securityCode").change(function () {
                vm.bandeira();
                vm.cardToken();
            });
            $("#cardExpirationMonth").change(function () {
                vm.bandeira();
                vm.cardToken();
            });
            $("#cardExpirationYear").change(function () {
                vm.bandeira();
                vm.cardToken();
            });
            $("#docNumber2").change(function () {
                vm.bandeira();
                vm.cardToken();
            });
            $("#cardholderName").change(function () {
                vm.bandeira();
                vm.cardToken();
            });
        },
    },
    created: function () {
        this.get_campos_extras();
        this.get_produtos_carrinho();
        setTimeout(() => {
            $("#cep").mask("99999-999");
            $(".two-numbers").mask("99");
            $(".four-numbers").mask("9999");
            $(".numbers").mask("999999");
            this.totalProdutos = vmCarrinho.subtotal;
            this.totalCompra = vmCarrinho.subtotal;
            this.getFrete();
            this.getCupom();
        }, 500);

        setTimeout(() => {
            this.inicializaCielo();
        }, 1500);

        let anoAtual = new Date().getFullYear();

        for (let i = anoAtual; i < anoAtual + 10; i++) {
            this.anos.push(i);
        }
    },
});
