<div class="col-xl-9 col-md-8">
    <h2 class="h6 px-4 py-3 bg-secondary mb-4 custom_menu_fundo custom_menu_texto_no_hover font_smooth">Opções de Entrega</h2>
    <div class="row">
        <div class="col-sm-12" v-if="enderecos != null">
            <h3 class="custom_loja_texto">Selecione seu endereço</h3>
            <div class="table-responsive">
                <table class="table">
                    <thead>
                        <tr>
                            <th class="align-middle"></th>
                            <th class="align-middle custom_loja_texto">Local</th>
                            <th class="align-middle custom_loja_texto">CEP</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr v-for="end of enderecos" style="cursor: pointer;" v-on:click="changeEndereco(end)">
                            <td>
                                <div class="custom-control custom-radio mb-4">
                                    <input class="custom-control-input radioEndereco" type="radio" :id="'endereco' + end.endereco_cliente_id" name="enderecos">
                                    <label class="custom-control-label" :for="'endereco' + end.endereco_cliente_id"></label>
                                </div>
                            </td>
                            <td class="align-middle">
                                <span class="text-dark custom_loja_texto">{{ end.endereco_cliente_titulo }}</span><br>
                                <span class="text-muted font-size-sm custom_loja_texto">{{ end.endereco_cliente_rua }}, nº {{ end.endereco_cliente_num }}, {{ end.endereco_cliente_bairro }} - {{ end.endereco_cliente_cidade }}/{{ end.endereco_cliente_uf }}</span>
                            </td>
                            <td class="align-middle custom_loja_texto">{{ end.endereco_cliente_cep }}</td>
                        </tr>
                    </tbody>
                </table>
            </div>

        </div>
        <div v-else class="col-sm-12">
            <h4 class="custom_loja_texto">Nenhum endereço cadastrado!
                Antes, cadastre um endereço <a href="#" class="text-danger" v-on:click="redirectEndereco()">clicando aqui</a>
        </div>
    </div>
    <div class="row pt-4">
        <div class="col-sm-12 text-center" v-if="loadingFrete">
            <h4 class="custom_loja_texto">Calculando Frete</h4>
            <div class="spinner-border" role="status">
                <span class="sr-only custom_loja_texto">Loading...</span>
            </div>

        </div>
        <div class="col-sm-12" v-if="!loadingFrete && opcoesFrete != null">
            <h4 class="custom_loja_texto">Valores de Frete</h4>
            <div class="table-responsive">
                <table class="table">
                    <thead>
                        <tr>
                            <th class="align-middle"></th>
                            <th class="align-middle custom_loja_texto">Valor</th>
                            <th class="align-middle custom_loja_texto">Serviço</th>
                            <th class="align-middle custom_loja_texto">Entrega</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr v-for="opc of opcoesFrete" style="cursor: pointer;" v-on:click="setFrete(opc)">
                            <td>
                                <div class="custom-control custom-radio mb-4">
                                    <input class="custom-control-input radioFrete" type="radio" :id="'frete' + opc.code" v-on:click="setFrete(opc)" name="frete">
                                    <label class="custom-control-label" :for="'frete' + opc.code"></label>
                                </div>
                            </td>
                            <td class="align-middle custom_loja_texto">
                                <span class="text-dark" v-if="Number(opc.price) > 0">{{ Number(opc.price).toLocaleString('pt-BR', { style: 'currency', currency: 'BRL' }) }}</span>
                                <span class="text-dark" v-if="Number(opc.price) == 0">
                                    {{ opc.name }}
                                </span>
                            </td>
                            <td class="align-middle">
                                <span class="text-dark custom_loja_texto">{{ opc.name }}</span>
                            </td>
                            <td class="align-middle">
                                <span class="text-dark custom_loja_texto" v-if="opc.deadline > 1">{{ opc.deadline }} dias úteis</span>
                                <span class="text-dark custom_loja_texto" v-else>{{ opc.deadline }} dia útil</span>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>