<!DOCTYPE html>
<html lang="pt-br">

<head>
    <title>${config_site_title}
        <?php if (isset($data['config']->config_site_slogan) && !empty($data['config']->config_site_slogan)) : ?>
            - ${config_site_slogan}
        <?php endif; ?>
    </title>
    <!-- SEO -->
    @(tema.loja.partials.meta_tags)
    @(tema.loja.partials.og_tags)
    <!-- SEO -->
    <link rel="icon" type="image/png" sizes="32x32" href="${baseUri}/media/site/${config_site_favicon}">
    @(tema.loja.partials.css-padrao)
</head>

<body>
    <!-- SEO -->
    @(tema.loja.partials.google_analytics)
    @(tema.loja.partials.google_tag_manager)
    <!-- SEO -->

    @(tema.loja.partials.menu-superior)


    <div class="hide-on-desk" style="position: relative; margin-top: 50px !important"></div>

    <div class="${config_site_layout_custom} pt-4 pb-4" id="vm">

        <!-- Steps (wizard)-->
        <div class="steps">
            <div class="steps-body">
                <a class="step step-completed custom_loja_texto" href="${baseUri}/carrinho">
                    <span class="step-indicator"><i data-feather="check"></i></span>
                    <span class="step-icon"><i data-feather="shopping-bag" class="custom_loja_texto"></i></span>1. Carrinho
                </a>
                <a class="step custom_loja_texto" href="#" style="cursor: not-allowed;"><span class="step-icon custom_loja_texto"><i data-feather="check-circle"></i></span>2. Detalhes do Orçamento</a>
            </div>
        </div>
        <div class="row pt-4 mt-2">
            <input type="hidden" id="frete_gratis" value="<?= $data['frete_gratis'] ?>">
            <!-- Content-->
            @(tema.loja.partials.frete-somente-retirada)
            <!-- Sidebar-->
            <div class="col-xl-3 col-md-4 pt-4 mt-3 pt-md-0 mt-md-0">
                <h2 class="h6 px-4 py-3 bg-secondary text-center custom_menu_fundo custom_menu_texto_no_hover font_smooth"><i class="fa fa-shopping-cart pull-left"></i> Carrinho</h2>
                <!-- Loop carrinho -->
                <div v-for="cart in produtos_carrinho" class="mb-2">
                    <div class="media">
                        <div class="featured-entry-thumb mr-3">
                            <a :href="'${baseUri}/produto/' + cart.produto.produto_url">
                                <img :src="'${baseUri}/thumb/resize/?w=100&h=100&f=' + cart.produto.produto_imagens[0].foto_produto_img" width="64" alt="produto">
                            </a>
                        </div>

                        <div class="media-body">
                            <h6 class="featured-entry-title">
                                <a class="custom_loja_texto" :href="'${baseUri}/produto/' + cart.produto.produto_url">{{ cart.produto.produto_titulo }}</a>
                            </h6>
                            <p class="featured-entry-meta custom_loja_texto"> {{ cart.produto.qtd }} <span class='text-muted'>x</span> R$ {{ cart.produto.produto_preco }}</p>

                        </div>

                    </div>
                    <!-- atributos -->
                    <div class="row" v-if="cart.produto.atributos_selecionados != null">
                        <div v-for="(att, index) in cart.produto.nomes_atributos" class="font-size-sm col-sm-6" style="font-size: .775rem !important;">
                            <span class="text-muted mr-2 custom_loja_texto">{{ att.atributo_nome }}:</span>{{ cart.produto.nomes_atributos_selecionados[index] }}
                        </div>
                        <hr>
                    </div>
                    <!-- atributos -->

                </div>
                <!-- Loop carrinho -->

                <h2 class="h6 px-4 py-3 bg-secondary text-center custom_menu_fundo custom_menu_texto_no_hover"><i class="fa fa-info-circle"></i> Detalhes Orçamento</h2>
                <div class="font-size-sm border-bottom pt-2 pb-3">
                    <div class="d-flex justify-content-between mb-2 custom_loja_texto"><span>Subtotal:</span><span class="valorSubtotal"></span></div>
                    <!--<div class="d-flex justify-content-between mb-2 custom_loja_texto"><span>Frete:</span><span class="valorFrete">&mdash;</span></div>-->
                    <!-- <div class="d-flex justify-content-between mb-2"><span>Taxas:</span><span>$7.25</span></div> -->
                    <div class="d-flex justify-content-between custom_loja_texto"><span>Desconto:</span><span class="valorCupom">&mdash;</span></div>
                </div>
                <div class="h3 font-weight-semibold text-center py-3 custom_loja_texto">{{ totalCompra }}</div>

                <?php if ($data['frete_opcoes'] == '1') : ?>
                    <button class="btn btn-primary btn-block" v-on:click="pagamentoEntregaRetirada()">Finalizar Orçamento</button>
                <?php elseif ($data['frete_opcoes'] == '2') : ?>
                    <button class="btn btn-primary btn-block" v-on:click="pagamentoEntrega()">Finalizar Orçamento</button>
                <?php else : ?>
                    <button class="btn btn-primary btn-block" v-on:click="pagamentoRetirada()">Finalizar Orçamento</button>
                <?php endif; ?>

                <br>


            </div>
        </div>
    </div>

    @(tema.loja.partials.footer-checkout)

    <script>
        const baseUri = "${baseUri}";
    </script>
    <script src="assets/js/jquery.min.js"></script>

    <script src="assets/js/vendor.min.js"></script>
    <script src="assets/js/theme.min.js"></script>
    <script src="assets/js/toasts.js"></script>
    <script src="assets/js/template.js"></script>
    <script src="assets/js/vue.min.js"></script>
    <script src="assets/js/carrinho.js"></script>
    <script src="assets/js/validacoes.js"></script>
    <script src="assets/js/main.js"></script>
    <script src="assets/js/jquery.mask.min.js"></script>
    <script src="checkout/frete.js"></script>
</body>

</html>