<div class="hide-on-desk" style="position: relative; margin-top: 150px !important"></div>
<div class="page-title-wrapper" aria-label="Page title">
    <div class="${config_site_layout_custom}">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="mt-n1 mr-1"><i data-feather="home" class="custom_loja_texto"></i></li>
                <li class="breadcrumb-item"><a href="${baseUri}" class="custom_loja_texto">Home</a>
                </li>
                <li class="breadcrumb-item active"><a href="#" class="custom_loja_texto">Carrinho</a>
                </li>
            </ol>
        </nav>
        <h1 class="page-title custom_loja_texto font_smooth" style="font-weight: 400;">Seu Carrinho</h1><span class="d-block mt-2 text-muted"></span>
    </div>
</div>
<!-- Page Content-->
<div class="${config_site_layout_custom} pb-5 mt-n2 mt-md-n3" id="vm">
    <div class="row" v-if="carrinho != null">
        <div class="col-xl-8 col-md-7">
            <h2 class="h6 d-flex flex-wrap justify-content-between align-items-center px-4 py-3 bg-secondary custom_menu_texto custom_menu_fundo font_smooth">
                <span class="custom_menu_texto_no_hover">Produtos</span>
                <a class="font-size-sm custom_menu_texto" href="${baseUri}"><i data-feather="chevron-left" style="width: 1rem; height: 1rem;"></i>Veja mais produtos</a>
            </h2>
            <!-- Item-->
            <div v-for="cart in carrinho" class="d-sm-flex justify-content-between my-4 pb-4">
                <div class="media d-block d-sm-flex text-center text-sm-left">
                    <a class="cart-item-thumb mx-auto mr-sm-4 text-center">
                        <img :src="'${baseUri}/thumb/resize/?w=100&h=100&f=' + cart.produto.produto_imagens[0].foto_produto_img" alt="produto">
                        <label :for="'btn-arquivo-' + cart.carrinho_id" class="btn btn-primary btn-sm mt-4 pointer" v-if="cart.produto.produto_arquivo == '1' && cart.produto.arquivo_url == undefined">
                            Anexar Arquivo
                        </label>
                        <label :for="'btn-arquivo-' + cart.carrinho_id" class="btn btn-success btn-sm mt-4 pointer" v-if="cart.produto.produto_arquivo == '1' && cart.produto.arquivo_url != undefined">
                            Alterar Arquivo
                        </label>
                        <form action="${baseUri}/Carrinho/salva_arquivo" method="post" enctype="multipart/form-data" :id="'form-arquivo-' + cart.carrinho_id">
                            <input type="hidden" name="carrinho_id" :value="cart.carrinho_id">
                            <input type="file" name="arquivo" v-on:change="upload_arquivo(cart.carrinho_id)" :id="'btn-arquivo-' + cart.carrinho_id" style="display: none;" class="btn-trigger-arquivo">
                        </form>
                    </a>
                    <div class="media-body pt-3">
                        <h4 class="font-weight-semibold border-0" style="padding-bottom: 0px !important">
                            <a class="custom_loja_texto" :href="'${baseUri}/produto/' + cart.produto.produto_url">{{ cart.produto.produto_titulo }} </a>
                        </h4>

                        <div v-if="cart.produto.atributos_selecionados != undefined">
                            <div v-for="(att, index) in cart.produto.nomes_atributos" class="font-size-sm" style="font-size: .775rem !important;">
                                <span class="text-muted mr-2 custom_loja_texto">{{ att.atributo_nome }}:</span>{{ cart.produto.nomes_atributos_selecionados[index] }}
                            </div>
                        </div>

                        <div class="font-size-lg text-primary pt-2 custom_loja_texto hide-on-orcamento">
                            <span v-if="Number(cart.produto.produto_preco_original) > Number(cart.produto.produto_preco)">
                                <small style="text-decoration: line-through; color: red !important;">
                                    {{ Number(cart.produto.produto_preco_original).toLocaleString('pt-BR', { style: 'currency', currency: 'BRL',maximumFractionDigits: 2 }) }}
                                </small>
                                <br>
                            </span>
                            R$ {{ cart.produto.produto_preco }}
                            <br>
                            <span style="font-size: 14px !important;" v-if="cart.produto.desc_boleto>0">
                                à vista <span class="text-success">
                                    R$ {{ cart.produto.produto_preco_desc_boleto }}
                                </span>
                                <small>({{ cart.produto.desc_boleto }}% de desconto)
                                </small><br>
                            </span>

                        </div>
                    </div>
                </div>
                <div class="pt-2 pt-sm-0 pl-sm-3 mx-auto mx-sm-0 text-center text-sm-left" style="max-width: 10rem;">
                    <div class="form-group mb-2">
                        <label for="quantity1" class="custom_loja_texto">Quantidade</label>
                        <input class="form-control form-control-sm qtd-ipt-cart" :data-cart="cart.carrinho_id" type="number" :value="cart.produto.qtd" min="1" :id="'qtd-' + cart.carrinho_id" :max="cart.produto.qtd_max" :maxlength="cart.produto.qtd_max"
                            data-toggle="tooltip"
                            :title="'Quantidade disponível: ' + cart.produto.qtd_max">
                    </div>
                    <!--
                    <button class="btn btn-outline-secondary btn-sm btn-block mb-2" type="button" v-on:click="atualizaItemCarrinho(cart.carrinho_id)"><i class="fa fa-refresh" aria-hidden="true"></i> Atualizar</button>
                    -->
                    <button class="btn btn-outline-danger btn-sm btn-block mb-2" type="button" v-on:click="removeItemCarrinho(cart.carrinho_id)"><i class="fa fa-trash" aria-hidden="true"></i> Remover</button>
                </div>
            </div>
            <!-- Item-->

        </div>
        <!-- Sidebar-->
        <div class="col-xl-4 col-md-5 pt-3 pt-md-0">
            <h2 class="h6 px-4 py-3 bg-secondary text-center custom_menu_fundo custom_menu_texto_no_hover font_smooth hide-on-orcamento">Subtotal</h2>
            <div class="h3 font-weight-semibold text-center py-3 custom_loja_texto hide-on-orcamento">{{ subtotal}}

                <br>
                <span style="font-size: 14px !important;" v-if="subtotal_desconto >0">
                    à vista <span class="text-success">
                        R$
                        {{ subtotal_desconto.toLocaleString('pt-BR', { style: 'currency', currency: 'BRL', minimumFractionDigits: 2,  
  maximumFractionDigits: 2 }) }}
                    </span>
            </div>

            <hr>
            <a class="btn btn-primary btn-block font_smooth btn-fin-compra" id="btn-fin-compra" href="${baseUri}/checkout"><i class="mr-2" data-feather="credit-card"></i>
                <span v-if="'${config_site_modo}' == '1'">
                    Concluir Compra
                </span>
                <span v-if="'${config_site_modo}' == '2'">
                    Concluir Orçamento
                </span>
            </a>
            <br><br><br>
            <div class="row hide-on-orcamento">
                <div class="col-sm-12">
                    <h2 class="h6 px-4 py-3 bg-secondary text-center custom_menu_fundo custom_menu_texto_no_hover font_smooth">Opções de Frete</h2>
                </div>
                <div class="col-sm-12 col-md-10">
                    <label for="cep" class="custom_loja_texto">Digite seu CEP</label>
                    <input type="text" class="form-control cep" id="cepVal" value="${cep}">
                </div>
                <div class="col-sm-12 col-md-2 align-self-end">
                    <button class="btn btn-primary btn-frete" v-on:click="getFrete()"><i class="fa fa-search"></i></button>
                </div>
            </div>
            <div class="row pt-4 hide-on-orcamento">
                <div class="col-sm-12 text-center" v-if="loadingFrete">
                    <h4 class="custom_loja_texto">Calculando Frete</h4>
                    <div class="spinner-border" role="status">
                        <span class="sr-only">Loading...</span>
                    </div>

                </div>
                <div class="col-sm-12" v-if="!loadingFrete && opcoesFrete != null">
                    <h4 class="custom_loja_texto">Valores de Frete</h4>
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead>
                                <tr>
                                    <th class="align-middle custom_loja_texto">Valor</th>
                                    <th class="align-middle custom_loja_texto">Empresa</th>
                                    <th class="align-middle custom_loja_texto">Entrega</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr v-for="opc of opcoesFrete">
                                    <td class="align-middle">
                                        <span class="text-dark" v-if="Number(opc.price) > 0">{{ Number(opc.price).toLocaleString('pt-BR', { style: 'currency', currency: 'BRL',maximumFractionDigits: 2 }) }}</span>
                                        <span class="text-dark" v-if="Number(opc.price) == 0">Grátis</span>
                                    </td>
                                    <td class="align-middle">
                                        <span class="text-dark custom_loja_texto">{{ opc.name }}</span>
                                    </td>
                                    <td class="align-middle">
                                        <span class="text-dark custom_loja_texto" v-if="opc.deadline > 1">{{ opc.deadline }} dias úteis</span>
                                        <span class="text-dark custom_loja_texto" v-else>{{ opc.deadline }} dia útil</span>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

        </div>
    </div>
    <div v-else>
        <h3 class="text-primary text-center custom_loja_texto"> Nenhum produto no carrinho </h3>
    </div>
</div>