<!DOCTYPE html>
<html lang="pt-br">

<head>
    <title>${config_site_title} <?= (!empty($data['config']->config_site_slogan)) ? ' - ' . $data['config']->config_site_slogan : ''; ?></title>
    <!-- SEO -->
    @(tema.loja.partials.meta_tags)
    @(tema.loja.partials.og_tags)
    <!-- SEO -->
    <link rel="icon" type="image/png" sizes="32x32" href="${baseUri}/media/site/${config_site_favicon}">
    @(tema.loja.partials.css-padrao)
</head>

<body>
    <!-- SEO -->
    @(tema.loja.partials.google_analytics)
    @(tema.loja.partials.google_tag_manager)
    <!-- SEO -->
    @(tema.loja.partials.menu-superior)

    <section class="${config_site_layout_custom} pt-5 pb-4 mt-mobile">
        <div class="row">

            <div class="col-sm-12 col-xs-12 col-md-8 col-lg-8">
                <div class="row">
                <!--Exibindo um alert de successo quando o orçamento for enviado-->
                <?php if(isset($_GET['orcamento_enviado'])):?>
                <div class="col-sm-12" style="margin-bottom: 35px">
                <div class="alert alert-success" role="alert">
                    <h4 style="color:#279a62;font-weight: bold">Recebemos seu orçamento, consulte seu email para mais detalhes.</h4>
                </div>
                </div> 
                <?php endif ?>
                    <div class="col-sm-12">
                        <h2 class="h3 text-center pb-4 custom_loja_texto"><i class="fa fa-question-circle"></i> Atendimento</h2>
                        <p>Entre em contato com nossa equipe de Atendimento ao Cliente sobre alguma dúvida, eventual problema ou outros assuntos. </p>
                    </div>
                    <div class="col-sm-12 col-md-4 mt-3">
                        <?php if (isset($data['config']->config_site_tel1) && !empty($data['config']->config_site_tel1)) : ?>
                            <ul>
                                <li class="mt-3">
                                    <a class="nav-link-inline nav-link-light" href="#">
                                        <i class="widget-categories-indicator custom_rodapeInformacoes_texto" data-feather="phone"></i>
                                        <span class="font-size-sm custom_rodapeInformacoes_texto">${config_site_tel1}</span>
                                    </a>
                                </li>
                                <?php if (isset($data['config']->config_site_tel2) && !empty($data['config']->config_site_tel2)) : ?>
                                    <li class="mt-3">
                                        <a class="nav-link-inline nav-link-light" href="#">
                                            <i class="widget-categories-indicator fa fa-whatsapp fa-2x custom_rodapeInformacoes_texto" aria-hidden="true"></i>
                                            <span class="font-size-sm custom_rodapeInformacoes_texto">${config_site_tel2}</span>
                                        </a>
                                    </li>
                                <?php endif; ?>
                                <?php if (isset($data['config']->config_site_email) && !empty($data['config']->config_site_email)) : ?>
                                    <li class="mt-3">
                                        <a class="nav-link-inline nav-link-light" href="#">
                                            <i class="widget-categories-indicator custom_rodapeInformacoes_texto" data-feather="mail"></i>
                                            <span class="font-size-sm custom_rodapeInformacoes_texto">${config_site_email}</span>
                                        </a>
                                    </li>
                                <?php endif; ?>
                            </ul>
                        <?php endif; ?>
                    </div>
                    <div class="col-sm-12 col-md-8 mt-3">
                        <ul>
                            <?php if (isset($data['config']->config_site_cep) && !empty($data['config']->config_site_cep)) : ?>
                                <li class="mt-3">
                                    <a class="nav-link-inline nav-link-light custom_rodapeInformacoes_texto" href="#">
                                        <i class="widget-categories-indicator custom_rodapeInformacoes_texto" data-feather="map-pin"></i>
                                        <span class="font-size-sm">${config_site_rua}, nº ${config_site_num}, ${config_site_bairro} - ${config_site_cidade}, ${config_site_uf}. CEP ${config_site_cep}</span>
                                    </a>
                                </li>
                            <?php endif; ?>

                            <?php if (isset($data['config']->config_site_funcionamento) && !empty($data['config']->config_site_funcionamento)) : ?>
                                <li class="mt-3">
                                    <a class="nav-link-inline nav-link-light" href="#">
                                        <i class="widget-categories-indicator custom_rodapeInformacoes_texto" data-feather="clock"></i>
                                        <span class="font-size-sm custom_rodapeInformacoes_texto">${config_site_funcionamento}</span>
                                    </a>
                                </li>
                            <?php endif; ?>
                        </ul>
                    </div>
                    <div class="col-sm-12 mt-3">
                        <div class="contact-map mb-7">
                            <iframe src="https://www.google.com.br/maps?q=${params_embed_google},%20Brasil&output=embed" style="width: 100%;" height="363px"></iframe>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-sm-12 col-xs-12 col-md-4 col-lg-4">
                <h2 class="h3 text-center pb-4 custom_loja_texto"><i class="fa fa-envelope"></i> Contato</h2>
                <form action="${baseUri}/atendimento/send" method="post">
                    <div class="row">
                        <div class="col-sm-12">
                            <label for="contato_nome">Nome</label>
                            <input type="text" class="form-control" name="contato_nome">
                        </div>
                        <div class="col-sm-12 mt-2">
                            <label for="contato_email">E-mail</label>
                            <input type="email" class="form-control" name="contato_email">
                        </div>
                        <div class="col-sm-12 mt-2">
                            <label for="contato_telefone">Telefone</label>
                            <input type="text" class="form-control celular" name="contato_telefone">
                        </div>
                        <div class="col-sm-12 mt-2">
                            <label for="contato_assunto">Assunto</label>
                            <input type="text" class="form-control" name="contato_assunto">
                        </div>
                        <div class="col-sm-12 mt-2">
                            <label for="contato_mensagem">Mensagem</label>
                            <textarea class="form-control" name="contato_mensagem" rows="5"></textarea>
                        </div>
                        <div class="col-sm-12 mt-2">
                            <label for="contato_captcha">Insira os caracteres da imagem </label>
                        </div>
                        <div class="col-sm-4 col-xs-4 col-lg-4 col-md-4 mt-2">
                            <img src="${baseUri}/atendimento/img_captcha" style="width: 100% !important; height: 42px !important">
                        </div>
                        <div class="col-sm-8 col-xs-8 col-lg-8 col-md-8 mt-2">
                            <input type="text" class="form-control" name="contato_captcha">
                        </div>
                        <div class="col-sm-12 mt-2">
                            <button class="btn btn-primary btn-block"><i class="fa fa-send"></i> Enviar mensagem</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </section>


    @(tema.loja.partials.toasts)
    @(tema.loja.partials.footer)

    <script>
        const baseUri = "${baseUri}";
    </script>
    <script src="assets/js/jquery.min.js"></script>
    <script src="assets/js/vendor.min.js"></script>
    <script src="assets/js/theme.min.js"></script>
    <script src="assets/js/toasts.js"></script>
    <script src="assets/js/template.js"></script>
    <script src="assets/js/vue.min.js"></script>
    <script src="assets/js/carrinho.js"></script>
    <script src="assets/js/jquery.mask.min.js"></script>
    <script src="assets/js/main.js?v=<?= rand(); ?>"></script>
    <script>
        setMasks();
    </script>
    <?php if(isset($_GET['captcha'])):?>
    <script>
        alert_error('Erro no formulário de contato','Captcha incorreto');
    </script>
    <?php endif ?>
</body>

</html>