<div class="row">
    <div class="col-sm-10 col-md-6">
        <label for="produtos_nao_relacionados">Adicionar produto relacionado <span class="text-danger">*</span> </label>
        <select id="produtos_nao_relacionados" class="form-control select2" style="width: 100%;">
            <option v-if="!produtos_nao_relacionados">Nenhum produto para relacionar</option>
            <option v-else v-for="prod in produtos_nao_relacionados" :value="prod.produto_id">{{ prod.produto_titulo }}</option>
        </select><br><br>
    </div>
    <div class="col-sm-2 col-md-1 align-self-end">
        <a class="btn btn-primary botoesAdd" id="btnAddProdutoRelacionado" v-on:click="relaciona_produto()" style="cursor: pointer;"><i class="fa fa-plus text-white"></i></a><br><br>
    </div>
</div>

<div class="row">
    <div class="col-sm-12">
        <br><br>
        <h3>Produtos relacionados</h3>
        <div id="tbl-splash" style="width: 5rem; height: 5rem; margin-left: 50%" role="status"></div>
        <div id="tbl-div" class="table-responsive m-ts-40">
            <table id="datatable" class="datatable display nowrap table table-hover table-striped table-bordered" cellspacing="0" width="100%">
                <thead>
                    <tr>
                        <th class="">Foto <i class="fa fa-sort" aria-hidden="true" style="cursor: pointer"></i></th>
                        <th class="">Produto <i class="fa fa-sort" aria-hidden="true" style="cursor: pointer"></i></th>
                        <th class="d-print-none text-right">Ações</th>
                    </tr>
                </thead>
                <tbody>
                    <tr v-for="post in produtos_relacionados">
                        <td width="60"><img :src="baseUri + '/media/produto/' + post.produto_foto" style="width: 60px;"></td>
                        <td class="">{{post.produto_titulo}}</td>
                        <td class="d-print-none text-right">
                            <a class="btn btn-sm btn-danger menu-access text-white" style="cursor: pointer;" data-id="ProdutosAdmin:G" data-toggle="tooltip" title="remover" v-on:click="prepareRemoverRelacionado(post.produto_id)">
                                <i class="fas fa-trash text-white"></i>
                            </a>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>

</div>

<div id="modal-remove-relacionado" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true" style="display: none;">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title" id="mySmallModalLabel">Remover produto relacionado</h4>
                <a type="button" class="close" data-dismiss="modal" aria-hidden="true">×</a>
            </div>
            <div class="modal-body">
                <div class="col-md-12 text-center">
                    <i class="text-warning fa fa-4x fa-exclamation-triangle"></i>
                    <br></br>
                    <h2 class="text-center">Atenção!</h2>
                    <p class="text-center" style="color: black">Você está prestes à remover um produto relacionado.
                        Deseja realmente prosseguir ?</p>
                </div>
            </div>
            <div class="modal-footer text-white">
                <a type="button" class="btn btn-primary waves-effect" data-dismiss="modal"><i class="fa fa-times-circle"></i> Cancelar</a>
                <a id="btn-remove-relacionado" type="button" class="btn btn-danger waves-effect waves-light" v-on:click="removerRelacionado()"><i class="fa fa-trash"></i> Remover</a>
            </div>
        </div>
    </div>
</div>