var table;
var vm = new Vue({
    el: "#vm",
    data: {
        produto: null,
        atributos: null,
        attr: null,

        selected: false,
        remove_a: false,
        selected: false,
        galerias: null,
        data_remove: new Array(),

        produtos_nao_relacionados: null,
        produtos_relacionados: null,
        relacionado_remove: null,

        produto_titulo: null,
        produto_desc: null,

        marcas: null,

        atributoRemove: null,

        // new atributos
        breadcrumb: [],
        breadcrumbItens: [],
        qtdAtributos: 0,

        atributoPrincipal: null,
        atributoAtual: null, // atributo no qual o usuario vai estar mexendo na hora
        todosAtributos: [],

        atributoAtualPredominante: false, // caso seja true, o atributo atual é o ultimo na hierarquia, portanto, liberar edição de estoque
        atributoAtualIndice: null, // caso seja 0, renderiza o atributo principal, se nao, renderiza o item do selecionado

        // new Categorias e Subs
        categorias: null, // contém todas as categorias e suas subs, além das categorias/subs exclusivas deste produto
        categoriasVinculadas: [], // contém as categorias que este produto possui vinculo
        subcategoriasVinculadas: [], // contém as subcategorias que este produto possui vinculo
    },
    methods: {
        show_modal_help_atributos: () => {
            $("#modalHelpAtributos").modal("show");
        },
        resetAtributos: () => {
            vm.breadcrumb = [];
            vm.breadcrumbItens = [];
            vm.atributoAtual = null;
            vm.atributoAtualPredominante = false;
            vm.atributoAtualIndice = null;
        },
        prevAtributo: () => {
            vm.todosAtributos.pop();
            vm.atributoAtual = vm.todosAtributos[vm.todosAtributos.length - 1];

            vm.atributoAtualIndice--;
            // -------------------------- AJUSTAR PREV DE ATRIBUTO ATUAL

            vm.breadcrumb.pop();
            vm.breadcrumbItens.pop();

            if (vm.atributoAtual.atributo_is_mandante == "1") {
                vm.atributoAtualPredominante = true;
            } else {
                vm.atributoAtualPredominante = false;
            }
            $(".moeda").unmask();
            $(".moeda").mask("000.000.000.000.000,00", { reverse: true });
        },
        nextAtributo: (index) => {
            let nomeItemAnterior =
                vm.atributoAtual.item[index].item_atributo_nome;
            let idItem = vm.atributoAtual.item[index].item_atributo_id;

            vm.atributoAtual =
                vm.todosAtributos[vm.atributoAtualIndice].item[
                    index
                ].item_atributo_filhos;

            vm.todosAtributos.push(vm.atributoAtual);
            vm.atributoAtualIndice++;

            vm.breadcrumb.push(nomeItemAnterior);
            vm.breadcrumbItens.push(idItem);

            if (vm.atributoAtual.atributo_is_mandante == "1") {
                vm.atributoAtualPredominante = true;
                // Busca os valores com base nos breadcrumbItens
                let data = {
                    produto_id: $("#produto_id").val(),
                    itens_pai: vm.breadcrumbItens,
                    atributo_atual: vm.atributoAtual,
                };

                let url = baseUri + "/ProdutosAdmin/getAtributoMandanteValores";
                $.post(url, data).then((res) => {
                    res = JSON.parse(res);
                    if (res.status != undefined && res.status == 200) {
                        vm.atributoAtual = res.atributo_atual;
                        $(".moeda").unmask();
                        $(".moeda").mask("000.000.000.000.000,00", {
                            reverse: true,
                        });
                    }
                });
            } else {
                vm.atributoAtualPredominante = false;
            }
        },
        addAtributo: () => {
            let att = $("#atributoAdd").val();

            if (Number(att) > 0) {
                let dados = {
                    produto_id: $("#produto_id").val(),
                    atributo_id: att,
                };
                let url = baseUri + "/ProdutosAdmin/gravarAtributo";
                $.post(url, dados).then((res) => {
                    if (res.trim() == "1") {
                        alert_success("Atributo adicionado");
                        vm.resetAtributos();
                        vm.lista_atributo();
                        vm.lista_atributo_e_itens();

                        $(".dropify").dropify("destroy");
                        setTimeout(() => {
                            $(".dropify").dropify({
                                messages: {
                                    default:
                                        "Clique aqui para selecionar um arquivo",
                                    replace:
                                        "Clique para selecionar um novo arquivo",
                                    error: "Ocorreu um erro ao alterar o arquivo",
                                },
                                error: {
                                    fileSize:
                                        "O tamanho máximo permitido é de: ({{ value }}).",
                                    minWidth:
                                        "The image width is too small ({{ value }}}px min).",
                                    maxWidth:
                                        "The image width is too big ({{ value }}}px max).",
                                    minHeight:
                                        "The image height is too small ({{ value }}}px min).",
                                    maxHeight:
                                        "The image height is too big ({{ value }}px max).",
                                    imageFormat:
                                        "Os formatos de imagem permitidos são: ({{ value }}).",
                                    fileExtension:
                                        "As extensões permitidas são: ({{ value }}).",
                                },

                                tpl: {
                                    clearButton:
                                        '<button type="button" class="dropify-clear" onclick="rem_capa()" >{{ remove }}</button>',
                                },
                            });
                        }, 1200);
                    }
                });
            } else {
                alert_error("Selecione um atributo válido.");
            }
        },
        // Lista todos os atributos que o produto não tem ligação
        lista_atributo: () => {
            var url = baseUri + "/ProdutosAdmin/lista_atributos/";
            var _this = this;
            $.post(url, { produto_id: $("#produto_id").val() }).then(function (
                rs
            ) {
                if (rs != null) {
                    vm.atributos = JSON.parse(rs);
                } else {
                    vm.atributos = null;
                }
            });
        },
        lista_atributo_e_itens: () => {
            var url = baseUri + "/ProdutosAdmin/lista_atributos_full/";
            $.post(url, { produto_id: $("#produto_id").val() }).then(function (
                rs
            ) {
                if (rs != null) {
                    res = JSON.parse(rs);

                    if (res.atributo == undefined) {
                        $("#produto_estoque").val(
                            $("#produto_estoque_hidden").val()
                        );
                        document.getElementById(
                            "produto_estoque"
                        ).disabled = false;

                        return;
                    }
                    if (res.atributo && res.atributo.atributo_tipo == 3) {
                        console.log(res.atributo);
                    }
                    vm.atributoAtual = res.atributo;
                    vm.todosAtributos = [res.atributo];
                    vm.qtdAtributos = res.qtdAtributos;
                    vm.atributoAtualIndice = 0;

                    if (vm.atributoAtual != undefined) {
                        if (vm.atributoAtual.atributo_is_mandante == "1") {
                            vm.atributoAtualPredominante = true;
                            let data = {
                                produto_id: $("#produto_id").val(),
                                itens_pai: vm.breadcrumbItens,
                                atributo_atual: vm.atributoAtual,
                            };
                            let url =
                                baseUri +
                                "/ProdutosAdmin/getAtributoMandanteValores";
                            $.post(url, data).then((res) => {
                                res = JSON.parse(res);

                                if (
                                    res.status != undefined &&
                                    res.status == 200
                                ) {
                                    vm.atributoAtual = res.atributo_atual;
                                }
                            });
                        } else {
                            vm.atributoAtualPredominante = false;
                        }

                        // Outro meio para saber se o atributo atual é mandante
                        if (
                            vm.atributoAtual.item[0].item_atributo_filhos ==
                            undefined
                        ) {
                            vm.atributoAtualPredominante = true;
                            let data = {
                                produto_id: $("#produto_id").val(),
                                itens_pai: vm.breadcrumbItens,
                                atributo_atual: vm.atributoAtual,
                            };

                            let url =
                                baseUri +
                                "/ProdutosAdmin/getAtributoMandanteValores";
                            $.post(url, data).then((res) => {
                                res = JSON.parse(res);

                                if (
                                    res.status != undefined &&
                                    res.status == 200
                                ) {
                                    vm.atributoAtual = res.atributo_atual;
                                }
                            });
                        } else {
                            vm.atributoAtualPredominante = false;
                        }
                        if (res.qtdEstoque == null) res.qtdEstoque = 0;
                        $("#produto_estoque").val(res.qtdEstoque);
                        document.getElementById(
                            "produto_estoque"
                        ).disabled = true;
                    }
                } else {
                    document.getElementById("produto_estoque").disabled = false;
                    vm.atributoAtual = null;
                }

                setTimeout(() => {
                    $(".moeda").unmask();
                    $(".moeda").mask("000.000.000.000.000,00", {
                        reverse: true,
                    });
                }, 200);
            });
        },
        prepareRemoveAtributo: (atributo_id) => {
            this.atributoRemove = atributo_id;
            $("#modalRemoveAtributo").modal("show");
        },
        removeAtributo: () => {
            let dados = {
                produto_id: $("#produto_id").val(),
                atributo_id: this.atributoRemove,
            };

            let url = baseUri + "/ProdutosAdmin/removerAtributo";

            $.post(url, dados).then((res) => {
                $("#modalRemoveAtributo").modal("hide");
                if (res == "1") {
                    console.log(res);
                    vm.resetAtributos();
                    vm.lista_atributo_e_itens();
                    vm.lista_atributo();
                    alert_success("Atributo removido com sucesso");
                } else {
                    alert_error("Erro ao remover o atributo");
                }
                vm.atributoRemove = null;
            });
        },
        listarMarcas: function () {
            var url = baseUri + "/marca/listar/";
            var self = this;
            $.getJSON(url, {}, function (dados) {}).then(function (dados) {
                if (dados != null) {
                    self.marcas = dados;
                } else {
                    self.marcas = null;
                }
            });
        },
        //#region fotos
        listarGaleria: function () {
            var url =
                baseUri +
                "/ProdutosAdmin/lista_img_produto/id/" +
                $("#produto_id").val();
            var _this = this;
            $.getJSON(url, function (dados) {
                $("#tbl-div").hide().promise().done($("#tbl-splash").show());
                $("#datatable").DataTable().destroy();
                if (dados != null) {
                    _this.galerias = dados;
                } else {
                    _this.galerias = null;
                }
                if (dados == null) {
                    _this.remove_a = false;
                } else {
                    _this.remove_a = true;
                }
            }).then(function (dados) {
                setTimeout(function () {
                    $("#tbl-splash")
                        .hide()
                        .promise()
                        .done($("#tbl-div").show());
                    _this.sortFotosPos();
                }, 500);
            });
        },
        add_class_remove: function (item) {
            var ele = $("#img-galeria-id-" + item.foto_produto_id);
            ele.toggleClass("border3px");

            if (ele.hasClass("border3px")) {
                alert_warning("Foto foi marcada para remoção");
            } else {
                alert_warning("Foto foi desmarcada para remoção");
            }

            var remove = $(".border3px");
            var _this = this;
            _this.$data.data_remove = new Array();
            if (remove.length > 0) {
                remove.each(function (index, element) {
                    var obj = {
                        id: $(element).data("remove"),
                        url: $(element).data("url"),
                    };
                    _this.$data.data_remove.push(obj);
                });
                this.selected = true;
            } else {
                this.selected = false;
            }
        },
        remove_img: function () {
            $("#modal-remove").modal("show");
        },
        remove_all: function () {
            var _this = this;
            var url = baseUri + "/ProdutosAdmin/remove_all_img_produto/";
            $.post(url, { produto_id: $("#produto_id").val() }).then(function (
                rs
            ) {
                if (parseInt(rs) == 0) {
                    alert_success("Fotos apagadas com sucesso!");
                    this.selected = false;
                    setTimeout(() => _this.listarGaleria(), 300);
                } else {
                    alert_success("Fotos não puderam ser apagadas");
                }
            });
        },

        remover: function () {
            var _this = this;
            var url = baseUri + "/ProdutosAdmin/remove_img/";
            $.post(url, {
                produto_id: $("#produto_id").val(),
                data: _this.$data.data_remove,
            }).then(function (rs) {
                if (parseInt(rs) == 0) {
                    alert_success("Fotos apagadas com sucesso!");
                    var remove = $(".border3px");

                    remove.each(function (index, element) {
                        $(element).removeClass("border3px");
                    });

                    // window.location.reload(false);
                    _this.listarGaleria();
                    _this.selected = false;
                } else {
                    alert_error("Fotos não puderam ser apagadas");
                }
            });
        },
        //#endregion
        // aparecer na table
        listar_produtos_relacionados: () => {
            var url =
                baseUri +
                "/ProdutosAdmin/lista_produtos_relacionados/id/" +
                $("#produto_id").val();
            $.post(url)
                .then(function (rs) {
                    if (rs != null) {
                        $("#tbl-div")
                            .hide()
                            .promise()
                            .done($("#tbl-splash").show());
                        $("#datatable").DataTable().destroy();
                        splash_dt();
                        vm.produtos_relacionados = JSON.parse(rs);
                        if (vm.produtos_relacionados != null) {
                            vm.produtos_relacionados.map((prod, i) => {
                                if (prod.produto_foto == null) {
                                    vm.produtos_relacionados[i].produto_foto =
                                        "nopic.jpg";
                                }
                            });
                        }
                    } else {
                        vm.produtos_relacionados = null;
                    }
                })
                .then(function (dados) {
                    setTimeout(function () {
                        $("#tbl-splash")
                            .hide()
                            .promise()
                            .done($("#tbl-div").show());
                        reload_dt_vue();
                    }, 500);
                });
        },
        // Aparecer no select
        listar_produtos_nao_relacionados: () => {
            var url =
                baseUri +
                "/ProdutosAdmin/lista_produtos_nao_relacionados/id/" +
                $("#produto_id").val();
            $.post(url).then(function (rs) {
                if (rs != null) {
                    vm.produtos_nao_relacionados = JSON.parse(rs);
                } else {
                    vm.produtos_nao_relacionados = null;
                }
                vm.$forceUpdate();
            });
        },

        relaciona_produto: () => {
            if ($("#produtos_nao_relacionados").val() > 0) {
                var url = baseUri + "/ProdutosAdmin/relaciona_produto/";
                $.post(url, {
                    produto1: $("#produto_id").val(),
                    produto2: $("#produtos_nao_relacionados").val(),
                }).then(function (rs) {
                    if (rs.trim() == "1") {
                        alert_success("Produto relacionado com sucesso");
                        vm.listar_produtos_nao_relacionados();
                        vm.listar_produtos_relacionados();
                    } else {
                        alert_error("Erro ao relacionar o produto.");
                    }
                    vm.$forceUpdate();
                });
            } else {
                alert_error("Selecione um produto para relacionar.");
            }
        },
        prepareRemoverRelacionado: (id) => {
            $("#modal-remove-relacionado").modal("show");
            vm.relacionado_remove = id;
        },
        removerRelacionado: () => {
            var url = baseUri + "/ProdutosAdmin/remove_relacao/";
            $.post(url, {
                produto1: $("#produto_id").val(),
                produto2: vm.relacionado_remove,
            }).then(function (rs) {
                if (rs.trim() == "1") {
                    alert_success("Relação removida com sucesso");
                    vm.listar_produtos_nao_relacionados();
                    vm.listar_produtos_relacionados();
                } else {
                    alert_error("Erro ao excluir relação do produto.");
                    console.log(rs);
                }
            });
            $("#modal-remove-relacionado").modal("hide");
        },
        lista_categorias: function () {
            var url = baseUri + "/ProdutosAdmin/lista_categoria_full/";
            var _this = this;
            _this.categorias = null;
            $.post(url).then(function (rs) {
                if (rs != null) {
                    rs = JSON.parse(rs);
                    _this.categorias = rs.categorias;
                } else {
                    _this.categorias = null;
                }
            });
        },
        lista: () => {
            if ($("#produto_id").val() > 0) {
                let url =
                    baseUri +
                    "/produtosAdmin/lista_por_id/" +
                    $("#produto_id").val();
                var _this = this;
                $.post(url).then((res) => {
                    if (res) {
                        _this.produto = JSON.parse(res);
                        _this.produto = _this.produto[0];
                        $("#produto_calcula_frete")
                            .val(_this.produto.produto_calcula_frete)
                            .trigger("change");

                        if ($("#produto_id").val() > 0) {
                            $("#produto_categoria2")
                                .val(_this.produto.produto_categoria)
                                .trigger("change");
                            setTimeout(
                                () =>
                                    $("#produto_subcategoria2")
                                        .val(_this.produto.produto_subcategoria)
                                        .trigger("change"),
                                50
                            );
                        } else {
                            $("#produto_categoria")
                                .val(_this.produto.produto_categoria)
                                .trigger("change");
                            setTimeout(
                                () =>
                                    $("#produto_subcategoria")
                                        .val(_this.produto.produto_subcategoria)
                                        .trigger("change"),
                                50
                            );
                        }

                        app.titulo = _this.produto.produto_titulo;
                        app.pagina_updated = _this.produto.produto_updated;
                        //$("#keywords_seo").val(_this.produto.produto_titulo);

                        $("#descSeo").hide();
                        $("#descProdutoSeo").html(_this.produto.produto_desc);
                    }
                });
            }
        },

        limpar: function () {
            $(".galeria-acao").html("Incluir");
        },
        cadastraCategoria: () => {
            let cat = $("#categoria_produto_nome").val().trim();
            if (cat == "") {
                alert_error("Insira o nome da categoria");
            } else {
                let url = baseUri + "/ProdutosAdmin/cadastroCategoria";
                let data = {
                    categoria_produto_nome: cat,
                    produto_id: $("#produto_id").val(),
                    // is_exclusiva: document.getElementById('categoria_produto_is_exclusiva').checked
                };
                $.post(url, data).then((res) => {
                    res = JSON.parse(res);
                    if (res.status == 200) {
                        $("#modalNovaCat").modal("hide");
                        alert_success("Categoria cadastrada com sucesso!");
                        $("#categoria_produto_nome").val("");
                        // document.getElementById('categoria_produto_is_exclusiva').checked = false;
                        vm.lista_categorias();
                    } else {
                        alert_error("Não foi possível cadastrar a categoria!");
                    }
                });
            }
        },
        cadastraSubcategoria: () => {
            let sub = $("#subcategoria_produto_nome").val().trim();
            let cat =
                Number($("#subcategoria_produto_categoria").val()) > 0
                    ? Number($("#subcategoria_produto_categoria").val())
                    : Number($("#subcategoria_produto_categoria").val());

            if (Number(cat) < 1) {
                alert_error("Selecione uma categoria");
            } else if (sub == "") {
                alert_error("Insira o nome da subcategoria");
            } else {
                let url = baseUri + "/ProdutosAdmin/cadastroSubcategoria";
                let data = {
                    subcategoria_produto_categoria: cat,
                    subcategoria_produto_nome: sub,
                    subcategoria_produto_pos: $(
                        "#subcategoria_produto_pos"
                    ).val(),
                    subcategoria_produto_ordem_destaque: $(
                        "#subcategoria_produto_ordem_destaque"
                    ).val(),
                    subcategoria_produto_apelido: $(
                        "#subcategoria_produto_apelido"
                    ).val(),
                    produto_id: $("#produto_id").val(),
                    // is_exclusiva: document.getElementById('subcategoria_produto_is_exclusiva').checked
                };
                $.post(url, data).then((res) => {
                    res = JSON.parse(res);
                    if (res.status == 200) {
                        $("#modalNovaSub").modal("hide");
                        alert_success("Subcategoria cadastrada com sucesso!");
                        $("#subcategoria_produto_nome").val("");
                        // document.getElementById('subcategoria_produto_is_exclusiva').checked = false;
                        vm.lista_categorias();
                    } else {
                        alert_error(
                            "Não foi possível cadastrar a subcategoria!"
                        );
                    }
                });
            }
        },

        // Métodos de vincular subs e cats com produtos
        getVinculoCategorias: () => {
            let url = baseUri + "/ProdutosAdmin/getVinculoCategorias";
            $.post(url, { produto_id: $("#produto_id").val() }).then((res) => {
                res = JSON.parse(res);
                if (res.status == 200) {
                    vm.categoriasVinculadas = res.categorias;
                    vm.subcategoriasVinculadas = res.subcategorias;
                } else {
                    vm.categoriasVinculadas = [];
                    vm.subcategoriasVinculadas = [];
                }
                vm.lista_categorias();
            });
        },
        vinculaCategoria: (categoria_id) => {
            if (categoria_id > 0) {
                let checkbox_id = "categoria-" + categoria_id;
                let data = {
                    produto_id: $("#produto_id").val(),
                    categoria_id: categoria_id,
                };

                let url = baseUri + "/ProdutosAdmin/";
                url +=
                    document.getElementById(checkbox_id).checked == true
                        ? "vinculaCategoria"
                        : "desvinculaCategoria";
                $.post(url, data).then((res) => {
                    res = JSON.parse(res);
                    if (res.status == 200) {
                        let msg =
                            document.getElementById(checkbox_id).checked == true
                                ? "Categoria vinculada com sucesso!"
                                : "Categoria desvinculada com sucesso!";
                        alert_success(msg);
                        vm.getVinculoCategorias();
                    } else {
                        alert_error("Erro ao realizar essa operação!");
                    }
                });
            }
        },
        vinculaSubcategoria: (categoria_id, subcategoria_id) => {
            if (categoria_id > 0 && subcategoria_id > 0) {
                let checkbox_id = "subcategoria-" + subcategoria_id;
                let data = {
                    produto_id: $("#produto_id").val(),
                    categoria_id: categoria_id,
                    subcategoria_id: subcategoria_id,
                };

                let url = baseUri + "/ProdutosAdmin/";
                url +=
                    document.getElementById(checkbox_id).checked == true
                        ? "vinculaSubcategoria"
                        : "desvinculaSubcategoria";
                $.post(url, data).then((res) => {
                    res = JSON.parse(res);
                    if (res.status == 200) {
                        let msg =
                            document.getElementById(checkbox_id).checked == true
                                ? "Subcategoria vinculada com sucesso!"
                                : "Subcategoria desvinculada com sucesso!";
                        alert_success(msg);
                        vm.getVinculoCategorias();
                    } else {
                        alert_error("Erro ao realizar essa operação!");
                    }
                });
            }
        },
        sortFotosPos: () => {
            var el = document.getElementById("sort");
            if (el) {
                var sortable = Sortable.create(el, {
                    animation: 750,
                    easing: "cubic-bezier(1, 0, 0, 1)",
                    onChange: function (evt) {
                        var id = $(evt.item).data("id");
                        var data = new Array();
                        var div = $(evt.to).children();
                        div.each(function (index, element) {
                            var obj = {
                                pos: index + 1,
                                foto_id: $(element).data("id"),
                            };
                            data.push(obj);
                        });
                        var url = baseUri + "/ProdutosAdmin/ordena_img/";
                        $.post(url, {
                            produto_id: $("#produto_id").val(),
                            data: data,
                        }).then(function (rs) {
                            if (parseInt(rs) == 0) {
                                alert_success("Posição Atualizada");
                            } else {
                                alert_error(
                                    "Não foi possível atualizar posição"
                                );
                            }
                        });
                    },
                });
            }
        },
    },
    created: function () {
        this.lista_categorias();
        loadPartials();
        this.listarMarcas();
        if ($("#produto_id").val() > 0) {
            this.lista();
            this.lista_atributo();
            this.lista_atributo_e_itens();
            this.listarGaleria();
            this.listar_produtos_relacionados();
            this.listar_produtos_nao_relacionados();
            this.getVinculoCategorias();
        } else {
            $("#descSeo, #descProdutoSeo").hide();
        }

        $("#produto_preco").val(Number($("#produto_preco").val()).toFixed(2));
    },
});

function loadPartials() {
    $(".partials").hide();
    $("#partialDados").show();
}

// altera valor atributo
function changeAttr(item) {
    item = item.split("|");
    var iattr_id = item[0];
    var atributo_id = item[1];
    var relacao_atributo = item[2];
    var item_id = $.trim($("#produto_id").val());
    var iattr_valor = $.trim($("#valor-" + iattr_id).val())
        ? $.trim($("#valor-" + iattr_id).val())
        : "";

    // apenas no atributo final
    var iattr_qtde = $.trim($("#qtde-" + iattr_id).val())
        ? $.trim($("#qtde-" + iattr_id).val())
        : "";
    var iattr_preco = $.trim($("#preco-" + iattr_id).val())
        ? $.trim($("#preco-" + iattr_id).val())
        : "";
    // Apenas no atributo final

    var url = baseUri + "/ProdutosAdmin/gravarItemAtributo/";
    let data = {
        iattr_id: iattr_id,
        produto: item_id,
        iattr_qtde: iattr_qtde,
        iattr_preco: iattr_preco,
        iattr_valor: iattr_valor,
        atributo_id: atributo_id,
        relacao: relacao_atributo,
        itens: vm.breadcrumbItens,
    };
    $.post(url, data, function (res) {
        res = JSON.parse(res);
        if (res.status != undefined && res.status == 200) {
            alert_success("Atributo atualizado!");
            $("#produto_estoque").val(res.qtdEstoque);
        } else {
            console.log(res);
            alert_error("Erro ao atualizar");
        }
    });
}

$(document).ready(function () {
    if ($("#produto_id").val() > 0) {
        $("#produtoNovo").html("");
    } else {
        $("#produtoEdit").html("");
    }
    // console.clear();
    setTimeout(() => {
        let image = $(".dropify-render");
        image = image.html();
        $("#img_facebook").html(image);
        $("#img_facebook").find("img").addClass("card-img-top");
        $("#img_facebook").find("img").css({
            width: "100%",
            height: "200px",
            "object-fit": "cover",
        });
    }, 500);
    $("#input-file-now-custom-1").on("change", function () {
        setTimeout(() => {
            let image = $(".dropify-render");
            image = image.html();
            $("#img_facebook").html(image);
            $("#img_facebook").find("img").addClass("card-img-top");
            $("#img_facebook").find("img").css({
                width: "100%",
                height: "200px",
                "object-fit": "cover",
            });
        }, 500);
    });

    $("#nova-galeria").on("click", function () {
        vm.limpar();
        $("#modal-galeria").modal("show");
    });

    $("#keywords_seo").attr("name", "produto_keywords");
    $("#pagina_desc").attr("name", "produto_desc");

    $("#keywords_seo").tagsinput({
        confirmKeys: [32],
        delimiter: ",",
    });
    redirect_tab();

    setTimeout(() => {
        if (vm.galerias != null) {
            // let image = $(".dropify-render");
            image = `
            <img src="${baseUri}/media/produto/${vm.galerias[0].foto_produto_img}">
            `;
            $("#img_facebook").html(image);
            $("#img_facebook").find("img").addClass("card-img-top");
            $("#img_facebook").find("img").css({
                width: "100%",
                height: "200px",
                "object-fit": "cover",
            });
        }
    }, 500);

    setTimeout(() => {
        var el = document.getElementById("sort");
        if (el) {
            var sortable = Sortable.create(el, {
                animation: 750,
                easing: "cubic-bezier(1, 0, 0, 1)",
                onChange: function (evt) {
                    var id = $(evt.item).data("id");
                    var data = new Array();
                    var div = $(evt.to).children();
                    div.each(function (index, element) {
                        var obj = {
                            pos: index + 1,
                            foto_id: $(element).data("id"),
                        };
                        data.push(obj);
                    });
                    var url = baseUri + "/ProdutosAdmin/ordena_img/";
                    $.post(url, {
                        produto_id: $("#produto_id").val(),
                        data: data,
                    }).then(function (rs) {
                        if (parseInt(rs) == 0) {
                            alert_success("Posição Atualizada");
                        } else {
                            alert_error("Não foi possível atualizar posição");
                        }
                    });
                },
            });
        }
    }, 200);
});

$(".money").mask("#.##0,00", { reverse: true });

$("#btn-remove").on("click", function () {
    $("#modal-remove").modal("hide");
    vm.remover();
});

$("#btn-remove-all").on("click", function () {
    $("#modal-remove-all").modal("hide");
    vm.remove_all();
});
// SEO
var app = new Vue({
    el: "#seo",
    data: {
        titulo: "",
        desc: "",
        categorias: null,
        cat_url: "${categoria_pagina_url}",
        pagina_url: "${pagina_url}",
        pagina_updated: "",
        pagina_nome: null,
        img: "",
        link: null,
        categoria_nome: null,
    },
    created: function () {},
});

function changeSeo(id, campo) {
    if (campo == "titulo") app.titulo = $(id).val();
    if (campo == "descricao") app.titulo = $(id).val();
}

$("#keywords_seo").change(function () {
    $("#produto_keywords").val($("#keywords_seo").val());
});

$(".nav-link").click((e) => {
    if ($(e.target).attr("data-id")) {
        let target = $(e.target).attr("data-id").split("|");
        $(".nav-link").removeClass("active");
        $("#" + target[1]).addClass("active");

        $(".partials").hide();
        $("#" + target[0]).show();
        $("#redirect").val(target[1].replace("nav", "").toLowerCase());
    }
});

function redirect_tab() {
    let url = window.location.href;

    if (url.indexOf("dados") != -1) {
        $(".nav-link").removeClass("active");
        $("#navDados").addClass("active");
        $(".partials").hide();
        $("#partialDados").show();
        $("#redirect").val("dados");
    } else if (url.indexOf("categorias") != -1) {
        $(".nav-link").removeClass("active");
        $("#navCategorias").addClass("active");
        $(".partials").hide();
        $("#partialCategorias").show();
        $("#redirect").val("categorias");
    } else if (url.indexOf("estoque") != -1) {
        $(".nav-link").removeClass("active");
        $("#navEstoque").addClass("active");
        $(".partials").hide();
        $("#partialEstoque").show();
        $("#redirect").val("estoque");
    } else if (url.indexOf("desc") != -1) {
        $(".nav-link").removeClass("active");
        $("#navDesc").addClass("active");
        $(".partials").hide();
        $("#partialDesc").show();
        $("#redirect").val("desc");
    } else if (url.indexOf("fotos") != -1) {
        $(".nav-link").removeClass("active");
        $("#navFotos").addClass("active");
        $(".partials").hide();
        $("#partialFotos").show();
        $("#redirect").val("fotos");
    } else if (url.indexOf("frete") != -1) {
        $(".nav-link").removeClass("active");
        $("#navFrete").addClass("active");
        $(".partials").hide();
        $("#partialFrete").show();
        $("#redirect").val("frete");
    } else if (url.indexOf("rel") != -1) {
        $(".nav-link").removeClass("active");
        $("#navRel").addClass("active");
        $(".partials").hide();
        $("#partialRel").show();
        $("#redirect").val("rel");
    } else if (url.indexOf("fiscal") != -1) {
        $(".nav-link").removeClass("active");
        $("#navFiscal").addClass("active");
        $(".partials").hide();
        $("#partialFiscal").show();
        $("#redirect").val("fiscal");
    }
}

$(".medida").mask("999.9");

Dropzone.autoDiscover = false;
Dropzone.prototype.defaultOptions.dictDefaultMessage =
    "Clique aqui ou arraste fotos";
// upload foto campo
dropzoneFotos = $("#form-galeria-img").dropzone({
    multiple: true,
    url: baseUri + "/ProdutosAdmin/enviar_img/id/" + $("#produto_id").val(),
    accept: function (file, done) {
        if (
            file.type == "image/jpeg" ||
            file.type == "image/png" ||
            file.type == "image/gif" ||
            file.type == "image/jpg" ||
            file.type == "image/webp"
        ) {
            done();
        } else {
            alert_error("Erro ao enviar fotos do produto");
        }
    },
    complete: function (file) {
        if (
            this.getUploadingFiles().length === 0 &&
            this.getQueuedFiles().length === 0
        ) {
            setTimeout(function () {
                console.log(file);
                if (file.status == "success") {
                    var msg = "Fotos enviadas com sucesso!";
                    alert_success(msg);
                    vm.listarGaleria();
                } else {
                    alert_error("Erro ao enviar fotos do produto");
                }
                Dropzone.forElement("#form-galeria-img").removeAllFiles(true);
            }, 300);
        }
    },
    sending: function (file, xhr, formData) {},
    error: function (file, response) {
        alert_error(
            "Falha ao enviar arquivo (s)!",
            "Verifique as imagens e tente novamente."
        );
        setTimeout(function () {}, 3000);
    },
    success: function (file, response) {
        console.log(response);
    },
    totaluploadprogress: function () {},
});

// Dropzone dos atributos
setTimeout(() => {
    $(".dropify").dropify({
        messages: {
            default: "Clique aqui para selecionar um arquivo",
            replace: "Clique para selecionar um novo arquivo",
            remove: "Remover",
            error: "Ocorreu um erro ao alterar o arquivo",
        },
        error: {
            fileSize: "O tamanho máximo permitido é de: ({{ value }}).",
            minWidth: "The image width is too small ({{ value }}}px min).",
            maxWidth: "The image width is too big ({{ value }}}px max).",
            minHeight: "The image height is too small ({{ value }}}px min).",
            maxHeight: "The image height is too big ({{ value }}px max).",
            imageFormat: "Os formatos de imagem permitidos são: ({{ value }}).",
            fileExtension: "As extensões permitidas são: ({{ value }}).",
        },

        tpl: {
            clearButton:
                '<button type="button" class="dropify-clear" onclick="rem_capa()" >{{ remove }}</button>',
        },
    });
}, 1200);
