var table;
var vm = new Vue({
    el: "#vm",
    data: {
        atributos: null,
        rm: null,
        url: null,
    },
    methods: {
        listar: function () {
            var url = baseUri + "/AtributosAdmin/lista/";
            var self = this;
            $.getJSON(url, {}, function (dados) {
                splash_dt();
            }).then(function (dados) {
                if (dados != null) {
                    self.atributos = dados;
                    setTimeout(function () {
                        $("#tbl-splash")
                            .hide()
                            .promise()
                            .done($("#tbl-div").show());
                        table = $("#datatable").DataTable({
                            language: datatable_ptbr,
                            aaSorting: [],
                            retrieve: true,
                            responsive: true,
                            rowReorder: true,
                            displayLength: 100,
                            pageLength: 100,
                        });
                        reload_dt_vue();
                    }, 500);
                } else {
                    self.atributos = null;
                }
                reload_dt_vue();
            });
        },
        editar: function (att) {
            console.log(att);
            this.limpar();
            $(".categoria-acao").html("Alterar");
            $("#modal-categoria").modal("show");
            $("#atributo_nome").val(att.atributo_nome);
            $("#atributo_id").val(att.atributo_id);
            $("#atributo_tipo").val(att.atributo_tipo).trigger("change");
        },
        limpar: function () {
            $(".categoria-acao").html("Incluir");
            $("#subcategoria_produto_nome").val("");
            $("#subcategoria_produto_id").val("");
            $("#atributo_tipo").val("1").trigger("change");
        },
        remover: function (dt) {
            vm.$data.rm = dt.atributo_id;
            $("#modal-remove").modal("show");
        },
        remove: function (id) {
            var url_remove = baseUri + "/AtributosAdmin/remover/";
            $.post(url_remove, { id: id }).then(function (rs) {
                if (rs == 1) {
                    alert_success(
                        "Ação realizada com sucesso!",
                        "Item removido"
                    );
                    vm.listar();
                } else {
                    alert_error("Ação não pode ser realizada!");
                }
            });
            $("#modal-remove").modal("hide");
        },
    },
    created: function () {
        $("#tbl-div").hide().promise().done($("#tbl-splash").show());
        this.listar();
    },
});
// click do modal
$("#btn-remove").on("click", function () {
    if (vm.$data.rm !== null) {
        vm.remove(vm.$data.rm, vm.$data.url);
    }
});
$("#nova-categoria").on("click", function () {
    vm.limpar();
    $("#modal-categoria").modal("show");
});
