<!DOCTYPE html>
<html lang="pt-br">

<head>
    <base href="${baseUri}/view/admin/">
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="description" content="${config_site_description}">
    <meta name="author" content="${config_site_author}">
    <meta name="keywords" content="${config_site_keywords}">
    <link rel="icon" type="image/png" sizes="16x16" href="${baseUri}/media/site/${config_site_favicon}">
    <title>${config_site_title} - Campos de Checkout</title>
    <link href="assets/plugins/bootstrap/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="assets/plugins/toast-master/css/jquery.toast.css">
    <link href="assets/plugins/bootstrap-select/bootstrap-select.min.css" rel="stylesheet" />
    <link href="assets/plugins/bootstrap-tagsinput/dist/bootstrap-tagsinput.css" rel="stylesheet" />
    <link href="assets/plugins/select2/dist/css/select2.min.css" rel="stylesheet">
    <link href="assets/css/style.css" rel="stylesheet">
    <!-- You can change the theme colors from here -->
    <link href="assets/css/colors/${config_tema_color}.css" id="theme" rel="stylesheet">
    <style>
        .select2-selection__rendered {
            line-height: 1.80rem !important;
        }

        .select2-container .select2-selection--single {
            height: 1.80rem !important;
        }

        .select2-selection__arrow {
            height: 1.80rem !important;
        }

        .modal-scroll {
            height: 300px !important;
            overflow-y: auto;
            overflow-x: hidden;
        }
    </style>
</head>

<body class="fix-header card-no-border logo-center">
    <div class="preloader">
        <svg class="circular" viewBox="25 25 50 50">
            <circle class="path" cx="50" cy="50" r="20" fill="none" stroke-width="2" stroke-miterlimit="10" />
        </svg>
    </div>

    <div id="main-wrapper">
        @(admin.layout.topo)
        @(admin.layout.topo-menu)
        <div class="page-wrapper" id="vm">
            <div class="container-fluid">
                <div class="row page-titles">
                    <div class="col-md-5 col-8 align-self-center">
                        <h3 class="text-themecolor m-b-0 m-t-0">Configurações</h3>
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="javascript:void(0);">Checkout</a></li>
                            <li class="breadcrumb-item active">Campos Adicionais no processo de compra</li>
                        </ol>
                    </div>
                    @(admin.layout.topo-info)
                    <div class="col-md-7 col-4 align-self-center">
                        <h6 class="float-right" style="padding-top: 20px">
                            <button id="novo-campo" data-id="ProdutosAdmin:G" class="btn btn-primary waves-effect waves-light text-white menu-access" v-on:click="show_add_campo()">
                                <i class="fa fa-plus-circle"></i> Novo
                                <span class="d-none d-xl-inline-block">Campo</span>
                            </button>
                        </h6>
                    </div>
                </div>

                <div class="row">
                    <div class="col-12">
                        <div class="card card-outline-primary">
                            <div class="card-header"><i class="text-white fas fa-th-list"></i>

                            </div>
                            <div class="card-body">
                                <div class="content">
                                    <div id="tbl-splash" class="spinner-border" style="width: 5rem; height: 5rem; margin-top: 5%; margin-left: 50%" role="status"></div>
                                    <div id="tbl-div" class="table-responsive m-ts-40">
                                        <table id="datatable" class="datatable display nowrap table table-hover table-striped table-bordered" cellspacing="0" width="100%">
                                            <thead>
                                                <tr>
                                                    <th class="">Título <i class="fa fa-sort" aria-hidden="true" style="cursor: pointer"></i></th>
                                                    <th class="">Produtos Atrelados <i class="fa fa-sort" aria-hidden="true" style="cursor: pointer"></i></th>

                                                    <th class="d-print-none text-right">Ações</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <tr v-for="campo in campos" :class="'campo-editar-' + campo.campo_checkout_id" :id="'campo-id-' + campo.campo_checkout_id">
                                                    <td class="">{{campo.campo_checkout_nome}}</td>

                                                    <td class=""> {{ campo.campo_checkout_produtos_vinculados }}</td>
                                                    <td class="d-print-none text-right">
                                                        <button class="btn btn-sm btn-primary menu-access" data-id="ProdutosAdmin:G" data-toggle="tooltip" title="editar" v-on:click="show_edit(campo)">
                                                            <i class="fas fa-edit"></i>
                                                        </button>

                                                        <button class="btn btn-sm btn-danger menu-access" data-id="ProdutosAdmin:G" data-toggle="tooltip" title="remover" v-on:click="show_remover(campo)">
                                                            <i class="fas fa-trash"></i>
                                                        </button>
                                                    </td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </div>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            @(admin.layout.footer)

            <div id="modal-campos" class="modal fade" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
                <div class="modal-dialog modal-lg">
                    <div class="modal-content">
                        <form action="${baseUri}/CamposExtras/gravar_campo/" method="post" enctype="multipart/form-data">
                            <div class="modal-header">
                                <h4 class="modal-title" id="mySmallModalLabel"><span class="categoria-acao">Gerenciar</span> Campo</h4>
                                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                            </div>
                            <div class="modal-body">
                                <input type="hidden" name="campo_checkout_id" v-if="campo_atual != null" :value="campo_atual.campo_checkout_id">

                                <div class="col-md-12 col-xs-12 col-sm-12">
                                    <div class="form-group">
                                        <label for="campo_checkout_nome">Nome do Campo <span class="text-danger">*</span></label>
                                        <input type="text" required class="form-control" placeholder="ex. horário de entrega " id="campo_checkout_nome" name="campo_checkout_nome" maxlength="255" required>
                                    </div>
                                </div>

                                <div class="col-md-12 col-xs-12 col-sm-12">
                                    <div class="form-group">
                                        <label for="campo_checkout_produtos">Aplicar aos produtos: <span class="text-danger">*</span></label>
                                        <select id="campo_checkout_produtos" class="form-control" name="produtos[]" multiple="multiple" style="width: 100% !important;">
                                            <option v-for="produto in produtos" :value="produto.produto_id"> {{ produto.produto_titulo }} </option>
                                        </select>
                                    </div>
                                </div>

                                <div class="col-md-12 col-xs-12 col-sm-12" v-if="produtos_vinculados != null">
                                    <div class="form-group modal-scroll">
                                        <label for="campo_checkout_produtos">Produtos Atrelados</label>

                                        <!-- produtos -->
                                        <div class="row" v-for="prod in produtos_vinculados">
                                            <div class="col-sm-12 col-md-10">
                                                {{ prod.produto_titulo }}
                                            </div>

                                            <div class="col-sm-12 col-md-2 align-self-center">
                                                <a class="btn btn-danger btn-sm text-white pointer" v-on:click="remove_produto_atrelado(prod.produto_id)"> <i class="fa fa-trash"></i> </a>
                                            </div>

                                            <div class="col-sm-12">
                                                <hr>
                                            </div>
                                        </div>
                                        <!-- produtos -->

                                    </div>
                                </div>
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-danger waves-effect" data-dismiss="modal"><i class="fa fa-times-circle"></i> Cancelar</button>
                                <button type="submit" class="btn btn-primary waves-effect waves-light"><i class="fa fa-check-circle"></i> Salvar</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>

            <div id="modal-remove" class="modal fade" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
                <div class="modal-dialog modal-lg">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title" id="mySmallModalLabel"><span class="categoria-acao">Remover</span> Campo</h4>
                            <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                        </div>
                        <div class="modal-body">
                            <div class="col-md-12 text-center">
                                <i class="text-warning fa fa-4x fa-exclamation-triangle"></i>
                                <br></br>
                                <h2 class="text-center">Atenção!</h2>
                                <p class="text-center" style="color: black">Você está prestes a remover um Campo de Checkout e todas as suas ligações com itens e esta ação não pode ser desfeita.<br>
                                    Deseja realmente prosseguir ?</p>
                            </div>

                        </div>
                        <div class="modal-footer">
                            <button type="button" v-on:click="campo_atual = null" class="btn btn-primary waves-effect" data-dismiss="modal"><i class="fa fa-times-circle"></i> Cancelar</button>
                            <button v-on:click="remove_campo()" class="btn btn-danger waves-effect waves-light"><i class="fa fa-check-circle"></i> Continuar</button>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>
    <script src="assets/plugins/jquery/jquery.min.js"></script>
    <!-- Bootstrap tether Core JavaScript -->
    <script src="assets/plugins/popper/popper.min.js"></script>
    <script src="assets/plugins/bootstrap/js/bootstrap.min.js"></script>
    <!-- slimscrollbar scrollbar JavaScript -->
    <script src="assets/js/jquery.slimscroll.js"></script>
    <!--Wave Effects -->
    <script src="assets/js/waves.js"></script>
    <!--Menu sidebar -->
    <script src="assets/js/sidebarmenu.js"></script>
    <!--stickey kit -->
    <script src="assets/plugins/sticky-kit-master/dist/sticky-kit.min.js"></script>
    <script src="assets/plugins/sparkline/jquery.sparkline.min.js"></script>
    <!--Custom JavaScript -->
    <script src="assets/js/custom.min.js"></script>
    <script src="assets/plugins/toast-master/js/jquery.toast.js"></script>
    <!-- Style switcher -->
    <script src="assets/plugins/styleswitcher/jQuery.style.switcher.js"></script>
    <!-- This is data table -->
    <script src="assets/plugins/datatables.net/js/jquery.dataTables.min.js"></script>
    <script src="assets/plugins/bootstrap-select/bootstrap-select.min.js" type="text/javascript"></script>
    <!-- start - This is for export functionality only -->
    <script src="assets/plugins/datatables-button/dataTables.buttons.min.js"></script>
    <script src="assets/plugins/datatables-button/buttons.flash.min.js"></script>
    <script src="assets/plugins/datatables-button/jszip.min.js"></script>
    <script src="assets/plugins/datatables-button/pdfmake.min.js"></script>
    <script src="assets/plugins/datatables-button/vfs_fonts.js"></script>
    <script src="assets/plugins/datatables-button/buttons.html5.min.js"></script>
    <script src="assets/plugins/datatables-button/buttons.print.min.js"></script>
    <script src="assets/plugins/jquery.mask.min.js"></script>
    <script src="assets/js/jquery.cookie.js"></script>
    <!-- PRINCIPAL JS -->
    <script src="assets/js/vue.min.js"></script>
    <script src="assets/plugins/select2/dist/js/select2.full.min.js" type="text/javascript"></script>
    <script src="assets/plugins/dropify/dist/js/dropify.min.js"></script>
    <script src="${baseUri}/view/admin/app-js/datatable.js"></script>
    <script src="${baseUri}/view/admin/app-js/main.js"></script>
    <script src="pedido/campos.js"></script>

</body>

</html>