var table;
var vm = new Vue({
    el: '#vm',
    data: {
        marcas: null,
        rm: null,
        url: null,
    },
    methods: {
        listar: function() {
            var url = baseUri + '/marca/listar/';
            var self = this;
            $.getJSON(url, {}, function(dados) {
                splash_dt();
            }).then(function(dados) {
                if (dados != null) {
                    self.marcas = dados;
                } else {
                    self.marcas = null;
                }
                reload_dt_vue();
            });
        },
        editar: (dt) => {
            $("#marca_id").val(dt.marca_id);
            $("#marca_nome").val(dt.marca_nome);
            $("#marca_logo").val(dt.marca_logo);

            let srcImg = baseUri + "/media/marca/" + dt.marca_logo;
            $("#modalNovaMarca").modal('show');
            $("#divShowFoto").show();
            $("#divAddFoto").hide();
            $("#btnAddFoto").show();
            $("#fotoShow").attr('src', srcImg);
        },

        remover: function(dt) {
            vm.$data.rm = dt.marca_id;
            $('#modal-remove').modal('show');
        },
        remove: function(id) {
            var url_remove = baseUri + '/marca/remover/';
            $.post(url_remove, { id: id }).then(function(rs) {
                if (rs == 1) {
                    alert_success('Ação realizada com sucesso!', 'Item removido');
                    vm.listar();
                } else {
                    alert_error('Ação não pode ser realizada!');
                }
            });
            $('#modal-remove').modal('hide');
        },
        limparModal: () => {

        }
    },
    created: function() {
        $('#tbl-div').hide().promise().done($('#tbl-splash').show());
        this.listar();
    }
});

// click do modal
$('#btn-remove').on('click', function() {
    if (vm.$data.rm !== null) {
        vm.remove(vm.$data.rm);
    }
});

$('#file-mass').dropify({
    messages: {
        default: '<div>Clique aqui para selecionar um arquivo (.png, .jpeg, .jpg)</div>',
        replace: '<div>Clique em remover para selecionar um novo arquivo</div>',
        remove: 'Remover',
        error: 'Ocorreu um erro ao alterar o arquivo'
    },
    error: {
        'fileSize': 'O tamanho máximo permitido é de: ({{ value }}).',
        'minWidth': 'The image width is too small ({{ value }}}px min).',
        'maxWidth': 'The image width is too big ({{ value }}}px max).',
        'minHeight': 'The image height is too small ({{ value }}}px min).',
        'maxHeight': 'The image height is too big ({{ value }}px max).',
        'imageFormat': 'Os formatos de imagem permitidos são: ({{ value }}).',
        'fileExtension': 'As extensões permitidas são: ({{ value }}).'
    }
});

function showModalAdd() {
    $("#marca_id").val("");
    $("#marca_nome").val("");
    $("#marca_logo").val("");
    $("#modalNovaMarca").modal('show');
    $("#divShowFoto").hide();
    $("#divAddFoto").show();
    $("#btnAddFoto").hide();
}

$("#btnAddFoto").click(function() {
    $("#divShowFoto").hide();
    $("#divAddFoto").show();
})