<!DOCTYPE html>
<html lang="pt-br">

<head>
    <base href="${baseUri}/view/admin/">
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <!-- Tell the browser to be responsive to screen width -->
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="description" content="${config_site_description}">
    <meta name="author" content="${config_site_author}">
    <meta name="keywords" content="${config_site_keywords}">
    <meta name="author" content="${config_seo_author}">
    <!-- Favicon icon -->
    <link rel="icon" type="image/png" sizes="16x16" href="${baseUri}/media/site/${config_site_favicon}">
    <title>${config_site_title} - Integração Bling</title>
    <!-- Bootstrap Core CSS -->
    <link href="assets/plugins/bootstrap/css/bootstrap.min.css" rel="stylesheet">
    <!-- Custom CSS -->
    <link rel="stylesheet" href="assets/plugins/toast-master/css/jquery.toast.css">
    <link href="assets/plugins/bootstrap-select/bootstrap-select.min.css" rel="stylesheet" />
    <link href="assets/css/style.css" rel="stylesheet">
    <link rel="stylesheet" href="assets/plugins/dropify/dist/css/dropify.min.css">
    <!-- You can change the theme colors from here -->
    <link href="assets/css/colors/${config_tema_color}.css" id="theme" rel="stylesheet">
    <!--[if lt IE 9]>
    <script src="assets/plugins/html5shiv.js"></script>
    <script src="assets/plugins/respond.min.js"></script>

    <![endif]-->
</head>

<body class="fix-header card-no-border logo-center">
    <div class="preloader">
        <svg class="circular" viewBox="25 25 50 50">
            <circle class="path" cx="50" cy="50" r="20" fill="none" stroke-width="2" stroke-miterlimit="10" />
        </svg>
    </div>

    <div id="main-wrapper">
        <!-- TOPO import -->
        @(admin.layout.topo)
        <!-- MENU import -->
        @(admin.layout.topo-menu)
        <!-- Page wrapper  -->
        <div class="page-wrapper">
            <!-- Container fluid  -->
            <div class="container-fluid">
                <!-- Bread crumb and right sidebar toggle -->
                <div class="row page-titles">
                    <div class="col-md-5 col-8 align-self-center">
                        <h3 class="text-themecolor m-b-0 m-t-0">Integração</h3>
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="javascript:void(0);">Bling</a></li>
                            <li class="breadcrumb-item active">Nota Fiscal e Estoque</li>
                        </ol>
                    </div>
                    <!-- Top Right Info -->
                    @(admin.layout.topo-info)
                </div>
                <!-- Start Page Content -->
                <div class="row" id="vm">
                    <div class="col-12">
                        <div class="card card-outline-primary">
                            <div class="card-header"><i class="text-white fas fa-th-list"></i></div>
                            <div class="card-body">
                                <form method="post" action="${baseUri}/bling/gravar_credenciais/">
                                    <div class="row">

                                        <div class="col-sm-12 col-md-2">
                                            <label for="integracao_ativo">Módulo Ativo<span class="text-danger">*</span></label>
                                            <select name="integracao_ativo" id="integracao_ativo" class="form-control">
                                                <option value="1">Sim</option>
                                                <option value="0">Não</option>
                                            </select><br><br>
                                        </div>

                                        <div class="col-sm-12 col-md-5">
                                            <label for="integracao_client_id">Client ID <span class="text-danger">*</span> </label>
                                            <input type="text" class="form-control" id="integracao_client_id" name="integracao_client_id" value="${integracao_client_id}" placeholder="Client ID da sua conta do Bling"><br><br>
                                        </div>

                                        <div class="col-sm-12 col-md-5">
                                            <label for="integracao_secret">Client Secret <span class="text-danger">*</span> </label>
                                            <input type="text" class="form-control" id="integracao_secret" name="integracao_secret" value="${integracao_secret}" placeholder="Secret da sua conta do Bling"><br><br>
                                        </div>



                                        <div class="col-sm-2 col-md-2">
                                            <label for="integracao_rec1">Emitir Nota Fiscal? </label>
                                            <select name="integracao_rec1" id="integracao_rec1" class="form-control">
                                                <option value="1">Sim</option>
                                                <option value="0">Não</option>
                                            </select><br><br>
                                        </div>

                                        <div class="col-sm-12 col-md-2">
                                            <label for="integracao_rec2">Atualizar Produtos? </label>
                                            <select name="integracao_rec2" id="integracao_rec2" class="form-control">
                                                <option value="1">Sim</option>
                                                <option value="0">Não</option>
                                            </select><br><br>
                                        </div>

                                        <div class="col-sm-12 col-md-3">
                                            <label for="integracao_rec3">Atualizar Estoque? </label>
                                            <select name="integracao_rec3" id="integracao_rec3" class="form-control">
                                                <option value="1">Sim</option>
                                                <option value="0">Não</option>
                                            </select><br><br>
                                        </div>

                                        <div class="col-sm-12 col-md-5">
                                            <label for="integracao_rec4">ID da Loja Bling
                                                <span data-toggle="modal" data-target="#lojaIdModal" type="button" class="">
                                                    <i class="fa fa-question-circle" title="ID da loja bling filial ou física"></i>
                                                </span>
                                            </label>
                                            <input type="text" class="form-control" id="integracao_rec4" name="integracao_rec4" value="${integracao_rec4}" placeholder="ID da Loja Bling"><br><br>
                                        </div>

                                        <div class="col-sm-12 col-md-2">
                                            <label for="integracao_rec5">UF da Loja (origem da NF)
                                                <span>
                                                    <i class="fa fa-question-circle" title="UF origem da NF"></i>
                                                </span>
                                            </label>
                                            <input type="text" class="form-control" id="integracao_rec5" name="integracao_rec5" value="${integracao_rec5}" placeholder="UF da Loja"><br><br>
                                        </div>



                                        <div class="col-sm-12 col-md-5">
                                            <label for="integracao_rec6">Natureza Operação (DENTRO do Estado)
                                                <span>
                                                    <i class="fa fa-question-circle" title="UF origem da NF"></i>
                                                </span>
                                            </label>
                                            <!--
                                            <input type="text" class="form-control" id="integracao_rec6" name="integracao_rec6" value="${integracao_rec6}" placeholder="ID da Natureza de Operação Bling"><br><br>
                                            -->

                                            <?php if (isset($data['nats']->data)) : ?>
                                                <select name="integracao_rec6" id="integracao_rec6" class="form-control">
                                                    <?php foreach ($data['nats']->data as $nat) :  ?>
                                                        <option value="<?= $nat->id ?>"><?= $nat->descricao ?> </option>
                                                    <?php endforeach; ?>
                                                </select>
                                            <?php endif; ?>
                                        </div>


                                        <div class="col-sm-12 col-md-5">
                                            <label for="integracao_rec7">Natureza Operação (FORA do Estado)
                                                <span>
                                                    <i class="fa fa-question-circle" title="UF origem da NF"></i>
                                                </span>
                                            </label>
                                            <!--
                                            <input type="text" class="form-control" id="integracao_rec7" name="integracao_rec7" value="${integracao_rec7}" placeholder="ID da Natureza de Operação Bling"><br><br>
                                                    -->
                                            <?php if (isset($data['nats']->data)) : ?>
                                                <select name="integracao_rec7" id="integracao_rec7" class="form-control">
                                                    <?php foreach ($data['nats']->data as $nat) :  ?>
                                                        <option value="<?= $nat->id ?>"><?= $nat->descricao ?> </option>
                                                    <?php endforeach; ?>
                                                </select>
                                            <?php endif; ?>
                                        </div>


                                        <div class="col-sm-12">
                                            <label for="url">Url de redirecionamento após autorização</label>
                                            <input type="text" class="form-control" value="${bling_callback_url}" readonly><br><br>
                                        </div>

                                        <!--Botão para obter o Token -->
                                        <div class="col-sm-12 text-center">
                                            <a href="${bling_auth_url}" class="btn btn-info"><i class="fa fa-key"></i> Obter Token</a>
                                        </div>
                                        <!---<div class="col-sm-12">
                                    <div class="">
                                        <input type="checkbox" class="form-check-input">
                                        <label class="form-check-label" ><strong>Nota fiscal</strong> </label>
                                    </div>
                                </div>-->
                                    </div>
                                    <br>
                                    <div class="row">
                                        <div class="col-sm-12 col-md-12 text-center">
                                            <br>
                                            <button class="btn btn-primary text-white btn-submit" type="submit" style="cursor: pointer;">
                                                <i class="fas fa-save"></i> Gravar Dados
                                            </button>
                                        </div>
                                    </div>

                            </div>
                            </form>
                        </div>
                    </div>
                </div>
                <!-- End Page Content -->
            </div>
            <!-- Footer import-->
            @(admin.layout.footer)
            <!-- End Footer -->
        </div>
        <!-- End Page wrapper  -->
        <!-- Modal Remove -->
        @(admin.layout.modal-remove)
        @(admin.integracoes.bling.modal-info-id-loja)



    </div>
    <script src="assets/plugins/jquery/jquery.min.js"></script>
    <!-- Bootstrap tether Core JavaScript -->
    <script src="assets/plugins/popper/popper.min.js"></script>
    <script src="assets/plugins/bootstrap/js/bootstrap.min.js"></script>
    <!-- slimscrollbar scrollbar JavaScript -->
    <script src="assets/js/jquery.slimscroll.js"></script>
    <!--Wave Effects -->
    <script src="assets/js/waves.js"></script>
    <!--Menu sidebar -->
    <script src="assets/js/sidebarmenu.js"></script>
    <!--stickey kit -->
    <script src="assets/plugins/sticky-kit-master/dist/sticky-kit.min.js"></script>
    <script src="assets/plugins/sparkline/jquery.sparkline.min.js"></script>
    <!--Custom JavaScript -->
    <script src="assets/js/custom.min.js"></script>
    <script src="assets/plugins/toast-master/js/jquery.toast.js"></script>
    <!-- Style switcher -->
    <script src="assets/plugins/styleswitcher/jQuery.style.switcher.js"></script>
    <!-- This is data table -->
    <script src="assets/plugins/datatables.net/js/jquery.dataTables.min.js"></script>
    <script src="assets/plugins/bootstrap-select/bootstrap-select.min.js" type="text/javascript"></script>
    <!-- start - This is for export functionality only -->
    <script src="assets/plugins/datatables-button/dataTables.buttons.min.js"></script>
    <script src="assets/plugins/datatables-button/buttons.flash.min.js"></script>
    <script src="assets/plugins/datatables-button/jszip.min.js"></script>
    <script src="assets/plugins/datatables-button/pdfmake.min.js"></script>
    <script src="assets/plugins/datatables-button/vfs_fonts.js"></script>
    <script src="assets/plugins/datatables-button/buttons.html5.min.js"></script>
    <script src="assets/plugins/datatables-button/buttons.print.min.js"></script>
    <script src="assets/plugins/jquery.mask.min.js"></script>
    <script src="assets/js/jquery.cookie.js"></script>
    <!-- PRINCIPAL JS -->
    <script src="assets/js/vue.min.js"></script>
    <script src="assets/plugins/dropify/dist/js/dropify.min.js"></script>
    <script src="${baseUri}/view/admin/app-js/datatable.js"></script>
    <script src="${baseUri}/view/admin/app-js/main.js"></script>
    <script src="produto/index.js"></script>
    <script type="text/javascript">
        $('.menu-integracao').addClass('active');
        $('.menu-integracao-bling').addClass('active');

        setTimeout(() => {
            $('#integracao_ativo').val('${integracao_ativo}');
            $('#integracao_rec1').val('${integracao_rec1}');
            $('#integracao_rec2').val('${integracao_rec2}');
            $('#integracao_rec3').val('${integracao_rec3}');
            $('#integracao_rec6').val('${integracao_rec6}');
            $('#integracao_rec7').val('${integracao_rec7}');
        }, 500)

        /*ALERTAS DE ERROR*/
        if (window.location.href.indexOf("error_gravar_token") != -1) {
            alert_error('Erro ao gravar o token', 'Verifique se as credenciais estão digitadas corretamente.');
        }
        if (window.location.href.indexOf("error_code") != -1) {
            alert_error('Erro ao gravar o token', 'Code inválido na URL.');
        }
    </script>
</body>

</html>
