<!DOCTYPE html>
<html lang="pt-br">

<head>
    <base href="${baseUri}/view/admin/">
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="description" content="${config_site_description}">
    <meta name="author" content="${config_site_author}">
    <meta name="keywords" content="${config_site_keywords}">
    <link rel="icon" type="image/png" sizes="16x16" href="${baseUri}/media/site/${config_site_favicon}">
    <title>${config_site_title} - Pagamento</title>
    <link href="assets/plugins/bootstrap/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="assets/plugins/toast-master/css/jquery.toast.css">
    <link href="assets/plugins/bootstrap-select/bootstrap-select.min.css" rel="stylesheet" />
    <link href="assets/plugins/bootstrap-tagsinput/dist/bootstrap-tagsinput.css" rel="stylesheet" />
    <link href="assets/plugins/summernote/dist/summernote-lite.css" rel="stylesheet">
    <link href="assets/css/style.css" rel="stylesheet">
    <!-- You can change the theme colors from here -->
    <link href="assets/css/colors/${config_tema_color}.css" id="theme" rel="stylesheet">
    <!--[if lt IE 9]>
    <script src="assets/plugins/html5shiv.js"></script>
    <script src="assets/plugins/respond.min.js"></script>

    <![endif]-->
</head>

<body class="fix-header card-no-border logo-center">
    <div class="preloader">
        <svg class="circular" viewBox="25 25 50 50">
            <circle class="path" cx="50" cy="50" r="20" fill="none" stroke-width="2" stroke-miterlimit="10" />
        </svg>
    </div>

    <div id="main-wrapper">
        @(admin.layout.topo)
        @(admin.layout.topo-menu)
        <div class="page-wrapper">
            <div class="container-fluid">
                <div class="row page-titles">
                    <div class="col-md-5 col-8 align-self-center">
                        <h3 class="text-themecolor m-b-0 m-t-0">Configurações</h3>
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="javascript:void(0)">Pagamentos</a></li>
                            <li class="breadcrumb-item active">Gateways</li>
                        </ol>
                    </div>
                    @(admin.layout.topo-info)
                </div>

                <div class="row">
                    <div class="col-12">
                        <div class="card card-outline-primary">
                            <div class="card-header"><i class="text-white fas fa-th-list"></i>

                            </div>
                            <div class="card-body" id="vm">
                                <div class="content">
                                    <section>
                                        <div>
                                            @(admin.gateway.partials.definicoes)
                                        </div>

                                        <h4>Módulos de pagamento</h4>
                                        <hr>
                                        <ul class="nav nav-tabs">

                                            <li class="nav-item">
                                                <a class="nav-link active mercadopago" style="cursor: pointer;" id="navMercadoPago" data-id="partialMercadopago|navMercadoPago">MercadoPago</a>
                                            </li>

                                            <li class="nav-item">
                                                <a class="nav-link pagarme" style="cursor: pointer;" id="navPagarMe" data-id="partialPagarMe|navPagarMe">PagarMe</a>
                                            </li>

                                            <!--
                                            <li class="nav-item">
                                                <a class="nav-link pagseguro" style="cursor: pointer;" id="navPagseguro" data-id="partialPagseguro|navPagseguro">Pagseguro</a>
                                            </li>

                                            <li class="nav-item">
                                                <a class="nav-link cielo" style="cursor: pointer;" id="navCielo" data-id="partialCielo|navCielo">Cielo</a>
                                            </li>
                                            
                                            -->
                                            <li class="nav-item">
                                                <a class="nav-link deposito" style="cursor: pointer;" id="navDeposito" data-id="partialDesposito|navDeposito">PIX / Depósito / Transferência</a>
                                            </li>
                                        </ul>
                                        <br>
                                        <div id="partialMercadopago" class="partials">
                                            @(admin.gateway.partials.mercadopago)
                                        </div>
                                        <div id="partialPagarMe" class="partials">
                                            @(admin.gateway.partials.pagarme)
                                        </div>


                                        <div id="partialDesposito" class="partials">
                                            @(admin.gateway.partials.deposito)
                                        </div>

                                        <div id="partialPagseguro" class="partials">
                                            @(admin.gateway.partials.pagseguro)
                                        </div>

                                        <div id="partialCielo" class="partials">
                                            @(admin.gateway.partials.cielo)
                                        </div>

                                    </section>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            @(admin.layout.footer)

        </div>
    </div>
    <script src="assets/plugins/jquery/jquery.min.js"></script>
    <script src="assets/plugins/popper/popper.min.js"></script>
    <script src="assets/plugins/bootstrap/js/bootstrap.min.js"></script>
    <script src="assets/js/jquery.slimscroll.js"></script>
    <script src="assets/js/waves.js"></script>
    <script src="assets/js/sidebarmenu.js"></script>
    <script src="assets/plugins/sticky-kit-master/dist/sticky-kit.min.js"></script>
    <script src="assets/plugins/sparkline/jquery.sparkline.min.js"></script>
    <script src="assets/plugins/summernote/dist/summernote-lite.min.js"></script>
    <script src="assets/plugins/summernote/dist/lang/summernote-pt-BR.js"></script>
    <script src="assets/js/custom.min.js"></script>
    <script src="assets/plugins/toast-master/js/jquery.toast.js"></script>
    <script src="assets/plugins/styleswitcher/jQuery.style.switcher.js"></script>
    <script src="assets/plugins/datatables.net/js/jquery.dataTables.min.js"></script>
    <script src="assets/plugins/datatables.net/js/dataTables.rowReorder.min.js"></script>
    <script src="assets/plugins/bootstrap-select/bootstrap-select.min.js" type="text/javascript"></script>
    <script src="assets/plugins/bootstrap-tagsinput/dist/bootstrap-tagsinput.min.js" type="text/javascript"></script>
    <script src="assets/plugins/jquery.mask.min.js"></script>
    <script src="assets/js/jquery.cookie.js"></script>

    <script src="assets/js/vue.min.js"></script>

    <script src="${baseUri}/view/admin/app-js/main.js"></script>
    <script type="text/javascript">
        $('.menu-pagamentos').addClass('active');
        $('.menu-gateways').addClass('active');
    </script>

    <script>
        $("#pay_key_ativo").val('${gateway_ativo}').trigger('change');

        let gwativo = '${gateway_ativo}'.toLowerCase();
        $('.nav-tabs a').removeClass('active');
        //$('.' + gwativo).addClass('active');
        setTimeout(function() {
            $('.' + gwativo).trigger('click');
        }, 1000)


        $("#pay_c6").val('${configPay_c6}').trigger('change');
        $("#pay_c8").val('${configPay_c8}').trigger('change');
        $("#pay_c1").val('${configPay_c1}').trigger('change');

        $("#pagseguro_c3").val('${pagseguro_c3}').trigger('change');
        $("#mercadopago_c3").val('${mercadopago_c3}').trigger('change');
        $("#cielo_pass").val('${cielo_pass}').trigger('change');
        $("#deposito_status").val('${deposito_status}').trigger('change');

        /*
        $('.summernote').summernote({
            placeholder: '',
            lang: 'pt-BR',
            minHeight: 150,
            maxHeight: 550,
            disableDragAndDrop: true,
            toolbar: [
                ['media', ['link']],
                ['style', ['bold', 'italic', 'underline', 'clear']],
                ['para', ['ul', 'ol']],
                ['size', ['paragraph', 'height', 'fontsize']],
                ['misc', ['undo', 'redo']],
            ]
        });
        */

        loadPartials();

        function loadPartials() {
            $(".partials").hide();
            $("#partialMercadopago").show();
        }
        $(".nav-link").click((e) => {
            if ($(e.target).attr('data-id')) {
                let target = $(e.target).attr('data-id').split('|');
                $(".nav-link").removeClass('active');
                $("#" + target[1]).addClass('active');
                $('.partials').hide();
                $("#" + target[0]).show();
            }
        })
        $('#form-gw-def').on('change', function() {
            let boleto_vencimento_qtd = $("#pay_c2").val();

            if (boleto_vencimento_qtd > 21 || boleto_vencimento_qtd < 0) {
                alert_error('Prazo do boleto não pode ser menor que 0 ou maior que 21');
                return;
            }

            let data = $('#form-gw-def').serializeArray();
            let url = $('#form-gw-def').attr('action');
            $.post(url, data, (rs) => {
                console.log(rs)
            }).then((rs) => {
                if (rs == 0) {
                    alert_success('Alterado com sucesso!');
                } else {
                    alert_error('Erro ao alterar!');
                }
            })
        })
    </script>
</body>

</html>