<!DOCTYPE html>
<html lang="pt-br">

<head>
    <base href="${baseUri}/view/admin/">
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="description" content="${config_site_description}">
    <meta name="author" content="${config_site_author}">
    <meta name="keywords" content="${config_site_keywords}">
    <link rel="icon" type="image/png" sizes="16x16" href="${baseUri}/media/site/${config_site_favicon}">
    <title>${config_site_title} - Faixa de Cep</title>
    <link href="assets/plugins/bootstrap/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="assets/plugins/toast-master/css/jquery.toast.css">
    <link href="assets/plugins/bootstrap-select/bootstrap-select.min.css" rel="stylesheet" />
    <link href="assets/plugins/bootstrap-tagsinput/dist/bootstrap-tagsinput.css" rel="stylesheet" />
    <link href="assets/css/style.css" rel="stylesheet">
    <!-- You can change the theme colors from here -->
    <link href="assets/css/colors/${config_tema_color}.css" id="theme" rel="stylesheet">
    <!--[if lt IE 9]>
    <script src="assets/plugins/html5shiv.js"></script>
    <script src="assets/plugins/respond.min.js"></script>

    <![endif]-->
</head>

<body class="fix-header card-no-border logo-center">
    <div class="preloader">
        <svg class="circular" viewBox="25 25 50 50">
            <circle class="path" cx="50" cy="50" r="20" fill="none" stroke-width="2" stroke-miterlimit="10" />
        </svg>
    </div>

    <div id="main-wrapper">
        @(admin.layout.topo)
        @(admin.layout.topo-menu)
        <div class="page-wrapper">
            <div class="container-fluid">
                <div class="row page-titles">
                    <div class="col-md-5 col-8 align-self-center">
                        <h3 class="text-themecolor m-b-0 m-t-0">Gerenciar faixa de CEP</h3>
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="javascript:void(0);">Loja</a></li>
                            <li class="breadcrumb-item"><a href="javascript:void(0);">Frete</a></li>
                            <li class="breadcrumb-item active">Gerenciar faixa de CEP</li>
                        </ol>
                    </div>
                    @(admin.layout.topo-info)
                    <div class="col-md-7 col-4 align-self-center">
                        <h6 class="float-right" style="padding-top: 20px">
                            <a id="" data-id="ProdutosAdmin:G" class="btn btn-primary waves-effect waves-light text-white menu-access" href="${baseUri}/frete/">
                                <i class="fa fa-arrow-left"></i> Voltar
                            </a>
                        </h6>
                    </div>
                </div>

                <div class="row">
                    <div class="col-12">
                        <div class="card card-outline-primary">
                            <div class="card-header"><i class="text-white fas fa-th-list"></i>

                            </div>
                            <div class="card-body" id="vm">
                                <div class="content">
                                    <div class="row">
                                        <div class="col-sm-12 col-md-8">
                                            <h3>Dados da faixa de CEP</h3>

                                        </div>
                                        <div class="col-sm-12 col-md-4">
                                            <label class="float-right" style="cursor: pointer;" onclick="$('#modalAjuda').modal('show')">
                                                <i class="fa fa-info-circle"></i> Precisa de ajuda?

                                            </label>
                                            <br><br>
                                        </div>
                                    </div>
                                    <br>
                                    <form action="${baseUri}/Frete/gravar_faixa" method="post">
                                        <input type="hidden" name="faixa_cep_id" value="${faixa_cep_id}">
                                        <div class="row">
                                            <div class="col-sm-12 col-md-2">
                                                <label for="faixa_cep_inicio">CEP Início <span class="text-danger">*</span> </label>
                                                <input type="text" class="form-control cep" required name="faixa_cep_inicio" value="${faixa_cep_inicio}" placeholder="Ex: 99999-999"><br><br>
                                            </div>
                                            <div class="col-sm-12 col-md-2">
                                                <label for="faixa_cep_final">CEP Final <span class="text-danger">*</span> </label>
                                                <input type="text" class="form-control cep" required name="faixa_cep_final" value="${faixa_cep_final}" placeholder="Ex: 99999-999"><br><br>
                                            </div>
                                            <div class="col-sm-12 col-md-2">
                                                <label for="faixa_cep_peso_de">Peso De (g) <span class="text-danger">*</span> </label>
                                                <input type="text" class="form-control money" required name="faixa_cep_peso_de" value="${faixa_cep_peso_de}" placeholder="Ex: 1,50"><br><br>
                                            </div>
                                            <div class="col-sm-12 col-md-2">
                                                <label for="faixa_cep_peso_ate">Peso Até (g) <span class="text-danger">*</span> </label>
                                                <input type="text" class="form-control money" required name="faixa_cep_peso_ate" value="${faixa_cep_peso_ate}" placeholder="Ex: 1,50"><br><br>
                                            </div>

                                            <div class="col-sm-12 col-md-4">
                                                <label for="faixa_cep_valor">Valor (R$) <span class="text-danger">*</span> </label>
                                                <input type="text" class="form-control money" required name="faixa_cep_valor" value="${faixa_cep_valor}" placeholder="Ex: 1,50"><br><br>
                                            </div>

                                            <div class="col-sm-12 col-md-6">
                                                <label for="faixa_cep_desc">Descrição <span class="text-danger">*</span> </label>
                                                <input type="text" class="form-control" required name="faixa_cep_desc" value="${faixa_cep_desc}" placeholder="Descrição do frete"><br><br>
                                            </div>

                                            <div class="col-sm-12 col-md-6">
                                                <label for="faixa_cep_prazo">Prazo De <span class="text-danger">*</span> </label>
                                                <input type="number" class="form-control" required name="faixa_cep_prazo" value="${faixa_cep_prazo}" placeholder="Informe o prazo estimado em dias"><br><br>
                                            </div>

                                        </div>

                                        <div class="row">
                                            <div class="col-sm-12 col-md-12 text-center">
                                                <br>
                                                <button class="btn btn-primary text-white" type="submit" style="cursor: pointer;">Gravar Dados</button>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            @(admin.layout.footer)

        </div>
        @(admin.produto.modal-novo)

        <!-- Modal ajuda -->
        <div class="modal fade" id="modalAjuda" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
            <div class="modal-dialog modal-lg" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalLabel">Informações sobre Retirada</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        Você deve informar o cep do local para o preenchimento automático do endereço. <br>
                        Este procedimento é necessário para haver precisão na consulta do frete. <br>
                        Os locais cadastrados aparecerão nas opções de "Retirar no Local" durante a finalização do pedido. <br>
                        * Após informar o cep, informe o número do local.
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-primary" data-dismiss="modal">Fechar</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script src="assets/plugins/jquery/jquery.min.js"></script>
    <script src="assets/plugins/popper/popper.min.js"></script>
    <script src="assets/plugins/bootstrap/js/bootstrap.min.js"></script>
    <script src="assets/js/jquery.slimscroll.js"></script>
    <script src="assets/js/waves.js"></script>
    <script src="assets/js/sidebarmenu.js"></script>
    <script src="assets/plugins/sticky-kit-master/dist/sticky-kit.min.js"></script>
    <script src="assets/plugins/sparkline/jquery.sparkline.min.js"></script>
    <script src="assets/js/custom.min.js"></script>
    <script src="assets/plugins/toast-master/js/jquery.toast.js"></script>
    <script src="assets/plugins/styleswitcher/jQuery.style.switcher.js"></script>
    <script src="assets/plugins/datatables.net/js/jquery.dataTables.min.js"></script>
    <script src="assets/plugins/datatables.net/js/dataTables.rowReorder.min.js"></script>
    <script src="assets/plugins/bootstrap-select/bootstrap-select.min.js" type="text/javascript"></script>
    <script src="assets/plugins/bootstrap-tagsinput/dist/bootstrap-tagsinput.min.js" type="text/javascript"></script>
    <script src="assets/plugins/jquery.mask.min.js"></script>
    <script src="assets/js/jquery.cookie.js"></script>
    <script src="${baseUri}/view/admin/app-js/endereco.js"></script>
    <script src="frete/retirada/form.js"></script>
    <script src="assets/js/vue.min.js"></script>

    <script src="${baseUri}/view/admin/app-js/main.js"></script>
    <script type="text/javascript">
        $('.menu-frete').addClass('active');
        $('.menu-faixa').addClass('active');

        $('.money').mask("#.##0,00", {
            reverse: true
        });
        // loadPartials();

        function loadPartials() {
            $(".partials").hide();
            $("#partialGerais").show();
        }

        $(".nav-link").click((e) => {
            if ($(e.target).attr('data-id')) {
                let target = $(e.target).attr('data-id').split('|');
                $(".nav-link").removeClass('active');
                $("#" + target[1]).addClass('active');

                $('.partials').hide();
                $("#" + target[0]).show();
            }
        });
    </script>

    <script>

    </script>
</body>

</html>