<!DOCTYPE html>
<html lang="pt-br">

<head>
    <base href="${baseUri}/view/admin/">
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <!-- Tell the browser to be responsive to screen width -->
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="description" content="${config_site_description}">
    <meta name="author" content="${config_site_author}">
    <meta name="keywords" content="${config_site_keywords}">
    <meta name="author" content="${config_seo_author}">
    <!-- Favicon icon -->
    <link rel="icon" type="image/png" sizes="16x16" href="${baseUri}/media/site/${config_site_favicon}">
    <title>${config_site_title} - Logo e Temas Admin</title>
    <!-- Bootstrap Core CSS -->
    <link href="assets/plugins/bootstrap/css/bootstrap.min.css" rel="stylesheet">
    <!-- Custom CSS -->
    <link rel="stylesheet" href="assets/plugins/toast-master/css/jquery.toast.css">
    <link href="assets/css/style.css" rel="stylesheet">
    <!-- You can change the theme colors from here -->
    <link href="assets/css/colors/${config_tema_color}.css" id="theme" rel="stylesheet">
    <link rel="stylesheet" href="assets/plugins/dropify/dist/css/dropify.min.css">
    <!--[if lt IE 9]>
    <script src="assets/plugins/html5shiv.js"></script>
    <script src="assets/plugins/respond.min.js"></script>
    <![endif]-->
</head>
<style>
    form .dropify-wrapper .dropify-preview .dropify-render img {
        object-fit: cover;
    }

    form .dropify-wrapper {
        display: block;
        position: relative;
        cursor: pointer;
        border-radius: 10px;
        object-fit: cover;
        width: 300px;
        height: 300px;
        overflow: hidden;
        max-width: 100%;
        font-size: 14px;
        line-height: 22px;
        color: #777;
        background-color: #FFF;
        border: 2px solid #E5E5E5;
        -webkit-transition: border-color .15s linear;
        transition: border-color .15s linear
    }

    <?php echo $data['color']; ?>
</style>

<body class="fix-header card-no-border logo-center">
    <div class="preloader">
        <svg class="circular" viewBox="25 25 50 50">
            <circle class="path" cx="50" cy="50" r="20" fill="none" stroke-width="2" stroke-miterlimit="10" />
        </svg>
    </div>

    <div id="main-wrapper">
        <!-- TOPO import -->
        @(admin.layout.topo)
        <!-- MENU import -->
        @(admin.layout.topo-menu)
        <!-- Page wrapper  -->
        <div class="page-wrapper">
            <!-- Container fluid  -->
            <div class="container-fluid">
                <!-- Bread crumb and right sidebar toggle -->
                <div class="row page-titles">
                    <div class="col-md-5 col-8 align-self-center">
                        <h3 class="text-themecolor m-b-0 m-t-0">Temas Admin</h3>
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="javascript:void(0);">Configurações</a></li>
                            <li class="breadcrumb-item"><a href="javascript:void(0)">Aparência</a></li>
                            <li class="breadcrumb-item active">Card do Produto</li>
                        </ol>
                    </div>
                    <!-- Top Right Info -->
                    @(admin.layout.topo-info)
                </div>
                <div class="row">
                    <div class="col-12">
                        <div class="card card-outline-primary">
                            <div class="card-header"><i class="text-white fas fa-globe"></i></div>
                            <div class="card-body">
                                <section>
                                    <div>
                                        <br>
                                        <h4 class="separator-line">Personalizar Card do Produto
                                        </h4>
                                        <hr>
                                    </div>
                                    <div class="container">













                                        <section>
                                            <div class="row mt-4">
                                                <div class="col-4" id="card-reload">

                                                    <?php foreach ($data['prod'] as $prod): ?>
                                                        <div class="product-card">
                                                            <a href="javascript:void(0)">
                                                                <div class="product-thumb">
                                                                    <?php if ($prod->produto_oferta == 1) : ?>
                                                                        <span class="badge badge-danger rounded-0">Oferta</span>
                                                                    <?php endif; ?>
                                                                    <img src="${baseUri}/media/produto/thumb_<?= $prod->produto_foto ?>" alt="foto" class="img-fluid d-block">
                                                                    <?php if ($prod->produto_foto_hover != "") : ?>
                                                                        <span>
                                                                            <img src="${baseUri}/media/produto/thumb_<?= $prod->produto_foto_hover ?>" class="foto-hover img-fluid d-block" />
                                                                        </span>
                                                                    <?php endif; ?>
                                                                </div>
                                                                <div class="product-card-body">
                                                                    <span class="product-title"><?= (($prod->produto_titulo)) ?></span>
                                                                    <?php if ($prod->produto_estoque <= 0): ?>
                                                                        <p class="hide-on-vitrine product-title-indisponivel">Indisponível</p>
                                                                    <?php else: ?>
                                                                        <?php if ($prod->produto_desconto > 0): ?>
                                                                            <span class=" product-card-text-line">
                                                                                R$ <?= $prod->produto_preco_original ?>
                                                                            </span>
                                                                        <?php endif; ?>
                                                                        <span class=" product-card-text-price">
                                                                            R$ <?= $prod->produto_preco ?>
                                                                        </span>
                                                                        <?php if ($prod->qtd_parcelas > 1): ?>
                                                                            <span class="product-card-parc">
                                                                                <?= $prod->produto_text_parc ?>
                                                                            </span>
                                                                        <?php endif; ?>
                                                                        <?php if ($prod->desc_boleto > 0): ?>
                                                                            <span class=" product-card-disc">
                                                                                ${config_card_text_desconto} R$ <?= $prod->produto_preco_desc_boleto ?>
                                                                            </span>
                                                                            <small class=" product-card-percent">
                                                                                <?= $prod->desc_boleto ?>${config_card_text_percent}
                                                                            </small>
                                                                        <?php endif; ?>
                                                                    <?php endif; ?>
                                                                </div>

                                                                <?php if ($prod->produto_estoque <= 0): ?>
                                                                    <button class="btn btn-primary btn-block btn-sm hide-on-vitrine" type="button">
                                                                        <i class="fa fa-envelope"></i>
                                                                        AVISE-ME QUANDO CHEGAR
                                                                    </button>
                                                                <?php else: ?>
                                                                    <button class="btn btn-primary btn-block btn-sm hide-on-vitrine" type="button">
                                                                        <i class="fa fa-shopping-cart"></i>
                                                                        ${config_card_tooltip_text}
                                                                    </button>
                                                                <?php endif; ?>

                                                            </a>
                                                        </div>
                                                    <?php endforeach; ?>
                                                </div>
                                                <?php
                                                //BORDER
                                                $border_size = explode(" ", $data['card']->config_card_border_size);
                                                $border_size_top = preg_replace('/\D/', '', $border_size[0]);
                                                $border_size_left = preg_replace('/\D/', '', $border_size[1]);
                                                $border_size_bottom = preg_replace('/\D/', '', $border_size[2]);
                                                $border_size_right = preg_replace('/\D/', '', $border_size[3]);
                                                //IMG
                                                $config_card_img_height = preg_replace('/\D/', '', $data['card']->config_card_img_height);
                                                ?>
                                                <div class="col-8">
                                                    <form class="" id="form-produto-card" action="" method="post">
                                                        <br>
                                                        <ul class="nav nav-tabs" id="nav-tab" role="tablist">
                                                            <li class="nav-item">
                                                                <a class="nav-link active" id="nav-cores-tab" data-toggle="tab" data-target="#nav-cores" type="button" role="tab" aria-controls="nav-cores" aria-selected="true">Textos</a>
                                                            </li>
                                                            <li class="nav-item">
                                                                <a class="nav-link" id="nav-bordas-tab" data-toggle="tab" data-target="#nav-bordas" type="button" role="tab" aria-controls="nav-bordas" aria-selected="false">Bordas</a>
                                                            </li>
                                                            <li class="nav-item">
                                                                <a class="nav-link" id="nav-fotos-tab" data-toggle="tab" data-target="#nav-fotos" type="button" role="tab" aria-controls="nav-fotos" aria-selected="false">Foto</a>
                                                            </li>
                                                        </ul>
                                                        <div class="tab-content tabcontent-border" id="nav-tabContent">
                                                            <div class="tab-pane p-3 fade show active" id="nav-cores" role="tabpanel"
                                                                aria-labelledby="nav-cores-tab">
                                                                <!--
                                <input type="color" name="config_card_bg_color" 
                                        value="${config_card_bg_color}">
                                <label for="">Cor de Fundo</label>
                                <br>
                                    -->

                                                                <div class="row" style="padding-top:20px">
                                                                    <div class="col-5">
                                                                        <label for="">Altura do Card</label>
                                                                    </div>
                                                                    <div class="col-3"></div>
                                                                    <div class="col-2"></div>
                                                                    <div class="col-2">
                                                                        <input type="number" style="width: 60px;"
                                                                            maxlength="3" max="800" min="150" class="form-control form-control-sm"
                                                                            name="config_card_desc_elm_height" id="config_card_desc_elm_height"
                                                                            value="${config_card_desc_elm_height}">
                                                                    </div>
                                                                </div>
                                                                <hr>
                                                                <div class="row" style="padding-top:20px">
                                                                    <div class="col-5">
                                                                        <label for="">Nome do Produto</label>
                                                                    </div>
                                                                    <div class="col-3">
                                                                        <div class="btn-group" role="group" aria-label="alinhar preço">
                                                                            <input type="hidden" name="config_card_text_pri_align"
                                                                                id="config_card_text_pri_align"
                                                                                value="${config_card_text_pri_align}">

                                                                            <input type="hidden" name="config_card_text_pri_bold"
                                                                                id="config_card_text_pri_bold"
                                                                                value="${config_card_text_pri_bold}">

                                                                            <button type="button" data-bold="${config_card_text_pri_bold}" data-elm="config_card_text_pri_bold"
                                                                                class="btn btn-primary btn-xs btn-text-bold"><i class="fas fa-bold"></i></button>
                                                                            <button type="button" data-align="left" data-elm="config_card_text_pri_align"
                                                                                class="btn btn-primary btn-xs btn-text-align"><i class="fa fa-align-left"></i></button>
                                                                            <button type="button" data-align="center" data-elm="config_card_text_pri_align"
                                                                                class="btn btn-primary btn-xs btn-text-align"><i class="fa fa-align-center"></i></button>
                                                                            <button type="button" data-align="right" data-elm="config_card_text_pri_align"
                                                                                class="btn btn-primary btn-xs btn-text-align"><i class="fa fa-align-right"></i></button>
                                                                        </div>
                                                                    </div>
                                                                    <div class="col-2">
                                                                        <input type="color" name="config_card_text_pri_color" style="width: 60px;"
                                                                            value="${config_card_text_pri_color}">
                                                                    </div>
                                                                    <div class="col-2">
                                                                        <input type="number" style="width: 60px;"
                                                                            maxlength="2" max="60" min="5" class="form-control form-control-sm"
                                                                            name="config_card_text_pri_size" id="config_card_text_pri_size"
                                                                            value="${config_card_text_pri_size}">
                                                                    </div>
                                                                </div>
                                                                <hr>


                                                                <div class="row" style="padding-top:20px">
                                                                    <div class="col-5">
                                                                        <label for="">Preço Original</label>
                                                                    </div>
                                                                    <div class="col-3">
                                                                        <div class="btn-group" role="group" aria-label="alinhar preço">
                                                                            <input type="hidden" name="config_card_text_line_align"
                                                                                id="config_card_text_line_align"
                                                                                value="${config_card_text_line_align}">

                                                                            <input type="hidden" name="config_card_text_line_bold"
                                                                                id="config_card_text_line_bold"
                                                                                value="${config_card_text_line_bold}">

                                                                            <button type="button" data-bold="${config_card_text_line_bold}" data-elm="config_card_text_line_bold"
                                                                                class="btn btn-primary btn-xs btn-text-bold"><i class="fas fa-bold"></i></button>
                                                                            <button type="button" data-align="left" data-elm="config_card_text_line_align"
                                                                                class="btn btn-primary btn-xs btn-text-align"><i class="fa fa-align-left"></i></button>
                                                                            <button type="button" data-align="center" data-elm="config_card_text_line_align"
                                                                                class="btn btn-primary btn-xs btn-text-align"><i class="fa fa-align-center"></i></button>
                                                                            <button type="button" data-align="right" data-elm="config_card_text_line_align"
                                                                                class="btn btn-primary btn-xs btn-text-align"><i class="fa fa-align-right"></i></button>
                                                                        </div>
                                                                    </div>
                                                                    <div class="col-2">
                                                                        <input type="color" name="config_card_text_line_color" style="width: 60px;"
                                                                            value="${config_card_text_line_color}">
                                                                    </div>
                                                                    <div class="col-2">
                                                                        <input type="number" style="width: 60px;"
                                                                            maxlength="2" max="60" min="5" class="form-control form-control-sm"
                                                                            name="config_card_text_line_size" id="config_card_text_line_size"
                                                                            value="${config_card_text_line_size}">
                                                                    </div>
                                                                </div>
                                                                <hr>


                                                                <div class="row" style="padding-top:20px">
                                                                    <div class="col-5">
                                                                        <label for="">Preço Padrão</label>
                                                                    </div>
                                                                    <div class="col-3">
                                                                        <div class="btn-group" role="group" aria-label="alinhar preço">
                                                                            <input type="hidden" name="config_card_text_price_align"
                                                                                id="config_card_text_price_align"
                                                                                value="${config_card_text_price_align}">

                                                                            <input type="hidden" name="config_card_text_price_bold"
                                                                                id="config_card_text_price_bold"
                                                                                value="${config_card_text_price_bold}">

                                                                            <button type="button" data-bold="${config_card_text_price_bold}" data-elm="config_card_text_price_bold"
                                                                                class="btn btn-primary btn-xs btn-text-bold"><i class="fas fa-bold"></i></button>
                                                                            <button type="button" data-align="left" data-elm="config_card_text_price_align"
                                                                                class="btn btn-primary btn-xs btn-text-align"><i class="fa fa-align-left"></i></button>
                                                                            <button type="button" data-align="center" data-elm="config_card_text_price_align"
                                                                                class="btn btn-primary btn-xs btn-text-align"><i class="fa fa-align-center"></i></button>
                                                                            <button type="button" data-align="right" data-elm="config_card_text_price_align"
                                                                                class="btn btn-primary btn-xs btn-text-align"><i class="fa fa-align-right"></i></button>
                                                                        </div>
                                                                    </div>
                                                                    <div class="col-2">
                                                                        <input type="color" name="config_card_text_price_color" style="width: 60px;"
                                                                            value="${config_card_text_price_color}">
                                                                    </div>
                                                                    <div class="col-2">
                                                                        <input type="number" style="width: 60px;"
                                                                            maxlength="2" max="60" min="5" class="form-control form-control-sm"
                                                                            name="config_card_text_price_size" id="config_card_text_price_size"
                                                                            value="${config_card_text_price_size}">
                                                                    </div>
                                                                </div>
                                                                <hr>

                                                                <div class="row " style="padding-top:20px">
                                                                    <div class="col-5">
                                                                        <div class="row">
                                                                            <div class="col-7">
                                                                                <label for="">Preço Parcelado</label>
                                                                            </div>
                                                                            <div class="col-5">

                                                                            </div>
                                                                        </div>
                                                                    </div>

                                                                    <div class="col-3">
                                                                        <div class="btn-group" role="group" aria-label="alinhar">
                                                                            <input type="hidden" name="config_card_text_parc_align"
                                                                                id="config_card_text_parc_align"
                                                                                value="${config_card_text_parc_align}">

                                                                            <input type="hidden" name="config_card_text_parc_bold"
                                                                                id="config_card_text_parc_bold"
                                                                                value="${config_card_text_parc_bold}">

                                                                            <button type="button" data-bold="${config_card_text_parc_bold}" data-elm="config_card_text_parc_bold"
                                                                                class="btn btn-primary btn-xs btn-text-bold"><i class="fas fa-bold"></i></button>
                                                                            <button type="button" data-align="left" data-elm="config_card_text_parc_align"
                                                                                class="btn btn-primary btn-xs btn-text-align"><i class="fa fa-align-left"></i></button>
                                                                            <button type="button" data-align="center" data-elm="config_card_text_parc_align"
                                                                                class="btn btn-primary btn-xs btn-text-align"><i class="fa fa-align-center"></i></button>
                                                                            <button type="button" data-align="right" data-elm="config_card_text_parc_align"
                                                                                class="btn btn-primary btn-xs btn-text-align"><i class="fa fa-align-right"></i></button>
                                                                        </div>
                                                                    </div>
                                                                    <div class="col-2">
                                                                        <input type="color" name="config_card_text_parc_color" style="width: 60px;"
                                                                            value="${config_card_text_parc_color}">
                                                                    </div>
                                                                    <div class="col-2">
                                                                        <input type="number" style="width: 60px;"
                                                                            maxlength="2" max="60" min="5" class="form-control form-control-sm"
                                                                            name="config_card_text_parc_size" id="config_card_text_parc_size"
                                                                            value="${config_card_text_parc_size}">
                                                                    </div>

                                                                </div>
                                                                <hr>

                                                                <div class="row" style="padding-top:20px">

                                                                    <div class="col-5">
                                                                        <div class="row">
                                                                            <div class="col-7">
                                                                                <label for="">Preço à Vista</label>
                                                                            </div>
                                                                            <div class="col-5">
                                                                                <input type="text" name="config_card_text_desconto" class="form-control form-control-sm"
                                                                                    value="${config_card_text_desconto}">
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                    <div class="col-3">
                                                                        <div class="btn-group" role="group" aria-label="alinhar">
                                                                            <input type="hidden" name="config_card_text_desconto_align"
                                                                                id="config_card_text_desconto_align"
                                                                                value="${config_card_text_desconto_align}">

                                                                            <input type="hidden" name="config_card_text_desconto_bold"
                                                                                id="config_card_text_desconto_bold"
                                                                                value="${config_card_text_desconto_bold}">

                                                                            <button type="button" data-bold="${config_card_text_desconto_bold}" data-elm="config_card_text_desconto_bold"
                                                                                class="btn btn-primary btn-xs btn-text-bold"><i class="fas fa-bold"></i></button>

                                                                            <button type="button" data-align="left" data-elm="config_card_text_desconto_align"
                                                                                class="btn btn-primary btn-xs btn-text-align"><i class="fa fa-align-left"></i></button>
                                                                            <button type="button" data-align="center" data-elm="config_card_text_desconto_align"
                                                                                class="btn btn-primary btn-xs btn-text-align"><i class="fa fa-align-center"></i></button>
                                                                            <button type="button" data-align="right" data-elm="config_card_text_desconto_align"
                                                                                class="btn btn-primary btn-xs btn-text-align"><i class="fa fa-align-right"></i></button>
                                                                        </div>
                                                                    </div>
                                                                    <div class="col-2">
                                                                        <input type="color" name="config_card_text_desconto_color" style="width: 60px;"
                                                                            value="${config_card_text_desconto_color}">
                                                                    </div>
                                                                    <div class="col-2">
                                                                        <input type="number" style="width: 60px;"
                                                                            maxlength="2" max="60" min="5" class="form-control form-control-sm"
                                                                            name="config_card_text_desconto_size" id="config_card_text_desconto_size"
                                                                            value="${config_card_text_desconto_size}">
                                                                    </div>

                                                                </div>
                                                                <hr>
                                                                <div class="row" style="padding-top:20px">

                                                                    <div class="col-5">
                                                                        <div class="row">
                                                                            <div class="col-7">
                                                                                <label for="">Desconto %</label>
                                                                            </div>
                                                                            <div class="col-5">
                                                                                <input type="text" name="config_card_text_percent" class="form-control form-control-sm"
                                                                                    value="${config_card_text_percent}">
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                    <div class="col-3">
                                                                        <div class="btn-group" role="group" aria-label="alinhar">
                                                                            <input type="hidden" name="config_card_text_percent_align"
                                                                                id="config_card_text_percent_align"
                                                                                value="${config_card_text_percent_align}">

                                                                            <input type="hidden" name="config_card_text_percent_bold"
                                                                                id="config_card_text_percent_bold"
                                                                                value="${config_card_text_percent_bold}">

                                                                            <button type="button" data-bold="${config_card_text_percent_bold}" data-elm="config_card_text_percent_bold"
                                                                                class="btn btn-primary btn-xs btn-text-bold"><i class="fas fa-bold"></i></button>

                                                                            <button type="button" data-align="left" data-elm="config_card_text_percent_align"
                                                                                class="btn btn-primary btn-xs btn-text-align"><i class="fa fa-align-left"></i></button>
                                                                            <button type="button" data-align="center" data-elm="config_card_text_percent_align"
                                                                                class="btn btn-primary btn-xs btn-text-align"><i class="fa fa-align-center"></i></button>
                                                                            <button type="button" data-align="right" data-elm="config_card_text_percent_align"
                                                                                class="btn btn-primary btn-xs btn-text-align"><i class="fa fa-align-right"></i></button>
                                                                        </div>
                                                                    </div>
                                                                    <div class="col-2">
                                                                        <input type="color" name="config_card_text_percent_color" style="width: 60px;"
                                                                            value="${config_card_text_percent_color}">
                                                                    </div>
                                                                    <div class="col-2">
                                                                        <input type="number" style="width: 60px;"
                                                                            maxlength="2" max="60" min="5" class="form-control form-control-sm"
                                                                            name="config_card_text_percent_size" id="config_card_text_percent_size"
                                                                            value="${config_card_text_percent_size}">
                                                                    </div>
                                                                </div>


                                                                <hr>
                                                                <div class="row" style="padding-top:10px">
                                                                    <div class="col-8">
                                                                        <label for="">Cor de fundo da tag Oferta</label>
                                                                    </div>
                                                                    <div class="col-4">
                                                                        <input type="color" name="config_card_tooltip_bg_color"
                                                                            value="${config_card_tooltip_bg_color}" style="width: 60px;">
                                                                    </div>
                                                                </div>

                                                                <hr>
                                                                <div class="row" style="padding-top:10px">
                                                                    <div class="col-8">
                                                                        <label for="">Cor do texto da tag Oferta</label>
                                                                    </div>
                                                                    <div class="col-4">
                                                                        <input type="color" name="config_card_tooltip_text_color"
                                                                            value="${config_card_tooltip_text_color}" style="width: 60px;">
                                                                    </div>
                                                                </div>

                                                                <hr>
                                                                <div class="row" style="padding-top:10px">
                                                                    <div class="col-5">
                                                                        <label for="">Texto do botão COMPRAR</label>
                                                                    </div>
                                                                    <div class="col-7">
                                                                        <input type="text" name="config_card_tooltip_text" maxlength="30"
                                                                            class="form-control form-control-sm" value="${config_card_tooltip_text}">
                                                                    </div>
                                                                </div>

                                                            </div>
                                                            <div class="tab-pane p-3 fade" id="nav-fotos" role="tabpanel" aria-labelledby="nav-fotos-tab">
                                                                <Br>
                                                                <div class="form-group">
                                                                    <input type="number" style="width: 80px;"
                                                                        maxlength="2" max="600" min="50" class="form-control"
                                                                        name="config_card_img_height" id="config_card_img_height"
                                                                        value="<?= intval($config_card_img_height) ?>">
                                                                    <label for="config_card_img_height">Altura da imagem</label>
                                                                </div>
                                                            </div>
                                                            <div class="tab-pane fade p-3" id="nav-bordas" role="tabpanel" aria-labelledby="nav-bordas-tab">
                                                                <div class="row" style="padding-top:10px">
                                                                    <div class="col-8">
                                                                        <label for="">Cor da borda</label>
                                                                    </div>
                                                                    <div class="col-4">
                                                                        <input type="color" name="config_card_border_color" style="width: 60px;"
                                                                            value="${config_card_border_color}">
                                                                    </div>
                                                                </div>
                                                                <hr>
                                                                <div class="row" style="padding-top:10px">
                                                                    <div class="col-8">
                                                                        <label for="">Cor da borda hover</label>
                                                                    </div>
                                                                    <div class="col-4">
                                                                        <input type="color" name="config_card_border_color_hover"
                                                                            value="${config_card_border_color_hover}" style="width: 60px;">
                                                                    </div>
                                                                </div>
                                                                <hr>
                                                                <div class="row" style="padding-top:10px">
                                                                    <div class="col-8">
                                                                        <label for="config_card_border_size_top">Tamanho da borda do Topo</label>
                                                                    </div>
                                                                    <div class="col-4">
                                                                        <input type="number" style="width: 60px;" max="9" min="0" class="form-control form-control-sm"
                                                                            name="config_card_border_size[]" id="config_card_border_size_top"
                                                                            value="<?= intval($border_size_top) ?>">
                                                                    </div>
                                                                </div>
                                                                <hr>
                                                                <div class="row" style="padding-top:10px">
                                                                    <div class="col-8">
                                                                        <label for="config_card_border_size_left">Tamanho da borda da Esquerda</label>
                                                                    </div>
                                                                    <div class="col-4">
                                                                        <input type="number" style="width: 60px;" max="9" min="0" class="form-control form-control-sm"
                                                                            name="config_card_border_size[]" id="config_card_border_size_left"
                                                                            value="<?= intval($border_size_left) ?>">

                                                                    </div>
                                                                </div>
                                                                <hr>
                                                                <div class="row" style="padding-top:10px">
                                                                    <div class="col-8">
                                                                        <label for="config_card_border_size_bottom">Tamanho da borda de Baixo</label>
                                                                    </div>
                                                                    <div class="col-4">
                                                                        <input type="number" style="width: 60px;" max="9" min="0" class="form-control form-control-sm"
                                                                            name="config_card_border_size[]" id="config_card_border_size_bottom"
                                                                            value="<?= intval($border_size_bottom) ?>">
                                                                    </div>
                                                                </div>
                                                                <hr>
                                                                <div class="row" style="padding-top:10px">
                                                                    <div class="col-8">
                                                                        <label for="border_size_right">Tamanho da borda da Direita</label>
                                                                    </div>
                                                                    <div class="col-4">
                                                                        <input type="number" style="width: 60px;" max="9" min="0" class="form-control form-control-sm"
                                                                            name="config_card_border_size[]" id="border_size_right"
                                                                            value="<?= intval($border_size_right) ?>">
                                                                    </div>
                                                                </div>




                                                            </div>
                                                    </form>
                                                </div>
                                            </div>

                                        </section>






















                                    </div>
                                </section>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- End Page Content -->
                @(admin.layout.config-tema)
            </div>
            <!-- Footer import-->
            @(admin.layout.footer)
            <!-- End Footer -->
        </div>
        <!-- End Page wrapper  -->
    </div>
    <!-- All Jquery -->
    <script src="assets/plugins/jquery/jquery.min.js"></script>
    <!-- Bootstrap tether Core JavaScript -->
    <script src="assets/plugins/popper/popper.min.js"></script>
    <script src="assets/plugins/bootstrap/js/bootstrap.min.js"></script>
    <!-- slimscrollbar scrollbar JavaScript -->
    <script src="assets/js/jquery.slimscroll.js"></script>
    <!--Wave Effects -->
    <script src="assets/js/waves.js"></script>
    <!--Menu sidebar -->
    <script src="assets/js/sidebarmenu.js"></script>
    <script src="assets/plugins/toast-master/js/jquery.toast.js"></script>
    <!--stickey kit -->
    <script src="assets/plugins/sticky-kit-master/dist/sticky-kit.min.js"></script>
    <script src="assets/plugins/sparkline/jquery.sparkline.min.js"></script>
    <!--Custom JavaScript -->
    <script src="assets/js/custom.min.js"></script>
    <!-- Style switcher -->
    <script src="assets/plugins/styleswitcher/jQuery.style.switcher.js"></script>
    <script src="assets/plugins/jquery.mask.min.js"></script>
    <!-- PRINCIPAL JS -->
    <script src="assets/js/vue.min.js"></script>
    <script src="${baseUri}/view/admin/app-js/main.js"></script>
    <script src="assets/plugins/dropify/dist/js/dropify.min.js"></script>
    <script type="text/javascript">
        $('.menu-aparencia').addClass('active');
        $('.menu-card').addClass('active');

        $('#form-produto-card').on('change', function() {
            var dados = $('#form-produto-card').serializeArray();
            console.log(dados);
            $.post('${baseUri}/configuracao/gravar_card', dados, function(rs) {
                $.post('${baseUri}/configuracao/card_reload', {}, function(rs) {
                    $('#card-reload').html(rs);
                    setTimeout(() => {
                        $(".tips-top").tooltip({
                            placement: "top"
                        });
                    }, 500)
                })
            })
        })

        $('.btn-text-align').on('click', function() {
            let al = $(this).data('align');
            let elm = $(this).data('elm');
            $('#' + elm).val(al);
            $('#' + elm).trigger('change');
        })

        $('.btn-text-bold').on('click', function() {
            let bl = $(this).data('bold');
            let elm = $(this).data('elm');
            bl = (bl == 'bold') ? 'normal' : 'bold';
            $(this).data('bold', bl);
            console.log(bl)
            $('#' + elm).val(bl);
            $('#' + elm).trigger('change');
        })

        $(".tips-top").tooltip({
            placement: "top",
        });
    </script>
</body>

</html>