<?php

namespace Frete;

class FreteFrenet
{
    public function get_frete($conf, $produtos)
    {
        $conf = (object) $conf;
        $produtos = (object) $produtos;
        if (
            (isset($conf->frenet_token) && !empty($conf->frenet_token)) &&
            (isset($conf->cep_origem) && !empty($conf->cep_origem)) &&
            (isset($conf->cep_destino) && !empty($conf->cep_destino)) &&
            (isset($produtos) && !empty($produtos))
        ) {
            $itens = [];
            foreach ($produtos as $k) {
                $k = (object) $k;
                $itens[] = [
                    "Height" => str_replace(",", ".", $k->altura),
                    "Length" => str_replace(",", ".", $k->comprimento),
                    "Quantity" => $k->quantidade,
                    "Weight" =>  str_replace(",", ".", $k->peso),
                    "Width" =>  str_replace(",", ".", $k->largura)
                ];
            }
            // consulta na api os valores com base nestes itens
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, "https://api.frenet.com.br/shipping/quote");
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
            curl_setopt($ch, CURLOPT_HEADER, FALSE);
            curl_setopt($ch, CURLOPT_POST, TRUE);
            $conf->cep_origem = str_replace("-", "", $conf->cep_origem);
            $conf->cep_destino = str_replace("-", "", $conf->cep_destino);
            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode([
                "SellerCep" => $conf->cep_origem,
                "RecipientCEP" => $conf->cep_destino,
                "ShipmentInvoiceValue" => 0,
                "ShippingServiceCode" => null,
                "ShippingItemArray" => $itens,
                "RecipientCountry" => "BR"
            ]));
            curl_setopt($ch, CURLOPT_HTTPHEADER, [
                "Accept: application/json",
                "token: $conf->frenet_token",
                "content-type: application/json"
            ]);
            $response = curl_exec($ch);
            curl_close($ch);
            $res = json_decode($response);
            $result = [];
            if ($res->ShippingSevicesArray) {
                $service = $res->ShippingSevicesArray;
                foreach ($service as $serv) {
                    if ($serv->Error == 0) {
                        $result[] = [
                            "code" => $serv->ServiceCode,
                            "price" => $serv->ShippingPrice,
                            "name" => $serv->ServiceDescription,
                            "deadline" => $serv->DeliveryTime,
                            "rastreio" => 4,
                        ];
                    }
                }
            } else {
                return ['error' => 'Nenhum frete foi encontrado.'];
            }
            return $result;
        } else {
            return ['error' => 'Valores obrigatórios não informados'];
        }
    }
}

/* 

//Documentação: https://frenetapi.docs.apiary.io/#
// Doc do método get_frete($conf, $produtos)
// Trazer em $conf as configurações de auth e de ceps, ex:
$conf = [
    "frenet_token" => ''
    "cep_origem" =>  '',
    "cep_destino" => ''
];

// Trazer em produtos os produtos no seguinte formato:
$produtos = [
    [
        'largura' => 1, //cm
        'altura' => 1, // cm
        'comprimento' => 1, // cm
        'peso' => 1, // gramas
        'quantidade' => 1, // uni
    ],
    [
        'largura' => 1, //cm
        'altura' => 1, // cm
        'comprimento' => 1, // cm
        'peso' => 1, // gramas
        'quantidade' => 1, // uni
    ]
];

// Ex de uso:

$produtos = [
    [
        'largura' => 1, //cm
        'altura' => 1, // cm
        'comprimento' => 1, // cm
        'peso' => 1, // gramas
        'quantidade' => 1, // uni
    ],
    [
        'largura' => 1, //cm
        'altura' => 1, // cm
        'comprimento' => 1, // cm
        'peso' => 1, // gramas
        'quantidade' => 1, // uni
    ]
];

$conf = [
    "frenet_token" => '--token--',
    "cep_origem" =>  '11702-570',
    "cep_destino" => '11703-570'
];
$result = (new FreteFrenet)->get_frete($conf, $produtos);
echo json_encode($result);

*/