<?php
class IPGeoLocationIO
{
    static function location($ip)
    {
        $api = @parse_ini_string(file_get_contents('config/.env'), true, INI_SCANNER_RAW)['ipgeolocation'];
        if (isset($api['key']) && !empty($api['key'])) {
            $key = $api['key'];
            $curl = curl_init();
            curl_setopt_array($curl, array(
                CURLOPT_URL => "https://api.ipgeolocation.io/ipgeo?apiKey=$key&ip=$ip",
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'GET',
            ));
            $response = curl_exec($curl);
            curl_close($curl);
            $error = curl_error($curl);
            if ($error) {
                return false;
            }
            $res = json_decode($response);
            if (!isset($res->city)) {
                return false;
            }
            return $res;
        } else {
            return false;
        }
    }
}
