<?php

class Browser
{


    static public function agent($type = null)
    {
        $user_agent = strtolower($_SERVER['HTTP_USER_AGENT']);
        if ($type == 'bot') {
            // matches popular bots
            if (preg_match("/googlebot|adsbot|yahooseeker|yahoobot|msnbot|watchmouse|pingdom\.com|feedfetcher-google/", $user_agent)) {
                return true;
                // watchmouse|pingdom\.com are "uptime services"
            }
        } elseif ($type == 'browser') {
            // matches core browser types
            if (preg_match("/mozilla\/|opera\//", $user_agent)) {
                return true;
            }
        } elseif ($type == 'mobile') {
            // matches popular mobile devices that have small screens and/or touch inputs
            // mobile devices have regional trends; some of these will have varying popularity in Europe, Asia, and America
            // detailed demographics are unknown, and South America, the Pacific Islands, and Africa trends might not be represented, here
            if (preg_match("/phone|iphone|itouch|ipod|symbian|android|htc_|htc-|palmos|blackberry|opera mini|iemobile|windows ce|nokia|fennec|hiptop|kindle|mot |mot-|webos\/|samsung|sonyericsson|^sie-|nintendo/", $user_agent)) {
                // these are the most common
                return true;
            } elseif (preg_match("/mobile|pda;|avantgo|eudoraweb|minimo|netfront|brew|teleca|lg;|lge |wap;| wap /", $user_agent)) {
                // these are less common, and might not be worth checking
                return true;
            }
        }
        return false;
    }


    static public function get_ip()
    {
        $ip_keys = [
            'HTTP_CLIENT_IP',
            'HTTP_X_FORWARDED_FOR',
            'HTTP_X_FORWARDED',
            'HTTP_FORWARDED_FOR',
            'HTTP_FORWARDED',
            'REMOTE_ADDR'
        ];

        foreach ($ip_keys as $key) {
            if (getenv($key)) {
                $ip_list = explode(',', getenv($key)); // Trata múltiplos IPs
                foreach ($ip_list as $ip) {
                    $ip = trim($ip); // Remove espaços extras
                    if (filter_var($ip, FILTER_VALIDATE_IP, FILTER_FLAG_IPV4)) {
                        return $ip;
                    }
                }
            }
        }

        return 'UNKNOWN';
    }


    static public function cookie($name, $val = null)
    {
        if ($val != null && $val != 'drop') {
            setcookie("$name", "$val", time() + (86400 * 30), "/");
        } else {
            if ($val == 'drop') {
                if (isset($_COOKIE["$name"])) {
                    unset($_COOKIE["$name"]);
                }
                setcookie("$name", "", time() - 3600, "/");
            }
            if (isset($_COOKIE["$name"])) {
                return $_COOKIE["$name"];
            } else {
                return false;
            }
        }
    }
}
