<?php

@session_start();

class Usuario
{

    public function __construct()
    {
        Sessao::check();
        Sessao::perms();
        if (ucfirst(Session::node('ulevel')) != '1') {
            Http::redirect_to('/admin/?error');
        }
        (new Install)->check_tabelas_principais();
    }

    public function indexAction()
    {
        $usuario = (new Factory('usuario'))->get();
        $data = [
            'config' => (new Config)->get(),
            'usuario' => $usuario,

            'mapper' => ['config', 'modulos']
        ];
        Tpl::view("admin.usuario.index", $data);
    }

    public function novo()
    {
        $data = [
            'config' => (new Config)->get(),

            'usuario' => (new Factory('usuario'))->map(),
            'mapper' => ['config', 'usuario', 'modulos']
        ];
        Tpl::view("admin.usuario.form", $data);
    }

    public function lista()
    {
        (new Factory('usuario'))
            ->select('usuario_id, usuario_nome, usuario_email, usuario_status, usuario_level, IF(usuario_level = 1, \'Administrador\', \'Operador\') AS level_nome , IF(usuario_status = 1, \'Ativo\', \'Inativo\') AS status_nome')
            ->get(1);
    }

    public function editar()
    {
        $id = Http::get_in_params('id', 'int');
        if (isset($id->value) && $id->value > 0) {
            $id = $id->value;
            $usu = (new Factory('usuario'))->find($id);
            Http::back_on_false($usu);
            
            $data = [
                'config' => (new Config)->get(),
                'usuario' => $usu,
                'mapper' => ['config', 'usuario', 'modulos']
            ];
            
            Tpl::view('admin.usuario.form', $data);
        }
    }

    public function gravar()
    {
        if (isset($_POST['usuario_nome']) && !empty($_POST['usuario_nome'])) {
            if (!empty(Req::post('usuario_permissao')) && is_array(Req::post('usuario_permissao'))) {
                $permissao = implode(",", Req::post('usuario_permissao'));
                Req::post('usuario_permissao', $permissao);
                Req::drop_blank();
            }
            if (Req::post('usuario_pass') != "") {
                Req::crypt('usuario_pass');
            }else{
                unset($_POST['usuario_pass']);
            }
            $save = (new Factory('usuario'))->with($_POST)->save();
            Http::back_on_false($save);
            Http::redirect_to('/usuario/?success');
        }
    }

    public function remove()
    {
        $id = Req::post('id', 'int');
        if ($id > 0) {
            (new Factory('usuario'))->drop($id);
            echo 1;
        } else {
            echo -1;
        }
    }


    public function altera_status()
    {
        $id = Req::post('id', 'int');
        if ($id > 0) {
            $status = intval($_POST['status']);
            $status == 1 ? $status = 0 : $status = 1;
            $data = [
                'id' => $id,
                'status' => $status
            ];
            (new Factory('usuario'))->with($data)->save();
        }
    }

    public function avatar_upload()
    {   
        if (!empty($_FILES['avatar']) && !empty($_POST['usuario_id']) && isset($_POST['usuario_id']) && isset($_FILES['avatar'])) {
            $file = $_FILES['avatar'];
            $id = intval($_POST['usuario_id']);
            $img = Media::img_upload($file, 'avatar');
            if (is_object($img)) {
                $current = (new Factory('usuario'))->select('usuario_avatar')->find($id);
                $current_login = Path::base() . "/media/avatar/$current->usuario_avatar";
                if (file_exists($current_login)) {
                    @unlink($current_login);
                }
                $data = ['avatar' => $img->url, 'id' => $id];
                (new Factory('usuario'))->with($data)->save();

                Http::redirect_to("/usuario/editar/id/$id/?success");
            } else {
                $current = (new Factory('usuario'))->select('usuario_avatar')->find($id);
                $current_login = Path::base() . "/media/avatar/$current->usuario_avatar";
                if (file_exists($current_login)) {
                    @unlink($current_login);
                }
                $data = ['avatar' => '', 'id' => $id];
                (new Factory('usuario'))->with($data)->save();

                Http::redirect_to("/usuario/editar/id/$id/?success");
            }
        } else {
            Http::redirect_to("/usuario/?erro");
        }
    }


    public function avatar_upload_profile()
    {
        if (!empty($_FILES['avatar']) && !empty($_POST['usuario_id']) && isset($_POST['usuario_id']) && isset($_FILES['avatar'])) {
            $file = $_FILES['avatar'];
            $id = $_SESSION['node']['uid'];
            $img = Media::img_upload($file, 'avatar');
            if (is_object($img)) {
                $current = (new Factory('usuario'))->select('usuario_avatar')->find($id);
                $current_login = Path::base() . "/media/avatar/$current->usuario_avatar";
                if (file_exists($current_login)) {
                    @unlink($current_login);
                }
                $data = ['avatar' => $img->url, 'id' => $id];
                (new Factory('usuario'))->with($data)->save();

                Http::redirect_to("/usuario/editar/id/$id/?success");
            } else {
                $current = (new Factory('usuario'))->select('usuario_avatar')->find($id);
                $current_login = Path::base() . "/media/avatar/$current->usuario_avatar";
                if (file_exists($current_login)) {
                    @unlink($current_login);
                }
                $data = ['avatar' => $current, 'id' => $id];
                (new Factory('usuario'))->with($data)->save();

                Http::redirect_to("/usuario/editar/id/$id/?success");
            }
        } else {
            Http::redirect_to("/usuario/?erro");
        }
    }
}
