<?php

class Upgrade
{
    public function __construct()
    {
        (new Install)->check_tabelas_principais();
    }

    public function indexAction()
    {

        //########################################### NÃO ALTERAR ################################################
        // ULTIMA VERSAO E DATA DA ULTIMA ALTERACAO
        $upgrade = [
            'num' => '405',
            'patch' => '4.0.5',
            'info' => '* PEDIDOS | FRETE | PAGAMENTOS ',
            'last' => date('Y-m-d H:i:s'),
            'id' => 1
        ];
        $force_upgrade = false; // TRUE PARA FORÇAR UPGRADE - NÃO RECOMENDADO (USAR SOMENTE EM CASOS DE ERROS DE BANCO DE DADOS)
        //VERIFICA SE A TABELA VERSION EXISTE E CRIA CASO NÃO EXISTA
        $ver_exists = (new DB)->show_columns("version");
        if (!isset($ver_exists->version_num)) {
            //13/02/25 -- VERSION 4.0.3
            $columns = [
                ['name' => 'id', 'type' => 'int(11)', 'key' => true],
                ['name' => 'num', 'type' => 'int(5)'],
                ['name' => 'patch', 'type' => 'varchar(20)'],
                ['name' => 'info', 'type' => 'longtext'],
                ['name' => 'last', 'type' => 'datetime', 'default' => 'NULL'],
            ];
            $add = [
                'num' => '403',
                'patch' => '4.0.3',
                'info' => 'install',
                'last' => date('Y-m-d H:i:s'),
            ];
            (new DB)->create_table('version', $columns, $add);
        }
        //VERIFICA SE A VERSAO ATUAL ESTÁ ATUALIZADA
        $ver = (new Factory('version'))->find(1);
        if ($ver->version_num >= $upgrade['num'] && !$force_upgrade) {
            $txt = "<pre>";
            $txt .= "Atualizado para {$ver->version_patch} em " . date('d/m/Y', strtotime($ver->version_last)) . "\n";
            $txt .= $ver->version_info . "\n";
            $txt .= "</pre>";
            die($txt);
        }
        //##############################################################################################################


        //INTEGRACAO   ex: bling 
        $columns = [
            ['name' => 'id', 'type' => 'int(11)', 'key' => true],
            ['name' => 'gw', 'type' => 'varchar(20)'],
            ['name' => 'ativo', 'type' => 'int', 'default' => '0'],
            ['name' => 'secret', 'type' => 'longtext'],
            ['name' => 'client_id', 'type' => 'longtext'],
            ['name' => 'token', 'type' => 'longtext'],
            ['name' => 'refresh_token', 'type' => 'longtext'],
            ['name' => 'data_refresh_token', 'type' => 'date'],
        ];
        $seed = [
            'integracao_gw' => 'Bling',
            'integracao_secret' => 'secret',
            'integracao_client_id' => 'client_id',
        ];
        //(new DB)->drop_table("integracao");
        (new DB)->create_table('integracao', $columns, $seed);

        //BLING PRODUTO MIGRATE
        $columns = [
            ['name' => 'class_fiscal', 'type' => 'VARCHAR(200)', 'default' => '""'],
            ['name' => 'tipo_unidade', 'type' => 'VARCHAR(20)', 'default' => '"UN"'],
        ];
        (new DB)->add_columns('produto', $columns);

        //BLING PEDIDO MIGRATE
        $columns = [
            ['name' => 'nf_status', 'type' => 'int', 'default' => '0'],
            ['name' => 'nf_num_id', 'type' => 'VARCHAR(200)', 'default' => '""'],
            ['name' => 'nf_serie', 'type' => 'int', 'default' => '0'],
            ['name' => 'nf_num', 'type' => 'VARCHAR(200)', 'default' => '""'],
            ['name' => 'nf_chave', 'type' => 'VARCHAR(200)', 'default' => '""'],
        ];
        (new DB)->add_columns('pedido', $columns);

        //CLIENTE CODIGO PARCEIRO 
        $columns = [
            ['name' => 'cupom', 'type' => 'VARCHAR(300)', 'default' => '""'],
        ];
        (new DB)->add_columns('cliente', $columns);

        //BLING PRODUTO MIGRATE
        $columns = [
            ['name' => 'class_fiscal', 'type' => 'VARCHAR(200)', 'default' => '""'],
            ['name' => 'tipo_unidade', 'type' => 'VARCHAR(20)', 'default' => '"UN"'],
        ];
        (new DB)->add_columns('produto', $columns);

        //BLING PEDIDO MIGRATE
        $columns = [
            ['name' => 'nf_status', 'type' => 'int', 'default' => '0'],
            ['name' => 'nf_num_id', 'type' => 'VARCHAR(200)', 'default' => '""'],
            ['name' => 'nf_serie', 'type' => 'int', 'default' => '0'],
            ['name' => 'nf_num', 'type' => 'VARCHAR(200)', 'default' => '""'],
            ['name' => 'nf_chave', 'type' => 'VARCHAR(200)', 'default' => '""'],
        ];
        (new DB)->add_columns('pedido', $columns);

        $columns = [
            ["name" => "desconto", "type" => "double(10,2)"],
            ["name" => "obs_sys", "type" => "varchar(1000)"],
        ];
        (new DB)->add_columns('pedido', $columns);

        $columns = [
            ["name" => "codigo", "type" => "varchar(100)"]
        ];
        (new DB)->add_columns('lista_pedido', $columns);


        /** FRETE 09/02/2024  */
        $columns = [
            ['name' => 'kangu', 'type' => 'int(1)', 'default' => 0],
            ['name' => 'kangu_token', 'type' => 'longtext'],
        ];
        (new DB)->add_columns('frete', $columns);
        $columns = [
            ['name' => 'servico_frete', 'type' => 'varchar(200)'],
        ];
        (new DB)->add_columns('pedido', $columns);
        $columns = [
            ["name" => "melhorenvio_ponto", "type" => "varchar(200)", 'default' => '""'],
            ["name" => "kangu_ponto", "type" => "varchar(200)", 'default' => '0'],
            ['name' => 'adicional', 'type' => 'double(10, 2)', 'default' => 0],
        ];
        (new DB)->add_columns('frete', $columns);

        //PEDIDO FISCAL
        $columns = [
            ['name' => 'gtin', 'type' => 'varchar(255)'],
            ['name' => 'gtint', 'type' => 'varchar(255)'],
            ['name' => 'class_tipoprod', 'type' => 'varchar(255)'],
            ['name' => 'class_oriprod', 'type' => 'varchar(255)'],
            ['name' => 'sku', 'type' => 'varchar(255)'],
        ];
        (new DB)->add_columns('produto', $columns);

        //PEDIDO INFO FRETE 
        $columns = [
            ["name" => "frete_id", "type" => "int(11)"],
            ["name" => "frete_height", "type" => "varchar(11)"],
            ["name" => "frete_width", "type" => "varchar(11)"],
            ["name" => "frete_length", "type" => "varchar(11)"],
            ["name" => "frete_weight", "type" => "varchar(11)"],
            ["name" => "frete_status", "type" => "varchar(100)"],
            ["name" => "frete_carrinho", "type" => "varchar(200)"],
            ["name" => "frete_company", "type" => "varchar(200)"],
        ];
        (new DB)->add_columns('pedido', $columns);

        $columns = [
            ["name" => "desconto", "type" => "double(10,2)"],
            ["name" => "obs_sys", "type" => "varchar(1000)"],
        ];
        (new DB)->add_columns('pedido', $columns);
        $columns = [["name" => "codigo", "type" => "varchar(100)"]];
        (new DB)->add_columns('lista_pedido', $columns);

        //ADMIN CONFIG 
        $columns = [
            ['name' => 'site_email_bcc', 'type' => 'longtext'],
        ];
        (new DB)->add_columns('config', $columns);

        //20/10/24
        //ESTOQUE guarda instrução para atualizar estoque
        $columns = [
            ['name' => 'id', 'type' => 'int(11)', 'key' => true],
            ['name' => 'pedido', 'type' => 'varchar(20)'],
            ['name' => 'action', 'type' => 'int(1)'],
            ['name' => 'sql', 'type' => 'longtext'],
            ['name' => 'data', 'type' => 'date'],
        ];
        //(new DB)->drop_table("estoque_fila");
        (new DB)->create_table('estoque_fila', $columns);

        //22/10/24
        //INTEGRACAO adicionar colunas para recursos extras  ex: id loja bling
        $columns = [
            ['name' => 'rec1', 'type' => 'VARCHAR(300)', 'default' => '0'],
            ['name' => 'rec2', 'type' => 'VARCHAR(300)', 'default' => '0'],
            ['name' => 'rec3', 'type' => 'VARCHAR(300)', 'default' => '0'],
            ['name' => 'rec4', 'type' => 'VARCHAR(300)', 'default' => 'NULL'],
            ['name' => 'rec5', 'type' => 'VARCHAR(300)', 'default' => 'NULL'],
        ];
        (new DB)->add_columns('integracao', $columns);

        //22/10/24
        //ALTERA TIPO PARA INTEIRO
        $columns = ['name' => 'produto_acessos', 'new' => 'produto_acessos', 'type' => 'int(11)', 'default' => 1];
        (new DB)->alter_column('produto', $columns);


        //ALTERA TAMANHO DE 20 PARA  255
        $columns = ['name' => 'pedido_cupom_alfa', 'new' => 'pedido_cupom_alfa', 'type' => 'varchar(255)', 'default' => '""'];
        (new DB)->alter_column('pedido', $columns);

        //28/10/24
        //ADD CAMPO DATA SYNC BLING ESTOQUE
        $columns = [["name" => "estoque_dt_sync", "type" => "datetime", "default" => "NULL"]];
        (new DB)->add_columns('produto', $columns);


        //30/10/24
        //INTEGRACAO adicionar colunas para recursos extras  ex: natop nf loja bling
        $columns = [
            ['name' => 'rec6', 'type' => 'VARCHAR(300)', 'default' => 'NULL'],
            ['name' => 'rec7', 'type' => 'VARCHAR(300)', 'default' => 'NULL'],
        ];
        (new DB)->add_columns('integracao', $columns);


        //31/10/24
        //pedidos bling para baixa no estoque loja
        $columns = [
            ['name' => 'id', 'type' => 'int(11)', 'key' => true],
            ['name' => 'id_bling', 'type' => 'varchar(100)'],
            ['name' => 'numero', 'type' => 'int(11)'],
            ['name' => 'data', 'type' => 'date'],
        ];
        //(new DB)->drop_table("estoque_fila");
        (new DB)->create_table('pedido_bling', $columns);

        //02/12/24
        //adiciona indices nas fotos
        $idx =
            [
                'name' => 'foto_idx',
                'columns' => 'foto_produto_produto, foto_produto_pos, foto_produto_img'
            ];
        (new DB)->add_index('foto_produto', $idx);

        $idx =
            [
                'name' => 'foto_idx',
                'columns' => 'produto_url, produto_status'
            ];
        (new DB)->add_index('produto', $idx);


        //08/01/25
        //IP pedido 
        $columns = [
            ["name" => "ip", "type" => "varchar(100)"],
            ["name" => "ip_city", "type" => "varchar(300)"],
        ];
        (new DB)->add_columns('pedido', $columns);

        //21/02/25
        //NOME INCORRETO
        $columns = ['name' => 'mehorenvio_cnpj', 'new' => 'melhorenvio_cnpj', 'type' => 'varchar(255)', 'default' => '""'];
        (new DB)->alter_column('frete', $columns);

        //21/02/25
        //CNAE OBRIGATORIO PARA LATAM 
        $columns = [["name" => "melhorenvio_cnae", "type" => "varchar(30)"]];
        (new DB)->add_columns('frete', $columns);


        //08/04/25
        //ADD CAMPO PARCELAS TABELA PEDIDO
        $columns = [
            ["name" => "parcelas", "type" => "int(3)"],
            ["name" => "parcelas_valor", "type" => "double(10,2)"],
        ];
        (new DB)->add_columns('pedido', $columns);


        //CONFIGURA parcelas sem JUROS para 1x 
        //(new Factory('pay'))->with(['id' => 5, 'pay_c8' => 3])->where("pay_name = 'Config'")->save();

        //########################################### NÃO ALTERAR ################################################
        (new Factory('version'))->with($upgrade)->save();
    }
}
