<?php

use Payment\PagarMe;

class Teste
{

    public function indexAction()
    {

        $customer = [
            "name" => "Rafael Clares",
            "email" => "rafael@clares.com.br",
            "type" => "individual",
            "document" => "00110589866",
            "phones" => [
                "home_phone" => [
                    "country_code" => "55",
                    "number" => "991104046",
                    "area_code" => "13"
                ],
            ],
        ];

        $billing_address = [
            "line_1" => "10880, Malibu Point, Malibu Central",
            "zip_code" => "90265",
            "city" => "Malibu",
            "state" => "CA",
            "country" => "US"
        ];

        $items = [
            [
                "amount" => 100,
                "description" => "Chaveiro do Tesseract",
                "quantity" => 1,
                "code" => 1
            ],
        ];


        $pix = [
            "items" => $items,
            "customer" => $customer,
            "payments" => [
                [
                    "payment_method" => "pix",
                    "pix" => ["expires_in" => "52134613"]
                ],
            ],
        ];

        $boleto = [
            "items" => $items,
            "customer" => $customer,
            "payments" => [
                [
                    "boleto" => [
                        "nosso_numero" => "1222",
                        "instructions" => "receber",
                        "bank" => "001"
                    ],
                    "payment_method" => "boleto"
                ],
            ],
        ];


        $cartao = [
            "items" => $items,
            "customer" => $customer,
            "payments" => [
                [
                    "payment_method" => "credit_card",
                    "credit_card" => [
                        "recurrence" => false,
                        "installments" => 1,
                        "statement_descriptor" => "AVENGERS",
                        "card" => [
                            "number" => "4000000000000010",
                            "holder_name" => "Rafael Clares Diniz",
                            "exp_month" => 8,
                            "exp_year" => 30,
                            "cvv" => "3531",
                            "billing_address" => $billing_address
                        ],
                    ],
                ],
            ],
        ];

        $formaPagto = "cartao";
        $payload = match ($formaPagto) {
            "boleto" => $boleto,
            "cartao" => $cartao,
            "pix" => $pix,
            default => $pix
        };


        echo json_encode($payload);
        exit;

        //PagarMe::payment($payload);
    }
}
