<?php

function pagseguro_get_env($env)
{
    if ($env == 'SANDBOX') {
        $URL_SESSION = 'https://ws.sandbox.pagseguro.uol.com.br/v2/sessions';
        $URL_JS = 'https://stc.sandbox.pagseguro.uol.com.br/pagseguro/api/v2/checkout/pagseguro.directpayment.js';
        $TRANS_URL = "https://ws.sandbox.pagseguro.uol.com.br/v2/transactions";
    } else {
        $URL_SESSION = 'https://ws.pagseguro.uol.com.br/v2/sessions';
        $URL_JS = 'https://stc.pagseguro.uol.com.br/pagseguro/api/v2/checkout/pagseguro.directpayment.js';
        $TRANS_URL = "https://ws.pagseguro.uol.com.br/v2/transactions";
    }
    return (object)['url_ssid' => $URL_SESSION, 'url_js' => $URL_JS, 'trans_url' => $TRANS_URL];
}
function faturaPS($gateway, $pedido_id, $pedido_total)
{
    $gateway->hash = Req::post('sender_hash', 'string');
    $gateway->cardToken = Req::post('card_token', 'string');
    $gateway->card_parcela = Req::post('card_parcela', 'string');
    $gateway->valor_parcela = Req::post('valor_parcela', 'string');
    $itens_p = [];
    $itens = [];
    $itens = (new Factory('lista_pedido'))->where('lista_pedido_pedido = ' . $pedido_id)->get();
    if (isset($itens) && !empty($itens)) {
        foreach ($itens as $item) {
            $item->lista_pedido_preco = preg_replace('/\,/', '', $item->lista_pedido_preco);
            $titulo = substr($item->lista_pedido_produto_titulo, 0, 30);
            $itens_p["id"] = $item->lista_pedido_produto;
            $itens_p["title"] = ("$titulo");
            $itens_p["quantity"] = $item->lista_pedido_qtde;
            $itens_p["description"] = ("$item->lista_pedido_produto_titulo");
            $itens_p["category_id"] = 'Produtos';
            $itens_p["unit_price"] = $item->lista_pedido_preco;
            $itens[] = $itens_p;
        }
    }
    $endereco = null;
    if (isset($_SESSION['frete']['endereco_id']) && !empty($_SESSION['frete']['endereco_id'])) {
        $endereco = (new Factory('endereco_cliente'))->find($_SESSION['frete']['endereco_id']);
    } else {
        $endereco = (new Factory('endereco_cliente'))->find_by('endereco_cliente_cliente', Session::client_node('uid'));
    }
    $cli_zip = str_replace('-', '', $endereco->endereco_cliente_cep);
    $cliente_email = Session::client_node('umail');
    $cli_rua = $endereco->endereco_cliente_rua;
    $cli_num = $endereco->endereco_cliente_num;
    $cli_bairro = $endereco->endereco_cliente_bairro;
    $cli_cidade = $endereco->endereco_cliente_cidade;
    $cli_uf = $endereco->endereco_cliente_uf;
    $cliente = (new Factory('cliente'))->find(Session::client_node('uid'));
    $cliente_full = explode(' ', $cliente->cliente_nome);
    $cliente_nome = isset($cliente_full[0]) ? $cliente_full[0] : ' ';
    $cliente_sobrenome = isset($cliente_full[1]) ? $cliente_full[1] : ' ';
    $cliente->telefone = preg_replace('/\W/', '', $cliente->cliente_telefone);
    $cliente->ddd = substr($cliente->telefone, 0, 2);
    $cliente->telefone = substr($cliente->telefone, 2, -1);
    if (isset($_POST['cardholderName']) && !empty($_POST['cardholderName'])) {
        $cliente_full = explode(' ', $_POST['cardholderName']);
        if (isset($cliente_full[0]) && !empty($cliente_full[0])) {
            $cliente_nome = $cliente_full[0];
        } else {
            $cliente_nome = '';
        }
        if (isset($cliente_full[1]) && !empty($cliente_full[1])) {
            $cliente_sobrenome = $cliente_full[1];
        } else {
            $cliente_sobrenome = '';
        }
    }
    if (isset($_POST['docNumberFake']) && !empty($_POST['docNumberFake'])) {
        $cli_doc_num = $_POST['docNumberFake'];
        $cli_doc_num = str_replace('.', '', $cli_doc_num);
        $cli_doc_num = str_replace('-', '', $cli_doc_num);
        $cli_doc_num = str_replace('/', '', $cli_doc_num);
        $cli_tipo_doc = strlen($cli_doc_num) > 11 ? 'CNPJ' : 'CPF';
    } else {
        $cli_doc_num = '';
        $cli_tipo_doc = '';
    }
    $sender = [
        'reference' => "$pedido_id",
        'senderName' => "$cliente_nome $cliente_sobrenome",
        "sender$cli_tipo_doc" => trim("$cli_doc_num"),
        'senderAreaCode' => $cliente->ddd,
        'senderPhone' => $cliente->telefone,
        'senderEmail' => 'joao-comprador@sandbox.pagseguro.com.br'
    ];
    $creds = [
        'email' => "$gateway->pay_user",
        'token' => "$gateway->pay_key",
        'creditCardToken' => "$gateway->cardToken",
        'senderHash' => "$gateway->hash",
        'receiverEmail' => "$gateway->pay_user",
        'notificationURL' => Http::base() . "/Notificacao/pagSeguro",
        'paymentMode' => 'default',
        'paymentMethod' => 'creditCard',
        'currency' => 'BRL'
    ];
    $shipping = [
        'shippingAddressStreet' => $cli_rua,
        'shippingAddressNumber' => $cli_num,
        'shippingAddressDistrict' => $cli_bairro,
        'shippingAddressPostalCode' => $cli_zip,
        'shippingAddressCity' => $cli_cidade,
        'shippingAddressState' => $cli_uf,
        'shippingAddressCountry' => 'BRA',
        'shippingType' => 1,
        'shippingCost' => '0.00'
    ];
    $bill = [
        'billingAddressStreet' => $cli_rua,
        'billingAddressNumber' => $cli_num,
        'billingAddressDistrict' => $cli_bairro,
        'billingAddressPostalCode' => $cli_zip,
        'billingAddressCity' => $cli_cidade,
        'billingAddressState' => $cli_uf,
        'billingAddressCountry' => 'BRA',
    ];
    if (isset($sender['senderCPF']) && !empty($sender['senderCPF'])) {
        $card = [
            'creditCardHolderName' => "$cliente_nome $cliente_sobrenome",
            'creditCardHolderCPF' => "$cli_doc_num",
            'creditCardHolderBirthDate' => '29/08/1993',
            'creditCardHolderAreaCode' => $cliente->ddd,
            'creditCardHolderPhone' => $cliente->telefone,
            'installmentQuantity' => $gateway->card_parcela,
            'installmentValue' => $gateway->valor_parcela,
        ];
    } else {
        $card = [
            'creditCardHolderName' => "$cliente_nome $cliente_sobrenome",
            'creditCardHolderCPF' => "29055621021",
            'creditCardHolderCNPJ' => str_replace(' ', '', trim("$cli_doc_num")),
            'creditCardHolderBirthDate' => '29/08/1993',
            'creditCardHolderAreaCode' => $cliente->ddd,
            'creditCardHolderPhone' => $cliente->telefone,
            'installmentQuantity' => $gateway->card_parcela,
            'installmentValue' => $gateway->valor_parcela,
        ];
    }
    if ($gateway->pay_c1 > 1) {
        $card['noInterestInstallmentQuantity'] = $gateway->pay_c1; //parcelas sem juros
    }
    $itens_p = [];
    $itens_p["itemId1"] = '1';
    $itens_p["itemDescription1"] = 'Produtos da loja';
    $itens_p["itemAmount1"] = number_format(($pedido_total), 2, '.', '');
    $itens_p["itemQuantity1"] = 1;
    $final = array_merge($bill, $shipping);
    $final = array_merge($final, $itens_p);
    $final = array_merge($final, $sender);
    $final =  array_merge($final, $creds);
    $final = array_merge($final, $card);
    $headers = ['Content-Type' => 'application/x-www-form-urlencoded; charset=UTF-8;'];
    $ch = curl_init();
    $url = "https://ws.pagseguro.uol.com.br/v2/transactions?email=$gateway->pay_user&token=$gateway->pay_key";
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($final, '', '&'));
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    $result = curl_exec($ch);
    return $result;
}

function faturaPSBoleto($gateway, $pedido_id, $pedido_total)
{
    $pedido_total = $pedido_total - 1;
    $gateway->hash = Req::post('sender_hash', 'string');
    $itens_p = [];
    $itens = [];
    $itens = (new Factory('lista_pedido'))->where('lista_pedido_pedido = ' . $pedido_id)->get();
    if (isset($itens) && !empty($itens)) {
        foreach ($itens as $item) {
            $item->lista_pedido_preco = preg_replace('/\,/', '', $item->lista_pedido_preco);
            $titulo = substr($item->lista_pedido_produto_titulo, 0, 30);
            $itens_p["id"] = $item->lista_pedido_produto;
            $itens_p["title"] = ("$titulo");
            $itens_p["quantity"] = $item->lista_pedido_qtde;
            $itens_p["description"] = ("$item->lista_pedido_produto_titulo");
            $itens_p["category_id"] = 'Produtos';
            $itens_p["unit_price"] = $item->lista_pedido_preco;
            $itens[] = $itens_p;
        }
    }
    $endereco = null;
    if (isset($_SESSION['frete']['endereco_id']) && !empty($_SESSION['frete']['endereco_id'])) {
        $endereco = (new Factory('endereco_cliente'))->find($_SESSION['frete']['endereco_id']);
    } else {
        $endereco = (new Factory('endereco_cliente'))->find_by('endereco_cliente_cliente', Session::client_node('uid'));
    }
    $cli_zip = str_replace('-', '', $endereco->endereco_cliente_cep);
    $cliente_email = Session::client_node('umail');
    $cli_rua = $endereco->endereco_cliente_rua;
    $cli_num = $endereco->endereco_cliente_num;
    $cli_bairro = $endereco->endereco_cliente_bairro;
    $cli_cidade = $endereco->endereco_cliente_cidade;
    $cli_uf = $endereco->endereco_cliente_uf;
    
    $cliente = (new Factory('cliente'))->find(Session::client_node('uid'));
    $cliente_full = explode(' ', $cliente->cliente_nome);
    $cliente_nome = isset($cliente_full[0]) ? $cliente_full[0] : ' ';
    $cliente_sobrenome = isset($cliente_full[1]) ? $cliente_full[1] : ' ';
    $cliente->telefone = preg_replace('/\W/', '', $cliente->cliente_telefone);
    $cliente->ddd = substr($cliente->telefone, 0, 2);
    $cliente->telefone = substr($cliente->telefone, 2, -1);
    if (isset($_POST['cardholderName']) && !empty($_POST['cardholderName'])) {
        $cliente_full = explode(' ', $_POST['cardholderName']);
        if (isset($cliente_full[0]) && !empty($cliente_full[0])) {
            $cliente_nome = $cliente_full[0];
        } else {
            $cliente_nome = '';
        }
        if (isset($cliente_full[1]) && !empty($cliente_full[1])) {
            $cliente_sobrenome = $cliente_full[1];
        } else {
            $cliente_sobrenome = '';
        }
    }
    if (isset($_POST['docNumberFake']) && !empty($_POST['docNumberFake'])) {
        $cli_doc_num = $_POST['docNumberFake'];
    } else {
        $cli_doc_num = $cliente->cliente_cpf;
    }
    $cli_doc_num = str_replace('.', '', "$cli_doc_num");
    $cli_doc_num = str_replace('-', '', "$cli_doc_num");
    $cli_doc_num = str_replace('/', '', "$cli_doc_num");    
    $cli_tipo_doc = strlen($cli_doc_num) > 11 ? 'CNPJ' : 'CPF';
    $retorno = Http::base() . '/Notificacao/pagSeguro';
    $sender = [
        'reference' => "$pedido_id",
        'senderName' => "$cliente_nome $cliente_sobrenome",
        "sender$cli_tipo_doc" => trim("$cli_doc_num"),
        'senderAreaCode' => $cliente->ddd,
        'senderPhone' => $cliente->telefone,
        'senderEmail' => 'joao-comprador@sandbox.pagseguro.com.br'
    ];
    $creds = [
        'email' => "$gateway->pay_user",
        'token' => "$gateway->pay_key",
        'senderHash' => "$gateway->hash",
        'receiverEmail' => "$gateway->pay_user",
        'notificationURL' => $retorno,
        'paymentMode' => 'default',
        'paymentMethod' => 'boleto',
        'currency' => 'BRL'
    ];
    $shipping = [
        'shippingAddressStreet' => $cli_rua,
        'shippingAddressNumber' => $cli_num,
        'shippingAddressDistrict' => $cli_bairro,
        'shippingAddressPostalCode' => $cli_zip,
        'shippingAddressCity' => $cli_cidade,
        'shippingAddressState' => $cli_uf,
        'shippingAddressCountry' => 'BRA',
        'shippingType' => 1,
        'shippingCost' => '0.00'
    ];
    $bill = [
        'billingAddressStreet' => $cli_rua,
        'billingAddressNumber' => $cli_num,
        'billingAddressDistrict' => $cli_bairro,
        'billingAddressPostalCode' => $cli_zip,
        'billingAddressCity' => $cli_cidade,
        'billingAddressState' => $cli_uf,
        'billingAddressCountry' => 'BRA',
    ];
    $itens_p = [];
    $itens_p["itemId1"] = '1';
    $itens_p["itemDescription1"] = 'Produtos da loja';
    $itens_p["itemAmount1"] = number_format(($pedido_total), 2, '.', '');
    $itens_p["itemQuantity1"] = 1;
    $final = array_merge($bill, $shipping);
    $final = array_merge($final, $itens_p);
    $final = array_merge($final, $sender);
    $final = array_merge($final, $creds);
    $headers = ['Content-Type' => 'application/x-www-form-urlencoded; charset=UTF-8;'];
    $ch = curl_init();
    $url = "https://ws.pagseguro.uol.com.br/v2/transactions?email=$gateway->pay_user&token=$gateway->pay_key";
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($final, '', '&'));
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    $result = curl_exec($ch);
    return $result;
}

function faturaPSPix($gateway, $pedido_id, $pedido_total) {
    

}