<?php

class Pagina
{
    public function __construct()
    {
        (new Install())->check();
        (new Install)->check_tabelas_principais();
    }

    public function listarPaginasTopo() {
        $cat = (new Factory('categoria_pagina'))
            ->select('categoria_pagina_id, categoria_pagina_nome, categoria_pagina_url, categoria_pagina_topo, categoria_pagina_pos')
            ->where('categoria_pagina_topo = "1" AND categoria_pagina_id IN (SELECT pagina_categoria FROM pagina WHERE pagina_status = 1)')
            ->get();
        if($cat) {
            foreach($cat as $k => $v) {
                $pag = (new Factory('pagina'))
                ->select('pagina_id, pagina_url, pagina_titulo, pagina_status')
                ->where('pagina_status = 1 AND pagina_categoria = ' . $cat[$k]->categoria_pagina_id)
                ->get();

                if($pag)
                    $cat[$k]->paginas = $pag;
                else
                    unset($cat[$k]);
            }
        }
        return $cat;
    }

    public function listarPaginasFooter() {
        $cat = (new Factory('categoria_pagina'))
            ->select('categoria_pagina_id, categoria_pagina_nome, categoria_pagina_url, categoria_pagina_rodape, categoria_pagina_pos')
            ->where('categoria_pagina_rodape = "1" AND categoria_pagina_id IN (SELECT pagina_categoria FROM pagina WHERE pagina_status = 1)')
            ->get();
        if($cat) {
            foreach($cat as $k => $v) {
                $pag = (new Factory('pagina'))
                ->select('pagina_id, pagina_url, pagina_titulo, pagina_status')
                ->where('pagina_status = 1 AND pagina_categoria = ' . $cat[$k]->categoria_pagina_id)
                ->get();

                if($pag)
                    $cat[$k]->paginas = $pag;
                else
                    unset($cat[$k]);
            }
        }
        return $cat;
    }

    public function ver(){

        $cat = Http::get_param(1, 'string');
        $nome = Http::get_param(2, 'string');
       
        if(!empty($cat) && !empty($nome)){
            $pagina = (new Factory('pagina'))->select('pagina_id, pagina_titulo,pagina_desc,pagina_keywords, pagina_texto, pagina_capa, categoria_pagina_nome, categoria_pagina_url')
                ->join('categoria_pagina', 'categoria_pagina_id = pagina_categoria')
                ->where("pagina_url = '$nome' AND categoria_pagina_url = '$cat' ")
                ->limit(1)
                ->get();
            $pagina = !empty($pagina[0]) ? $pagina[0] : '';

            if(!$pagina){
                Http::redirect_to('/?_404');
            }

            $data = [
                'categorias' => (new CategoriasProdutosFront())->listar(),
            'destaques' => (new CategoriasProdutosFront())->listaSubcategoriasDestaque(),
                'paginasTopo' => (new Pagina())->listarPaginasTopo(),
                // Footer
                 'paginasFooter' => (new Pagina())->listarPaginasFooter(),
            'faq' => (new Faq())->listaFooter(),  
                // Principal
                'config' => (new Config)->get(),
                'social' => (new Config)->getRedesSociais(),
                'pagina' => $pagina,
                'mapper' => ['config','pagina','social']
            ];
            Tpl::view("tema.loja.pagina.index", $data, 1);
            
        }else{
            Http::redirect_to('/');
        }
    }
}