<?php

class Marca
{

    public function __construct()
    {
        Sessao::check();
        (new Install)->check_tabelas_principais();
    }

    public function indexAction()
    {        
        $data = [
            'config' => (new Config)->get(),
            
            'mapper' => ['config']
        ];
        Tpl::view('admin.marca.index', $data, 1);
    }

    public function listar() {
        (new Factory('marca'))
            ->select('*, (SELECT COUNT(*) FROM produto WHERE produto_marca = marca_id) AS marca_produtos')
            ->get(1);
    }

    public function gravar() {
        if(isset($_POST['marca_nome']) && !empty($_POST['marca_nome'])) {
            $_POST = Filter::parse_full($_POST);
            $_POST['marca_url'] = Filter::slug($_POST['marca_nome']);
            if (!intval($_POST['marca_id']) > 0 && intval($_FILES['marca_logo']['error']) > 0) {
                Http::redirect_to("/marca/?error");
            }
            $media = Media::img_upload($_FILES['marca_logo'], 'marca');
            if (isset($media->url)) {
                $ds = DIRECTORY_SEPARATOR;
                $path = Path::base() . $ds . 'media' . $ds . 'marca' . $ds . $_POST['marca_logo'];
                if (is_file($path)) {
                    //@system("chmod -R 777 $path");
                    @unlink($path);
                }
                $_POST['marca_logo'] = $media->url;
            } else {
                unset($_POST['marca_logo']);
            }
            $marca = (new Factory('marca'))->with($_POST)->save();
            $marca > 0 ? Http::redirect_to("/marca/?success") : Http::redirect_to("/marca/?error");
        }
        
    }

    public function remover() {
        $id = Req::post('id', 'int');
        if($id > 0) {
            (new Factory('marca'))->drop($id);
            echo '1';
        } else {
            echo '0';
        }
    }

    
}