<?php

@session_start();
class Install
{

	public function check()
	{
		$check = (new DB)->check("SELECT * FROM config");
		if ($check === false) {
			Http::redirect_to('/install/');
		}
	}
	public function check_auth()
	{
		if (!isset($_SESSION['login_install'])) {
			Http::redirect_to('/install/login');
		}
	}
	public function logout()
	{
		unset($_SESSION['login_install']);
		Http::redirect_to('/install/login');
	}

	public function login()
	{
		$data = [
			'mapper' => [],
		];
		Tpl::view('admin.install.login', $data);
	}

	public function auth()
	{
		$senha = Req::post('senha', 'string');
		$env_install = 'config/.env';
		//$env_install = @parse_ini_file($env_install, 1)['develop'];
		$env_install = @parse_ini_string(file_get_contents($env_install), true, INI_SCANNER_RAW)['develop'];
		$env_install = (object) $env_install;
		if (empty($senha) || $senha != $env_install->installpass) {
			Http::redirect_to('/install/login?incorreto');
		}
		$_SESSION['login_install'] = true;
		Http::redirect_to('/install');
	}
	// Faz uma checagem nas tabelas necessárias pro funcionamento da loja
	// Caso exista alguma irregularidade, como por exemplo, sem registro no config, reseta a mesma
	public function check_tabelas_principais() {}

	public function indexAction()
	{
		$this->check_auth();
		$file = 'config/.env';
		//$bd = (object) @parse_ini_file($file, 1)['database'];
		//$dev = (object) @parse_ini_file($file, 1)['develop'];
		$bd = (object) @parse_ini_string(file_get_contents($file), true, INI_SCANNER_RAW)['database'];
		$dev = (object) @parse_ini_string(file_get_contents($file), true, INI_SCANNER_RAW)['develop'];
		$con = false;
		try {
			$con = new PDO("mysql:host=$bd->host;port=$bd->port;dbname=$bd->base", $bd->user, $bd->pass);
		} catch (PDOException $e) {
			//erro ao conectar
		}
		$status_code = 1;
		$status_text = '<div class="text-center bg-danger"><h4 class="text-white p-10">
                        <span class="float-left"><i class="fa fa-toggle-off"></i></span>
                        O sistema não está conectado ao banco de dados! Verifique as credenciais de acesso!</h4></div>';
		if ($con) {
			$status_code = 0;
			$status_text = '<div class="text-center bg-primary"><h4 class="p-10 text-white">
                            <span class="float-left"><i class="fa fa-toggle-on"></i></span>
                            O sistema está conectado ao banco de dados!</h4></div>';
		}

		$data = [
			'database' => $bd,
			'develop' => $dev,
			'status_text' => ['status_text' => $status_text],
			'status_code' => ['status_code' => $status_code],
			'mapper' => ['database', 'status_text', 'status_code', 'develop'],
		];
		Tpl::view('admin.install.index', $data);
	}

	public function save_conf()
	{
		$this->check_auth();
		if (isset($_POST) && !empty($_POST)) {
			//$_POST = self::parser();
			$host = $_POST['host'];
			$base = $_POST['base'];
			$user = $_POST['user'];
			$pass = $_POST['pass'];
			$port = $_POST['port'];
			$prefix = "true";
			$str = "[database]\nhost = \"$host\"\nbase = \"$base\"\nuser = \"$user\"\npass = \"$pass\"\nport = \"$port\"\nprefix = \"$prefix\"\n\n";

			$installpass = $_POST['installpass'];

			$str .= "[develop] \ncompress = \"false\"\nnocache  = \"false\"\ninstallpass = \"$installpass\"";
			$str = ltrim(rtrim(trim($str)));
			$server_user = get_current_user();
			$config_path = Path::base() . '/config/';
			$config_file = $config_path . '.env';

			//system("chmod 777 $config_file");
			@chown($config_file, $server_user);
			@chmod($config_file, 0777);
			//unlink($config_file);
			$fp = @fopen($config_file, 'w+') or
				die("<h3>Permissão de gravação [erro -1]:</h3><p>$config_file está sem permissão de gravação!</p>");
			////@system("chmod 777 $config_file");
			fwrite($fp, $str);
			@chmod($config_file, 0744);
			////@system("chmod 644 $config_file");
			fclose($fp);
			Http::redirect_to('/install/');
		}
	}

	public function down($redirect = true)
	{
		$this->check_auth();
		(new DB)->drop_table('atributo');
		(new DB)->drop_table('avaliacoes_produto');
		(new DB)->drop_table('campo_checkout');
		(new DB)->drop_table('campo_checkout_produto');
		(new DB)->drop_table('campo_checkout_respostas');
		(new DB)->drop_table('categoria_faq');
		(new DB)->drop_table('categoria_pagina');
		(new DB)->drop_table('categoria_produto');
		(new DB)->drop_table('cliente');
		(new DB)->drop_table('config');
		(new DB)->drop_table('config_cores');
		(new DB)->drop_table('contato');
		(new DB)->drop_table('cupom');
		(new DB)->drop_table('endereco_cliente');
		(new DB)->drop_table('faixa_cep');
		(new DB)->drop_table('faq');
		(new DB)->drop_table('categoria_faq');
		(new DB)->drop_table('foto_produto');
		(new DB)->drop_table('frete');
		(new DB)->drop_table('frete_diferenciado');
		(new DB)->drop_table('item_atributo');
		(new DB)->drop_table('lista_pedido');
		(new DB)->drop_table('lista_pedido_atributo');
		(new DB)->drop_table('marca');
		(new DB)->drop_table('newsletter');
		(new DB)->drop_table('order_home');
		(new DB)->drop_table('pagina');
		(new DB)->drop_table('parceiro');
		(new DB)->drop_table('pay');
		(new DB)->drop_table('pedido');
		(new DB)->drop_table('produto');
		(new DB)->drop_table('produtos_relacionados');
		(new DB)->drop_table('redesSociais');
		(new DB)->drop_table('relacao_atributo');
		(new DB)->drop_table('relacao_item');
		(new DB)->drop_table('retirada');
		(new DB)->drop_table('slide');
		(new DB)->drop_table('smtp');
		(new DB)->drop_table('subcategoria_pagina');
		(new DB)->drop_table('subcategoria_produto');
		(new DB)->drop_table('usuario');
		(new DB)->drop_table('vinculo_categoria_produto');
		(new DB)->drop_table('visualizacoes_produto');
		(new DB)->drop_table('config_card');
		(new DB)->drop_table('integracao');
		if ($redirect) {
			Http::redirect_to('/install/?success');
		}
	}

	// instalação sem itens
	public function up()
	{
		$this->down(false);
		$this->check_auth();
		$this->create();
		Http::redirect_to('/install/?success');
	}

	// instalação com itens
	public function up_padrao()
	{
		$this->down(false);
		$this->check_auth();
		$this->create();
		$this->mock();
		Http::redirect_to('/install/?success');
	}

	public function update()
	{
		$this->check_auth();
		// $this->config_update();
		// Http::redirect_to('/');
	}

	public function create()
	{
		$this->check_auth();
		$this->atributo_create();
		$this->avaliacoes_produto_create();
		$this->campo_checkout_create();
		$this->campo_checkout_produto_create();
		$this->campo_checkout_respostas_create();
		$this->categoria_faq_create();
		$this->categoria_pagina_create();
		$this->categoria_produto_create();
		$this->cliente_create();
		$this->config_create();
		$this->config_cores_create();
		$this->card_product_create();
		$this->contato_create();
		$this->cupom_create();
		$this->endereco_cliente_create();
		$this->faixa_cep_create();
		$this->faq_create();
		$this->foto_produto_create();
		$this->frete_create();
		$this->frete_diferenciado_create();
		$this->item_atributo_create();
		$this->lista_pedido_create();
		$this->lista_pedido_atributo_create();
		$this->marca_create();
		$this->newsletter_create();
		$this->order_home_create();
		$this->pagina_create();
		$this->parceiro_create();
		$this->pay_create();
		$this->pedido_create();
		$this->produto_create();
		$this->produtos_relacionados_create();
		$this->rede_create();
		$this->relacao_atributo_create();
		$this->relacao_item_create();
		$this->retirada_create();
		$this->slide_create();
		$this->smtp_create();
		$this->subcategoria_pagina_create();
		$this->subcategoria_produtos_create();
		$this->usuario_create();
		$this->vinculo_categoria_produto_create();
		$this->visualizacoes_produto_create();
		$this->favorito_create();
		$this->integracao_create();
		$this->estoque_fila_create();
		$this->pedidos_bling_create();
		$this->indexes_create();
		$this->version_create();
	}

	public function version_create()
	{
		$now = date('Y-m-d H:i:s');
		$columns = [
			['name' => 'id', 'type' => 'int(11)', 'key' => true],
			['name' => 'num', 'type' => 'int(5)'],
			['name' => 'patch', 'type' => 'varchar(20)'],
			['name' => 'info', 'type' => 'longtext'],
			['name' => 'last', 'type' => 'datetime', 'default' => 'NULL'],


		];
		$add = [
			'num' => '403',
			'patch' => '4.0.3',
			'info' => 'install',
			'last' => $now,
		];
		(new DB)->drop_table('version');
		(new DB)->create_table('version', $columns, $add);
	}

	public function indexes_create()
	{
		$idx = [
			'name' => 'foto_idx',
			'columns' => 'foto_produto_produto, foto_produto_pos, foto_produto_img'
		];
		(new DB)->add_index('foto_produto', $idx);
		$idx = [
			'name' => 'foto_idx',
			'columns' => 'produto_url, produto_status'
		];
		(new DB)->add_index(
			'produto',
			$idx
		);
	}
	public function cliente_create()
	{
		$this->check_auth();
		$columns = [
			['name' => 'id', 'type' => 'int(11)', 'key' => true],
			['name' => 'nome', 'type' => 'varchar(100)'],
			['name' => 'cpf', 'type' => 'varchar(20)'],
			['name' => 'rg', 'type' => 'varchar(20)'],
			['name' => 'sexo', 'type' => 'int(1)'],
			['name' => 'telefone', 'type' => 'varchar(20)'],
			['name' => 'celular', 'type' => 'varchar(20)'],
			['name' => 'whats', 'type' => 'varchar(20)'],
			['name' => 'email', 'type' => 'varchar(100)', 'null' => 'NOT NULL'],
			['name' => 'email2', 'type' => 'varchar(100)'],
			['name' => 'password', 'type' => 'varchar(100)'],
			['name' => 'token', 'type' => 'varchar(100)'],
			['name' => 'cep', 'type' => 'varchar(15)'],
			['name' => 'rua', 'type' => 'varchar(200)'],
			['name' => 'num', 'type' => 'varchar(20)'],
			['name' => 'bairro', 'type' => 'varchar(100)'],
			['name' => 'cidade', 'type' => 'varchar(100)'],
			['name' => 'uf', 'type' => 'varchar(2)'],
			['name' => 'complemento', 'type' => 'varchar(200)'],
			['name' => 'ref', 'type' => 'varchar(200)'],
			['name' => 'razao', 'type' => 'varchar(100)'],
			['name' => 'cnpj', 'type' => 'varchar(30)'],
			['name' => 'ie', 'type' => 'varchar(30)'],
			['name' => 'contato', 'type' => 'varchar(200)'],
			['name' => 'cupom', 'type' => 'VARCHAR(200)', 'default' => '""'],
			['name' => 'obs', 'type' => 'text'],
			['name' => 'nascimento', 'type' => 'datetime'],
			['name' => 'tipo', 'type' => 'int(1)', 'default' => 1],
			['name' => 'status', 'type' => 'int(1)', 'default' => 1],
		];
		$add = [
			'nome' => 'PHP STAFF',
			'razao' => 'PHP STAFF',
			'email' => 'falecom@phpstaff.com.br',
			'telefone' => '(11) 5555-5555',
		];
		(new DB)->create_table('cliente', $columns, $add);
	}

	public function card_product_create()
	{
		// $this->check_auth();
		$columns = [
			['name' => 'id', 'type' => 'int(11)', 'key' => true],
			['name' => 'bg_color', 'type' => 'varchar(12)'],
			['name' => 'border_size', 'type' => 'varchar(200)'],
			['name' => 'border_size_hover', 'type' => 'varchar(200)'],
			['name' => 'border_color', 'type' => 'varchar(10)'],
			['name' => 'border_color_hover', 'type' => 'varchar(10)'],

			['name' => 'tooltip_text', 'type' => 'varchar(50)'],
			['name' => 'tooltip_text_color', 'type' => 'varchar(20)'],
			['name' => 'tooltip_bg_color', 'type' => 'varchar(20)'],

			['name' => 'text_pri_color', 'type' => 'varchar(10)'],
			['name' => 'text_pri_size', 'type' => 'varchar(10)'],
			['name' => 'text_pri_align', 'type' => 'varchar(10)'],
			['name' => 'text_pri_bold', 'type' => 'varchar(10)'],

			['name' => 'text_sec_color', 'type' => 'varchar(10)'],
			['name' => 'text_sec_size', 'type' => 'varchar(10)'],
			['name' => 'text_sec_align', 'type' => 'varchar(10)'],

			['name' => 'btn_text_color', 'type' => 'varchar(10)'],
			['name' => 'btn_bg_color', 'type' => 'varchar(10)'],
			['name' => 'btn_text_color_hover', 'type' => 'varchar(10)'],
			['name' => 'btn_bg_color_hover', 'type' => 'varchar(10)'],

			['name' => 'img_width', 'type' => 'varchar(10)'],
			['name' => 'img_height', 'type' => 'varchar(10)'],
			['name' => 'img_elm_height', 'type' => 'varchar(10)'],
			['name' => 'desc_elm_height', 'type' => 'varchar(10)'],

			['name' => 'text_price_align', 'type' => 'varchar(20)'],
			['name' => 'text_price_size', 'type' => 'varchar(10)'],
			['name' => 'text_price_color', 'type' => 'varchar(10)'],
			['name' => 'text_price_bold', 'type' => 'varchar(10)'],

			['name' => 'text_line_align', 'type' => 'varchar(20)'],
			['name' => 'text_line_size', 'type' => 'varchar(10)'],
			['name' => 'text_line_color', 'type' => 'varchar(10)'],
			['name' => 'text_line_bold', 'type' => 'varchar(10)'],

			['name' => 'text_desconto', 'type' => 'varchar(50)'],
			['name' => 'text_desconto_color', 'type' => 'varchar(10)'],
			['name' => 'text_desconto_size', 'type' => 'varchar(10)'],
			['name' => 'text_desconto_align', 'type' => 'varchar(20)'],
			['name' => 'text_desconto_bold', 'type' => 'varchar(20)'],

			['name' => 'text_percent', 'type' => 'varchar(40)'],
			['name' => 'text_percent_color', 'type' => 'varchar(10)'],
			['name' => 'text_percent_size', 'type' => 'varchar(10)'],
			['name' => 'text_percent_align', 'type' => 'varchar(20)'],
			['name' => 'text_percent_bold', 'type' => 'varchar(20)'],

			['name' => 'text_parc', 'type' => 'varchar(50)'],
			['name' => 'text_parc_size', 'type' => 'varchar(10)'],
			['name' => 'text_parc_color', 'type' => 'varchar(10)'],
			['name' => 'text_parc_align', 'type' => 'varchar(20)'],
			['name' => 'text_parc_bold', 'type' => 'varchar(20)'],

			['name' => 'shadow_bg_color', 'type' => 'varchar(10)'],
			['name' => 'padding', 'type' => 'varchar(30)'],
			['name' => 'body_padding', 'type' => 'varchar(30)'],
		];
		$seeds[] = [
			'bg_color' => '#ffffff',

			'padding' => '0',
			'body_padding' => '6',
			'border_size' => '1px 1px 1px 1px',

			'border_size_hover' => '1px 1px 1px 1px',
			'border_color_hover' => '#A67720',

			'tooltip_text' => 'COMPRAR',
			'tooltip_text_color' => '#F5E5C3',
			'tooltip_bg_color' => '#A67720',

			'text_pri_color' => '#555555',
			'text_pri_size' => '18',
			'text_pri_align' => 'center',
			'text_pri_bold' => 'normal',

			'text_sec_color' => '#000000',
			'text_sec_size' => '12',
			'text_sec_align' => 'left',

			'btn_text_color' => '#ffffff',
			'btn_bg_color' => '#333333',
			'btn_text_color_hover' => '#ffffff',
			'btn_bg_color_hover' => '#666666',

			'img_width' => '100%',
			'img_height' => '300',
			'img_elm_height' => '300',
			'desc_elm_height' => '160',

			'text_price_size' => '18',
			'text_price_color' => '#555555',
			'text_price_align' => 'center',
			'text_price_bold' => 'bold',

			'text_line_size' => '13',
			'text_line_color' => '#ff0000',
			'text_line_align' => 'center',
			'text_line_bold' => 'normal',

			'text_desconto' => 'no PIX',
			'text_desconto_color' => '#ff0000',
			'text_desconto_size' => '12',
			'text_desconto_align' => 'center',
			'text_desconto_bold' => 'normal',

			'text_percent' => '% off',
			'text_percent_color' => '#555555',
			'text_percent_size' => '11',
			'text_percent_align' => 'center',
			'text_percent_bold' => 'normal',

			'text_parc' => 'c/ juros',
			'text_parc_size' => '12',
			'text_parc_color' => '2e3fc2',
			'text_parc_align' => 'center',
			'text_parc_bold' => 'normal',

			'shadow_bg_color' => '#666666',
		];
		(new DB)->drop_table('config_card');
		$card = (new DB)->create_table('config_card', $columns, $seeds);
		$card = (new Factory('config_card'))->find(1);
	}
	public function smtp_create()
	{
		$this->check_auth();
		$columns = [
			['name' => 'id', 'type' => 'int(11)', 'key' => true],
			['name' => 'host', 'type' => 'varchar(200)'],
			['name' => 'email', 'type' => 'varchar(200)'],
			['name' => 'cc', 'type' => 'varchar(200)'],
			['name' => 'bcc', 'type' => 'varchar(200)'],
			['name' => 'pass', 'type' => 'varchar(200)'],
			['name' => 'port', 'type' => 'varchar(200)'],
			['name' => 'secure', 'type' => 'varchar(200)'],
			['name' => 'nome', 'type' => 'varchar(200)'],
		];
		$add = [
			'host' => 'host.com.br',
			'email' => 'email@host.com.br',
			'pass' => '123senha',
			'port' => '587',
			'secure' => '1',
			'nome' => 'Teste',
		];
		(new DB)->drop_table('smtp');
		(new DB)->create_table('smtp', $columns, $add);
	}

	public function contato_create()
	{
		$this->check_auth();
		$columns = [
			['name' => 'id', 'type' => 'int(11)', 'key' => true],
			['name' => 'email', 'type' => 'varchar(200)'],
			['name' => 'emails', 'type' => 'text'],
			['name' => 'tell1', 'type' => 'varchar(200)'],
			['name' => 'tell2', 'type' => 'varchar(200)'],
			['name' => 'cep', 'type' => 'varchar(200)'],
			['name' => 'rua', 'type' => 'varchar(200)'],
			['name' => 'numero', 'type' => 'varchar(200)'],
			['name' => 'complemento', 'type' => 'varchar(200)'],
			['name' => 'ref', 'type' => 'varchar(200)'],
			['name' => 'bairro', 'type' => 'varchar(200)'],
			['name' => 'cidade', 'type' => 'varchar(200)'],
			['name' => 'uf', 'type' => 'varchar(200)'],
		];
		$add = [
			'email' => 'email@email.com',
			'tell1' => '(13) 4321-1234',
			'tell2' => '(11) 1234-4321',
			'cep' => '11704-100',
			'rua' => 'Avenida Presidente Kennedy',
			'numero' => '123',
			'complemento' => 'teste',
			'ref' => 'teste',
			'bairro' => 'Ocian',
			'cidade' => 'Praia Grande',
			'uf' => 'SP',
		];

		(new DB)->drop_table('contato');
		(new DB)->create_table('contato', $columns, $add);
	}

	public function rede_create()
	{
		$this->check_auth();
		$columns = [
			['name' => 'id', 'type' => 'int(11)', 'key' => true],
			['name' => 'facebook', 'type' => 'varchar(200)'],
			['name' => 'twitter', 'type' => 'varchar(200)'],
			['name' => 'instagram', 'type' => 'varchar(200)'],
			['name' => 'linkedin', 'type' => 'varchar(200)'],
			['name' => 'youtube', 'type' => 'varchar(200)'],
		];
		$add = [
			'facebook' => 'http://facebook.com/',
			'twitter' => 'http://twitter.com/',
			'instagram' => 'http://instagram.com/',
			'linkedin' => 'http://linkedin.com/',
			'youtube' => 'https://www.youtube.com/',
		];
		(new DB)->create_table('redesSociais', $columns, $add);
	}

	public function usuario_create()
	{
		$this->check_auth();
		$columns = [
			['name' => 'id', 'type' => 'int(11)', 'key' => true],
			['name' => 'nome', 'type' => 'varchar(200)'],
			['name' => 'fone', 'type' => 'varchar(200)'],
			['name' => 'email', 'type' => 'varchar(200)'],
			['name' => 'pass', 'type' => 'varchar(200)'],
			['name' => 'avatar', 'type' => 'varchar(200)'],
			['name' => 'token', 'type' => 'varchar(200)'],
			['name' => 'level', 'type' => 'int(1)', 'default' => 1],
			['name' => 'status', 'type' => 'int(1)', 'default' => 1],
			['name' => 'online', 'type' => 'int(1)', 'default' => 0],
			['name' => 'flag_online', 'type' => 'int(5)', 'default' => 0],
			['name' => 'permissao', 'type' => 'varchar(1000)', 'default' => "'*'"],

		];
		$add = ['nome' => 'Admin', 'email' => 'admin@admin.com', 'pass' => md5('admin')];
		(new DB)->drop_table('usuario');
		(new DB)->create_table('usuario', $columns, $add);
	}

	public function slide_create()
	{
		$this->check_auth();
		$columns = [
			['name' => 'id', 'type' => 'int(11)', 'key' => true],
			['name' => 'status', 'type' => 'int(1)', 'default' => 1],
			['name' => 'pos', 'type' => 'int(3)', 'default' => 999],
			['name' => 'img', 'type' => 'varchar(200)'],
			['name' => 'size', 'type' => 'varchar(20)'],
			['name' => 'path', 'type' => 'varchar(255)'],
			['name' => 'titulo', 'type' => 'varchar(200)'],
			['name' => 'texto', 'type' => 'varchar(255)'],
			['name' => 'url', 'type' => 'varchar(255)'],
			['name' => 'tipo', 'type' => 'int(1)', 'default' => 1],
			['name' => 'video', 'type' => 'varchar(255)'],
		];

		(new DB)->create_table('slide', $columns);
	}

	public function categoria_pagina_create()
	{
		$this->check_auth();
		$columns = [
			['name' => 'id', 'type' => 'int(11)', 'key' => true],
			['name' => 'nome', 'type' => 'varchar(200)'],
			['name' => 'url', 'type' => 'varchar(200)'],
			['name' => 'topo', 'type' => 'int(1)'],
			['name' => 'rodape', 'type' => 'int(1)'],
			['name' => 'icone', 'type' => 'varchar(200)'],
			['name' => 'pos', 'type' => 'int(11)'],
			['name' => 'cor', 'type' => 'varchar(200)'],
		];
		(new DB)->create_table('categoria_pagina', $columns);
	}

	public function subcategoria_pagina_create()
	{
		$this->check_auth();
		$columns = [
			['name' => 'id', 'type' => 'int(11)', 'key' => true],
			['name' => 'nome', 'type' => 'varchar(200)'],
			['name' => 'categoria', 'type' => 'varchar(200)'],
			['name' => 'url', 'type' => 'varchar(200)'],
		];
		(new DB)->create_table('subcategoria_pagina', $columns);
	}

	public function pagina_create()
	{
		$this->check_auth();
		$columns = [
			['name' => 'id', 'type' => 'int(11)', 'key' => true],
			['name' => 'categoria', 'type' => 'int(11)'],
			['name' => 'subcategoria', 'type' => 'int(11)'],
			['name' => 'url', 'type' => 'varchar(200)'],
			['name' => 'titulo', 'type' => 'varchar(200)'],
			['name' => 'desc', 'type' => 'text'],
			['name' => 'status', 'type' => 'int(1)', 'default' => 1],
			['name' => 'texto', 'type' => 'longtext'],
			['name' => 'capa', 'type' => 'varchar(255)'],
			['name' => 'acessos', 'type' => 'int(11)', 'default' => 0],
			['name' => 'keywords', 'type' => 'varchar(200)'],
		];
		(new DB)->create_table('pagina', $columns);
	}

	public function config_create()
	{
		$this->check_auth();
		$columns = [
			['name' => 'id', 'type' => 'int(11)', 'key' => true],
			['name' => 'site_title', 'type' => 'varchar(200)'],
			['name' => 'site_logo', 'type' => 'varchar(200)'],
			['name' => 'site_slogan', 'type' => 'varchar(200)'],
			['name' => 'site_logoText', 'type' => 'varchar(30)'],
			['name' => 'site_favicon', 'type' => 'varchar(200)'],
			['name' => 'site_loginscreen', 'type' => 'varchar(200)'],

			['name' => 'site_author', 'type' => 'varchar(200)'],
			['name' => 'site_description', 'type' => 'text'],
			['name' => 'site_about', 'type' => 'longtext'],
			['name' => 'site_keywords', 'type' => 'text'],
			['name' => 'site_ga_id', 'type' => 'varchar(200)'],
			['name' => 'site_ga_code', 'type' => 'varchar(255)'],
			['name' => 'site_tm_code', 'type' => 'varchar(255)'],

			['name' => 'site_funcionamento', 'type' => 'varchar(200)'],
			['name' => 'tema_color', 'type' => 'varchar(100)'],
			['name' => 'tema_color_back', 'type' => 'varchar(100)'],
			['name' => 'tema_color_text', 'type' => 'varchar(100)'],
			['name' => 'tema_id', 'type' => 'int(2)', 'default' => 1],
			['name' => 'tema_path', 'type' => 'varchar(200)'],
			['name' => 'script_chat', 'type' => 'longtext'],

			['name' => 'site_tel1', 'type' => 'varchar(16)'],
			['name' => 'site_tel2', 'type' => 'varchar(16)'],
			['name' => 'site_email', 'type' => 'varchar(200)'],
			['name' => 'site_email_cc', 'type' => 'varchar(200)'],
			['name' => 'site_email_bcc', 'type' => 'longtext'],
			['name' => 'site_cnpj', 'type' => 'varchar(30)'],

			['name' => 'site_cep', 'type' => 'varchar(16)'],
			['name' => 'site_rua', 'type' => 'varchar(200)'],
			['name' => 'site_num', 'type' => 'varchar(16)'],
			['name' => 'site_bairro', 'type' => 'varchar(200)'],
			['name' => 'site_cidade', 'type' => 'varchar(200)'],
			['name' => 'site_uf', 'type' => 'varchar(3)'],

			['name' => 'lgpd_texto', 'type' => 'varchar(255)'],
			['name' => 'lgpd_link', 'type' => 'varchar(255)'],

			['name' => 'site_modo', 'type' => 'int(2)', 'default' => '1'],
			['name' => 'site_layout', 'type' => 'int(2)', 'default' => '1'],

			['name' => 'slide_comum_config', 'type' => 'varchar(255)', 'default' => '"height: auto !important"'],
			['name' => 'slide_multiplo_config', 'type' => 'varchar(255)', 'default' => '"height: auto !important"'],

			['name' => 'site_layout_footer', 'type' => 'int(2)', 'default' => '1'],
			['name' => 'site_mapa_rodape', 'type' => 'int(2)', 'default' => '1'],

			['name' => 'site_layout_altura_facebook', 'type' => 'int(5)', 'default' => '500'],
			['name' => 'site_layout_altura_mapa', 'type' => 'int(5)', 'default' => '340'],
			['name' => 'site_icon_whats', 'type' => 'varchar(255)', 'default' => '"logo_whats.png"'],
			['name' => 'site_layout_altura_logo', 'type' => 'int(5)', 'default' => '80'],
			['name' => 'site_layout_largura_logo', 'type' => 'int(5)', 'default' => '180'],
		];
		$seed = [
			"site_title" => "Flux",
			"site_logo" => "logo.png",
			"site_slogan" => "Plataforma",
			"site_logoText" => "Flux",
			"site_favicon" => "favicon.png",
			"site_loginscreen" => "screen.jpg",
			"site_author" => "PHP STAFF",
			"site_description" => "",
			"site_about" => "Gostaria de enfatizar que a competitividade nas transações comerciais aponta para a melhoria do processo de comunicação como um todo. Acima de tudo, é fundamental ressaltar que a complexidade dos estudos efetuados obstaculiza a apreciação da importância dos procedimentos normalmente adotados. Não obstante, a valorização de fatores subjetivos agrega valor ao estabelecimento dos modos de operação convencionais.",
			"site_keywords" => "",
			"site_ga_id" => "",
			"site_ga_code" => "",
			"site_tm_code" => "",
			"site_funcionamento" => "",
			"tema_color" => "default",
			"tema_color_back" => "",
			"tema_color_text" => "",
			"tema_id" => "2",
			"tema_path" => "",
			"script_chat" => "",
			"site_tel1" => "",
			"site_tel2" => "",
			"site_email" => "falecom@phpstaff.com.br",
			"site_cnpj" => "",
			"site_cep" => "11701-380",
			"site_rua" => "Av. São Paulo",
			"site_num" => "1048",
			"site_bairro" => "Boqueirão",
			"site_cidade" => "Praia Grande",
			"site_uf" => "SP",
			"lgpd_texto" => "Ao acessar nosso site, você concorda com os nossos termos de privacidade.",
			"lgpd_link" => "",
			"site_modo" => "1",
			"site_layout" => "2",
			"site_layout_footer" => "1",
			"site_mapa_rodape" => "1",
		];
		(new DB)->drop_table('config');
		(new DB)->create_table('config', $columns, $seed);
	}
	public function categoria_produto_create()
	{
		$this->check_auth();
		$columns = [
			['name' => 'id', 'type' => 'int(11)', 'key' => true],
			['name' => 'nome', 'type' => 'varchar(200)'],
			['name' => 'url', 'type' => 'varchar(200)'],
			['name' => 'pos', 'type' => 'int(11)'],
		];
		(new DB)->create_table('categoria_produto', $columns);
	}

	public function subcategoria_produtos_create()
	{
		$this->check_auth();
		$columns = [
			['name' => 'id', 'type' => 'int(11)', 'key' => true],
			['name' => 'nome', 'type' => 'varchar(200)'],
			['name' => 'url', 'type' => 'varchar(200)'],
			['name' => 'pos', 'type' => 'int(11)'],
			['name' => 'apelido', 'type' => 'varchar(200)'],
			['name' => 'ordem_destaque', 'type' => 'int(3)'],
			['name' => 'categoria', 'type' => 'int(11)'],
		];

		(new DB)->create_table('subcategoria_produto', $columns);
	}

	public function vinculo_categoria_produto_create()
	{
		$this->check_auth();
		$columns = [
			['name' => 'id', 'type' => 'int(11)', 'key' => true],
			['name' => 'categoria', 'type' => 'int(11)'],
			['name' => 'subcategoria', 'type' => 'int(11)'],
			['name' => 'produto', 'type' => 'int(11)'],
		];

		(new DB)->create_table('vinculo_categoria_produto', $columns);
	}

	public function atributo_create()
	{
		$this->check_auth();
		$columns = [
			['name' => 'id', 'type' => 'int(11)', 'key' => true],
			['name' => 'nome', 'type' => 'varchar(200)'],
			['name' => 'tipo', 'type' => 'int(1)'],
		];

		(new DB)->create_table('atributo', $columns);
	}

	public function item_atributo_create()
	{
		$this->check_auth();
		$columns = [
			['name' => 'id', 'type' => 'int(11)', 'key' => true],
			['name' => 'nome', 'type' => 'varchar(200)'],
			['name' => 'atributo', 'type' => 'int(11)'],
		];

		(new DB)->create_table('item_atributo', $columns);
	}

	public function relacao_atributo_create()
	{
		$this->check_auth();
		// Tabela que ligará os ATRIBUTOS com o produto, ex: produto XXX tem COR, produto XXX tem TAMANHO, produto YYY tem COR etc.
		$columns = [
			['name' => 'id', 'type' => 'int(11)', 'key' => true],
			['name' => 'produto', 'type' => 'int(11)'],
			['name' => 'atributo', 'type' => 'int(11)'],
			['name' => 'relacao_pai', 'type' => 'int(11)'], // caso preenchido, recebe o pai hierarquico na questão dos atributos, fazendo deste um sub-atributo do atributo pai.
			['name' => 'item_atributo', 'type' => 'int(11)'],
			['name' => 'qtd', 'type' => 'int(11)'],
			['name' => 'preco', 'type' => 'varchar(20)'],
			['name' => 'valor', 'type' => 'varchar(90)'],
		];
		(new DB)->create_table('relacao_atributo', $columns);
	}

	public function relacao_item_create()
	{
		$this->check_auth();
		$columns = [
			['name' => 'id', 'type' => 'int(11)', 'key' => true],
			['name' => 'relacao_atributo', 'type' => 'int(11)'], // recebe o id da relacao_atributo que ligou um atributo com item (cores no produto, tamanho no produto)
			['name' => 'atributo', 'type' => 'int(11)'],
			['name' => 'item', 'type' => 'int(11)'],
			['name' => 'produto', 'type' => 'int(11)'],
			['name' => 'qtd', 'type' => 'int(11)'],
			['name' => 'preco', 'type' => 'decimal(10, 2)'],
			['name' => 'valor', 'type' => 'varchar(90)'],
			['name' => 'relacao_pai', 'type' => 'varchar(500)'], // caso preenchido, recebe o pai hierarquico na questão dos atributos, fazendo deste um sub-item do item pai.
		];
		(new DB)->create_table('relacao_item', $columns);
	}

	public function foto_produto_create()
	{
		$this->check_auth();
		$columns = [
			['name' => 'id', 'type' => 'int(11)', 'key' => true],
			['name' => 'img', 'type' => 'varchar(255)'],
			['name' => 'url', 'type' => 'varchar(2000)'],
			['name' => 'produto', 'type' => 'int(11)'],
			['name' => 'tamanho', 'type' => 'varchar(25)'],
			['name' => 'titulo', 'type' => 'varchar(200)'],
			['name' => 'desc', 'type' => 'text'],
			['name' => 'tipo', 'type' => 'int(1)'],
			['name' => 'pos', 'type' => 'int(11)', 'default' => 9999],
		];
		(new DB)->create_table('foto_produto', $columns);
	}

	public function produtos_relacionados_create()
	{
		$this->check_auth();
		$columns = [
			['name' => 'id', 'type' => 'int(11)', 'key' => true],
			['name' => 'produto1', 'type' => 'int(11)'],
			['name' => 'produto2', 'type' => 'int(11)'],
		];
		(new DB)->create_table('produtos_relacionados', $columns);
	}

	public function pay_create()
	{
		$this->check_auth();
		$columns = [
			['name' => 'id', 'type' => 'int(11)', 'key' => true],
			['name' => 'name', 'type' => 'varchar(100)'],
			['name' => 'key', 'type' => 'varchar(100)'],
			['name' => 'user', 'type' => 'varchar(100)'],
			['name' => 'pass', 'type' => 'varchar(100)'],
			['name' => 'retorno', 'type' => 'varchar(200)'],
			['name' => 'status', 'type' => 'int(1)', 'default' => 1],
			['name' => 'url_redir', 'type' => 'varchar(600)'],
			['name' => 'fator_juros', 'type' => 'longtext'],
			['name' => 'texto', 'type' => 'text'],
			['name' => 'c1', 'type' => 'varchar(200)'],
			['name' => 'c2', 'type' => 'varchar(200)'],
			['name' => 'c3', 'type' => 'varchar(200)'],
			['name' => 'c4', 'type' => 'varchar(200)'],
			['name' => 'c5', 'type' => 'varchar(200)'],
			['name' => 'c6', 'type' => 'varchar(200)'],
			['name' => 'c7', 'type' => 'varchar(200)'],
			['name' => 'c8', 'type' => 'varchar(400)'],
			['name' => 'c9', 'type' => 'varchar(200)'],
			['name' => 'd1', 'type' => 'varchar(200)'],
			['name' => 'd2', 'type' => 'varchar(200)'],

		];

		$seeds = [];
		$seeds[] = [
			// 'id' => 1,
			'name' => 'PagSeguro',
			'key' => 'pagseguro',
			'user' => 'suporte@lojamodelo.com.br',
			'pass' => '',
			'retorno' => 'http://[baseUri]/notificacao/pagseguro',
			'status' => 1,
			'url_redir' => '',
			'fator_juros' => '5',
			'texto' => '',
			'c1' => '2',
			'c2' => '0',
			'c3' => '1',
			'c4' => '2',
			'c5' => 'SANDBOX',
			'c6' => '12', //total de parcelas
			'c7' => '',
			'c8' => '3', //parcelas sem juros
			'c9' => '',
			'd1' => '',
			'd2' => '',
		];
		$seeds[] = [
			// 'id' => 3,
			'name' => 'Cielo',
			'key' => '25fbb99741c739dd84d7b06ec78c9bac718838630f30b112d033ce2e621b34f3',
			'user' => '1006993069',
			'pass' => '2',
			'retorno' => 'http://[baseUri]/notificacao/cielo/',
			'status' => 1,
			'url_redir' => '12',
			'fator_juros' => '5',
			'texto' => 'Cartão de Crédito',
			'c1' => '6',
			'c2' => '0',
			'c3' => '10',
			'c4' => 'visa,mastercard,elo,amex,diners',
			'c5' => '20.00',
			'c6' => '2',
			'c7' => '3',
			'c8' => '',
			'c9' => '',
			'd1' => '',
			'd2' => '',
		];
		$seeds[] = [
			// 'id' => 4,
			'name' => 'Deposito',
			'key' => '6253',
			'user' => 'EMAIL',
			'pass' => 'falecom@phpstaff.com.br',
			'retorno' => 'http://[baseUri]/notificacao/',
			'status' => 2,
			'url_redir' => '',
			'fator_juros' => 'PHP STAFF',
			'texto' => 'falecom@phpstaff.com.br',
			'c1' => '4',
			'c2' => '0',
			'c3' => '18',
			'c4' => '',
			'c5' => '',
			'c6' => '',
			'c7' => '',
			'c8' => '',
			'c9' => '',
			'd1' => '',
			'd2' => '',
		];
		$seeds[] = [
			// 'id' => 5,
			'name' => 'Boleto',
			'key' => 'PHP STAFF LTDA.',
			'user' => 'Bradesco',
			'pass' => '001.002.003-44',
			'retorno' => '',
			'status' => 0,
			'url_redir' => '',
			'fator_juros' => '0',
			'texto' => 'Boleto Bradesco',
			'c1' => '1234',
			'c2' => '5',
			'c3' => '9876',
			'c4' => '5',
			'c5' => '107',
			'c6' => '09.876.543/0001-99',
			'c7' => 'Av. Paulista, 300',
			'c8' => '11701-380',
			'c9' => 'São Paulo',
			'd1' => 'SP',
			'd2' => '5',
		];
		$seeds[] = [
			//'id' => 5,
			'name' => 'Config',
			'key' => 'mercadoPago',
			'user' => 'config',
			'pass' => '',
			'retorno' => 'http://[baseUri]/notificacao/mercadopago',
			'status' => 1,
			'url_redir' => '',
			'fator_juros' => '5',
			'texto' => '',
			'c1' => '5.00',
			'c2' => '3',
			'c3' => '',
			'c4' => '',
			'c5' => '',
			'c6' => '6',
			'c7' => '',
			'c8' => '3',
			'c9' => '',
			'd1' => '',
			'd2' => '',
		];
		$seeds[] = [
			// 'id' => 7,
			'name' => 'MercadoPago',
			'key' => 'TEST-6f4eb3f2-f723-4d74-984b-1540c49392c8',
			'user' => 'TEST-6710319316158643-021713-cce4534743d926cabe371019c508d4b7-147729738',
			'pass' => '',
			'retorno' => 'http://[baseUri]/notificacao/mercadopago',
			'status' => 1,
			'url_redir' => '',
			'fator_juros' => '7',
			'texto' => '',
			'c1' => '2',
			'c2' => '',
			'c3' => '0',
			'c4' => '',
			'c5' => 'PRODUCAO',
			'c6' => '12', //total de parcelas
			'c7' => '',
			'c8' => '3', //parcelas sem juros
			'c9' => '',
			'd1' => '',
			'd2' => '',
		];

		$seeds[] = [
			// 'id' => 7,
			'name' => 'PagarMe',
			'key' => 'sk_test_ec750c2a556e4e5a9ed523ce326b5dff',
			'user' => 'sk_test_ec750c2a556e4e5a9ed523ce326b5dff',
			'pass' => '',
			'retorno' => 'http://[baseUri]/notificacao/pagarme',
			'status' => 1,
			'url_redir' => '',
			'fator_juros' => '',
			'texto' => '',
			'c1' => '2',
			'c2' => '',
			'c3' => '1',
			'c4' => '',
			'c5' => 'PRODUCAO',
			'c6' => '12', //total de parcelas
			'c7' => '',
			'c8' => '3', //parcelas sem juros
			'c9' => '',
			'd1' => '',
			'd2' => '',
		];

		(new DB)->drop_table('pay');
		(new DB)->create_table('pay', $columns, $seeds);
	}

	public function faixa_cep_create()
	{
		$this->check_auth();
		$columns = [
			['name' => 'id', 'type' => 'int(11)', 'key' => true],
			['name' => 'inicio', 'type' => 'int(10)'],
			['name' => 'final', 'type' => 'int(10)'],
			['name' => 'desc', 'type' => 'varchar(200)'],
			['name' => 'peso_de', 'type' => 'decimal(10,2)'],
			['name' => 'peso_ate', 'type' => 'decimal(10,2)'],
			['name' => 'valor', 'type' => 'decimal(10,2)'],
			['name' => 'prazo', 'type' => 'varchar(255)'],

		];
		(new DB)->create_table('faixa_cep', $columns);
	}

	public function retirada_create()
	{
		$this->check_auth();
		$columns = [
			['name' => 'id', 'type' => 'int(11)', 'key' => true],
			['name' => 'local', 'type' => 'varchar(200)'],
			['name' => 'horario', 'type' => 'varchar(200)'],
			['name' => 'rua', 'type' => 'varchar(200)'],
			['name' => 'num', 'type' => 'varchar(255)'],
			['name' => 'complemento', 'type' => 'varchar(100)'],
			['name' => 'bairro', 'type' => 'varchar(100)'],
			['name' => 'cidade', 'type' => 'varchar(100)'],
			['name' => 'uf', 'type' => 'varchar(3)'],
			['name' => 'cep', 'type' => 'varchar(10)'],
			['name' => 'telefone', 'type' => 'varchar(100)'],

		];
		(new DB)->create_table('retirada', $columns);
	}

	public function cupom_create()
	{
		$this->check_auth();
		$columns = [
			['name' => 'id', 'type' => 'int(11)', 'key' => true],
			['name' => 'alfa', 'type' => 'varchar(200)'],
			['name' => 'status', 'type' => 'int(1)', 'default' => '0'],
			['name' => 'lote', 'type' => 'int(11)', 'default' => '0'],
			['name' => 'desconto', 'type' => 'int(11)'],
			['name' => 'tipo', 'type' => 'int(1)', 'default' => '1'],
			['name' => 'min', 'type' => 'int(11)', 'default' => '10'],
			['name' => 'validade', 'type' => 'date'],
			['name' => 'limite', 'type' => 'int(1)', 'default' => '1'],
			['name' => 'real', 'type' => 'varchar(20)'],
		];
		(new DB)->create_table('cupom', $columns);
	}

	public function marca_create()
	{
		$this->check_auth();
		$columns = [
			['name' => 'id', 'type' => 'int(11)', 'key' => true],
			['name' => 'nome', 'type' => 'varchar(100)'],
			['name' => 'url', 'type' => 'varchar(100)'],
			['name' => 'logo', 'type' => 'varchar(100)'],
		];
		(new DB)->create_table('marca', $columns);
	}

	public function endereco_cliente_create()
	{
		$this->check_auth();
		$columns = [
			['name' => 'id', 'type' => 'int(11)', 'key' => true],
			['name' => 'cliente', 'type' => 'int(11)'],
			['name' => 'cep', 'type' => 'varchar(15)'],
			['name' => 'rua', 'type' => 'varchar(300)'],
			['name' => 'uf', 'type' => 'varchar(3)'],
			['name' => 'num', 'type' => 'varchar(255)'],
			['name' => 'complemento', 'type' => 'varchar(100)'],
			['name' => 'cidade', 'type' => 'varchar(200)'],
			['name' => 'bairro', 'type' => 'varchar(200)'],
			['name' => 'tipo', 'type' => 'int(1)'],
			['name' => 'titulo', 'type' => 'varchar(200)'],
		];
		(new DB)->create_table('endereco_cliente', $columns);
	}

	public function frete_diferenciado_create()
	{
		$this->check_auth();
		$columns = [
			['name' => 'id', 'type' => 'int(11)', 'key' => true],
			['name' => 'valor', 'type' => 'varchar(20)'],
			['name' => 'bairro', 'type' => 'varchar(200)'],
			['name' => 'cidade', 'type' => 'varchar(200)'],
			['name' => 'uf', 'type' => 'varchar(2)'],
			['name' => 'cep', 'type' => 'varchar(12)'],
			['name' => 'tipo', 'type' => 'int(1)', 'default' => 1],
			['name' => 'prazo', 'type' => 'varchar(200)'],
			['name' => 'desc', 'type' => 'varchar(200)'],

		];
		(new DB)->create_table('frete_diferenciado', $columns);
	}

	public function visualizacoes_produto_create()
	{
		$this->check_auth();
		$columns = [
			['name' => 'id', 'type' => 'int(11)', 'key' => true],
			['name' => 'data', 'type' => 'date'],
			['name' => 'produto', 'type' => 'int(11)'],

		];
		(new DB)->create_table('visualizacoes_produto', $columns);
	}

	public function avaliacoes_produto_create()
	{
		$this->check_auth();
		$columns = [
			['name' => 'id', 'type' => 'int(11)', 'key' => true],
			['name' => 'produto', 'type' => 'int(11)'],
			['name' => 'status', 'type' => 'int(1)'],
			['name' => 'descricao', 'type' => 'varchar(255)'],
			['name' => 'cliente', 'type' => 'int(11)'],
			['name' => 'nota', 'type' => 'int(1)'],
		];
		(new DB)->create_table('avaliacoes_produto', $columns);
	}

	public function newsletter_create()
	{
		$this->check_auth();
		$columns = [
			['name' => 'id', 'type' => 'int(11)', 'key' => true],
			['name' => 'email', 'type' => 'varchar(360)'],
			['name' => 'status', 'type' => 'int(1)'],
		];
		(new DB)->create_table('newsletter', $columns);
	}

	public function frete_create()
	{
		$this->check_auth();
		$columns = [
			['name' => 'id', 'type' => 'int(11)', 'key' => true],
			['name' => 'cep_origem', 'type' => 'varchar(20)'],
			['name' => 'correios_cod_empresa', 'type' => 'varchar(80)'],
			['name' => 'correios_senha_empresa', 'type' => 'varchar(80)'],
			['name' => 'faixa', 'type' => 'double'],
			['name' => 'pac', 'type' => 'int(1)'],
			['name' => 'sedex', 'type' => 'int(1)'],
			['name' => 'sedex10', 'type' => 'int(1)'],
			['name' => 'frenet', 'type' => 'int(1)'],
			['name' => 'frenet_token', 'type' => 'varchar(160)'],
			['name' => 'kangu', 'type' => 'int(1)', 'default' => 0],
			['name' => 'kangu_token', 'type' => 'longtext'],
			["name" => "kangu_ponto", "type" => "varchar(200)", 'default' => '""'],
			['name' => 'melhorenvio', 'type' => 'int(1)'],
			['name' => 'melhorenvio_client_id', 'type' => 'varchar(80)'],
			['name' => 'melhorenvio_secret', 'type' => 'longtext'],
			['name' => 'melhorenvio_token', 'type' => 'longtext'],
			['name' => 'melhorenvio_refresh_token', 'type' => 'longtext'],
			['name' => 'melhorenvio_data_refresh_token', 'type' => 'date'],
			['name' => 'melhorenvio_servicos', 'type' => 'varchar(200)', 'default' => '1,2,17,28,29,30'],
			["name" => "melhorenvio_ponto", "type" => "varchar(200)", 'default' => '0'],
			["name" => "melhorenvio_cnpj", "type" => "varchar(30)", 'default' => '""'],
			["name" => "melhorenvio_cnae", "type" => "varchar(30)"],
			['name' => 'gratis_ativo', 'type' => 'int(1)', 'default' => '0'],
			['name' => 'gratis_label', 'type' => 'varchar(200)', 'default' => 'Frete Gratis'],
			['name' => 'prazo', 'type' => 'varchar(200)', 'default' => 7],
			['name' => 'show_free', 'type' => 'int(1)', 'default' => 2],
			['name' => 'opcoes', 'type' => 'int(11)', 'default' => 1],
			['name' => 'gratis_valor_minimo', 'type' => 'double(10, 2)'],
			['name' => 'sul', 'type' => 'double(10, 2)'],
			['name' => 'nome', 'type' => 'varchar(200)'],
			['name' => 'perc_sul', 'type' => 'double(10, 2)'],
			['name' => 'perc_apt', 'type' => 'double(10, 2)'],
			['name' => 'perc_prazo_sul', 'type' => 'varchar(100)'],
			['name' => 'perc_prazo_outros', 'type' => 'varchar(100)'],
			['name' => 'adicional', 'type' => 'double(10, 2)', 'default' => 0],
		];
		$seed = [
			'cep_origem' => '11701380',
			'correios_cod_empresa' => '',
			'correios_senha_empresa' => '',
			'faixa' => '0',
			'pac' => '0',
			'sedex' => '0',
			'sedex10' => '0',
			'frenet' => '0',
			'frenet_token' => '',
			'melhorenvio' => '0',
			'melhorenvio_client_id' => '',
			'melhorenvio_secret' => '',
			'melhorenvio_token' => '',

			'gratis_ativo' => '0',
			'gratis_label' => 'Frete Grátis',
			'prazo' => '7',
			'show_free' => '2',
			'opcoes' => '1',
			'gratis_valor_minimo' => '0.00',
			'sul' => '0',
			'perc_sul' => '10',
			'perc_apt' => '20',
			'perc_prazo_sul' => '3 à 7 dias uteis',
			'perc_prazo_outros' => '3 à 7 dias uteis',
		];
		(new DB)->drop_table("frete");
		(new DB)->create_table('frete', $columns, $seed);
	}

	public function produto_create()
	{
		$this->check_auth();
		$columns = [
			['name' => 'id', 'type' => 'int(11)', 'key' => true],
			['name' => 'titulo', 'type' => 'varchar(200)'],
			['name' => 'desc', 'type' => 'longtext'],
			['name' => 'preco', 'type' => 'decimal(10,2)'],
			['name' => 'keywords', 'type' => 'varchar(200)'],
			['name' => 'acessos', 'type' => 'int(11)', 'default' => 0],
			['name' => 'url', 'type' => 'varchar(200)'],
			['name' => 'oferta', 'type' => 'int(1)', 'default' => 0],
			['name' => 'largura', 'type' => 'varchar(20)', 'default' => '12'],
			['name' => 'altura', 'type' => 'varchar(20)', 'default' => '4'],
			['name' => 'comprimento', 'type' => 'varchar(20)', 'default' => '16'],
			['name' => 'tamanho', 'type' => 'varchar(255)'],
			['name' => 'peso', 'type' => 'varchar(20)', 'default' => '0.5'],
			['name' => 'desconto', 'type' => 'decimal(10,2)', 'default' => 0],
			['name' => 'calcula_frete', 'type' => 'int(1)', 'default' => 1],
			['name' => 'estoque', 'type' => 'int(11)', 'default' => 10],
			["name" => "estoque_dt_sync", "type" => "datetime", "default" => "NULL"],
			['name' => 'min_estoque', 'type' => 'int(5)', 'default' => 5],
			['name' => 'destaque', 'type' => 'int(1)', 'default' => 0],
			['name' => 'arquivo', 'type' => 'int(1)', 'default' => 0],
			['name' => 'ref', 'type' => 'varchar(60)'],
			['name' => 'marca', 'type' => 'int(11)', 'default' => 0],
			['name' => 'disp', 'type' => 'varchar(255)'],
			['name' => 'gtin', 'type' => 'varchar(255)'],
			['name' => 'gtint', 'type' => 'varchar(255)'],
			['name' => 'status', 'type' => 'int(1)', 'default' => 1],
			['name' => 'class_fiscal', 'type' => 'VARCHAR(200)', 'default' => '""'],
			['name' => 'class_tipoprod', 'type' => 'varchar(255)'],
			['name' => 'class_oriprod', 'type' => 'varchar(255)'],
			['name' => 'sku', 'type' => 'varchar(255)'],
			['name' => 'tipo_unidade', 'type' => 'VARCHAR(20)', 'default' => '"UN"'],
		];

		(new DB)->create_table('produto', $columns);
	}

	public function parceiro_create()
	{
		$this->check_auth();
		$columns = [
			['name' => 'id', 'type' => 'int(11)', 'key' => true],
			['name' => 'nome', 'type' => 'varchar(200)'],
			['name' => 'logo', 'type' => 'varchar(200)'],
			['name' => 'pos', 'type' => 'int(11)'],
			['name' => 'status', 'type' => 'int(1)'],
		];

		(new DB)->create_table('parceiro', $columns);
	}

	public function faq_create()
	{
		$this->check_auth();
		$columns = [
			['name' => 'id', 'type' => 'int(11)', 'key' => true],
			['name' => 'titulo', 'type' => 'varchar(200)'],
			['name' => 'url', 'type' => 'varchar(200)'],
			['name' => 'categoria', 'type' => 'int(11)'],
			['name' => 'texto', 'type' => 'text'],
		];

		$seeds[] = [
			'titulo' => 'Pergunta 01',
			'url' => 'pergunta-01',
			'categoria' => 1,
			'texto' => 'Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry',
		];

		$seeds[] = [
			'titulo' => 'Pergunta 02',
			'url' => 'pergunta-02',
			'categoria' => 1,
			'texto' => 'Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry',
		];

		$seeds[] = [
			'titulo' => 'Pergunta 03',
			'url' => 'pergunta-03',
			'categoria' => 1,
			'texto' => 'Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry',
		];
		(new DB)->create_table('faq', $columns, $seeds);
	}

	public function categoria_faq_create()
	{
		$this->check_auth();
		$columns = [
			['name' => 'id', 'type' => 'int(11)', 'key' => true],
			['name' => 'nome', 'type' => 'varchar(200)'],
			['name' => 'pos', 'type' => 'int(11)'],
			['name' => 'url', 'type' => 'varchar(200)'],

		];

		(new DB)->create_table('categoria_faq', $columns);
	}

	public function campo_checkout_create()
	{
		$this->check_auth();
		$columns = [
			['name' => 'id', 'type' => 'int(11)', 'key' => true],
			['name' => 'nome', 'type' => 'varchar(200)'],
		];

		(new DB)->create_table('campo_checkout', $columns);
	}

	public function campo_checkout_produto_create()
	{
		$this->check_auth();
		$columns = [
			['name' => 'id', 'type' => 'int(11)', 'key' => true],
			['name' => 'campo', 'type' => 'int(11)'],
			['name' => 'produto', 'type' => 'int(11)'],
		];

		(new DB)->create_table('campo_checkout_produto', $columns);
	}

	public function campo_checkout_respostas_create()
	{
		$this->check_auth();
		$columns = [
			['name' => 'id', 'type' => 'int(11)', 'key' => true],
			['name' => 'pedido_id', 'type' => 'int(11)'],
			['name' => 'campo_id', 'type' => 'int(11)'],
			['name' => 'cliente_id', 'type' => 'int(11)'],
			['name' => 'pergunta', 'type' => 'varchar(255)'],
			['name' => 'resposta', 'type' => 'varchar(255)'],
		];

		(new DB)->create_table('campo_checkout_respostas', $columns);
	}

	public function estoque_fila_create()
	{
		$this->check_auth();
		$columns = [
			['name' => 'id', 'type' => 'int(11)', 'key' => true],
			['name' => 'pedido', 'type' => 'varchar(20)'],
			['name' => 'action', 'type' => 'int(1)'],
			['name' => 'sql', 'type' => 'longtext'],
			['name' => 'data', 'type' => 'date'],
		];
		//(new DB)->drop_table("estoque_fila");
		(new DB)->create_table('estoque_fila', $columns);
	}

	public function pedidos_bling_create()
	{
		$columns = [
			['name' => 'id', 'type' => 'int(11)', 'key' => true],
			['name' => 'id_bling', 'type' => 'varchar(100)'],
			['name' => 'numero', 'type' => 'int(11)'],
			['name' => 'data', 'type' => 'date'],
		];
		//(new DB)->drop_table("estoque_fila");
		(new DB)->create_table('pedido_bling', $columns);
	}
	public function config_cores_create()
	{
		$this->check_auth();
		$columns = [
			['name' => 'id', 'type' => 'int(11)', 'key' => true],
			['name' => 'local', 'type' => 'varchar(40)'],
			['name' => 'fundo', 'type' => 'varchar(16)'],
			['name' => 'texto', 'type' => 'varchar(16)'],
			['name' => 'size', 'type' => 'int', 'default' => 14],
			['name' => 'hover_fundo', 'type' => 'varchar(16)'],
			['name' => 'hover_texto', 'type' => 'varchar(16)'],
		];

		$seeds[] = [
			'local' => 'Topo',
			'fundo' => '#fafafa',
			'texto' => '#333333',
			'hover_fundo' => '#000',
			'hover_texto' => '#DBC47B',
		];

		$seeds[] = [
			'local' => 'Menu',
			'fundo' => '#fafafa',
			'texto' => '#73543e',
			'size' => '16',
			'hover_fundo' => '#000',
			'hover_texto' => '#DBC47B',
		];

		$seeds[] = [
			'local' => 'Loja',
			'fundo' => '#ffffff',
			'texto' => '#1c1c1c',
			'hover_fundo' => '#000',
			'hover_texto' => '#000',
		];

		$seeds[] = [
			'local' => 'Redes Sociais',
			'fundo' => '#fafafa',
			'texto' => '#333333',
			'hover_fundo' => '#000',
			'hover_texto' => '#000',
		];

		$seeds[] = [
			'local' => 'Rodapé Informações',
			'fundo' => '#fafafa',
			'texto' => '#333333',
			'hover_fundo' => '#000',
			'hover_texto' => '#000',
		];

		$seeds[] = [
			'local' => 'Rodapé',
			'fundo' => '#fafafa',
			'texto' => '#333333',
			'hover_fundo' => '#000',
			'hover_texto' => '#000',
		];

		$seeds[] = [
			'local' => 'Botões Principais',
			'fundo' => '#DBC47B',
			'texto' => '#ffffff',
			'hover_fundo' => '#73543e',
			'hover_texto' => '#ffffff',
		];

		$seeds[] = [
			'local' => 'Botões Secundários',
			'fundo' => '#73543e',
			'texto' => '#ffffff',
			'hover_fundo' => '#DBC47B',
			'hover_texto' => '#ffffff',
		];

		(new DB)->drop_table('config_cores');
		(new DB)->create_table('config_cores', $columns, $seeds);
	}

	public function order_home_create()
	{
		$this->check_auth();
		$columns = [
			['name' => 'id', 'type' => 'int(11)', 'key' => true],
			['name' => 'view', 'type' => 'varchar(255)'],
			['name' => 'apelido', 'type' => 'varchar(255)'],
			['name' => 'order', 'type' => 'int(11)'],
			['name' => 'status', 'type' => 'int(2)', 'default' => 1],
		];

		$seeds[] = [
			'view' => 'slide-superior',
			'apelido' => 'Slide 1',
			'order' => 1,
			'status' => 1,
		];
		$seeds[] = [
			'view' => 'banner-multiplo-1',
			'apelido' => 'Banner Múltiplo Full',
			'order' => 2,
			'status' => 1,
		];
		$seeds[] = [
			'view' => 'index-produtos-oferta',
			'apelido' => 'Produtos em Oferta',
			'order' => 3,
			'status' => 1,
		];
		$seeds[] = [
			'view' => 'banner-fino-1',
			'apelido' => 'Banner Fino Full',
			'order' => 4,
			'status' => 1,
		];
		$seeds[] = [
			'view' => 'banner-2',
			'apelido' => 'Banner Boxed',
			'order' => 5,
			'status' => 1,
		];
		$seeds[] = [
			'view' => 'index-produtos-destaques',
			'apelido' => 'Produtos em Destaques',
			'order' => 6,
			'status' => 1,

		];
		$seeds[] = [
			'view' => 'slide-2',
			'apelido' => 'Slide 2',
			'order' => 7,
			'status' => 1,
		];

		$seeds[] = [
			'view' => 'slide-marcas',
			'apelido' => 'Slide de Marcas',
			'order' => 8,
			'status' => 1,

		];
		$seeds[] = [
			'view' => 'slide-meio',
			'apelido' => 'Slide Vertical, produtos mais vendidos/acessados',
			'order' => 9,
			'status' => 1,

		];

		$seeds[] = [
			'view' => 'banner-1',
			'apelido' => 'Banner Full',
			'order' => 10,
			'status' => 1,
		];

		$seeds[] = [
			'view' => 'index-produtos-novos',
			'apelido' => 'Produtos Novos',
			'order' => 11,
			'status' => 1,

		];
		$seeds[] = [
			'view' => 'banner-fino-2',
			'apelido' => 'Banner Fino Boxed',
			'order' => 12,
			'status' => 1,
		];

		$seeds[] = [
			'view' => 'banner-multiplo-2',
			'apelido' => 'Banner Múltiplo Boxed',
			'order' => 13,
			'status' => 1,
		];

		$seeds[] = [
			'view' => 'slide-parceiros',
			'apelido' => 'Slide de parceiros',
			'order' => 14,
			'status' => 1,
		];

		$seeds[] = [
			'view' => 'faq',
			'apelido' => 'FAQ',
			'order' => 15,
			'status' => 1,
		];
		(new DB)->drop_table('order_home');
		(new DB)->create_table('order_home', $columns, $seeds);
	}

	public function order_home_migrate()
	{
		$seeds = [
			'view' => 'faq',
			'apelido' => 'FAQ',
			'order' => 15,
			'status' => 1,
		];

		(new Factory('order_home'))->with($seeds)->save();
	}

	public function lista_pedido_create()
	{
		$this->check_auth();
		$columns = [
			['name' => 'id', 'type' => 'int(11)', 'key' => true],
			['name' => 'produto', 'type' => 'int(11)'],
			['name' => 'produto_titulo', 'type' => 'varchar(300)'],
			['name' => 'preco', 'type' => 'varchar(100)'],
			['name' => 'pedido', 'type' => 'int(11)'],
			['name' => 'qtde', 'type' => 'int(11)'],
			['name' => 'foto', 'type' => 'varchar(160)'],
			['name' => 'arquivo', 'type' => 'varchar(160)'],
			['name' => 'codigo', 'type' => 'varchar(100)'],
		];
		(new DB)->create_table('lista_pedido', $columns);
	}

	public function lista_pedido_atributo_create()
	{
		$this->check_auth();
		$columns = [
			['name' => 'id', 'type' => 'int(11)', 'key' => true],
			['name' => 'attnome', 'type' => 'varchar(180)'],
			['name' => 'itemnome', 'type' => 'varchar(180)'],
			['name' => 'valor_adicional', 'type' => 'decimal(10,2)'],
			['name' => 'lista', 'type' => 'int(11)'],
			['name' => 'atributo', 'type' => 'int(11)'],
		];
		(new DB)->create_table('lista_pedido_atributo', $columns);
	}

	public function pedido_create()
	{
		$this->check_auth();
		$columns = [
			["name" => "id", "type" => "int(11)", 'key' => true],
			["name" => "cliente", "type" => "int(11)"],
			["name" => "status", "type" => "int(11)"],
			["name" => "total_frete", "type" => "varchar(16)"],
			["name" => "frete", "type" => "double(10,2)"],
			["name" => "prazo", "type" => "varchar(200)"],

			["name" => "servico_frete", "type" => "varchar(200)"],
			["name" => "tipo_frete", "type" => "int(11)"],
			["name" => "frete_id", "type" => "int(11)"],
			["name" => "frete_height", "type" => "varchar(11)"],
			["name" => "frete_width", "type" => "varchar(11)"],
			["name" => "frete_length", "type" => "varchar(11)"],
			["name" => "frete_weight", "type" => "varchar(11)"],
			["name" => "frete_status", "type" => "varchar(100)"],
			["name" => "frete_carrinho", "type" => "varchar(200)", 'default' => '""'],
			["name" => "codigo_rastreio", "type" => "varchar(100)", 'default' => '""'],
			["name" => "frete_company", "type" => "varchar(200)", 'default' => '""'],


			["name" => "pay_code", "type" => "varchar(200)"],
			["name" => "pay_situacao", "type" => "int(11)"],
			["name" => "pay_url", "type" => "varchar(500)"],
			["name" => "endereco", "type" => "int(11)"],
			["name" => "entrega", "type" => "int(11)"],
			["name" => "pay_gw", "type" => "int(11)"],
			["name" => "pay_meio", "type" => "varchar(200)"],
			["name" => "pay_obs", "type" => "text"],
			["name" => "barcode", "type" => "text"],
			["name" => "cupom_alfa", "type" => "varchar(255)"],
			["name" => "cupom_desconto", "type" => "varchar(16)"],
			["name" => "desconto", "type" => "double(10,2)"],
			["name" => "info", "type" => "text"],
			["name" => "obs", "type" => "text"],
			["name" => "obs_sys", "type" => "varchar(1000)"],
			["name" => "cupom_info", "type" => "varchar(300)"],
			["name" => "total_produto", "type" => "varchar(16)"],
			["name" => "empresa_rastreio", "type" => "int(11)"],
			["name" => "comprovante", "type" => "varchar(200)"],
			["name" => "total_parcelado", "type" => "double(10,2)"],
			["name" => "parcelas", "type" => "int(3)"],
			["name" => "parcelas_valor", "type" => "double(10,2)"],
			["name" => "pix_qr", "type" => "text"],
			["name" => "pix_qr_img", "type" => "longtext"],
			["name" => "tipo", "type" => "int(2)", 'default' => '1'],
			['name' => 'nf_status', 'type' => 'int', 'default' => '0'],
			['name' => 'nf_num_id', 'type' => 'VARCHAR(200)', 'default' => '""'],
			['name' => 'nf_serie', 'type' => 'int', 'default' => '0'],
			['name' => 'nf_num', 'type' => 'VARCHAR(200)', 'default' => '""'],
			['name' => 'nf_chave', 'type' => 'VARCHAR(200)', 'default' => '""'],
			["name" => "ip", "type" => "varchar(100)"],
			["name" => "ip_city", "type" => "varchar(300)"],
		];

		(new DB)->create_table('pedido', $columns);
	}

	public function integracao_create()
	{
		$this->check_auth();
		$columns = [
			['name' => 'id', 'type' => 'int(11)', 'key' => true],
			['name' => 'gw', 'type' => 'varchar(20)'],
			['name' => 'ativo', 'type' => 'int', 'default' => '0'],
			['name' => 'secret', 'type' => 'longtext'],
			['name' => 'client_id', 'type' => 'longtext'],
			['name' => 'token', 'type' => 'longtext'],
			['name' => 'refresh_token', 'type' => 'longtext'],
			['name' => 'datetime_refresh_token', 'type' => 'datetime'],
			['name' => 'rec1', 'type' => 'VARCHAR(300)', 'default' => 'NULL'],
			['name' => 'rec2', 'type' => 'VARCHAR(300)', 'default' => 'NULL'],
			['name' => 'rec3', 'type' => 'VARCHAR(300)', 'default' => 'NULL'],
			['name' => 'rec4', 'type' => 'VARCHAR(300)', 'default' => 'NULL'],
			['name' => 'rec5', 'type' => 'VARCHAR(300)', 'default' => 'NULL'],
			['name' => 'rec6', 'type' => 'VARCHAR(300)', 'default' => 'NULL'],
			['name' => 'rec7', 'type' => 'VARCHAR(300)', 'default' => 'NULL'],
		];

		$seed = [
			'integracao_gw' => 'Bling',
			'integracao_secret' => 'seu-secret',
			'integracao_client_id' => 'seu-client-id',
			'integracao_rec1' => '0',
			'integracao_rec2' => '0',
			'integracao_rec3' => '0',
			'integracao_rec4' => '0',
			'integracao_rec5' => 'SP',
			'integracao_rec6' => '1234',
			'integracao_rec7' => '5678',
		];
		(new DB)->create_table('integracao', $columns, $seed);
	}

	public function favorito_create()
	{
		$this->check_auth();
		$columns = [
			['name' => 'id', 'type' => 'int(11)', 'key' => true],
			['name' => 'produto', 'type' => 'int(1)'],
			['name' => 'cliente', 'type' => 'int(1)'],
		];
		(new DB)->create_table('favorito', $columns);
	}

	// cria dados fake na plataforma
	public function mock()
	{
		$this->mock_slide();
		$this->mock_config();
		$this->mock_categoria_paginas();
		$this->mock_pagina();
		$this->mock_categoria_produtos();
		$this->mock_subcategoria_produtos();
		$this->mock_atributo();
		$this->mock_item_atributo();
		$this->mock_marcas();
		$this->mock_produto();
		$this->mock_produto_relacionado();
		$this->mock_produto_categorias();
	}

	public function mock_produto_categorias()
	{
		$seeds = [];
		$seeds[] = [
			'produto' => 1,
			'categoria' => 1,
			'subcategoria' => 2,
		];
		(new Factory('vinculo_categoria_produto'))->with($seeds)->save();
	}

	public function mock_produto_relacionado()
	{
		$seeds = [];
		$seeds[] = [
			'produto1' => 1,
			'produto2' => 2,
		];
		$seeds[] = [
			'produto1' => 1,
			'produto2' => 3,
		];
		$seeds[] = [
			'produto1' => 1,
			'produto2' => 4,
		];
		$seeds[] = [
			'produto1' => 2,
			'produto2' => 3,
		];
		$seeds[] = [
			'produto1' => 2,
			'produto2' => 4,
		];
		$seeds[] = [
			'produto1' => 2,
			'produto2' => 5,
		];
		$seeds[] = [
			'produto1' => 2,
			'produto2' => 6,
		];
		$seeds[] = [
			'produto1' => 2,
			'produto2' => 7,
		];
		$seeds[] = [
			'produto1' => 8,
			'produto2' => 3,
		];
		$seeds[] = [
			'produto1' => 7,
			'produto2' => 3,
		];
		$seeds[] = [
			'produto1' => 6,
			'produto2' => 3,
		];
		$seeds[] = [
			'produto1' => 5,
			'produto2' => 3,
		];
		$seeds[] = [
			'produto1' => 5,
			'produto2' => 6,
		];
		$seeds[] = [
			'produto1' => 5,
			'produto2' => 7,
		];
		(new Factory('produtos_relacionados'))->with($seeds)->save();
	}

	public function mock_marcas()
	{
		$seeds = [];
		$seeds[] = [
			'nome' => 'Marca 1',
			'url' => 'marca-1',
			'logo' => 'default.png',
		];
		$seeds[] = [
			'nome' => 'Marca 2',
			'url' => 'marca-2',
			'logo' => 'default.png',
		];
		$seeds[] = [
			'nome' => 'Marca 3',
			'url' => 'marca-3',
			'logo' => 'default.png',
		];
		$seeds[] = [
			'nome' => 'Marca 4',
			'url' => 'marca-4',
			'logo' => 'default.png',
		];
		$seeds[] = [
			'nome' => 'Marca 5',
			'url' => 'marca-5',
			'logo' => 'default.png',
		];
		$seeds[] = [
			'nome' => 'Marca 6',
			'url' => 'marca-6',
			'logo' => 'default.png',
		];
		(new Factory('marca'))->with($seeds)->save();
	}

	public function mock_produto()
	{
		$seeds = [];
		$seeds[] = [
			'titulo' => 'Produto 1',
			'desc' => 'Lorem ipsum, dolor sit amet consectetur adipisicing elit. Cumque sequi fugiat sunt harum eum repellendus autem ut totam earum, commodi ullam dolorum cupiditate iste neque unde libero maiores omnis dignissimos.',
			'preco' => '159.99',
			'acessos' => '0',
			'url' => 'produto-1',
			'oferta' => 1,
			'destaque' => 1,
			'desconto' => '10.00',
			'ref' => 'PDT-1',
			'marca' => 1,
		];
		$seeds[] = [
			'titulo' => 'Produto 2',
			'desc' => 'Lorem ipsum, dolor sit amet consectetur adipisicing elit. Cumque sequi fugiat sunt harum eum repellendus autem ut totam earum, commodi ullam dolorum cupiditate iste neque unde libero maiores omnis dignissimos.',
			'preco' => '179.99',
			'acessos' => '0',
			'url' => 'produto-2',
			'oferta' => 1,
			'destaque' => 1,
			'desconto' => '5.00',
			'ref' => 'PDT-2',
			'marca' => 1,
		];
		$seeds[] = [
			'titulo' => 'Produto 3',
			'url' => 'produto-3',
			'desc' => 'Lorem ipsum, dolor sit amet consectetur adipisicing elit. Cumque sequi fugiat sunt harum eum repellendus autem ut totam earum, commodi ullam dolorum cupiditate iste neque unde libero maiores omnis dignissimos.',
			'preco' => '159.99',
			'acessos' => '0',
			'oferta' => 1,
			'destaque' => 1,
			'desconto' => '10.00',
			'ref' => 'PDT-3',
			'marca' => 1,
		];
		$seeds[] = [
			'titulo' => 'Produto 4',
			'url' => 'produto-4',
			'desc' => 'Lorem ipsum, dolor sit amet consectetur adipisicing elit. Cumque sequi fugiat sunt harum eum repellendus autem ut totam earum, commodi ullam dolorum cupiditate iste neque unde libero maiores omnis dignissimos.',
			'preco' => '159.99',
			'acessos' => '0',
			'oferta' => 1,
			'destaque' => 1,
			'desconto' => '10.00',
			'ref' => 'PDT-4',
			'marca' => 2,
		];
		$seeds[] = [
			'titulo' => 'Produto 5',
			'url' => 'produto-5',
			'desc' => 'Lorem ipsum, dolor sit amet consectetur adipisicing elit. Cumque sequi fugiat sunt harum eum repellendus autem ut totam earum, commodi ullam dolorum cupiditate iste neque unde libero maiores omnis dignissimos.',
			'preco' => '159.99',
			'acessos' => '0',
			'oferta' => 1,
			'destaque' => 1,
			'desconto' => '10.00',
			'ref' => 'PDT-5',
			'marca' => 2,
		];
		$seeds[] = [
			'titulo' => 'Produto 6',
			'url' => 'produto-6',
			'desc' => 'Lorem ipsum, dolor sit amet consectetur adipisicing elit. Cumque sequi fugiat sunt harum eum repellendus autem ut totam earum, commodi ullam dolorum cupiditate iste neque unde libero maiores omnis dignissimos.',
			'preco' => '159.99',
			'acessos' => '0',
			'oferta' => 1,
			'destaque' => 1,
			'desconto' => '10.00',
			'ref' => 'PDT-6',
			'marca' => 3,
		];
		$seeds[] = [
			'titulo' => 'Produto 7',
			'url' => 'produto-7',
			'desc' => 'Lorem ipsum, dolor sit amet consectetur adipisicing elit. Cumque sequi fugiat sunt harum eum repellendus autem ut totam earum, commodi ullam dolorum cupiditate iste neque unde libero maiores omnis dignissimos.',
			'preco' => '159.99',
			'acessos' => '0',
			'oferta' => 1,
			'destaque' => 1,
			'desconto' => '10.00',
			'ref' => 'PDT-7',
			'marca' => 4,
		];
		$seeds[] = [
			'titulo' => 'Produto 8',
			'url' => 'produto-8',
			'desc' => 'Lorem ipsum, dolor sit amet consectetur adipisicing elit. Cumque sequi fugiat sunt harum eum repellendus autem ut totam earum, commodi ullam dolorum cupiditate iste neque unde libero maiores omnis dignissimos.',
			'preco' => '159.99',
			'acessos' => '0',
			'oferta' => 1,
			'destaque' => 1,
			'desconto' => '10.00',
			'ref' => 'PDT-8',
			'marca' => 5,
		];
		(new Factory('produto'))->with($seeds)->save();
	}

	public function mock_item_atributo()
	{
		$seeds = [];
		$seeds[] = [
			'nome' => 'Azul',
			'atributo' => 1,
		];
		$seeds[] = [
			'nome' => 'Vermelho',
			'atributo' => 1,
		];
		$seeds[] = [
			'nome' => 'Verde',
			'atributo' => 1,
		];
		$seeds[] = [
			'nome' => 'Branco',
			'atributo' => 1,
		];
		$seeds[] = [
			'nome' => 'P',
			'atributo' => 2,
		];
		$seeds[] = [
			'nome' => 'M',
			'atributo' => 2,
		];
		$seeds[] = [
			'nome' => 'G',
			'atributo' => 2,
		];
		$seeds[] = [
			'nome' => '110 V',
			'atributo' => 3,
		];
		$seeds[] = [
			'nome' => '220 V',
			'atributo' => 3,
		];
		(new Factory('item_atributo'))->with($seeds)->save();
	}

	public function mock_atributo()
	{
		$seeds = [];
		$seeds[] = [
			'nome' => 'Cores',
			'tipo' => 1,
		];
		$seeds[] = [
			'nome' => 'Tamanho',
			'tipo' => 1,
		];
		$seeds[] = [
			'nome' => 'Voltagem',
			'tipo' => 1,
		];
		(new Factory('atributo'))->with($seeds)->save();
	}

	public function mock_subcategoria_produtos()
	{
		$with = [];
		$with[] = [
			'nome' => 'Alimentação',
			'url' => 'alimentacao',
			'pos' => 0,
			'apelido' => '',
			'ordem_destaque' => 0,
			'categoria' => 1,
		];
		$with[] = [
			'nome' => 'Brinquedos',
			'url' => 'brinquedos',
			'pos' => 0,
			'categoria' => 1,
			'apelido' => '',
			'ordem_destaque' => 0,
		];
		$with[] = [
			'nome' => 'Carrinho de Bebê',
			'url' => 'carrinho-de-bebe',
			'categoria' => 1,
			'pos' => 0,
			'apelido' => '',
			'ordem_destaque' => 0,
		];
		$with[] = [
			'nome' => 'Higiene',
			'url' => 'higiene',
			'categoria' => 1,
			'pos' => 0,
			'apelido' => '',
			'ordem_destaque' => 0,
		];
		$with[] = [
			'nome' => 'Segurança',
			'url' => 'seguranca',
			'categoria' => 1,
			'pos' => 0,
			'apelido' => '',
			'ordem_destaque' => 0,
		];

		$with[] = [
			'nome' => 'Secadores',
			'url' => 'secadores',
			'categoria' => 2,
			'pos' => 0,
			'apelido' => '',
			'ordem_destaque' => 0,
		];
		$with[] = [
			'nome' => 'Depuradores de Ar',
			'url' => 'depuradores-de-ar',
			'categoria' => 3,
			'pos' => 0,
			'apelido' => '',
			'ordem_destaque' => 0,
		];
		$with[] = [
			'nome' => 'Multifuncionais',
			'url' => 'multifuncionais',
			'categoria' => 4,
			'pos' => 0,
			'apelido' => '',
			'ordem_destaque' => 0,
		];
		$with[] = [
			'nome' => 'Notebooks',
			'url' => 'notebooks',
			'pos' => 1,
			'categoria' => 4,
			'apelido' => 'Para seu Home Office',
			'ordem_destaque' => 1,
		];
		$with[] = [
			'nome' => 'Tablets',
			'url' => 'tablets',
			'categoria' => 4,
			'pos' => 0,
			'apelido' => '',
			'ordem_destaque' => 0,
		];
		$with[] = [
			'nome' => 'Ultrabooks',
			'url' => 'ultrabooks',
			'categoria' => 4,
			'pos' => 0,
			'apelido' => '',
			'ordem_destaque' => 0,
		];
		$with[] = [
			'nome' => 'Regatas',
			'url' => 'regatas',
			'categoria' => 5,
			'pos' => 0,
			'apelido' => '',
			'ordem_destaque' => 0,
		];
		$with[] = [
			'nome' => 'Celulares e Smartphones',
			'url' => 'celulares-e-smartphones',
			'pos' => 1,
			'categoria' => 6,
			'apelido' => 'Smartphones em Oferta',
			'ordem_destaque' => 2,
		];
		$with[] = [
			'nome' => 'Smart TV',
			'url' => 'smart-tv',
			'pos' => 1,
			'categoria' => 7,
			'apelido' => 'Smarts TVs em oferta',
			'ordem_destaque' => 3,
		];
		(new Factory('subcategoria_produto'))->with($with)->save();
	}

	public function mock_categoria_produtos()
	{
		$with = [];
		$with[] = [
			'nome' => 'Bebê',
			'url' => 'bebe',
			'pos' => 1,
		];
		$with[] = [
			'nome' => 'Beleza e Saúde',
			'url' => 'beleza-e-saude',
			'pos' => 2,
		];
		$with[] = [
			'nome' => 'Eletrodomésticos',
			'url' => 'eletrodomesticos',
			'pos' => 3,
		];
		$with[] = [
			'nome' => 'Informática',
			'url' => 'informatica',
			'pos' => 4,
		];
		$with[] = [
			'nome' => 'Roupas e Acessórios',
			'url' => 'roupas-e-acessorios',
			'pos' => 5,
		];
		$with[] = [
			'nome' => 'Telefonia',
			'url' => 'telefonia',
			'pos' => 6,
		];
		$with[] = [
			'nome' => 'Smart TV',
			'url' => 'smart-tv',
			'pos' => 7,
		];
		(new Factory('categoria_produto'))->with($with)->save();
	}

	public function mock_pagina()
	{
		$with = [];
		$with[] = [
			'categoria' => '1',
			'titulo' => 'Política de Privacidade',
			'url' => 'politica-de-privacidade',
			'capa' => 'default.png',
			'desc' => 'Lorem ipsum dolor sit amet consectetur, adipisicing elit. Ullam modi vitae cupiditate alias ut odit ratione sequi labore? Ratione itaque aliquid ipsum corporis harum repellat eum unde alias vero est. <br> Lorem ipsum dolor sit amet consectetur, adipisicing elit.',
			'texto' => 'Lorem ipsum dolor sit amet consectetur, adipisicing elit. Ullam modi vitae cupiditate alias ut odit ratione sequi labore? Ratione itaque aliquid ipsum corporis harum repellat eum unde alias vero est. <br> Lorem ipsum dolor sit amet consectetur, adipisicing elit. Ullam modi vitae cupiditate alias ut odit ratione sequi labore? Ratione itaque aliquid ipsum corporis harum repellat eum unde alias vero est. Lorem ipsum dolor sit amet consectetur, adipisicing elit. Ullam modi vitae cupiditate alias ut odit ratione sequi labore? Ratione itaque aliquid ipsum corporis harum repellat eum unde alias vero est.',
		];
		$with[] = [
			'categoria' => '1',
			'titulo' => 'Termos de Uso e Condições',
			'url' => 'termos-de-uso-e-condicoes',
			'capa' => 'default.png',
			'desc' => 'Lorem ipsum dolor sit amet consectetur, adipisicing elit. Ullam modi vitae cupiditate alias ut odit ratione sequi labore? Ratione itaque aliquid ipsum corporis harum repellat eum unde alias vero est. <br> Lorem ipsum dolor sit amet consectetur, adipisicing elit.',
			'texto' => 'Lorem ipsum dolor sit amet consectetur, adipisicing elit. Ullam modi vitae cupiditate alias ut odit ratione sequi labore? Ratione itaque aliquid ipsum corporis harum repellat eum unde alias vero est. <br> Lorem ipsum dolor sit amet consectetur, adipisicing elit. Ullam modi vitae cupiditate alias ut odit ratione sequi labore? Ratione itaque aliquid ipsum corporis harum repellat eum unde alias vero est. Lorem ipsum dolor sit amet consectetur, adipisicing elit. Ullam modi vitae cupiditate alias ut odit ratione sequi labore? Ratione itaque aliquid ipsum corporis harum repellat eum unde alias vero est.',
		];
		$with[] = [
			'categoria' => '2',
			'titulo' => 'Como aproveitar as promoções',
			'url' => 'como-aproveitar-as-promocoes',
			'capa' => 'default.png',
			'desc' => 'Lorem ipsum dolor sit amet consectetur, adipisicing elit. Ullam modi vitae cupiditate alias ut odit ratione sequi labore? Ratione itaque aliquid ipsum corporis harum repellat eum unde alias vero est. <br> Lorem ipsum dolor sit amet consectetur, adipisicing elit.',
			'texto' => 'Lorem ipsum dolor sit amet consectetur, adipisicing elit. Ullam modi vitae cupiditate alias ut odit ratione sequi labore? Ratione itaque aliquid ipsum corporis harum repellat eum unde alias vero est. <br> Lorem ipsum dolor sit amet consectetur, adipisicing elit. Ullam modi vitae cupiditate alias ut odit ratione sequi labore? Ratione itaque aliquid ipsum corporis harum repellat eum unde alias vero est. Lorem ipsum dolor sit amet consectetur, adipisicing elit. Ullam modi vitae cupiditate alias ut odit ratione sequi labore? Ratione itaque aliquid ipsum corporis harum repellat eum unde alias vero est.',
		];
		$with[] = [
			'categoria' => '2',
			'titulo' => 'Pagamento Seguro',
			'url' => 'pagamento-seguro',
			'capa' => 'default.png',
			'desc' => 'Lorem ipsum dolor sit amet consectetur, adipisicing elit. Ullam modi vitae cupiditate alias ut odit ratione sequi labore? Ratione itaque aliquid ipsum corporis harum repellat eum unde alias vero est. <br> Lorem ipsum dolor sit amet consectetur, adipisicing elit.',
			'texto' => 'Lorem ipsum dolor sit amet consectetur, adipisicing elit. Ullam modi vitae cupiditate alias ut odit ratione sequi labore? Ratione itaque aliquid ipsum corporis harum repellat eum unde alias vero est. <br> Lorem ipsum dolor sit amet consectetur, adipisicing elit. Ullam modi vitae cupiditate alias ut odit ratione sequi labore? Ratione itaque aliquid ipsum corporis harum repellat eum unde alias vero est. Lorem ipsum dolor sit amet consectetur, adipisicing elit. Ullam modi vitae cupiditate alias ut odit ratione sequi labore? Ratione itaque aliquid ipsum corporis harum repellat eum unde alias vero est.',
		];
		$with[] = [
			'categoria' => '3',
			'titulo' => 'Cupom de Desconto',
			'url' => 'cupom-de-desconto',
			'capa' => 'default.png',
			'desc' => 'Lorem ipsum dolor sit amet consectetur, adipisicing elit. Ullam modi vitae cupiditate alias ut odit ratione sequi labore? Ratione itaque aliquid ipsum corporis harum repellat eum unde alias vero est. <br> Lorem ipsum dolor sit amet consectetur, adipisicing elit.',
			'texto' => 'Lorem ipsum dolor sit amet consectetur, adipisicing elit. Ullam modi vitae cupiditate alias ut odit ratione sequi labore? Ratione itaque aliquid ipsum corporis harum repellat eum unde alias vero est. <br> Lorem ipsum dolor sit amet consectetur, adipisicing elit. Ullam modi vitae cupiditate alias ut odit ratione sequi labore? Ratione itaque aliquid ipsum corporis harum repellat eum unde alias vero est. Lorem ipsum dolor sit amet consectetur, adipisicing elit. Ullam modi vitae cupiditate alias ut odit ratione sequi labore? Ratione itaque aliquid ipsum corporis harum repellat eum unde alias vero est.',
		];
		$with[] = [
			'categoria' => '3',
			'titulo' => 'Entregas e Frete',
			'url' => 'entregas-e-frete',
			'capa' => 'default.png',
			'desc' => 'Lorem ipsum dolor sit amet consectetur, adipisicing elit. Ullam modi vitae cupiditate alias ut odit ratione sequi labore? Ratione itaque aliquid ipsum corporis harum repellat eum unde alias vero est. <br> Lorem ipsum dolor sit amet consectetur, adipisicing elit.',
			'texto' => 'Lorem ipsum dolor sit amet consectetur, adipisicing elit. Ullam modi vitae cupiditate alias ut odit ratione sequi labore? Ratione itaque aliquid ipsum corporis harum repellat eum unde alias vero est. <br> Lorem ipsum dolor sit amet consectetur, adipisicing elit. Ullam modi vitae cupiditate alias ut odit ratione sequi labore? Ratione itaque aliquid ipsum corporis harum repellat eum unde alias vero est. Lorem ipsum dolor sit amet consectetur, adipisicing elit. Ullam modi vitae cupiditate alias ut odit ratione sequi labore? Ratione itaque aliquid ipsum corporis harum repellat eum unde alias vero est.',
		];
		$with[] = [
			'categoria' => '3',
			'titulo' => 'Formas de Pagamento',
			'url' => 'formas-de-pagamento',
			'capa' => 'default.png',
			'desc' => 'Lorem ipsum dolor sit amet consectetur, adipisicing elit. Ullam modi vitae cupiditate alias ut odit ratione sequi labore? Ratione itaque aliquid ipsum corporis harum repellat eum unde alias vero est. <br> Lorem ipsum dolor sit amet consectetur, adipisicing elit.',
			'texto' => 'Lorem ipsum dolor sit amet consectetur, adipisicing elit. Ullam modi vitae cupiditate alias ut odit ratione sequi labore? Ratione itaque aliquid ipsum corporis harum repellat eum unde alias vero est. <br> Lorem ipsum dolor sit amet consectetur, adipisicing elit. Ullam modi vitae cupiditate alias ut odit ratione sequi labore? Ratione itaque aliquid ipsum corporis harum repellat eum unde alias vero est. Lorem ipsum dolor sit amet consectetur, adipisicing elit. Ullam modi vitae cupiditate alias ut odit ratione sequi labore? Ratione itaque aliquid ipsum corporis harum repellat eum unde alias vero est.',
		];
		$with[] = [
			'categoria' => '3',
			'titulo' => 'Trocas e Devoluções',
			'url' => 'trocas-e-devolucoes',
			'capa' => 'default.png',
			'desc' => 'Lorem ipsum dolor sit amet consectetur, adipisicing elit. Ullam modi vitae cupiditate alias ut odit ratione sequi labore? Ratione itaque aliquid ipsum corporis harum repellat eum unde alias vero est. <br> Lorem ipsum dolor sit amet consectetur, adipisicing elit.',
			'texto' => 'Lorem ipsum dolor sit amet consectetur, adipisicing elit. Ullam modi vitae cupiditate alias ut odit ratione sequi labore? Ratione itaque aliquid ipsum corporis harum repellat eum unde alias vero est. <br> Lorem ipsum dolor sit amet consectetur, adipisicing elit. Ullam modi vitae cupiditate alias ut odit ratione sequi labore? Ratione itaque aliquid ipsum corporis harum repellat eum unde alias vero est. Lorem ipsum dolor sit amet consectetur, adipisicing elit. Ullam modi vitae cupiditate alias ut odit ratione sequi labore? Ratione itaque aliquid ipsum corporis harum repellat eum unde alias vero est.',
		];
		(new Factory('pagina'))->with($with)->save();
	}

	public function mock_categoria_paginas()
	{
		$with = [];
		$with[] = [
			'nome' => 'Institucional',
			'url' => 'institucional',
			'topo' => 0,
			'rodape' => 1,
			'pos' => 1,
		];
		$with[] = [
			'nome' => 'Nossas Dicas',
			'url' => 'nossas-dicas',
			'topo' => 0,
			'rodape' => 1,
			'pos' => 2,
		];
		$with[] = [
			'nome' => 'Tire suas Dúvidas',
			'url' => 'tire-suas-duvidas',
			'topo' => 1,
			'rodape' => 1,
			'pos' => 3,
		];
		(new Factory('categoria_pagina'))->with($with)->save();
	}

	public function mock_config()
	{
		$with = [
			'id' => 1,
			'site_title' => 'Loja Virtual',
			'site_logo' => 'logo.png',
			'site_slogan' => 'Venda online',
			'site_favicon' => 'logo.png',
		];
		(new Factory('config'))->with($with)->save();
	}

	public function mock_slide()
	{
		$add = [
			[
				'status' => 1,
				'tipo' => 1,
				'pos' => 1,
				'img' => 'slide-padrao.png',
				'url' => '',
			],
			[
				'status' => 1,
				'tipo' => 1,
				'pos' => 2,
				'img' => 'slide-padrao-2.png',
				'url' => '',
			],
			[
				'status' => 1,
				'tipo' => 8,
				'pos' => 1,
				'img' => 'slide-padrao-quadrado-2.png',
				'url' => '',
			],
			[
				'status' => 1,
				'tipo' => 8,
				'pos' => 2,
				'img' => 'slide-padrao-quadrado-2.png',
				'url' => '',
			],
			[
				'status' => 1,
				'tipo' => 8,
				'pos' => 3,
				'img' => 'slide-padrao-quadrado-2.png',
				'url' => '',
			],
			[
				'status' => 1,
				'tipo' => 4,
				'pos' => 1,
				'img' => 'banner-full-meio.png',
				'url' => '',
			],
			[
				'status' => 1,
				'tipo' => 3,
				'pos' => 1,
				'img' => 'banner-lateral-1.png',
				'url' => '',
			]
		];
		(new Factory('slide'))->with($add)->save();
	}


	public function migrate()
	{
		$this->check_auth();

		/** FRETE 25/09/2023  */
		$columns = [
			['name' => 'melhorenvio_refresh_token', 'type' => 'longtext'],
		];
		(new DB)->add_columns('frete', $columns);

		/** FRETE 25/09/2023,campo data do dia em que o token da melhor envio for atualizado */
		$columns = [
			['name' => 'melhorenvio_data_refresh_token', 'type' => 'date'],
		];
		(new DB)->add_columns('frete', $columns);

		/** PEDIDO 25/09/2023  */
		$columns = [
			["name" => "codigo_rastreio", "type" => "varchar(100)"],
		];
		(new DB)->add_columns('pedido', $columns);

		/** PEDIDO 25/09/2023 campo para identificar a empresa de rastreio*/
		$columns = [
			["name" => "empresa_rastreio", "type" => "int(3)", 'default' => 1],
		];
		(new DB)->add_columns('pedido', $columns);

		/** FRETE 27/09/2023 campo de codigos de serviços de transportadora da MelhorEnvio
		 *  Por padrão vão vir apenas aqueles que são dos correios
		 */
		$columns = [
			['name' => 'melhorenvio_servicos', 'type' => 'varchar(200)', 'default' => "'1,2,17,28,29,30'"],
		];
		(new DB)->add_columns('frete', $columns);


		//frete_adicional

		Http::redirect_to('/install/?success');
	}

	public function generic_migrate()
	{
		$this->check_auth();
		$columns = [
			['name' => 'forma', 'type' => 'int(3)'],
		];
		(new DB)->add_columns('movimentacao', $columns);
	}

	public function geraSeed($table = false)
	{
		if ($table) {
			$rows = (new Factory($table))->get();
			$seed = '[';
			foreach ($rows as $indice) {
				$seed .= '[ <br>';
				foreach ($indice as $campo => $valor) {
					if ($campo != $table . "_created" && $campo != $table . "_updated" && $campo != $table . "_id") {
						$campo = str_replace($table . "_", "", $campo);
						$seed .= '  "' . $campo . '" => "' . $valor . '", <br>';
					}
				}
				$seed .= '], <br>';
			}
			$seed .= "]";
			echo $seed;
			exit;
			return (array) $seed;
		}
	}

	public function show_seed()
	{
		$this->check_auth();
		$table = Http::get_in_params('show_seed', 'string');
		if (isset($table->value) && !empty($table->value)) {
			$this->geraSeed($table->value);
		}
	}
	public function map()
	{
		$this->check_auth();
		//  $map = (new Factory('pedido'))->map(1);
		$map = (new DB)->show_table('produto');
		foreach ($map as $k => $v) {
			$k = str_replace("produto_", "", $k);
			echo '["name" => "' . $k . '", "type" => "' . $v . '"], <br>';
		}
	}

	public function mapRows()
	{
		$this->check_auth();
		$tabela = "categoria_produto";
		$rows = (new Factory($tabela))->get();

		$seed = '$seed = ';
		foreach ($rows as $indice) {
			$seed .= '[ <br>';
			foreach ($indice as $campo => $valor) {
				if ($campo != $tabela . "_created" && $campo != $tabela . "_updated" && $campo != $tabela . "_id") {
					$campo = str_replace($tabela . "_", "", $campo);
					$seed .= '  ["' . $campo . '" => "' . $valor . '"], <br>';
				}
			}

			$seed .= '],';
		}
		$seed .= '];';
		Filter::pre($seed, 1);
	}

	public function clear_tables_dev()
	{
		$this->check_auth();
		exit;
		(new DB)->drop_table('categoria_produto');
		(new DB)->drop_table('subcategoria_produto');
	}
}
