<?php

use Frete\Kangu;

class Index
{

	public function __construct()
	{
		(new Install)->check();
		(new Install)->check_tabelas_principais();
	}


	public function indexAction()
	{
		$slides_vertical = (new SlideFront())->listarSlideVertical();
		$produtos_mais_acessados = (new ProdutosFront())->listarMaisAcessados();
		$produtos_mais_vendidos = (new ProdutosFront())->listarMaisVendidos();
		$mostra_meio = intval(0);
		if (is_array($slides_vertical) && sizeof($slides_vertical) > 0 && (is_array($produtos_mais_acessados) && sizeof($produtos_mais_acessados) > 0 || is_array($produtos_mais_vendidos) && sizeof($produtos_mais_vendidos) > 0)) {
			$mostra_meio = intval(1);
		} else if (is_array($produtos_mais_acessados) && sizeof($produtos_mais_acessados) > 0 && is_array($produtos_mais_vendidos) && sizeof($produtos_mais_vendidos) > 0) {
			$mostra_meio = intval(1);
		}
		$slide2 = (new SlideFront())->listarSlidesBanners(2);
		$banner1 = (new SlideFront())->listarSlidesBanners(4);
		$banner2 = (new SlideFront())->listarSlidesBanners(5);
		$bannerFino1 = (new SlideFront())->listarSlidesBanners(6);
		$bannerFino2 = (new SlideFront())->listarSlidesBanners(7);
		$bannerMultiplo1 = (new SlideFront())->listarSlidesBanners(8);
		$bannerMultiplo2 = (new SlideFront())->listarSlidesBanners(9);
		$card = (new Factory('config_card'))->get()[0];
		$parceiros = (new Factory('parceiro'))->select("parceiro_logo")->get();
		$data = [
			// Menu Superior
			'categorias' => (new CategoriasProdutosFront())->listar(),
			'destaques' => (new CategoriasProdutosFront())->listaSubcategoriasDestaque(),
			'slideSuperior' => (new SlideFront())->listarSlidePrincipal(),
			'paginasTopo' => (new Pagina())->listarPaginasTopo(),
			// Feed Produtos
			'produtosOferta' => (new ProdutosFront())->listarOfertas(),
			'produtosNovo' => (new ProdutosFront())->listarNovos(),
			'produtosDestaque' => (new ProdutosFront())->listarDestaques(),
			// Marcas
			'marcas' => (new SlideFront())->listarMarcas(),
			// Parceiros
			'parceiros' => $parceiros,
			// Slide meio e produtos
			'slide2' => $slide2,
			'banner1' => $banner1,
			'banner2' => $banner2,
			'bannerFino1' => $bannerFino1,
			'bannerFino2' => $bannerFino2,
			'bannerMultiplo1' => $bannerMultiplo1,
			'bannerMultiplo2' => $bannerMultiplo2,
			'slideVertical' => $slides_vertical,
			'produtosMaisAcessados' => $produtos_mais_acessados,
			'produtosMaisVendidos' => $produtos_mais_vendidos,
			'mostraMeio' => $mostra_meio,
			'paginasFooter' => (new Pagina())->listarPaginasFooter(),
			'faq' => (new Faq())->listaFooter(),
			'config' => (new Config)->get(),
			'card' => $card,
			'social' => (new Config)->getRedesSociais(),
			'order' => (new OrdenarHome)->listaHome(),
			'mapper' => ['config', 'social', 'card'],
		];
		Tpl::view("tema.loja.home.index", $data);
	}

	public function envia_email_recupera_senha()
	{
		$email = Req::post('cliente_email', 'string');
		$config = (new Config)->get();
		if (!empty($email)) {
			$cliente = (new Factory('cliente'))
				->select("cliente_id, cliente_nome")
				->find_by("cliente_email", $email);

			if (isset($cliente->cliente_id) && !empty($cliente->cliente_id)) {
				// existe cliente
				$token = md5(time());
				$data = [
					'token' => $token,
					'cliente_id' => $cliente->cliente_id,
				];
				(new Factory('cliente'))->with($data)->save();
				// Envia o email
				$url = Http::base() . '/cliente-recupera-senha/' . $token;
				$data_email = [
					'config' => (new Config)->get(),
					'nome' => ['nome' => $cliente->cliente_nome],
					'url' => ['url' => $url],
					'mapper' => ['config', 'nome', 'url'],
				];
				$mensagem = Tpl::output("email.recuperacao-senha", $data_email);
				$msg = [
					'assunto' => "$config->config_site_title - Solicitação para mudança de senha",
					'nome' => $config->config_site_title,
					'destinatario' => $email,
					'mensagem' => $mensagem,
				];
				if (Sender::mail($msg)) {
					echo json_encode(['status' => 200, 'msg' => 'Email enviado com sucesso!']);
				} else {
					echo json_encode(['status' => 501]);
				}
			} else {
				echo json_encode(['status' => 404]);
			}
		} else {
			echo json_encode(['status' => 401]);
		}
	}

	public function viewRecuperaSenha()
	{
		$token = Http::get_in_params('cliente-recupera-senha', 'string');
		if (isset($token->value) && !empty($token->value)) {
			$token = $token->value;
			$cliente = (new Factory('cliente'))->select("cliente_id")->find_by("cliente_token", $token);
			if (isset($cliente->cliente_id) && !empty($cliente->cliente_id)) {
				$cliente_id = $cliente->cliente_id;

				$data = [
					// Menu Superior
					'categorias' => (new CategoriasProdutosFront())->listar(),
					'destaques' => (new CategoriasProdutosFront())->listaSubcategoriasDestaque(),
					'slideSuperior' => (new SlideFront())->listarSlidePrincipal(),
					'paginasTopo' => (new Pagina())->listarPaginasTopo(),
					// Footer
					'paginasFooter' => (new Pagina())->listarPaginasFooter(),
					'faq' => (new Faq())->listaFooter(),
					// Principal
					'config' => (new Config)->get(),
					'cliente_id' => ['cliente_id' => $cliente_id],
					'token' => ['token' => $token],
					'social' => (new Config)->getRedesSociais(),
					'mapper' => ['config', 'cliente_id', 'token', 'produto_keywords', 'social'],
				];

				Tpl::view("tema.loja.cliente.recupera-senha", $data, 1);
			}
		}
	}

	public function troca_senha_cliente()
	{
		$cliente_id = Req::post('cliente_id', 'int');
		$token = Req::post('token', 'string');

		$senha = trim(Req::post('senha', 'string'));
		$senha2 = trim(Req::post('senha2', 'string'));

		if (!empty($token) && !empty($cliente_id) && !empty($senha) && !empty($senha2) && $senha == $senha2) {
			$cliente = (new Factory('cliente'))
				->select("cliente_id")
				->where("cliente_id = $cliente_id AND cliente_token = '$token'")
				->get();
			if (isset($cliente[0])) {
				// atualiza
				$data = [
					'cliente_id' => $cliente_id,
					'cliente_password' => md5($senha),
					'cliente_token' => '',
				];
				(new Factory('cliente'))->with($data)->save();
				Http::redirect_to("/login-cliente");
			}
		} else {
			Http::redirect_to("/cliente-recupera-senha/$token/?senha-invalida");
		}
	}
}
