<?php

class Endereco
{

    public function __construct()
    {
        Sessao::check();
        (new Install)->check_tabelas_principais();
    }

    public function indexAction()
    {
        $id = Http::get_in_params('id', 'int');
        if (isset($id->value) && $id->value > 0) {
            $id = $id->value;
            $data = [
                'config' => (new Config)->get(),
                
                'cliente_id' => ['cliente_id' => $id],
                'mapper' => ['config', 'cliente_id']
            ];
            Tpl::view('admin.cliente.endereco.index', $data, 1);
        } else {
            Http::redirect_to('/cliente/?error');
        }
    }


    public function novo()
    {
        $id = Http::get_in_params('id', 'int');
        if (isset($id->value) && $id->value > 0) {
            $id = $id->value;
            $data = [
                'config' => (new Config)->get(),
                
                'cliente_id' => ['endereco_cliente_cliente' => $id],
                'endereco' => (new Factory('endereco_cliente'))->map(),
                'mapper' => ['config', 'cliente_id', 'endereco']
            ];
            Tpl::view('admin.cliente.endereco.form', $data, 1);
        } else {
            Http::redirect_to('/cliente/?error');
        }
    }

    public function editar()
    {
        $id = Http::get_in_params('id', 'int');
        if (isset($id->value) && $id->value > 0) {
            $id = $id->value;
            $end = (new Factory('endereco_cliente'))->find($id);
            if (isset($end) && !empty($end)) {
                $data = [
                    'config' => (new Config)->get(),
                    
                    'endereco' => $end,
                    'cliente_id' => ['cliente_id' => $end->endereco_cliente_cliente],
                    'mapper' => ['config', 'endereco']
                ];
                Tpl::view('admin.cliente.endereco.form', $data, 1);
            } else {
                Http::redirect_to('/cliente/?error');
            }
        } else {
            Http::redirect_to('/cliente/?error');
        }
    }

    public function listar()
    {
        $cliente_id = Req::post('cliente_id', 'int');
        if ($cliente_id > 0) {
            (new Factory('endereco_cliente'))
                ->where('endereco_cliente_cliente = ' . $cliente_id)
                ->get(1);
        }
    }

    public function gravar()
    {
        if(isset($_POST['endereco_cliente_cliente']) && !empty($_POST['endereco_cliente_cliente'])) {
            $_POST = Filter::parse_full($_POST);

            // VERIFICA SE EXISTE UM ENDEREÇO, CASO NÃO EXISTA, CADASTRA COMO CORRESPONDENCIA
            $res = (new Factory('endereco_cliente'))->where('endereco_cliente_cliente = ' . $_POST['endereco_cliente_cliente'] . ' AND endereco_cliente_tipo = 1')->get();
    
            if (!$res) {
                $_POST['endereco_cliente_tipo'] = '1';
            }
            (new Factory('endereco_cliente'))->with($_POST)->save();
            Http::redirect_to('/endereco-listar/id/' . $_POST['endereco_cliente_cliente'] . '/?success');
        }
       
    }

    public function remover()
    {
        $id = Req::post('id', 'int');
        if ($id > 0) {
            (new Factory('endereco_cliente'))->drop($id);
            echo '1';
        } else {
            echo '0';
        }
    }
}
