<?php

class Config
{
    public function __construct()
    {
        (new Install)->check_tabelas_principais();
    }
    public $config;
    public function get()
    {
        $avatar = '';
        if (isset($_SESSION['node']['ulevel']) && !empty($_SESSION['node']['ulevel'])) {
            //  1 = admin | 2 = cliente
            $tipo = intval($_SESSION['node']['ulevel']);
            $id = (Session::node('uid'));
            $avatar = (new Factory('usuario'))
                ->select('usuario_avatar as avatar')
                ->find($id);
             $avatar = (isset($avatar->avatar) && strlen($avatar->avatar) > 4) ? $avatar->avatar : 'nopic.png';
        }
        $conf = (new Factory('config'))->find(1);
        if (Session::node('uid') != null) {
            $conf->uname = ucfirst(Session::node('unome'));
            $conf->level = ucfirst(Session::node('ulevel'));
            $conf->id = ucfirst(Session::node('uid'));
        }
        $conf->baseUri = Http::base();
        $conf->avatar = $avatar;
        $conf->tema_color = '1';
        $conf->tema_color_bg = "FABC3D";
        $conf->tema_color_fg = "2B2D37";
        $conf->whatsNum = Filter::phone2Number($conf->config_site_tel2);
        $conf->params_embed_google = $this->remove_espacos("$conf->config_site_rua, $conf->config_site_cidade - $conf->config_site_uf, $conf->config_site_cep");

        if(intval($conf->config_site_layout) == 2) {
            $conf->config_site_layout_custom = 'container';
            $conf->config_site_layout_custom_slide = 'container';
        } else {
            $conf->config_site_layout_custom = 'container-fluid';
        }

        $conf->config_site_funcionamento = $this->formatarHorarioFunc($conf->config_site_funcionamento);

        return $conf;
    }
    public function getSmtp()
    {
        return (new Factory('smtp'))->select('smtp_host,smtp_email,smtp_port,smtp_secure,smtp_nome')->find(1);
    }
    public function getContato()
    {
        $contato = (new Factory('contato'))->find(1);
        $whattsNum = Filter::phone2Number($contato->contato_tell1);
        $contato->whatsNum = $whattsNum;
        return $contato;
    }
    public function getRedesSociais()
    {
        return (new Factory('redesSociais'))->find(1);
    }

    public function remove_espacos($str = '')
    {
        return implode('+', explode(' ', trim($str)));
    }

    public function formatarHorarioFunc($text) {
        $semana = [
            'domingo', 
            'terça', 
            'quarta', 
            'quinta', 

            'sábado',
            'sabado'
        ];

        foreach ($semana as $s) {
            $text = preg_replace("/($s)/i", "<br>$1", $text);
        }

        return $text;
    }
}
