<?php

use Erp\BlingApi;

class Bling
{
    public function __construct()
    {
        Sessao::check();
        (new Install)->check_tabelas_principais();
    }

    public function indexAction() {}

    static function modulo_status()
    {
        $data = (new Factory('integracao'))->find(1);
        return (isset($data->integracao_ativo) && !empty($data->integracao_ativo)) ? $data->integracao_ativo : 0;
    }

    static function modulo_rec($rec)
    {
        $f = "integracao_{$rec}";
        $data = (new Factory('integracao'))->select($f)->where("integracao_id = 1")->get();
        return $data[0]->{$f};
    }

    public function gravar_credenciais()
    {
        $data = [
            'id' => 1,
            'integracao_ativo' => Req::post('integracao_ativo', 'int'),
            'integracao_secret' => Req::post('integracao_secret', 'string'),
            'integracao_client_id' => Req::post('integracao_client_id', 'string'),
            'integracao_rec1' => Req::post('integracao_rec1', 'int'),
            'integracao_rec2' => Req::post('integracao_rec2', 'int'),
            'integracao_rec3' => Req::post('integracao_rec3', 'int'),
            'integracao_rec4' => Req::post('integracao_rec4'),
            'integracao_rec5' => Req::post('integracao_rec5'),
            'integracao_rec6' => Req::post('integracao_rec6', 'int'),
            'integracao_rec7' => Req::post('integracao_rec7', 'int'),
        ];
        (new Factory('integracao'))->with($data)->save();
        Http::redirect_to('/integracao/bling/?success');
    }

    public function gravar_token()
    {
        if (!isset($_GET['code']) || empty($_GET['code'])) {
            Http::redirect_to('/integracao/bling/?error_code');
        }
        $response = BlingApi::autorizacao_callback(self::get_credenciais());
        if ($response && is_object($response) && isset($response->status) && $response->status == 1) {
            $response = $response->response;
            $add = [
                'id' => 1,
                'integracao_token' => $response->access_token,
                'integracao_refresh_token' => $response->refresh_token,
                'integracao_datetime_refresh_token' => date('Y-m-d H:i:s'),
            ];
            (new Factory('integracao'))->with($add)->save();

            Http::redirect_to('/integracao/bling/?success');
        } else {
            Http::redirect_to('/integracao/bling/?error_gravar_token');
        }
    }

    static public function atualizar_token($redirect = false)
    {
        //Checando se o token está prestes a expirar
        $refresh = self::check_token_timelimit();
        if (!$refresh) {
            $response = BlingApi::atualizar_token(self::get_credenciais());
            if ($response && is_object($response) && isset($response->status) && $response->status == 1) {
                $response = $response->response;
                $add = [
                    'id' => 1,
                    'integracao_token' => $response->access_token,
                    'integracao_refresh_token' => $response->refresh_token,
                    'integracao_datetime_refresh_token' => date('Y-m-d H:i:s'),
                ];
                (new Factory('integracao'))->with($add)->save();
                if ($redirect) {
                    Http::redirect_to('/integracao/bling/?success');
                } else {
                    return true;
                }
            } else {
                if ($redirect) {
                    Http::redirect_to('/integracao/bling/?error_gravar_token');
                } else {
                    return false;
                }
            }
        }
    }

    static public function get_token()
    {
        self::atualizar_token();
        $credenciais = self::get_credenciais();
        $token = $credenciais->integracao_token;
        return $token;
    }

    /**
     * @method gerar_nfe
     * @param $pedido  | required
     * @param $produto | required
     * @param $cliente | required
     * @description Metodo que vai apenas gerar a NFE na Bling
     * @redirect /pedidos/?success
     * @redirect /pedidos/?error
     */
    static function gerar_nfe($pedido, $produto, $cliente)
    {
        self::atualizar_token();
        $data = [
            'pedido' => $pedido,
            'cliente' => $cliente,
            'produtos' => $produto,
        ];
        $res = BlingApi::gerar_nfe(self::get_credenciais(), $data);
        if ($res && is_object($res) && isset($res->status) && $res->status == 1) {
            $add = [
                'pedido_id' => $pedido->pedido_id,
                'pedido_nf_status' => 3,
                'pedido_nf_num_id' => $res->response->id,
                'pedido_nf_serie' => $res->response->serie,
                'pedido_nf_num' => $res->response->numero,
            ];
            (new Factory('pedido'))->with($add)->save();
            Http::redirect_to('/pedidos/?success');
        } else {
            $msg = '';
            if (isset($res->response->error->fields[0]->msg)) {
                $msg = $res->response->error->fields[0]->msg;
            }
            // Http::redirect_to('/pedidos/?error=' . $msg);
        }
    }

    /**
     * @method enviar_nfe
     * @param int $pedido_id | required
     * @param int $nfe_id | required
     * @description Metodo que vai enviar a NFE gerada na Bling para o SEFAZ(Secretaria da Fazenda)
     * @redirect /pedidos/?success
     * @redirect /pedidos/?error_enviar_nfe
     */
    public function enviar_nfe($pedido_id, $nfe_id)
    {
        self::atualizar_token();
        $res = BlingApi::enviar_nfe(self::get_credenciais(), $nfe_id);
        if ($res && is_object($res) && isset($res->status) && $res->status > 0) {
            $add = [
                'pedido_id' => $pedido_id,
                'pedido_nf_status' => ($res->status == 1) ? 1 : 2,
                'pedido_nf_chave' => $res->response->chNFe,
            ];
            (new Factory('pedido'))->with($add)->save();
            Http::redirect_to('/pedidos/?success');
        } else {
            $msg = '';
            if (isset($res->response->error->fields[0]->msg)) {
                $msg = $res->response->error->fields[0]->msg;
            }
            Http::redirect_to('/pedidos/?error_enviar_nfe' . $msg);
        }
    }

    /**
     * @method gerar_enviar_nfe
     * @param $pedido  | required
     * @param $produto | required
     * @param $cliente | required
     * @description Vai gerar a NFE na Bling e imediatamente enviar para o SEFAZ
     * @redirect /pedidos/?success
     * @redirect /pedidos/?error_enviar_nfe
     */
    public function gerar_enviar_nfe($pedido, $produto, $cliente)
    {
        self::atualizar_token();
        $data = [
            'pedido' => $pedido,
            'cliente' => $cliente,
            'produtos' => $produto,
        ];
        $res = BlingApi::gerar_nfe(self::get_credenciais(), $data);
        if ($res && is_object($res) && isset($res->status) && $res->status == 1) {
            $add = [
                'pedido_id' => $pedido->pedido_id,
                'pedido_nf_status' => 3,
                'pedido_nf_num_id' => $res->response->id,
                'pedido_nf_serie' => $res->response->serie,
                'pedido_nf_num' => $res->response->numero,
            ];
            (new Factory('pedido'))->with($add)->save();
            self::enviar_nfe($pedido->pedido_id, $res->response->id);
        } else {
            $msg = '';
            if (isset($res->response->error->fields[0]->msg)) {
                $msg = $res->response->error->fields[0]->msg;
            }
            Http::redirect_to('/pedidos/?error_gerar_nfe=' . $msg);
        }
    }

    static function get_credenciais()
    {
        $data = (new Factory('integracao'))->find(1);
        $data->bling_callback_url = self::get_callback_url();
        $data->bling_auth_url = self::get_auth_url($data);
        return $data;
    }

    static function get_auth_url($data)
    {
        $state = uniqid();
        //$redirect_uri = 'https://php81.phpdemo.com.br/flux-shop-teste/';
        $redirect_uri = self::get_callback_url();
        $url = "https://www.bling.com.br/OAuth2/views/authorization.php?response_type=code&client_id=$data->integracao_client_id&redirect_uri=$redirect_uri&state=$state";
        return $url;
    }

    static function get_callback_url()
    {
        $redirect_uri = Http::base() . '/bling/gravar_token/';
        return $redirect_uri;
    }

    /**
     * O token da Bling ele expira em 21600 segundos(6 horas)
     * Esse metodo vai checar quanto tempo falta para expirar o token 
     * @return true | se tiver ainda tiver menos de 5 horas desde que foi criado/atualizado
     * @return false | se tiver ainda tiver 5 horas ou mais desde que foi criado/atualizado
     */
    static public function check_token_timelimit()
    {
        $timestamp_atual = date('Y-m-d H:i:s');
        $refresh = (new Factory('integracao'))
            ->select("integracao_id")
            ->where("integracao_id = 1 AND TIMESTAMPDIFF(HOUR,integracao_datetime_refresh_token,'$timestamp_atual') <= 5")
            ->get();
        $refresh = (isset($refresh[0]) && is_array($refresh)) ? true : false;
        return $refresh;
    }

    static public function get_empresa()
    {
        self::atualizar_token();
        $cred = Bling::get_credenciais();
        $token =  $cred->integracao_token;
        $empresa = BlingApi::empresa($token);
        return $empresa;
    }

    static public function get_produto($id)
    {
        self::atualizar_token();
        $cred = Bling::get_credenciais();
        $token =  $cred->integracao_token;
        $produto = BlingApi::get_produto_by_cod($id, $token);
        return $produto;
    }

    static public function add_produto($produto)
    {
        self::atualizar_token();
        $cred = Bling::get_credenciais();
        $token =  $cred->integracao_token;
        return BlingApi::add_produto($produto, $token);
    }

    static public function sync_produto($produto)
    {
        self::atualizar_token();
        $cred = Bling::get_credenciais();
        $token =  $cred->integracao_token;
        return BlingApi::sync_produto($produto, $token);
    }

    static public function sync_estoque($id, $qtde = 10)
    {
        self::atualizar_token();
        $cred = Bling::get_credenciais();
        $token =  $cred->integracao_token;
        $estoque = BlingApi::get_estoque_by_cod($id, $token);
        if (isset($estoque->id_produto) && isset($estoque->deposito)) {
            return  BlingApi::set_estoque_by_deposito_produto($estoque->deposito, $estoque->id_produto, $qtde, 'B', $token);
        }
    }

    static public function get_nat_op()
    {
        self::atualizar_token();
        $cred = Bling::get_credenciais();
        $token = $cred->integracao_token;
        $nats = BlingApi::natop($token);
        return $nats;
    }

    static public function get_nfe($nfe_id)
    {
        self::atualizar_token();
        Bling::get_credenciais();
        $nfe = BlingApi::get_nfe(self::get_credenciais(), $nfe_id);
        return $nfe;
    }

    public function teste()
    {
        //echo (Bling::modulo_rec('rec4'));        exit;
        self::get_nfe(22298250576);


        exit;
        $pedidos = BlingApi::pedidos($token, $today, $today);
        foreach ($pedidos->data as $ped) {
            $pedido = BlingApi::pedido($token, $ped->id);
            echo "<h1>$ped->id</h1>";
            Filter::pre($pedido->data->itens);
        };
    }
}
