<?php

class Atendimento
{
    public function __construct()
    {
        @session_start();
        (new Install)->check();
        (new Install)->check_tabelas_principais();
    }

    public function indexAction()
    {

        if (isset($_SESSION['captcha'])) {
            unset($_SESSION['captcha']);
        }
        $config = (new Config)->get();
        

        $data = [
            // Menu Superior
            'categorias' => (new CategoriasProdutosFront())->listar(),
            'destaques' => (new CategoriasProdutosFront())->listaSubcategoriasDestaque(),
            'slideSuperior' => (new SlideFront())->listarSlidePrincipal(),
            'paginasTopo' => (new Pagina())->listarPaginasTopo(),
            // Footer
             'paginasFooter' => (new Pagina())->listarPaginasFooter(),
            'faq' => (new Faq())->listaFooter(),
            // Principal
            'config' => $config,
            'social' => (new Config)->getRedesSociais(),
            'mapper' => ['config', 'social', 'params_embed_google'],
        ];


        Tpl::view("tema.loja.atendimento.index", $data, 1);
    }


    public function send()
    {
        if (isset($_SESSION["captcha"]) &&  !empty($_SESSION["captcha"])) {
            $captcha_session = $_SESSION["captcha"];
            unset($_SESSION['captcha']);
            $config = new Config;
            $conf = $config->get();

            $contato_nome = Req::post('contato_nome');
            $contato_email = Req::post('contato_email');
            $contato_telefone = Req::post('contato_telefone');
            $contato_assunto = Req::post('contato_assunto');
            $contato_mensagem = Req::post('contato_mensagem');

            $captcha = Req::post('contato_captcha');
            $contato = (new Config)->getContato();

            $msg = Req::post('mensagem');
            preg_match('/http/', $msg, $m, PREG_OFFSET_CAPTURE);
            if (isset($m[0])) {
                //contem link, não enviado!
                Http::redirect_to("/atendimento/?nao-enviado");
                exit;
            }

            if (isset($captcha) && !empty($captcha) && isset($captcha_session) && !empty($captcha_session) && $captcha_session == $captcha) {

                $conteudo = [
                    'nome' => $contato_nome,
                    'email' => $contato_email,
                    'telefone' => $contato_telefone,
                    'assunto' => $contato_assunto,
                    'mensagem' => $contato_mensagem,
                ];

                $me = [
                    'config' => $conf,
                    'conteudo' => $conteudo,
                    'contato' => $contato,
                    'mapper' => ['config', 'conteudo', 'contato'],
                ];

                $corpo_mensagem =  Tpl::output("email.contato", $me);


                $msg = [
                    'assunto' => "Contato via site",
                    'nome' => $contato_nome,
                    'destinatario' => $contato->contato_email,
                    'mensagem' => $corpo_mensagem,
                ];
                if (Sender::mail($msg)) {
                    Http::redirect_to("/?success");
                } else {
                    Http::redirect_to("/?error");
                }
            } else {
                Http::redirect_to("/atendimento/?captcha");
            }
        } else {
            Http::redirect_to("/atendimento/?captcha");
        }
    }


    public function img_captcha()
    {
        (new Captcha)->img();
    }
}
