const APP_NAME = 'RestauranteWebApp';
const APP_VER = '6.0';
const CACHE_NAME = `${APP_NAME}-${APP_VER}`;

// Somente arquivos LOCAIS usados na página
const REQUIRED_FILES = [
  'index.php',  
  'app_assets/css/style.css',
  'app_assets/css/bootstrap.css',
  'assets/css/custom-restaurant-front.css',
  'manifest.php'
];




// Instala o Service Worker e adiciona arquivos ao cache
self.addEventListener('install', (event) => {
  console.log('✅ Service Worker instalado');

  event.waitUntil(
    caches.open(CACHE_NAME)
      .then(cache => {
        console.log('📦 Cacheando arquivos:', REQUIRED_FILES);
        return cache.addAll(REQUIRED_FILES);
      })
      .then(() => self.skipWaiting())
      .catch(err => console.error('❌ Erro ao adicionar ao cache:', err))
  );
});

// Ativação do SW - LIMPA CACHES ANTIGOS
self.addEventListener('activate', (event) => {
  console.log('✅ Service Worker ativado');
  event.waitUntil(
    caches.keys().then(cacheNames => {
      return Promise.all(
        cacheNames.map(cache => {
          if (cache !== CACHE_NAME) {
            console.log('🗑️ Limpando cache antigo:', cache);
            return caches.delete(cache);
          }
        })
      );
    }).then(() => self.clients.claim())
  );
});

// Intercepta as requisições - SEMPRE BUSCA CSS ATUALIZADO
self.addEventListener('fetch', (event) => {
  const url = event.request.url;
  
  // Para CSS, sempre buscar versão atualizada (não usar cache)
  if (url.includes('.css')) {
    console.log('🎨 CSS - Sempre atualizado:', url);
    event.respondWith(
      fetch(event.request).catch(() => caches.match(event.request))
    );
    return;
  }
  
  console.log('🔄 Interceptando:', url);

  event.respondWith(
    caches.match(event.request)
      .then(response => response || fetch(event.request))
  );
});
