<?php
// DIAGNÓSTICO COMPLETO - RASTREAR ORIGEM DA MENSAGEM

error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "<h1>🔍 DIAGNÓSTICO COMPLETO DO SISTEMA</h1><hr>";

// 1. Verificar conexão com banco
echo "<h2>1. Testando Conexão com Banco de Dados</h2>";
$servidor = 'localhost';
$banco = 'kubonet_sysrestnrt';
$usuario = 'kubonet_srestrnta';
$senha = 'zfEaPzxp6Zs6Wajl';

try {
    $pdo = new PDO("mysql:dbname=$banco;host=$servidor;charset=utf8mb4", "$usuario", "$senha");
    echo "✅ Conectado ao banco: <strong>$banco</strong><br><br>";
} catch (Exception $e) {
    echo "❌ ERRO: " . $e->getMessage() . "<br><br>";
    die();
}

// 2. Verificar configuração da API
echo "<h2>2. Configuração da API WhatsApp</h2>";
$result = $pdo->query("SELECT api_whatsapp, token_whatsapp, instancia_whatsapp FROM config LIMIT 1");
$config = $result->fetch(PDO::FETCH_ASSOC);
echo "API WhatsApp: <strong style='color: " . ($config['api_whatsapp'] == 'Não' ? 'green' : 'red') . "'>" . $config['api_whatsapp'] . "</strong><br>";
echo "Token: <strong>" . (empty($config['token_whatsapp']) ? '(vazio)' : substr($config['token_whatsapp'], 0, 20) . '...') . "</strong><br>";
echo "Instância: <strong>" . (empty($config['instancia_whatsapp']) ? '(vazio)' : $config['instancia_whatsapp']) . "</strong><br><br>";

// 3. Testar se a mensagem vem do MenuIA
echo "<h2>3. Testando Chamada ao MenuIA (SIMULAÇÃO)</h2>";
if ($config['api_whatsapp'] == 'menuia') {
    echo "<span style='color: red; font-weight: bold;'>❌ PERIGO! API está configurada como 'menuia'!</span><br>";
    echo "A mensagem pode estar vindo daqui.<br><br>";
} else {
    echo "✅ API não está configurada como 'menuia'<br><br>";
}

// 4. Verificar arquivos críticos
echo "<h2>4. Verificando Arquivos Críticos</h2>";
$arquivos = [
    'sistema/conexao.php',
    'sistema/index.php',
    'sistema/recuperar-senha.php',
    'sistema/autenticar.php',
    'sistema/painel/apis/texto.php'
];

foreach ($arquivos as $arquivo) {
    $caminho = __DIR__ . '/' . $arquivo;
    if (file_exists($caminho)) {
        $conteudo = file_get_contents($caminho);
        $tem_menuia = (stripos($conteudo, 'menuia') !== false);
        $tem_certificado = (stripos($conteudo, 'certificado venceu') !== false);
        $tem_hugocursos = (stripos($conteudo, 'hugocursos') !== false);
        
        $status = '✅';
        $cor = 'green';
        $msg = 'OK';
        
        if ($tem_certificado && !preg_match('/\/\/.*certificado|bloqueio|filtrar/i', $conteudo)) {
            $status = '❌';
            $cor = 'red';
            $msg = 'CONTÉM A MENSAGEM DO CERTIFICADO!';
        } elseif ($tem_menuia && !preg_match('/if.*false.*menuia|\/\/.*menuia|bloqueio.*menuia/i', $conteudo)) {
            $status = '⚠️';
            $cor = 'orange';
            $msg = 'Contém referência ao MenuIA (pode estar desabilitado)';
        }
        
        echo "$status <strong style='color: $cor;'>$arquivo</strong> - $msg<br>";
    } else {
        echo "❌ <strong style='color: red;'>$arquivo</strong> - ARQUIVO NÃO ENCONTRADO!<br>";
    }
}

echo "<br>";

// 5. Simular requisição de recuperação de senha
echo "<h2>5. Teste de Requisição (SEM EXECUTAR)</h2>";
echo "Para testar se a mensagem vem da recuperação de senha:<br>";
echo "<form action='sistema/recuperar-senha.php' method='POST'>";
echo "<input type='email' name='email' placeholder='Digite um email' required>";
echo "<button type='submit'>Testar Recuperação</button>";
echo "</form><br>";

// 6. Verificar se há chamadas AJAX no JavaScript
echo "<h2>6. Procurando Chamadas AJAX Automáticas</h2>";
$js_files = glob('sistema/assets/js/*.js');
$found_ajax = false;

foreach ($js_files as $js_file) {
    $conteudo = file_get_contents($js_file);
    if (preg_match('/\$\.ajax.*menuia|fetch.*menuia|XMLHttpRequest.*menuia/i', $conteudo)) {
        echo "⚠️ Encontrado em: <strong>$js_file</strong><br>";
        $found_ajax = true;
    }
}

if (!$found_ajax) {
    echo "✅ Nenhuma chamada AJAX ao MenuIA encontrada nos arquivos JavaScript<br>";
}

echo "<br><hr>";
echo "<h2>📊 RESUMO DO DIAGNÓSTICO</h2>";
echo "<ul>";
echo "<li><strong>Banco de Dados:</strong> Conectado</li>";
echo "<li><strong>API WhatsApp:</strong> " . $config['api_whatsapp'] . "</li>";
echo "<li><strong>Arquivos Críticos:</strong> Verificados</li>";
echo "</ul>";

echo "<br><hr>";
echo "<h2>🎯 PRÓXIMO PASSO</h2>";
echo "<p><strong>AGORA FAÇA O TESTE:</strong></p>";
echo "<ol>";
echo "<li>Abra o navegador em modo anônimo (CTRL+SHIFT+N)</li>";
echo "<li>Acesse: <a href='sistema/index.php' target='_blank'>https://kubonet.com.br/restaurante/sistema/index.php</a></li>";
echo "<li>Pressione F12 para abrir o DevTools</li>";
echo "<li>Vá na aba <strong>Network</strong></li>";
echo "<li>Se a mensagem aparecer, veja qual requisição retornou a mensagem</li>";
echo "<li>Me diga qual arquivo apareceu na aba Network quando o alerta surgiu</li>";
echo "</ol>";
?>
