<?php if (intval($data['mostraMeio']) > 0) : ?>
    <section class="${config_site_layout_custom} pt-sm-3 pb-4 pb-md-5" id="div-slide-meio">
        <div class="row">
            <?php if (is_array($data['slideVertical']) && sizeof($data['slideVertical']) > 0) : ?>
                <div class="col-6 d-block d-sm-none d-md-block mb-3">
                    <div class="custom-carousel">
                        <div class="owl-carousel" id="slideVertical">
                            <?php foreach ($data['slideVertical'] as $slide) : ?>
                                <div>
                                    <a style="cursor: pointer;">
                                        <img class="img-banner-vertical" style="object-fit: cover" src="${baseUri}/thumb/slide/?w=400&h=600&f=<?= $slide->slide_img ?>" alt="slide">
                                    </a>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
            <?php if (is_array($data['produtosMaisVendidos']) && sizeof($data['produtosMaisVendidos']) > 0) : ?>
                <div class="col-3 mb-2 py-3 hide-on-vitrine">
                    <div class="widget widget-featured-entries">
                        <h3 class="widget-title font-size-lg custom_loja_texto font_smooth">Mais vendidos</h3>
                        <!-- Loop mais vendidos -->
                        <?php foreach ($data['produtosMaisVendidos'] as $prod) : ?>
                            <div class="media"><a class="featured-entry-thumb" href="${baseUri}/produto/<?= $prod->produto_url ?>"><img src="${baseUri}/thumb/resize/?w=90&h=90&f=<?= $prod->produto_foto ?>" style="height: 65px; width: 65px" alt="produto"></a>
                                <div class="media-body">
                                    <h6 class="featured-entry-title"><a class="custom_loja_texto" href="${baseUri}/produto/<?= $prod->produto_url ?>"><?= $prod->produto_titulo ?></a></h6>
                                    <p class="hide-on-orcamento featured-entry-meta custom_loja_texto">
                                        <?php if ($prod->produto_estoque <= 0) : ?>
                                            <span class="text-primary custom_loja_texto">Indisponível</span>
                                        <?php else : ?>
                                            <?php if ($prod->produto_desconto > 0) : ?>
                                                <span class="custom_loja_texto" style="text-decoration: line-through; color: red !important;">R$ <?= $prod->produto_preco_original ?></span>
                                            <?php endif; ?>
                                            R$ <?= $prod->produto_preco ?>
                                        <?php endif; ?>
                                    </p>
                                </div>
                            </div>
                        <?php endforeach; ?>
                        <!-- Loop mais vendidos -->
                    </div>
                </div>
            <?php endif; ?>

            <?php if (is_array($data['produtosMaisAcessados']) && sizeof($data['produtosMaisAcessados']) > 0) : ?>
                <div class="col-3 mb-2 py-3">
                    <div class="widget widget-featured-entries">
                        <h3 class="widget-title font-size-lg custom_loja_texto font_smooth">Mais acessados</h3>
                        <!-- Loop mais acessados -->
                        <?php foreach ($data['produtosMaisAcessados'] as $prod) : ?>
                            <div class="media"><a class="featured-entry-thumb" href="${baseUri}/produto/<?= $prod->produto_url ?>"><img src="${baseUri}/thumb/resize/?w=90&h=90&f=<?= $prod->produto_foto ?>" style="height: 65px; width: 65px" alt="produto"></a>
                                <div class="media-body">
                                    <h6 class="featured-entry-title"><a class="custom_loja_texto " href="${baseUri}/produto/<?= $prod->produto_url ?>"><?= $prod->produto_titulo ?></a></h6>
                                    <p class="featured-entry-meta hide-on-vitrine hide-on-orcamento custom_loja_texto">
                                        <?php if ($prod->produto_estoque <= 0) : ?>
                                            <span class="custom_loja_texto">Indisponível</span>
                                        <?php else : ?>
                                            <?php if ($prod->produto_desconto > 0) : ?>
                                                <span class="custom_loja_texto" style="text-decoration: line-through; color: red !important;">R$ <?= $prod->produto_preco_original ?></span>
                                            <?php endif; ?>
                                            R$ <?= $prod->produto_preco ?>
                                        <?php endif; ?>
                                    </p>
                                </div>
                            </div>
                        <?php endforeach; ?>
                        <!-- Loop mais acessados -->
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </section>
<?php endif; ?>