$(document).ready(function () {
    if (localStorage.getItem("remember_login")) {
        $("#login_email").val(localStorage.getItem("remember_login"));
        $("#remember_me").attr("checked", "checked").trigger("change");
    }
    let url = window.location.href;
    $("#divCadastro").hide();

    if (url.indexOf("inexistente") != -1) {
        alert_warning(
            "Não foi possível efetuar o login",
            "Email e/ou senha incorreto(s)"
        );
    } else if (url.indexOf("existente") != -1) {
        alert_warning(
            "Não foi possível efetuar o cadastro",
            "Email já está cadastrado"
        );
    }

     $('.celular').mask("(00) 0000-00009");

    // $(".cpf").mask('999.999.999-99');

    var cpfCnpj = function (val) {
            if (val.replace(/\D/g, "").length > 11) {
                $("#div-dt-nasc").hide();
                $("#cliente_nascimento").removeAttr("required");
            } else {
                $("#div-dt-nasc").show();
                $("#cliente_nascimento").attr("required", "required");
            }

            return val.replace(/\D/g, "").length > 11
                ? "00.000.000/0000-00"
                : "000.000.000-009";
        },
        cpfOptions = {
            onKeyPress: function (val, e, field, options) {
                field.mask(cpfCnpj.apply({}, arguments), options);
            },
        };
    $(".cpfCnpj").mask(cpfCnpj, cpfOptions);
});

function validaForm(form) {
    if ($("#cliente_senha").val() != $("#cliente_senha2").val()) {
        alert_warning("As senhas são diferentes!");
        $("#cliente_senha").focus();
        return false;
    } else {
        return true;
    }
}

$("#cliente_cpf").change(function () {
    let cpfcnpj = $("#cliente_cpf").replace(/\D/g, "").val().length;
    let cpf = $("#cliente_cpf").val();

    if (cpfcnpj > 11) {
        if (!validarCNPJ(cpf)) {
            alert_warning("CNPJ Inválido!");
            $("#cliente_cpf").val("").focus();
        }
    } else {
        if (!validarCPF(cpf)) {
            alert_warning("CPF Inválido!");
            $("#cliente_cpf").val("").focus();
        }
    }
});

function changeView(id) {
    if (id == "cadastro") {
        $("#divLogin").attr("style", "display: none");
        $("#divCadastro").attr("style", "display: block");
    } else {
        $("#divLogin").attr("style", "display: block");
        $("#divCadastro").attr("style", "display: none");
    }
}

function lembrar_me() {
    let valor = document.getElementById("remember_me").checked;
    if (valor) {
        localStorage.setItem("remember_login", $("#login_email").val());
    } else {
        localStorage.removeItem("remember_login");
    }
}

function envia_email_recupera_senha() {
    $("#btn-email-enviar").addClass("d-none");
    $("#btn-email-enviando").removeClass("d-none");
    let email = $("#email_recupera_senha").val().trim();
    let url = baseUri + "/Index/envia_email_recupera_senha";

    if (email == "") {
        alert_warning("Preencha o email!");
        $("#email_recupera_senha").focus();
        return false;
    }

    $.post(url, { cliente_email: email }).then((res) => {
        console.log(res);
        res = JSON.parse(res);
        if (res.status != undefined) {
            let status = res.status;
            switch (status) {
                case 200:
                    alert_success(
                        "O email de recuperação foi enviado. Por favor, verifique a caixa de entrada e a caixa de span do seu email!"
                    );
                    $("#btn-email-enviando").addClass("d-none");
                    $("#btn-email-enviado").removeClass("d-none");
                    $("#modalRecuperaSenha").modal("hide");
                    break;
                case 501:
                    alert_warning("Um erro ocorreu ao enviar o email");
                    $("#btn-email-enviando").addClass("d-none");
                    $("#btn-email-enviar").removeClass("d-none");
                    break;
                case 404:
                    alert_warning("Email não encontrado!");
                    $("#btn-email-enviando").addClass("d-none");
                    $("#btn-email-enviar").removeClass("d-none");
                    break;
                case 401:
                    alert_warning("Preencha o email!");
                    $("#btn-email-enviando").addClass("d-none");
                    $("#btn-email-enviar").removeClass("d-none");
                    break;
                default:
                    alert_warning("Um erro ocorreu ao enviar o email");
                    $("#btn-email-enviando").addClass("d-none");
                    $("#btn-email-enviar").removeClass("d-none");
                    break;
            }
        }
    });
}

$("#email_recupera_senha").keyup(function (e) {
    if (e.keyCode == 13) {
        envia_email_recupera_senha();
    }
});
