var vm = new Vue({
    el: "#vm",
    data: {
        cupom: null,
        frete: null,
        totalProdutos: null,
        totalCompra: null,
        totalCompraSemFormatacao: null,
        cardIsValid: false,
        loadingPage: true, // pode ser usado para uma splash screen
        validandoCartao: false,
        descontoBoleto: false,
        valorDescontoBoleto: null,
        totalBoleto: null,
        // selects e opções adicionais
        anos: [],
        campos_extras: null,
        produtos_carrinho: null,
    },
    methods: {
        get_produtos_carrinho: () => {
            let url = baseUri + "/carrinho/getCarrinho";
            $.post(url).then((res) => {
                if (res) {
                    res = JSON.parse(res);
                    vm.produtos_carrinho = res.carrinho;
                } else {
                    vm.produtos_carrinho = null;
                }
            });
        },
        get_campos_extras: () => {
            let url = baseUri + "/CamposExtras/get_campos_extras";
            $.post(url).then((res) => {
                res = JSON.parse(res);

                if (res.status != undefined && res.status == 200) {
                    vm.campos_extras = res.campos;
                } else {
                    // Redirect para tela de carrinho, pois não tem nenhum item no carrinho
                }
            });
        },
        get_respostas_campos_extras: () => {
            if (vm.campos_extras != null) {
                let respostas = [];
                $(".campos_checkout").each((i, el) => {
                    let id = $(el).data("id");
                    let pergunta = $(el).data("pergunta");
                    let resposta = $(el).val();
                    if (resposta.trim() == "") {
                        alert_error(
                            "Responda todas as perguntas para prosseguir"
                        );
                        $(el).focus();
                        return false;
                    }
                    respostas.push({
                        campo_checkout_id: id,
                        pergunta: pergunta,
                        resposta: resposta,
                    });
                });

                return respostas;
            }
        },

        // -- verifica se existe um cupom com os valores digitados pelo usuário
        verifyCupom: () => {
            $("#msgCupom").html("");
            let cupom = $("#cupomValue").val().trim();
            if (cupom == "") {
                $("#cupomValue")
                    .attr("placeholder", "PREENCHA O CAMPO")
                    .val("")
                    .attr("style", "border: 1px solid red");
            } else {
                let url = baseUri + "/CupomFront/getCupom";

                $.post(url, { cupom: cupom }).then((res) => {
                    res = JSON.parse(res);
                    if (res.error == null) {
                        vm.cupom = res.cupom;
                        if (vm.cupom.cupom_desconto > 0) {
                            $(".valorCupom").html(
                                `${vm.cupom.cupom_desconto} %`
                            );
                            if (vm.frete != null) {
                                vm.totalCompraSemFormatacao =
                                    Number(vm.totalProdutos) -
                                    Number(vm.totalProdutos) *
                                        (vm.cupom.cupom_desconto / 100);
                                if (vm.totalCompra < 0) {
                                    vm.totalCompraSemFormatacao = Number(
                                        vm.frete.price
                                    );
                                } else {
                                    vm.totalCompraSemFormatacao += Number(
                                        vm.frete.price
                                    );
                                }
                            } else {
                                vm.totalCompraSemFormatacao =
                                    Number(vm.totalProdutos) -
                                    Number(vm.totalProdutos) *
                                        (vm.cupom.cupom_desconto / 100);
                                if (vm.totalCompraSemFormatacao < 0) {
                                    vm.totalCompraSemFormatacao = Number(0);
                                }
                            }
                        } else {
                            $(".valorCupom").html(
                                `${Number(vm.cupom.cupom_real).toLocaleString(
                                    "pt-BR",
                                    { style: "currency", currency: "BRL" }
                                )}`
                            );

                            if (vm.frete != null) {
                                vm.totalCompraSemFormatacao =
                                    Number(vm.totalProdutos) -
                                    Number(vm.cupom.cupom_real);
                                if (vm.totalCompraSemFormatacao < 0) {
                                    vm.totalCompraSemFormatacao = Number(
                                        vm.frete.price
                                    );
                                } else {
                                    vm.totalCompraSemFormatacao += Number(
                                        vm.frete.price
                                    );
                                }
                            } else {
                                vm.totalCompraSemFormatacao =
                                    Number(vm.totalProdutos) -
                                    Number(vm.cupom.cupom_real);
                                if (vm.totalCompraSemFormatacao < 0) {
                                    vm.totalCompraSemFormatacao = Number(0);
                                }
                            }
                        }
                        $("#cupomValue")
                            .attr("placeholder", "CUPOM APLICADO")
                            .val("")
                            .attr("style", "border: 1px solid green");
                    } else {
                        vm.cupom = null;
                        if (vm.frete != null) {
                            vm.totalCompraSemFormatacao =
                                Number(vm.totalProdutos) +
                                Number(vm.frete.price);
                        } else {
                            vm.totalCompraSemFormatacao = Number(
                                vm.totalProdutos
                            );
                        }
                        $(".valorCupom").html("&mdash;");
                        $("#cupomValue")
                            .attr("placeholder", res.error)
                            .val("")
                            .attr("style", "border: 1px solid red");
                    }
                    if (!isNaN(vm.totalCompraSemFormatacao)) {
                        vm.totalCompra = Number(
                            vm.totalCompraSemFormatacao
                        ).toLocaleString("pt-BR", {
                            style: "currency",
                            currency: "BRL",
                        });
                    }

                    vm.inicializaMercadoPago(1);
                });
            }
        },
        // Verifica se existe um cupom já setado para aplicar desconto
        getCupom: () => {
            let url = baseUri + "/FreteFront/getValorCupom";

            $.post(url).then((res) => {
                if (res != null && res != "") {
                    res = JSON.parse(res);
                    if (res.cupom != undefined) {
                        vm.cupom = res.cupom;

                        if (vm.cupom.cupom_desconto > 0) {
                            // Desconto percentual
                            $(".valorCupom").html(
                                `${vm.cupom.cupom_desconto} %`
                            );
                            if (vm.frete != null) {
                                vm.totalCompraSemFormatacao =
                                    Number(vm.totalProdutos) -
                                    Number(vm.totalProdutos) *
                                        (vm.cupom.cupom_desconto / 100) +
                                    Number(vm.frete.price);
                            } else {
                                vm.totalCompraSemFormatacao =
                                    Number(vm.totalProdutos) -
                                    Number(vm.totalProdutos) *
                                        (vm.cupom.cupom_desconto / 100);
                            }

                            vm.totalCompra =
                                vm.totalCompraSemFormatacao.toLocaleString(
                                    "pt-BR",
                                    { style: "currency", currency: "BRL" }
                                );
                        } else {
                            // Desconto em real
                            $(".valorCupom").html(
                                `${Number(vm.cupom.cupom_real).toLocaleString(
                                    "pt-BR",
                                    { style: "currency", currency: "BRL" }
                                )}`
                            );
                            if (vm.frete != null) {
                                vm.totalCompra =
                                    Number(vm.totalProdutos) -
                                    Number(vm.cupom.cupom_real);
                                if (vm.totalCompra < 0) {
                                    vm.totalCompraSemFormatacao = Number(
                                        vm.frete.price
                                    );
                                } else {
                                    vm.totalCompraSemFormatacao += Number(
                                        vm.frete.price
                                    );
                                }
                            } else {
                                vm.totalCompraSemFormatacao =
                                    Number(vm.totalProdutos) -
                                    Number(vm.cupom.cupom_real);
                                if (vm.totalCompraSemFormatacao < 0) {
                                    vm.totalCompraSemFormatacao = 0;
                                }
                            }
                        }
                    }
                }
                if (vm.totalCompraSemFormatacao > 0) {
                    vm.totalCompra = vm.totalCompraSemFormatacao.toLocaleString(
                        "pt-BR",
                        { style: "currency", currency: "BRL" }
                    );
                }
            });
        },

        // --frete
        getFrete: () => {
            let url = baseUri + "/FreteFront/getValorFrete";

            $.post(url).then((res) => {
                if (res != null && res != "") {
                    res = JSON.parse(res);
                    if (res.frete != undefined) {
                        vm.frete = res.frete;
                        $(".valorFrete").html(
                            `${Number(vm.frete.price).toLocaleString("pt-BR", {
                                style: "currency",
                                currency: "BRL",
                            })}`
                        );
                        /*
                        vm.totalCompraSemFormatacao =
                            Number(vm.totalProdutos) + Number(vm.frete.price);
                        console.log("total" + vm.totalCompraSemFormatacao);
                        vm.totalCompra =
                            vm.totalCompraSemFormatacao.toLocaleString(
                                "pt-BR",
                                { style: "currency", currency: "BRL" }
                            );
                            */
                    }
                }
            });
        },

        goToFrete: () => {
            let url = baseUri + "/FreteFront/clearFrete";
            $.post(url).then((res) => {
                if (res.trim() == "1") {
                    window.location.href = baseUri + "/checkout";
                }
            });
        },
        paymentBoleto: () => {
            if (vm.campos_extras != null) {
                let respostas = vm.get_respostas_campos_extras();

                if (respostas.length == vm.campos_extras.length) {
                    let data = {
                        cupom: vm.cupom,
                        frete: vm.frete,
                        metodo: "boleto",
                        respostas: respostas,
                    };
                    let url = baseUri + "/PagamentoFront/payment";
                    $("#modalProcessandoPagamento").modal("show");
                    $.post(url, data).then((res) => {
                        if (res != null) {
                            res = JSON.parse(res);
                            if (res.redirect != null) {
                                window.location.href = res.redirect;
                            } else if (res.error) {
                                $("#modalProcessandoPagamento").modal("hide");
                                alert_warning(res.error);
                            } else if (res.pedido_id != undefined) {
                                window.location.href =
                                    baseUri +
                                    "/pedido-detalhes/" +
                                    res.pedido_id;
                            }
                        }
                    });
                }
            } else {
                let data = {
                    cupom: vm.cupom,
                    frete: vm.frete,
                    metodo: "boleto",
                };
                let url = baseUri + "/PagamentoFront/payment";
                $("#modalProcessandoPagamento").modal("show");
                $.post(url, data).then((res) => {
                    if (res != null) {
                        res = JSON.parse(res);
                        if (res.redirect != null) {
                            window.location.href = res.redirect;
                        } else if (res.error) {
                            $("#modalProcessandoPagamento").modal("hide");
                            alert_warning(res.error);
                        } else if (res.pedido_id != undefined) {
                            window.location.href =
                                baseUri + "/pedido-detalhes/" + res.pedido_id;
                        }
                    }
                });
            }
        },
        paymentDeposito: () => {
            if (vm.campos_extras != null) {
                let respostas = vm.get_respostas_campos_extras();

                if (respostas.length == vm.campos_extras.length) {
                    let data = {
                        cupom: vm.cupom,
                        frete: vm.frete,
                        metodo: "deposito",
                        respostas: respostas,
                    };
                    let url = baseUri + "/PagamentoFront/payment";
                    $("#modalProcessandoPagamento").modal("show");
                    $.post(url, data).then((res) => {
                        if (res != null) {
                            res = JSON.parse(res);
                            if (res.redirect != null) {
                                window.location.href = res.redirect;
                            } else if (res.error) {
                                $("#modalProcessandoPagamento").modal("hide");
                                alert_warning(res.error);
                            } else if (res.pedido_id != undefined) {
                                window.location.href =
                                    baseUri +
                                    "/pedido-detalhes/" +
                                    res.pedido_id;
                            }
                        }
                    });
                }
            } else {
                let data = {
                    cupom: vm.cupom,
                    frete: vm.frete,
                    metodo: "deposito",
                };
                let url = baseUri + "/PagamentoFront/payment";
                $("#modalProcessandoPagamento").modal("show");
                $.post(url, data).then((res) => {
                    if (res != null) {
                        res = JSON.parse(res);
                        if (res.redirect != null) {
                            window.location.href = res.redirect;
                        } else if (res.error) {
                            $("#modalProcessandoPagamento").modal("hide");
                            alert_warning(res.error);
                        } else if (res.pedido_id != undefined) {
                            window.location.href =
                                baseUri + "/pedido-detalhes/" + res.pedido_id;
                        }
                    }
                });
            }
        },
        paymentPix: () => {
            if (vm.campos_extras != null) {
                let respostas = vm.get_respostas_campos_extras();

                if (respostas.length == vm.campos_extras.length) {
                    let data = {
                        cupom: vm.cupom,
                        frete: vm.frete,
                        metodo: "pix",
                        respostas: respostas,
                    };
                    let url = baseUri + "/PagamentoFront/payment";
                    $("#modalProcessandoPagamento").modal("show");
                    $.post(url, data).then((res) => {
                        if (res != null) {
                            res = JSON.parse(res);
                            if (res.redirect != null) {
                                window.location.href = res.redirect;
                            } else if (res.error) {
                                $("#modalProcessandoPagamento").modal("hide");
                                alert_warning(res.error);
                            } else if (res.pedido_id != undefined) {
                                window.location.href =
                                    baseUri +
                                    "/pedido-pagar-pix/" +
                                    res.pedido_id;
                            }
                        }
                    });
                }
            } else {
                let data = {
                    cupom: vm.cupom,
                    frete: vm.frete,
                    metodo: "pix",
                };
                let url = baseUri + "/PagamentoFront/payment";
                $("#modalProcessandoPagamento").modal("show");
                $.post(url, data).then((res) => {
                    if (res != null) {
                        res = JSON.parse(res);
                        if (res.redirect != null) {
                            window.location.href = res.redirect;
                        } else if (res.error) {
                            $("#modalProcessandoPagamento").modal("hide");
                            alert_warning(res.error);
                        } else if (res.pedido_id != undefined) {
                            window.location.href =
                                baseUri + "/pedido-pagar-pix/" + res.pedido_id;
                        }
                    }
                });
            }
        },
        payment: () => {
            if (vm.campos_extras != null) {
                let respostas = vm.get_respostas_campos_extras();

                if (respostas.length == vm.campos_extras.length) {
                    $("#modalProcessandoPagamento").modal("show");
                    let cardToken = $("#card_token").val();
                    let parcelas = $("#card_parcela").val();
                    let cardholderName = $("#cardholderName").val();
                    let doc = $("#docNumber").val();
                    let paymentMethodId = $("#paymentMethodId").val();

                    // variavel enviada para o php
                    let data = {
                        card_token: cardToken,
                        cardholderName: cardholderName,
                        docNumberFake: doc,
                        card_parcela: parcelas,
                        paymentMethodId: paymentMethodId,
                        cupom: vm.cupom,
                        frete: vm.frete,
                        metodo: "cartao",
                        respostas: respostas,
                    };

                    // request para salvar o pedido, efetuar o pagamento no mp e redireciona para o detalhes do pedido
                    let url = baseUri + "/PagamentoFront/payment";
                    $.post(url, data).then((res) => {
                        if (res != null) {
                            res = JSON.parse(res);
                            if (res.redirect != null) {
                                window.location.href = res.redirect;
                            } else if (res.error) {
                                $("#modalProcessandoPagamento").modal("hide");
                                alert_warning(res.error);
                            } else if (res.pedido_id != undefined) {
                                window.location.href =
                                    baseUri +
                                    "/pedido-detalhes/" +
                                    res.pedido_id;
                            }
                        }
                    });
                }
            } else {
                $("#modalProcessandoPagamento").modal("show");
                let cardToken = $("#card_token").val();
                let parcelas = $("#card_parcela").val();
                let cardholderName = $("#cardholderName").val();
                let doc = $("#docNumber").val();
                let paymentMethodId = $("#paymentMethodId").val();

                // variavel enviada para o php
                let data = {
                    card_token: cardToken,
                    cardholderName: cardholderName,
                    docNumberFake: doc,
                    card_parcela: parcelas,
                    paymentMethodId: paymentMethodId,
                    cupom: vm.cupom,
                    frete: vm.frete,
                    metodo: "cartao",
                };

                // request para salvar o pedido, efetuar o pagamento no mp e redireciona para o detalhes do pedido
                let url = baseUri + "/PagamentoFront/payment";
                $.post(url, data).then((res) => {
                    if (res != null) {
                        res = JSON.parse(res);
                        if (res.redirect != null) {
                            window.location.href = res.redirect;
                        } else if (res.error) {
                            $("#modalProcessandoPagamento").modal("hide");
                            alert_warning(res.error);
                        } else if (res.pedido_id != undefined) {
                            window.location.href =
                                baseUri + "/pedido-detalhes/" + res.pedido_id;
                        }
                    }
                });
            }
        },
        inicializaMercadoPago: (reload = false) => {
            var public_key = $("#pay_key").val();
            //console.log(vm);
            // Transforma o total em numérico (float)
            vm.totalCompraSemFormatacao =
                Number(vm.totalProdutos) + Number(vm.frete.price);
            vm.totalCompra =
                Number(vmCarrinho.subtotal) + Number(vm.frete.price);
            let total = vm.totalCompraSemFormatacao;
            if (!total) total = vm.totalCompra;
            if (!isNaN(vm.totalCompra)) {
                vm.totalCompra = Number(vm.totalCompra).toLocaleString(
                    "pt-BR",
                    { style: "currency", currency: "BRL" }
                );
            }
            // Verificação se existe desconto no boleto
            if (parseInt($("#desconto_boleto").val()) > 0) {
                vm.descontoBoleto = true;
                vm.valorDescontoBoleto = Number($("#desconto_boleto").val());
                vm.totalBoleto = total - total * (vm.valorDescontoBoleto / 100);
            } else {
                vm.totalBoleto = total;
            }
            $("#transactionAmount").val(total);

            var cpfCnpj = function (val) {
                    return val.replace(/\D/g, "").length > 11
                        ? "00.000.000/0000-00"
                        : "000.000.000-009";
                },
                cpfOptions = {
                    onKeyPress: function (val, e, field, options) {
                        field.mask(cpfCnpj.apply({}, arguments), options);
                    },
                };
            $(".cpfCnpj").mask(cpfCnpj, cpfOptions);
            if (reload) {
                var bin = $("#cardNumber").val();
                bin = bin.replace(/\s/g, "");
                // var bin = bin.substring(0,3);
                getPaymentMethod(bin);
                return true;
            }
            Mercadopago.setPublishableKey(public_key);
            Mercadopago.getIdentificationTypes();

            $("#docNumber2").blur(function () {
                let documento = $("#docNumber2").val();

                documento = documento
                    .split(".")
                    .join("")
                    .split("-")
                    .join("")
                    .split("/")
                    .join("");
                $("#docNumber").val(documento);
            });
            $("#cardNumber").on("change", function () {
                var bin = $("#cardNumber").val();
                bin = bin.replace(/\s/g, "");
                // var bin = bin.substring(0,3);
                getPaymentMethod(bin);
            });

            $(".cardField").on("change", function () {
                vm.cardIsValid = false;
            });

            function getPaymentMethod(bin) {
                Mercadopago.getPaymentMethod(
                    {
                        bin: bin,
                    },
                    setPaymentMethodInfo
                );
                var val_total = total;
                // parcelas
                Mercadopago.getInstallments(
                    {
                        bin: bin,
                        amount: val_total,
                    },
                    setInstallmentInfo
                );
            }

            $("#docNumberFake").on("keyup", function () {
                var number = $("#docNumberFake").val();
                var desired = number.replace(/[^a-z0-9 -]/g, "");
                desired = desired.replace(/-/g, "");
                desired = desired.replace(/\s+/g, "");
                $("#docNumber").val(desired);
            });

            function setPaymentMethodInfo(status, response) {
                if (status == 200) {
                    $("#paymentMethodId").val(response[0].id);
                }
            }

            function setInstallmentInfo(status, response) {
                if (status == 200) {
                    var issuer_id = response[0].issuer.id;
                    $("#issuer_id").val(issuer_id);
                    var parcelas = response[0].payer_costs;
                    fill_parcelas(parcelas);
                }
            }

            function fill_parcelas(parcelamento) {
                $("#card_parcela option").remove();
                let maxInstallments = $("#maxInstallments").val();
                $.each(parcelamento, function (k, v) {
                    if (k < maxInstallments) {
                        $("<option />")
                            .attr(
                                "data-amount",
                                parseFloat(v.total_amount).toFixed(2)
                            )
                            .val(v.installments)
                            .text(v.recommended_message)
                            .appendTo($("#card_parcela"));
                    }

                    $("#card_parcela").trigger("change");
                });
            }

            $("#verificar-dados").on("click", function (event) {
                vm.validandoCartao = true;
                var $form = document.querySelector("#pay");
                Mercadopago.createToken($form, sdkResponseHandler); // The function "sdkResponseHandler" is defined below
            });

            function sdkResponseHandler(status, response) {
                $(".error-signal-secury").addClass("hide");
                $(".error-signal-cardN").addClass("hide");
                $(".error-signal-ano").addClass("hide");
                $(".error-signal-mes").addClass("hide");
                $(".error-signal-cardName").addClass("hide");
                $(".error-signal-doc").addClass("hide");
                if (status != 200 && status != 201) {
                    var error = response.cause;
                    //console.log(error);
                    $("#msg-error").removeClass("hide");
                    $.each(error, function (key, item) {
                        var code = item.code;
                        switch (code) {
                            case "325":
                                $("#cardExpirationMonth").val("");
                                $(".error-signal-mes").removeClass("hide");
                                alert_warning("Mês de validade inválido");
                                break;
                            case "326":
                                $("#cardExpirationYear").val("");
                                $(".error-signal-ano").removeClass("hide");
                                alert_warning("Ano de validade inválido");
                                break;
                            case "E301":
                                $("#cardNumber").val("");
                                $(".error-signal-cardN").removeClass("hide");
                                alert_warning("Número do cartão inválido");
                                break;
                            case "E302":
                                $("#securityCode").val("");
                                $(".error-signal-secury").removeClass("hide");
                                alert_warning("Código de segurança inválido");
                                break;
                            case "316":
                                $("#cardholderName").val("");
                                $(".error-signal-cardName").removeClass("hide");
                                alert_warning("Titular do cartão inválido");
                                break;
                            case "324":
                                $("#docNumber").val("");
                                $("#docNumberFake").val("");
                                $(".error-signal-doc").removeClass("hide");
                                alert_warning("CPF/CNPJ inválido");
                                break;
                            default:
                                alert_warning("Dados de cartão inválidos!");
                                break;
                        }
                    });

                    vm.cardIsValid = false;
                } else {
                    vm.cardIsValid = true;
                    $("#card_token").val(response.id);
                    $("#msg-error").addClass("hide");
                    $("#verificar-dados").toggleClass("hide");
                    $("#comprar-creditos-true").toggleClass("hide");
                }
                vm.validandoCartao = false;
            }

            new Card({
                form: document.getElementById("pay"),
                formSelectors: {
                    numberInput: 'input[name="cardNumber"]',
                    expiryInput: 'input[name=""]',
                    cvcInput: 'input[name="securityCode"]',
                    nameInput: 'input[name="cardholderName"]',
                },
                placeholders: {
                    number: "•••• •••• •••• ••••",
                    name: "Nome do Titular",
                    expiry: "••/••",
                    cvc: "•••",
                },
                container: ".card-wrapper",
            });
            // $('#docNumberFake').mask('999.999.999-99 000');
            // $("#cardNumber").mask('9999 9999 9999 9999');
            // $('#documento').mask('999.999.999-99 000');

            if (!reload) {
                vm.loadingPage = false;
            }
        },
    },
    created: function () {
        this.get_campos_extras();
        this.get_produtos_carrinho();
        setTimeout(() => {
            this.getFrete();
            this.getCupom();
        }, 1500);

        setTimeout(() => {
            $("#cep").mask("99999-999");
            $(".two-numbers").mask("99");
            $(".numbers").mask("999999");
            this.totalProdutos = vmCarrinho.subtotal;
            this.totalCompra = vmCarrinho.subtotal;
            this.inicializaMercadoPago();
        }, 2000);

        let anoAtual = new Date().getFullYear();
        for (let i = anoAtual; i < anoAtual + 10; i++) {
            this.anos.push(i);
        }
    },
});
