var vm = new Vue({
    el: "#vm",
    data: {
        enderecos: null,
        opcoesRetirada: null,
        opcoesFrete: null,
        loadingFrete: false,
        frete: null,
        retirada: null,
        cupom: null,
        totalProdutos: null,
        totalCompra: null,
        endSetado: null,
        produtos_carrinho: null,
    },
    methods: {
        get_produtos_carrinho: () => {
            let url = baseUri + "/carrinho/getCarrinho";
            $.post(url).then((res) => {
                if (res) {
                    res = JSON.parse(res);
                    vm.produtos_carrinho = res.carrinho;
                } else {
                    vm.produtos_carrinho = null;
                }
            });
        },
        listarEnderecos: () => {
            let url = baseUri + "/ClienteFront/listarEndereco";
            $.post(url).then((res) => {
                if (res != null) {
                    vm.enderecos = JSON.parse(res);
                } else {
                    vm.enderecos = null;
                }
            });
        },
        changeEndereco: (end) => {
            $(".radioEndereco, .radioRetirada")
                .attr("checked", false)
                .trigger("change");
            vm.retirada = null;
            $("#endereco" + end.endereco_cliente_id)
                .attr("checked", true)
                .trigger("change");
            vm.endSetado = end.endereco_cliente_id;
            vm.listarOpcoesFrete(end);
        },
        redirectEndereco: () => {
            let url = baseUri + "/FreteFront/goToEndereco";
            $.post(url).then((res) => {
                window.location.href = baseUri + "/adicionar-endereco";
            });
        },
        // -- Retirada --
        listarRetirada: () => {
            let url = baseUri + "/ClienteFront/listarRetirada";
            $.post(url).then((res) => {
                if (res != null) {
                    vm.opcoesRetirada = JSON.parse(res);
                } else {
                    vm.opcoesRetirada = null;
                }
            });
        },
        changeRetirada: (ret) => {
            $(".radioRetirada, .radioFrete")
                .attr("checked", false)
                .trigger("change");
            $("#retirada" + ret.retirada_id)
                .attr("checked", true)
                .trigger("change");
            vm.retirada = ret;
            vm.frete = null;
            $(".valorFrete").html(`&mdash;`);
            vm.totalCompra = Number(vm.totalProdutos);
            vm.totalCompra = vm.totalCompra.toLocaleString("pt-BR", {
                style: "currency",
                currency: "BRL",
            });
        },
        // -- Frete --
        listarOpcoesFrete: (end) => {
            let url = baseUri + "/FreteFront/get_frete";
            vm.loadingFrete = true;
            vm.opcoesFrete = null;
            $.post(url, { cep: end.endereco_cliente_cep }).then((res) => {
                if (res != null) {
                    let result = JSON.parse(res);
                    if (result.error != undefined) {
                        alert_warning(result.error);
                        vm.loadingFrete = false;
                    } else {
                        result.map((r, i) => {
                            result[i].price =
                                $("#frete_gratis").val() == "1"
                                    ? "0.00"
                                    : Number(result[i].price).toFixed(2);
                        });
                        vm.opcoesFrete = result[0];
                        vm.loadingFrete = false;
                    }
                }
            });
        },
        setFrete: (frete) => {
            vm.retirada = null;
            $(".radioRetirada, .radioFrete")
                .attr("checked", false)
                .trigger("change");
            $("#frete" + frete.code)
                .attr("checked", true)
                .trigger("change");
            vm.frete = frete;
            $(".valorFrete").html(
                `${Number(vm.frete.price).toLocaleString("pt-BR", {
                    style: "currency",
                    currency: "BRL",
                })}`
            );
            vm.totalCompra = Number(vm.totalProdutos) + Number(vm.frete.price);
            vm.totalCompra = vm.totalCompra.toLocaleString("pt-BR", {
                style: "currency",
                currency: "BRL",
            });
        },
        // -- Cupom
        getCupom: () => {
            $("#msgCupom").html("");
            let cupom = $("#cupomValue").val().trim();
            if (cupom == "") {
                $("#msgCupom")
                    .attr("class", "text-danger")
                    .html("Preencha o campo");
            } else {
                let url = baseUri + "/CupomFront/getCupom";
                $.post(url, { cupom: cupom }).then((res) => {
                    res = JSON.parse(res);
                    if (res.error == null) {
                        vm.cupom = res.cupom;
                        if (vm.cupom.cupom_desconto > 0) {
                            $(".valorCupom").html(
                                `${vm.cupom.cupom_desconto} %`
                            );
                        } else {
                            $(".valorCupom").html(
                                `${vm.cupom.cupom_real.toLocaleString("pt-BR", {
                                    style: "currency",
                                    currency: "BRL",
                                })}`
                            );
                        }
                        $("#msgCupom")
                            .attr("class", "text-success")
                            .html("Cupom encontrado");
                    } else {
                        vm.cupom = null;
                        $(".valorCupom").html("&mdash;");
                        $("#msgCupom")
                            .attr("class", "text-danger")
                            .html(res.error);
                    }
                });
            }
        },
        // -- Pagamento na loja configurada para apenas Entrega
        pagamentoEntrega: () => {
            // se não tiver frete
            if (vm.frete == null) {
                alert_warning("Escolha uma opção de frete!");
            } else {
                let url = baseUri + "/FreteFront/goToPagamentoEntrega";
                $.post(url, {
                    frete: vm.frete,
                    cupom: vm.cupom,
                    endereco: vm.endSetado,
                }).then((res) => {
                    if (res.trim() == "1") {
                        window.location.href = baseUri + "/checkout";
                    } else if (res.trim() == "-1") {
                        alert_warning("Escolha uma opção de frete!");
                    }
                });
            }
        },
        // -- Pagamento na loja configurada para apenas retirada
        pagamentoRetirada: () => {
            // se não tiver frete
            if (vm.retirada == null) {
                alert_warning("Escolha uma opção de retirada!");
            } else {
                let url = baseUri + "/FreteFront/goToPagamentoRetirada";
                $.post(url, { retirada: vm.retirada, cupom: vm.cupom }).then(
                    (res) => {
                        if (res.trim() == "1") {
                            window.location.href = baseUri + "/checkout";
                        } else if (res.trim() == "-1") {
                            alert_warning("Escolha uma opção de retirada!");
                        }
                    }
                );
            }
        },
        // -- Pagamento na loja configurada para entrega ou retirada
        pagamentoEntregaRetirada: () => {
            // se não tiver frete
            if (vm.frete == null && vm.retirada == null) {
                alert_warning("Escolha uma opção de frete ou de retirada!");
            } else if (vm.frete != null) {
                let url = baseUri + "/FreteFront/goToPagamentoEntrega";
                $.post(url, {
                    frete: vm.frete,
                    cupom: vm.cupom,
                    endereco: vm.endSetado,
                }).then((res) => {
                    if (res.trim() == "1") {
                        window.location.href = baseUri + "/checkout";
                    } else if (res.trim() == "-1") {
                        alert_warning("Escolha uma opção de frete!");
                    }
                });
            } else {
                let url = baseUri + "/FreteFront/goToPagamentoRetirada";
                $.post(url, { retirada: vm.retirada, cupom: vm.cupom }).then(
                    (res) => {
                        if (res.trim() == "1") {
                            window.location.href = baseUri + "/checkout";
                        } else if (res.trim() == "-1") {
                            alert_warning("Escolha uma opção de retirada!");
                        }
                    }
                );
            }
        },
    },
    created: function () {
        this.listarEnderecos();
        this.listarRetirada();
        this.get_produtos_carrinho();
        setTimeout(() => {
            $("#cep").mask("99999-999");

            this.totalProdutos = vmCarrinho.subtotal;
            this.totalCompra = vmCarrinho.subtotal.toLocaleString("pt-BR", {
                style: "currency",
                currency: "BRL",
            });
        }, 500);
    },
});
