<!DOCTYPE html>
<html lang="pt-br">
<head>
    <title>${config_site_title}<?php if (isset($data['config']->config_site_slogan) && 
!empty($data['config']->config_site_slogan)): ?> - ${config_site_slogan}<?php endif;?></title>
@(tema.loja.partials.meta_tags)
@(tema.loja.partials.og_tags)
    <link rel="icon" type="image/png" sizes="32x32" href="${baseUri}/media/site/${config_site_favicon}">
@(tema.loja.partials.css-padrao)
</head>
<body>
    @(tema.loja.partials.google_analytics)
    @(tema.loja.partials.google_tag_manager)
    @(tema.loja.partials.menu-superior)
    <div class="hide-on-desk" style="position: relative; margin-top: 100px !important"></div>
    <section class="${config_site_layout_custom} pt-4 pb-4">
        <div class="row">
            <div class="col-sm-12 col-md-9 col-lg-9 offset-md-3 offset-lg-3 mt-5">
                <br><br>
                <h2 class="pb-2 text-center custom_loja_texto font_smooth">Resultado da busca</h2>
                <?php if (is_array($data['produtos']) && sizeof($data['produtos']) > 0): ?>
                <p class=" text-center custom_loja_texto">
                    Home /
                    <?php if (isset($data['categoria']) && !empty($data['categoria'])): ?>
                        <a class="custom_loja_texto text-capitalize" href="${baseUri}/busca-categoria/<?=str_replace(' ', '-', $data['categoria']->categoria_produto_url)?>">
                            <?=$data['categoria']->categoria_produto_nome ?>
                        </a> 
                    <?php endif;?>
                    <?php if (isset($data['subcategoria']) && !empty($data['subcategoria'])): ?>
                        / <a class="text-capitalize custom_loja_texto" aria-current="page"><?=$data['subcategoria']?></a>
                    <?php endif;?>
                    <?php if (isset($data['marca']) && !empty($data['marca'])): ?>
                        <a class="text-capitalize custom_loja_texto" aria-current="page"><?=$data['marca']?></a>
                    <?php endif;?>
                </p>
                <?php endif;?>
            </div>
        </div>
            <div class="row ">
            <!-- FILTRO MOBILE DENTRO DO BOTÃO-->
            <?php if (Browser::agent('mobile')): ?>
                <div class="col-sm-12 col-md-3 col-lg-3" style="margin-top: 50px !important;">
                    <a href="#offcanvas-produto-filtro" data-toggle="offcanvas" class="btn btn-primary btn-block hide-on-vitrine hide-on-orcamento">
                        <i class="fa fa-bars"></i> Filtrar
                    </a>
                </div>
            <!-- FILTRO DESKTOP FORA DO BOTÃO-->    
            <?php else: ?>
            <div class="col-sm-12 col-md-3 col-lg-3" style="margin-top: 50px !important;">
                <h4 class="hide-on-vitrine hide-on-orcamento custom_loja_texto">Filtre por valor (R$)</h4>
                <hr class="hide-on-vitrine hide-on-orcamento">
                <form class="hide-on-vitrine hide-on-orcamento" action="${baseUri}/busca-valor" method="post">
                    <?php if (isset($data['cat'])): ?>
                        <input type="hidden" value="<?=$data['cat']?>" name="categoria_url">
                    <?php endif;?>
                    <?php if (isset($data['sub'])): ?>
                        <input type="hidden" value="<?=$data['sub']?>" name="subcategoria_url">
                    <?php endif;?>
                    <?php if (isset($data['marca_url'])): ?>
                        <input type="hidden" value="<?=$data['marca_url']?>" name="marca_url">
                    <?php endif;?>
                    <label for="">Valor Mínimo</label>
                    <input type="text" class="form-control money" name="valor_minimo" placeholder="Ex: 100,00" value="<?=$data['min']?>">
                    <br>
                    <label for="">Valor Máximo</label>
                    <input type="text" class="form-control money" name="valor_maximo" placeholder="Ex: 2.000,00" value="<?=$data['max']?>">
                    <br>
                    <button class="btn btn-primary btn-block font_smooth"><i class="fa fa-search"></i> Buscar</button>
                    <br><br>
                </form>
                <?php if (is_array($data['categorias']) && sizeof($data['categorias']) > 0): ?>
                    <h4 class="custom_loja_texto">Filtre por Categoria</h4>
                    <hr><br>
                    <?php foreach ($data['categorias'] as $cat): ?>
                        <b>
                            <a class="custom_loja_texto font_smooth" id="categoria_link_<?=$cat->categoria_produto_url?>" href="${baseUri}/busca-categoria/<?=$cat->categoria_produto_url?>"><?=$cat->categoria_produto_nome?></a>
                        </b>
                        <br>
                        <?php if (is_array($cat->categoria_produto_subcategorias) && sizeof($cat->categoria_produto_subcategorias) > 0): ?>
                            <?php foreach ($cat->categoria_produto_subcategorias as $sub): ?>
                                <a id="subcategoria_link_<?=$sub->subcategoria_produto_url?>" href="${baseUri}/busca-categoria/<?=$cat->categoria_produto_url?>/subcategoria/<?=$sub->subcategoria_produto_url?>">
                                    <span class="font-size-sm text-muted"><?=$sub->subcategoria_produto_nome?></span>
                                </a>
                                <br>
                            <?php endforeach;?>
                        <?php endif;?>
                    <?php endforeach;?>
                <?php endif;?>
                <br><br>

                <?php if (is_array($data['marcas']) && sizeof($data['marcas']) > 0): ?>
                    <h4 class="custom_loja_texto">Filtre por Marcas</h4>
                    <hr><br>
                    <?php foreach ($data['marcas'] as $marca): ?>
                        <a id="marca_link_<?=$marca->marca_url?>" href="${baseUri}/busca-marca/<?=$marca->marca_url?>">
                            <span class="font-size-sm text-muted"><?=$marca->marca_nome?></span>
                        </a>
                        <br>
                    <?php endforeach;?>
                <?php endif;?>

            </div>
             <?php endif;?>
                <div class="col-sm-12 col-md-9 col-lg-9">
                <div class="row">
                <?php if (is_array($data['produtos']) && sizeof($data['produtos']) > 0): ?>
                <?php foreach ($data['produtos'] as $prod): ?>
                    <div class="col-lg-4 col-md-4 col-xs-6 mt-4">
                        <div class="product-card tips-top" title="${config_card_tooltip_text}">
                            <a href="${baseUri}/produto/<?=$prod->produto_url?>">
                                <div class="product-thumb">
                                    <?php if ($prod->produto_oferta == 1): ?>
                                        <span class="badge badge-danger rounded-0">Oferta</span>
                                    <?php endif;?>
                                <img src="${baseUri}/thumb/resize/?w=300&h=300&f=<?=$prod->produto_foto?>" alt="foto ">
                                <?php if($prod->produto_foto_hover != ""):?>
                                    <span>
                                        <img src="${baseUri}/thumb/resize/?w=300&h=300&f=<?=$prod->produto_foto_hover?>"class="foto-hover" />
                                    </span>                           
                                <?php endif;?>
                                </div>
                                <div class="product-card-body">
                                    <span class="product-title"><?= (($prod->produto_titulo))?></span>
                                    <?php if ($prod->produto_estoque <= 0): ?>
                                        <p class="hide-on-vitrine product-title-indisponivel">Indisponível</p>
                                    <?php else: ?>
                                        <?php if ($prod->produto_desconto > 0): ?>
                                            <span class="hide-on-vitrine hide-on-orcamento product-card-text-line">
                                                R$ <?=$prod->produto_preco_original?>
                                            </span>
                                        <?php endif;?>
                                        <span class="hide-on-vitrine hide-on-orcamento product-card-text-price">
                                            R$ <?=$prod->produto_preco?>
                                        </span>
                                        <?php if ($prod->qtd_parcelas > 1): ?>
                                            <span class="hide-on-vitrine hide-on-orcamento product-card-parc">
                                                <?=$prod->qtd_parcelas?>X                                             
                                                    R$ <?=$prod->produto_preco_parc?> ${config_card_text_parc}
                                            </span>
                                        <?php endif;?>
                                        <?php if ($prod->desc_boleto > 0): ?>
                                            <span class="hide-on-vitrine hide-on-orcamento product-card-disc">
                                                ${config_card_text_desconto} R$ <?=$prod->produto_preco_desc_boleto?>
                                            </span>
                                            <small class="hide-on-vitrine hide-on-orcamento product-card-percent">
                                                <?=$prod->desc_boleto?>${config_card_text_percent}
                                            </small>
                                        <?php endif;?>
                                    <?php endif;?>                         
                                </div>
                            </a>
                        </div>
                    </div>
                <?php endforeach;?>
                <?php else: ?>
                <div class="col-sm-12">
                    <h3 class="text-center text-capitalize">Nenhum produto foi encontrado</h3>
                </div>
                <?php endif;?>
                </div>
                </div>
                </div>
    </section>
    @(tema.loja.partials.blog-insta)
    @(tema.loja.partials.toasts)
    @(tema.loja.partials.footer)
<?php if (Browser::agent('mobile')): ?>
    @(tema.loja.partials.offcanvas-produto-filtro)
<?php endif ?>
    <script>const baseUri = "${baseUri}";</script>
    <script src="assets/js/jquery.min.js"></script>
    <script src="assets/js/vendor.min.js"></script>
    <script src="assets/js/theme.min.js"></script>
    <script src="assets/js/toasts.js"></script>
    <script src="assets/js/template.js"></script>
    <script src="assets/js/vue.min.js"></script>
    <script src="assets/js/carrinho.js"></script>
    <script src="assets/js/jquery.mask.min.js"></script>
    <script src="assets/js/main.js?v=<?=rand();?>"></script>
    <script src="home/index.js"></script>

    <script>
        $('.money').mask("#.##0,00", {
            reverse: true
        });
    </script>
</body>

</html>