var vmCarrinho = new Vue({
    el: "#offcanvas-cart",
    data: {
        carrinho: null,
        qtdItens: null,
        subtotal: null,
    },
    methods: {
        listarCarrinho: () => {
            let url = baseUri + "/carrinho/getCarrinho";
            $.post(url).then((res) => {
                if (res) {
                    res = JSON.parse(res);
                    vmCarrinho.carrinho = res.carrinho;
                    vmCarrinho.qtdItens = res.info.qtd_itens;
                    vmCarrinho.subtotal = res.info.subtotal;
                    $(".valorSubtotal").html(
                        `${vmCarrinho.subtotal.toLocaleString("pt-BR", {
                            style: "currency",
                            currency: "BRL",
                        })}`
                    );
                    $(".qtdCarrinho").html(vmCarrinho.qtdItens);
                } else {
                    $(".qtdCarrinho").html(0);
                    vmCarrinho.carrinho = null;
                }
            });
        },
        removeItemCarrinho: (id) => {
            let url = baseUri + "/carrinho/removeProduto";
            $.post(url, { carrinho_id: id }).then((res) => {
                if (res.trim() == "1") {
                    vmCarrinho.listarCarrinho();
                    alert_success("Produto removido da sacola");
                } else {
                    alert_warning("Não foi possível remover o item da sacola");
                }
            });
        },
    },
    created: function () {
        this.listarCarrinho();
    },
});
