$(function() {
    populaSelect();
    "use strict";
    let url = baseUri + "/relatorios/vendasByYear";
    let vendas = [];
    $.post(url, { ano: new Date().getUTCFullYear() })
        .then(res => {
            res = JSON.parse(res);
            vendas = res;
            let series = [];
            vendas.map(venda => {
                series[venda.pedido_mes - 1] = venda.pedido_qtd;
            })

            for (let i = 0; i < 12; i++) {
                if (series[i] == undefined)
                    series[i] = 0;
            }

            populaGraficoMaisVendidos(series);
        })
});

function getVendasByYear() {
    let url = baseUri + "/relatorios/vendasByYear";
    let vendas = [];
    $.post(url, { ano: $("#vendasAno").val() })
        .then(res => {
            res = JSON.parse(res);
            vendas = res;
            let series = [];
            if (vendas) {
                vendas.map(venda => {
                    series[venda.pedido_mes - 1] = venda.pedido_qtd;
                })

                for (let i = 0; i < 12; i++) {
                    if (series[i] == undefined)
                        series[i] = 0;
                }
                populaGraficoMaisVendidos(series);
            } else {
                populaGraficoMaisVendidos([0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]);
            }

        })
}

function populaSelect() {
    let url = baseUri + "/relatorios/getYears";
    $.post(url)
        .then(res => {
            res = JSON.parse(res);
            let anos = res;

            anos.map(ano => {
                $("#vendasAno").append(`
                    <option value="${ano.pedido_ano}">${ano.pedido_ano}</option>
                `);
            })
        })
}

$("#vendasAno").change(() => getVendasByYear());

function populaGraficoMaisVendidos(arr) {

    new Chart(document.getElementById("graficoVendidos"), {
        "type": "pie",
        "data": {
            "labels": ["Red", "Blue", "Yellow"],
            "datasets": [{
                "label": "My First Dataset",
                "data": [300, 50, 100],
                "backgroundColor": ["rgb(252, 75, 108)", "rgb(30, 136, 229)", "rgb(255, 178, 43)"]
            }]
        }
    });

    new Chart(document.getElementById("graficoVisitados"), {
        "type": "pie",
        "data": {
            "labels": ["Red", "Blue", "Yellow"],
            "datasets": [{
                "label": "My First Dataset",
                "data": [300, 50, 100],
                "backgroundColor": ["rgb(252, 75, 108)", "rgb(30, 136, 229)", "rgb(255, 178, 43)"]
            }]
        }
    });
}