<!DOCTYPE html>
<html lang="pt-br">

<head>
    <base href="${baseUri}/view/admin/">
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="description" content="${config_site_description}">
    <meta name="author" content="${config_site_author}">
    <meta name="keywords" content="${config_site_keywords}">
    <link rel="icon" type="image/png" sizes="16x16" href="${baseUri}/media/site/${config_site_favicon}">
    <title>${config_site_title} - Produtos</title>
    <link href="assets/plugins/bootstrap/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="assets/plugins/toast-master/css/jquery.toast.css">
    <link href="assets/plugins/bootstrap-select/bootstrap-select.min.css" rel="stylesheet" />
    <link href="assets/plugins/bootstrap-tagsinput/dist/bootstrap-tagsinput.css" rel="stylesheet" />
    <link href="assets/css/style.css" rel="stylesheet">

    <link rel="stylesheet" href="assets/plugins/datatables.net/rowReorder.dataTables.min.css">
    <!-- You can change the theme colors from here -->
    <link href="assets/css/colors/${config_tema_color}.css" id="theme" rel="stylesheet">

    <link rel="stylesheet" href="assets/plugins/dropzone-master/dist/dropzone.css">
    <link rel="stylesheet" href="assets/plugins/lightbox/css/lightbox.css">
    <link rel="stylesheet" href="assets/plugins/dropify/dist/css/dropify.min.css">
    <link rel="stylesheet" href="assets/plugins/dropify-multiple/dist/css/dropify-multiple.min.css">
    <link href="assets/plugins/summernote/dist/summernote-lite.css" rel="stylesheet">

    <link href="assets/plugins/select2/dist/css/select2.min.css" rel="stylesheet">
    <!--[if lt IE 9]>
    <script src="assets/plugins/html5shiv.js"></script>
    <script src="assets/plugins/respond.min.js"></script>

    <![endif]-->
    <style>
        /* form .dropify-wrapper .dropify-preview .dropify-render img {
            width: 100%;
            height: 100%;
        } */

        /* form .dropify-wrapper {
            border-radius: 10px;
            object-fit: cover;
            width: 100%;
        } */

        .border3px {
            border: 3px solid #33555555;
        }

        .dropify-wrapper,
        .dropify-wrapper .dropify-clear {
            font-family: 'Poppins';
        }

        .dropify-wrapper .dropify-preview .dropify-render img {
            width: 100%;
            min-height: 900px;
        }

        @media screen and (max-width: 799px) {
            .botoesAdd {
                width: 100%;
            }
        }

        @media screen and (min-width: 800px) {
            .mr-desktop {
                margin-right: 5px !important;
            }
        }

        .dropify-clear {
            display: none !important;
        }

        td {
            vertical-align: middle !important;
        }
    </style>
</head>

<body class="fix-header card-no-border logo-center">
    <div class="preloader">
        <svg class="circular" viewBox="25 25 50 50">
            <circle class="path" cx="50" cy="50" r="20" fill="none" stroke-width="2" stroke-miterlimit="10" />
        </svg>
    </div>

    <div id="main-wrapper">
        @(admin.layout.topo)
        @(admin.layout.topo-menu)
        <div class="page-wrapper">
            <div class="container-fluid">
                <div class="row page-titles">
                    <div class="col-md-5 col-8 align-self-center">
                        <h3 class="text-themecolor m-b-0 m-t-0">Gerenciar Produtos</h3>
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="javascript:void(0);">Loja</a></li>
                            <li class="breadcrumb-item"><a href="javascript:void(0);">Produtos</a></li>
                            <li class="breadcrumb-item active">Gerenciar Produtos</li>
                        </ol>
                    </div>
                    @(admin.layout.topo-info)
                    <div class="col-md-7 col-4 align-self-center">
                        <h6 class="float-right" style="padding-top: 20px">
                            <a href="${baseUri}/produtos-lista/" data-id="ProdutosAdmin:L" class="btn btn-primary waves-effect waves-light text-white menu-access">
                                <i class="fa fa-arrow-circle-left"></i> Voltar
                            </a>
                        </h6>
                    </div>
                </div>

                <div class="row">
                    <div class="col-12">
                        <div class="card card-outline-primary">
                            <div class="card-header"><i class="text-white fas fa-th-list"></i>
                                @(admin.layout.seo)
                            </div>
                            <div class="card-body" id="vm">
                                <div class="content">
                                    <section id="produtoNovo">
                                        <!-- Form produto -->
                                        <form class="form mar-top-10" method="post" enctype="multipart/form-data" action="${baseUri}/ProdutosAdmin/gravar">
                                            <div class="row">
                                                <div class="col-sm-12 col-md-6">
                                                    <label for="produto_titulo">Título <span class="text-danger">*</span> </label>
                                                    <input type="text" class="form-control" name="produto_titulo" id="produto_titulo1" placeholder="Título / Nome do Produto" required onchange="changeSeo('#produto_titulo', 'titulo')"><br><br>
                                                </div>
                                                <div class="col-sm-12 col-md-3">
                                                    <label for="produto_preco">Valor R$<span class="text-danger">*</span></label>
                                                    <input type="text" class="form-control moeda" name="produto_preco" id="produto_preco1" placeholder="Valor / Preço do Produto" required><br><br>
                                                </div>
                                                <div class="col-sm-12 col-md-3">
                                                    <label for="produto_desconto">Desconto R$</label>
                                                    <input type="text" class="form-control moeda" name="produto_desconto" value="0" id="produto_desconto1" placeholder="Valor de desconto sobre o valor total"><br><br>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-sm-12 col-md-3">
                                                    <label for="produto_ref">Código</label>
                                                    <input type="text" class="form-control" name="produto_ref" id="produto_ref1" placeholder="Referência do Produto"><br><br>
                                                </div>
                                                <div class="col-sm-12 col-md-3">
                                                    <label for="produto_marca">Marca / Fabricante</label>
                                                    <select name="produto_marca" id="produto_marca" class="form-control">
                                                        <option value="">Selecione uma marca</option>
                                                        <option v-if="marcas == null" value="">Nenhuma marca cadastrada</option>
                                                        <option v-else v-for="marca in marcas" :value="marca.marca_id">{{marca.marca_nome}}</option>
                                                    </select> <br><br>
                                                </div>

                                                <div class="col-sm-12 col-md-3">
                                                    <label for="produto_arquivo">Solicitar Arquivo?
                                                    </label>
                                                    <span class="float-right" data-toggle="tooltip" title="o cliente deve enviar um arquivo durante o processo de compra">
                                                        <i class="fa fa-info-circle"></i>
                                                    </span>
                                                    <select name="produto_arquivo" id="produto_arquivo1" class="form-control">
                                                        <option value="0">Não</option>
                                                        <option value="1">Sim</option>
                                                    </select> <br><br>
                                                </div>

                                                <div class="col-sm-12 col-md-3">
                                                    <label for="produto_status">Produto Ativo</label>
                                                    <select name="produto_status" id="produto_status1" class="form-control">
                                                        <option value="0">Não</option>
                                                        <option value="1">Sim</option>
                                                    </select> <br><br>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <input type="hidden" value="${produto_keywords}" class="form-control uppercase" name="produto_keywords" id="produto_keywords1">

                                                <div class="col-sm-12 col-md-6">
                                                    <label for="produto_disp">Disponibilidade</label>
                                                    <input type="text" class="form-control uppercase" name="produto_disp" id="produto_disp1" placeholder="Disponibilidade de postagem. Ex: Entre 5 e 10 dias úteis."><br><br>
                                                </div>

                                                <div class="col-sm-12 col-md-3">
                                                    <label for="produto_oferta">Em Oferta</label>
                                                    <select name="produto_oferta" id="produto_oferta1" class="form-control">
                                                        <option value="0">Não</option>
                                                        <option value="1">Sim</option>
                                                    </select> <br><br>
                                                </div>
                                                <div class="col-sm-12 col-md-3">
                                                    <label for="produto_destaque">Produto em Destaque</label>
                                                    <select name="produto_destaque" id="produto_destaque1" class="form-control">
                                                        <option value="0">Não</option>
                                                        <option value="1">Sim</option>
                                                    </select> <br><br>
                                                </div>

                                            </div>

                                            <section id="obs">
                                                <div class="col-xs-12 text-center menu-access" data-id="ProdutosAdmin:G">
                                                    <div class="form-group text-center">
                                                        <br><br>
                                                        <button type='submit' class="btn btn-primary"><i class="fas fa-check-circle"></i> Gravar Dados
                                                        </button>
                                                    </div>
                                                </div>
                                            </section>
                                        </form>
                                    </section>
                                    <section id="produtoEdit">
                                        <form name="f-produto" id="f-produto" class="form mar-top-10" method="post" enctype="multipart/form-data" action="${baseUri}/ProdutosAdmin/gravar">
                                            <input type="hidden" name="produto_id" id="produto_id" value="${produto_id}">
                                            <input type="hidden" name="redirect" id="redirect" value="dados">
                                            <div id="partials">
                                                <ul class="nav nav-tabs">
                                                    <li class="nav-item">
                                                        <a class="nav-link active" style="cursor: pointer;" id="navDados" data-id="partialDados|navDados">Dados Principais</a>
                                                    </li>
                                                    <li class="nav-item">
                                                        <a class="nav-link" style="cursor: pointer;" id="navCategorias" data-id="partialCategorias|navCategorias">Categorias/Subcategorias</a>
                                                    </li>
                                                    <li class="nav-item">
                                                        <a class="nav-link" style="cursor: pointer;" id="navEstoque" data-id="partialEstoque|navEstoque">Estoque/Atributos</a>
                                                    </li>
                                                    <li class="nav-item">
                                                        <a class="nav-link" style="cursor: pointer;" id="navDesc" data-id="partialDesc|navDesc">Descrição</a>
                                                    </li>
                                                    <li class="nav-item">
                                                        <a class="nav-link" style="cursor: pointer;" id="navFotos" data-id="partialFotos|navFotos">Fotos</a>
                                                    </li>
                                                    <li class="nav-item">
                                                        <a class="nav-link" style="cursor: pointer;" id="navFrete" data-id="partialFrete|navFrete">Frete</a>
                                                    </li>
                                                    <li class="nav-item">
                                                        <a class="nav-link" style="cursor: pointer;" id="navRel" data-id="partialRel|navRel">Produtos Relacionados</a>
                                                    </li>
                                                    <li class="nav-item">
                                                        <a class="nav-link" style="cursor: pointer;" id="navFiscal" data-id="partialFiscal|navFiscal">Fiscal</a>
                                                    </li>
                                                </ul>
                                                <br>
                                                <div id="partialDados" class="partials">
                                                    @(admin.produto.partials.dados)
                                                </div>
                                                <div id="partialCategorias" class="partials">
                                                    @(admin.produto.partials.categorias)
                                                </div>
                                                <div id="partialEstoque" class="partials">
                                                    @(admin.produto.partials.estoque)
                                                </div>
                                                <div id="partialDesc" class="partials">
                                                    @(admin.produto.partials.descricao)
                                                </div>
                                                <div id="partialFotos" class="partials">
                                                    @(admin.produto.partials.fotos)
                                                </div>
                                                <div id="partialFrete" class="partials">
                                                    @(admin.produto.partials.frete)
                                                </div>
                                                <div id="partialRel" class="partials">
                                                    @(admin.produto.partials.rel)
                                                </div>
                                                <div id="partialFiscal" class="partials">
                                                    @(admin.produto.partials.fiscal)
                                                </div>
                                            </div>

                                            <section id="obs">
                                                <div class="col-xs-12 text-center menu-access" data-id="ProdutosAdmin:G">
                                                    <div class="form-group text-center">
                                                        <br><br>
                                                        <button id="btn-send" type='submit' class="btn btn-primary"><i class="fas fa-check-circle"></i> Gravar Dados
                                                        </button>
                                                    </div>
                                                </div>
                                            </section>
                                        </form>
                                    </section>


                                </div>
                                <div id="modalNovaCat" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true" style="display: none;">
                                    <div class="modal-dialog">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h4 class="modal-title" id="mySmallModalLabel"><span class="categoria-acao">Incluir</span> categoria</h4>
                                                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                                            </div>
                                            <div class="modal-body">
                                                <div class="col-md-12 col-xs-12 col-sm-12">
                                                    <div class="form-group">
                                                        <label for="categoria_produto_nome">Nome da categoria <span class="text-danger">*</span></label>
                                                        <input type="text" class="form-control" id="categoria_produto_nome" name="categoria_produto_nome" maxlength="200" required>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="modal-footer">
                                                <button type="button" class="btn btn-danger waves-effect" data-dismiss="modal"><i class="fa fa-times-circle"></i> Cancelar</button>
                                                <button type="button" class="btn btn-primary waves-effect waves-light" v-on:click="cadastraCategoria()"><i class="fa fa-check-circle"></i> Enviar</button>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div id="modalNovaSub" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true" style="display: none;">
                                    <div class="modal-dialog modal-lg">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h4 class="modal-title" id="mySmallModalLabel"><span class="categoria-acao">Incluir</span> Subcategoria</h4>
                                                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                                            </div>
                                            <div class="modal-body row">
                                                <div class="col-md-12 col-xs-12 col-sm-12">
                                                    <div class="form-group">
                                                        <label for="subcategoria_produto_nome">Nome da subcategoria <span class="text-danger">*</span></label>
                                                        <input type="text" class="form-control" id="subcategoria_produto_nome" maxlength="200" required>
                                                    </div>
                                                </div>
                                                <div class="col-md-12 col-xs-12 col-sm-12">
                                                    <div class="form-group">
                                                        <label for="subcategoria_produto_categoria">Categoria<span class="text-danger">*</span></label>
                                                        <select id="subcategoria_produto_categoria" class="form-control select2" style="width: 100% !important;">
                                                            <option value="0">Selecione uma Categoria</option>
                                                            <option v-if="categorias != null" v-for="cat in categorias" :value="cat.categoria_produto_id"> {{ cat.categoria_produto_nome }} </option>
                                                        </select>
                                                    </div>
                                                </div>
                                                <div class="col-sm-12 col-md-6 col-xs-6">
                                                    <div class="form-group">
                                                        <label for="subcategoria_produto_pos">Em destaque <span class="text-danger">*</span></label>
                                                        <span class="pull-right">
                                                            <i class="fa fa-info-circle"></i>
                                                            Em destaque no menu da loja
                                                        </span>
                                                        <select class="form-control" id="subcategoria_produto_pos" required>
                                                            <option value="0">Não</option>
                                                            <option value="1">Sim</option>
                                                        </select>
                                                    </div>
                                                </div>
                                                <div class="col-sm-12 col-md-6 col-xs-6">
                                                    <div class="form-group">
                                                        <label for="subcategoria_produto_ordem_destaque">Posição no destaque <span v-if="$('#subcategoria_produto_pos').val() > 0" class="text-danger">*</span></label>
                                                        <input type="number" class="form-control" id="subcategoria_produto_ordem_destaque">
                                                    </div>
                                                </div>
                                                <div class="col-sm-12 col-md-12 col-xs-12">
                                                    <div class="form-group">
                                                        <label for="subcategoria_produto_apelido">Apelido no destaque</label>
                                                        <input type="text" class="form-control" id="subcategoria_produto_apelido">
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="modal-footer">
                                                <button type="button" class="btn btn-danger waves-effect" data-dismiss="modal"><i class="fa fa-times-circle"></i> Cancelar</button>
                                                <button type="button" class="btn btn-primary waves-effect waves-light" v-on:click="cadastraSubcategoria()"><i class="fa fa-check-circle"></i> Enviar</button>
                                            </div>
                                        </div>
                                    </div>
                                </div>


                                <div id="modalRemoveAtributo" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true" style="display: none;">
                                    <div class="modal-dialog modal-lg">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h4 class="modal-title" id="mySmallModalLabel">Remover atributo e seus itens</h4>
                                                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                                            </div>
                                            <div class="modal-body">
                                                <div class="col-md-12 text-center">
                                                    <i class="text-warning fa fa-4x fa-exclamation-triangle"></i>
                                                    <br><br>
                                                    <h2 class="text-center">Atenção!</h2>
                                                    <p class="text-center" style="color: black">Você está prestes a remover este atributo deste produto. Deseja continuar?</p>
                                                </div>
                                            </div>
                                            <div class="modal-footer">
                                                <button type="button" class="btn btn-primary waves-effect" data-dismiss="modal"><i class="fa fa-times-circle"></i> Cancelar</button>
                                                <button type="button" class="btn btn-danger waves-effect waves-light" v-on:click="removeAtributo()"><i class="fa fa-check-circle"></i> Remover</button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            @(admin.layout.footer)

        </div>
    </div>
    <script src="assets/plugins/jquery/jquery.min.js"></script>
    <script src="assets/plugins/popper/popper.min.js"></script>
    <script src="assets/plugins/bootstrap/js/bootstrap.min.js"></script>
    <script src="assets/js/jquery.slimscroll.js"></script>
    <script src="assets/js/waves.js"></script>
    <script src="assets/js/sidebarmenu.js"></script>
    <script src="assets/plugins/sticky-kit-master/dist/sticky-kit.min.js"></script>
    <script src="assets/plugins/sparkline/jquery.sparkline.min.js"></script>
    <script src="assets/js/custom.min.js"></script>
    <script src="assets/plugins/toast-master/js/jquery.toast.js"></script>
    <script src="assets/plugins/styleswitcher/jQuery.style.switcher.js"></script>
    <script src="assets/plugins/datatables.net/js/jquery.dataTables.min.js"></script>
    <script src="assets/plugins/datatables.net/js/dataTables.rowReorder.min.js"></script>
    <script src="assets/plugins/bootstrap-select/bootstrap-select.min.js" type="text/javascript"></script>
    <script src="assets/plugins/bootstrap-tagsinput/dist/bootstrap-tagsinput.min.js" type="text/javascript"></script>
    <script src="assets/plugins/jquery.mask.min.js"></script>
    <script src="assets/js/jquery.cookie.js"></script>

    <script src="assets/plugins/summernote/dist/summernote-lite.min.js"></script>
    <script src="assets/plugins/summernote/dist/lang/summernote-pt-BR.js"></script>

    <script src="assets/js/vue.min.js"></script>
    <!-- FILE UPLOAD -->
    <script src="assets/plugins/dropzone-master/dist/dropzone.js"></script>
    <script src="assets/plugins/lightbox/js/lightbox.js"></script>
    <script src="assets/plugins/sortable/Sortable.js"></script>
    <script src="assets/plugins/dropify/dist/js/dropify.min.js"></script>
    <script src="assets/plugins/dropify-multiple/dist/js/dropify-multiple.min.js"></script>

    <script src="${baseUri}/view/admin/app-js/datatable.js"></script>
    <script src="assets/plugins/datatables-button/dataTables.buttons.min.js"></script>
    <script src="assets/plugins/datatables-button/buttons.flash.min.js"></script>
    <script src="assets/plugins/datatables-button/jszip.min.js"></script>
    <script src="assets/plugins/datatables-button/pdfmake.min.js"></script>
    <script src="assets/plugins/datatables-button/vfs_fonts.js"></script>
    <script src="assets/plugins/datatables-button/buttons.html5.min.js"></script>
    <script src="assets/plugins/datatables-button/buttons.print.min.js"></script>
    <script src="${baseUri}/view/admin/app-js/main.js"></script>
    <script src="assets/plugins/select2/dist/js/select2.full.min.js" type="text/javascript"></script>

    <script src="produto/form.js?v=${rand}"></script>
    <script type="text/javascript">
        $('.menu-produtos-cadastrar').addClass('active');
        $('.menu-produtos').addClass('active');

        $(".select2").select2();

        $('.summernote').summernote({
            placeholder: '',
            lang: 'pt-BR',
            minHeight: 150,
            maxHeight: 550,
            disableDragAndDrop: true,
            toolbar: [
                ['style', ['bold', 'italic', 'underline', 'clear']],
                ['fontname', ['fontname']],
                ['color', ['color']],
                ['para', ['ul', 'ol']],
                ['size', ['paragraph', 'height', 'fontsize']],
                ['misc', ['undo', 'redo']],
                ['insert', ['link', 'picture', 'video', 'hr']],
                ['view', ['fullscreen', 'codeview']],
            ]
        });

        $(document).ready(function() {
            $("#labelDesc").html('Descrição do produto');
        });

        if (Number("${produto_id}") <= 0) {
            $("#produto_status1").val('1').trigger('change');
            $("#produto_oferta1").val("0").trigger('change');
            $("#produto_destaque1").val("0").trigger('change');
            $("#produto_arquivo1").val("0").trigger('change');
        } else {
            $("#produto_status").val("${produto_status}").trigger('change');
            $("#produto_oferta").val("${produto_oferta}").trigger('change');
            $("#produto_destaque").val("${produto_destaque}").trigger('change');
            $("#produto_arquivo").val("${produto_arquivo}").trigger('change');
            $("#produto_calcula_frete").val("${produto_calcula_frete}").trigger('change');
        }


        $("#keywords_seo").val("${produto_keywords}");

        setTimeout(() => {
            $("#produto_marca1").val("${produto_marca}").trigger('change');
            $("#produto_tipo_unidade").val("${produto_tipo_unidade}").trigger('change');
        }, 650);
    </script>


</body>

</html>