var table;
var vm = new Vue({
    el: "#vm",
    data: {
        pedidos: null,
        rm: null,
        url: null,
    },
    methods: {
        listar: function () {
            var url = baseUri + "/Pedido/listar/";
            var self = this;
            $.getJSON(url, {}, function (dados) {
                splash_dt();
            }).then(function (dados) {
                if (dados != null) {
                    dados = dados.map((dado, i) => {
                        if (!isNaN(dado.pedido_total_parcelado)) {
                            dado.pedido_total_parcelado = Number(
                                dado.pedido_total_parcelado
                            ).toLocaleString("pt-BR", {
                                style: "currency",
                                currency: "BRL",
                            });
                        } else {
                            dado.pedido_total_parcelado =
                                "R$ " + dado.pedido_total_parcelado;
                        }

                        if (!isNaN(dado.pedido_total_produto)) {
                            dado.pedido_total_produto = Number(
                                dado.pedido_total_produto
                            ).toLocaleString("pt-BR", {
                                style: "currency",
                                currency: "BRL",
                            });
                        } else {
                            dado.pedido_total_produto =
                                "R$ " + dado.pedido_total_produto;
                        }
                        return dado;
                    });

                    self.pedidos = dados;
                } else {
                    self.pedidos = null;
                }
                reload_dt_vue();
            });
        },
        remover: function (dt) {
            vm.$data.rm = dt.pedido_id;
            $("#modal-remove").modal("show");
        },
        remove: function (id) {
            var url_remove = baseUri + "/Pedido/remover/";
            $.post(url_remove, { id: id }).then(function (rs) {
                if (rs == 1) {
                    alert_success(
                        "Ação realizada com sucesso!",
                        "Item removido"
                    );
                    vm.listar();
                } else {
                    alert_error("Ação não pode ser realizada!");
                }
            });
            $("#modal-remove").modal("hide");
        },
    },
    created: function () {
        $("#tbl-div").hide().promise().done($("#tbl-splash").show());
        this.listar();
    },
});

/*ALERTAS DE ERROR*/
if (window.location.href.indexOf("error_enviar_nfe") != -1) {
    alert_error(
        "Ocorreu um erro",
        "Erro ao enviar a Nota fiscal para o SEFAZ, verifique os dados cadastrados na Bling",
        15000
    );
}
if (window.location.href.indexOf("error_gerar_nfe") != -1) {
    alert_error("Ocorreu um erro", "Erro ao gerar a Nota fiscal", 15000);
}
if (window.location.href.indexOf("error_pedido_invalido") != -1) {
    alert_error("Ocorreu um erro", "Pedido inválido", 15000);
}

// click do modal
$("#btn-remove").on("click", function () {
    if (vm.$data.rm !== null) {
        vm.remove(vm.$data.rm);
    }
});

$(".menu-pedidos").addClass("active");
