var table;
var vm = new Vue({
    el: "#vm",
    data: {
        produtos_vinculados: null,
        produtos_nao_vinculados: null,
        produtos: null,
        campos: null,
        campo_atual: null,
    },
    methods: {
        listar_campos: () => {
            var url = baseUri + "/CamposExtras/listar_campos/";
            $.post(url, {}).then(function (dados) {
                splash_dt();
                dados = JSON.parse(dados);
                if (dados != null) {
                    vm.campos = dados.campos;
                } else {
                    vm.campos = null;
                }
                reload_dt_vue();
            });
        },
        listar_produtos_vinculados: function (id) {
            var url = baseUri + "/CamposExtras/listar_produtos_vinculados/";
            $.post(url, { campo_checkout_id: id }).then(function (dados) {
                dados = JSON.parse(dados);
                if (dados != null) {
                    vm.produtos_vinculados = dados.produtos;
                } else {
                    vm.produtos_vinculados = null;
                }
            });
        },
        listar_produtos_nao_vinculados: function (id) {
            var url = baseUri + "/CamposExtras/listar_produtos_nao_vinculados/";
            $.post(url, { campo_checkout_id: id }).then(function (dados) {
                dados = JSON.parse(dados);
                if (dados != null) {
                    vm.produtos = dados.produtos;
                } else {
                    vm.produtos = null;
                }
            });
        },
        listar_produtos: function () {
            var url = baseUri + "/CamposExtras/listar_produtos/";
            $.post(url, {}).then(function (dados) {
                dados = JSON.parse(dados);
                if (dados != null) {
                    vm.produtos = dados.produtos;
                } else {
                    vm.produtos = null;
                }
            });
        },
        remover: function (dt) {
            vm.$data.rm = dt.pedido_id;
            $("#modal-remove").modal("show");
        },
        remove: function (id) {
            var url_remove = baseUri + "/CamposExtras/remover/";
            $.post(url_remove, { id: id }).then(function (rs) {
                if (rs == 1) {
                    alert_success(
                        "Ação realizada com sucesso!",
                        "Item removido"
                    );
                    vm.listar();
                } else {
                    alert_error("Ação não pode ser realizada!");
                }
            });
            $("#modal-remove").modal("hide");
        },

        show_add_campo: () => {
            vm.campo_atual = null;
            $("#modal-campos").modal("show");
            setTimeout(() => {
                $("#campo_checkout_produtos").select2();
            }, 150);
            vm.listar_produtos();
            $("#campo_checkout_nome").val("");
            vm.produtos_nao_vinculados = null;
            vm.produtos_vinculados = null;
        },

        show_edit: (campo) => {
            console.log(campo);
            vm.campo_atual = campo;

            vm.produtos = null;
            vm.produtos_vinculados = null;

            vm.listar_produtos_vinculados(campo.campo_checkout_id);
            vm.listar_produtos_nao_vinculados(campo.campo_checkout_id);

            $("#modal-campos").modal("show");
            setTimeout(() => {
                $("#campo_checkout_produtos").select2();
            }, 150);

            $("#campo_checkout_nome").val(campo.campo_checkout_nome);
        },

        remove_produto_atrelado: (produto_id) => {
            if (vm.campo_atual != null) {
                let data = {
                    campo_id: vm.campo_atual.campo_checkout_id,
                    produto_id: produto_id,
                };
                let url = baseUri + "/CamposExtras/remove_produto_atrelado";

                $.post(url, data).then((res) => {
                    res = JSON.parse(res);

                    if (res.error == undefined) {
                        alert_success("Produto desvinculado com sucesso!");
                        vm.listar_produtos_vinculados(
                            vm.campo_atual.campo_checkout_id
                        );
                    } else {
                        alert_error("Erro ao desvincular produto!");
                    }
                });
            } else {
                alert_error("Selecione um campo para poder realizar essa ação");
            }
        },

        show_remover: (campo) => {
            vm.campo_atual = campo;

            $("#modal-remove").modal("show");
        },

        remove_campo: () => {
            $("#modal-remove").modal("hide");
            if (vm.campo_atual != null) {
                let data = {
                    campo_id: vm.campo_atual.campo_checkout_id,
                };
                let url = baseUri + "/CamposExtras/remove_campo";

                $.post(url, data).then((res) => {
                    res = JSON.parse(res);

                    if (res.error == undefined) {
                        alert_success(
                            "Campo de Checkout removido com sucesso!"
                        );
                        vm.listar_campos();
                    } else {
                        alert_error("Erro ao remover Campo de Checkout!");
                    }
                });
            } else {
                alert_error("Selecione um campo para poder realizar essa ação");
            }
        },
    },
    created: function () {
        $("#tbl-div").hide().promise().done($("#tbl-splash").show());
        this.listar_produtos();
        this.listar_campos();
    },
});

$(".menu-campos").addClass("active");
