<!DOCTYPE html>
<html lang="pt-br">
<head>
    <base href="${baseUri}/view/admin/">
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <!-- Tell the browser to be responsive to screen width -->
    <meta name="viewport" content="width=device-width, initial-scale=1">
     <meta name="description" content="${config_site_description}">
    <meta name="author" content="${config_site_author}">
    <meta name="keywords" content="${config_site_keywords}">
    <!-- Favicon icon -->
    <title>Instalação</title>
    <!-- Bootstrap Core CSS -->
    <link href="assets/plugins/bootstrap/css/bootstrap.min.css" rel="stylesheet">
    <!-- Custom CSS -->
    <link rel="stylesheet" href="assets/plugins/toast-master/css/jquery.toast.css">
    <link href="assets/css/style.css" rel="stylesheet">
    <!-- You can change the theme colors from here -->
    <link href="assets/css/colors/default.css" id="theme" rel="stylesheet">
    <!--[if lt IE 9]>
    <script src="assets/plugins/html5shiv.js"></script>
    <script src="assets/plugins/respond.min.js"></script>
    <![endif]-->
</head>

<body class="fix-header card-no-border logo-center">
<div class="preloader">
    <svg class="circular" viewBox="25 25 50 50">
        <circle class="path" cx="50" cy="50" r="20" fill="none" stroke-width="2" stroke-miterlimit="10"/>
    </svg>
</div>

<div id="main-wrapper">
    <!-- MENU import -->
    <div class="page-wrapperX">
        <!-- Container fluid  -->
        <div class="container-fluid" style="margin-top: 50px">
            <!-- Start Page Content -->
            <div class="row">
                <div class="col-12">
                    <div class="card card-outline-primary">
                        <div class="card-header text-white"><i class="text-white fas fa-rocket"></i>
                            INSTALAÇÃO FLUX PLATAFORMA
                            <a href="${baseUri}/install/logout" class="btn btn-danger btn-sm pull-right">
                                <i class="fa fa-logout"></i> Sair
                            </a>
                        </div>
                        <div class="card-body">
                            <p>${status_text}</p>
                            <br><br>
                            <form action="${baseUri}/install/save_conf/" method="post" class="">

                                <input type="hidden" name="installpass" value="${installpass}" class="form-control"
                                                   placeholder="senha do painel de instalação">    

                                <input type="hidden" name="nocache" value="${nocache}" 
                                        placeholder="forçar versões em js e css">      
                                        
                                <input type="hidden" name="compress" value="${compress}"  
                                placeholder="comprimir html" />                         


                                                   
                                                   
                                <div class="row">
                                    <div class="col-md-2">
                                        <div class="form-group">
                                            <label>Hostname</label>
                                            <input type="text" name="host" value="${host}" class="form-control"
                                                   placeholder="hostname do banco ex: localhost">
                                        </div>
                                    </div>
                                    <div class="col-md-2">
                                        <div class="form-group">
                                            <label>Nome do Banco</label>
                                            <input type="text"  name="base" value="${base}" class="form-control"
                                                   placeholder="nome do banco ex: site">
                                        </div>
                                    </div>
                                    <div class="col-md-2">
                                        <div class="form-group">
                                            <label>Usuário do Banco</label>
                                            <input type="text"  name="user" value="${user}" class="form-control"
                                                   placeholder="informe o usuário do banco">
                                        </div>
                                    </div>
                                    <div class="col-md-2">
                                        <div class="form-group">
                                            <label>Senha do Banco</label>
                                            <input type="password" name="pass" value="${pass}" class="form-control"
                                                   placeholder="informe a senha do banco">
                                        </div>
                                    </div>
                                    <div class="col-md-2">
                                        <div class="form-group">
                                            <label>Porta do Host</label>
                                            <input  type="text"  name="port" value="${port}" class="form-control"
                                                   placeholder="porta ex: 3306">
                                        </div>
                                    </div>
                                    <div class="col-md-2">
                                        <div class="form-group">
                                            <label>&nbsp;</label>
                                            <button type="submit" class="btn btn-primary btn-block">GRAVAR</button>
                                        </div>
                                    </div>
                                </div>
                            </form>
                            <br><br>
                            <div class="row" id="bd-actions">
                                <div class="col-md-3">
                                    <a class="btn btn-primary btn-block" href="${baseUri}/install/up/">
                                        <i class="text-white fas fa-database"></i>
                                        Instalação Limpa
                                    </a>
                                </div>

                                <div class="col-md-3">
                                    <a class="btn btn-info btn-block" href="${baseUri}/install/up_padrao/">
                                        <i class="text-white fas fa-database"></i>
                                        Instalação Padrão
                                    </a>
                                </div>

                                <div class="col-md-3">
                                    <a class="btn btn-danger btn-block" href="${baseUri}/install/down/">
                                        <i class="text-white fas fa-trash"></i>
                                        Excluir Tabelas do Banco
                                    </a>
                                </div>
<!-- 
                                <div class="col-md-3">
                                    <a class="btn btn-info btn-block" href="${baseUri}/install/migrate/">
                                        <i class="text-white fas fa-cubes"></i>
                                        Efetuar Atualizações de Tabelas
                                    </a>
                                </div> -->

                                <div class="col-md-3">
                                    <a class="btn btn-success btn-block" href="${baseUri}/login/">
                                        <i class="text-white fas fa-rocket"></i>
                                        Entrar - Painel Administrativo
                                    </a>
                                </div>


                            </div>


                            <br><br><br><br>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- End Page wrapper  -->
</div>
<script src="assets/plugins/jquery/jquery.min.js"></script>
<script src="assets/plugins/jquery.mask.min.js"></script>
<!-- Bootstrap tether Core JavaScript -->
<script src="assets/plugins/popper/popper.min.js"></script>
<script src="assets/plugins/bootstrap/js/bootstrap.min.js"></script>
<!-- slimscrollbar scrollbar JavaScript -->
<script src="assets/js/jquery.slimscroll.js"></script>
<!--Wave Effects -->
<script src="assets/js/waves.js"></script>
<!--Menu sidebar -->
<script src="assets/js/sidebarmenu.js"></script>
<script src="assets/plugins/toast-master/js/jquery.toast.js"></script>
<!--stickey kit -->
<script src="assets/plugins/sticky-kit-master/dist/sticky-kit.min.js"></script>
<script src="assets/plugins/sparkline/jquery.sparkline.min.js"></script>
<!--Custom JavaScript -->
<script src="assets/js/custom.min.js"></script>
<!-- Style switcher -->

</body>
</html>