<!DOCTYPE html>
<html lang="pt-br">

<head>
    <base href="${baseUri}/view/admin/">
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <!-- Tell the browser to be responsive to screen width -->
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="description" content="${config_site_description}">
    <meta name="author" content="${config_site_author}">
    <meta name="keywords" content="${config_site_keywords}">
    <meta name="author" content="${config_seo_author}">
    <!-- Favicon icon -->
    <link rel="icon" type="image/png" sizes="16x16" href="${baseUri}/media/site/${config_site_favicon}">
    <title>${config_site_title}</title>
    <!-- Bootstrap Core CSS -->
    <link href="assets/plugins/bootstrap/css/bootstrap.min.css" rel="stylesheet">
    <!-- Custom CSS -->
    <link rel="stylesheet" href="assets/plugins/toast-master/css/jquery.toast.css">

    <!-- chartist CSS -->
    <link href="assets/plugins/chartist-js/dist/chartist.min.css" rel="stylesheet">
    <link href="assets/plugins/chartist-js/dist/chartist-init.css" rel="stylesheet">
    <link href="assets/plugins/chartist-plugin-tooltip-master/dist/chartist-plugin-tooltip.css" rel="stylesheet">
    <!--This page css - Morris CSS -->
    <link href="assets/plugins/c3-master/c3.min.css" rel="stylesheet">


    <link href="assets/css/style.css" rel="stylesheet">
    <!-- You can change the theme colors from here -->
    <link href="assets/css/colors/${config_tema_color}.css" id="theme" rel="stylesheet">
    <!--[if lt IE 9]>
    <script src="assets/plugins/html5shiv.js"></script>
    <script src="assets/plugins/respond.min.js"></script>
    <![endif]-->
</head>

<body class="fix-header card-no-border logo-center">
    <div class="preloader">
        <svg class="circular" viewBox="25 25 50 50">
            <circle class="path" cx="50" cy="50" r="20" fill="none" stroke-width="2" stroke-miterlimit="10" />
        </svg>
    </div>

    <div id="main-wrapper">
        <!-- TOPO import -->
        @(admin.layout.topo)
        <!-- MENU import -->
        @(admin.layout.topo-menu)
        <!-- Page wrapper  -->
        <div class="page-wrapper">
            <!-- Container fluid  -->
            <div class="container-fluid">
                <!-- Bread crumb and right sidebar toggle -->
                <div class="row page-titles">
                    <div class="col-md-5 col-8 align-self-center">
                        <h3 class="text-themecolor m-b-0 m-t-0">Dashboard</h3>
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="javascript:void(0)">Loja</a></li>
                            <li class="breadcrumb-item active">Dashboard</li>
                        </ol>
                    </div>
                    <!-- Top Right Info -->
                    @(admin.layout.topo-info)
                </div>

                <!-- Start Page Content -->
                <div class="row">
                    <div class="col-sm-12 col-md-4">
                        <div class="card card-outline-primary">
                            <div class="card-header"><i class="text-white fas fa-chart-bar"></i> </div>
                            <a href="${baseUri}/cliente">
                                <div class="card-body ">

                                    <div class="row align-items-center">
                                        <div class="col-3 text-right"><i class="fa fa-users fa-4x" aria-hidden="true"></i></div>
                                        <div class="col-9 text-left">
                                            <h4>Clientes Cadastrados</h4>
                                            <h1 class="counter">
                                                <?= $data['clientes'] ?>
                                                <?php if (intval($data['clientes_30_dias']) > 0) : ?>
                                                    &nbsp;<span style="color: #69ff5B; font-size: 20px !important;"><i class="fa fa-line-chart" aria-hidden="true"></i> +<?= $data['clientes_30_dias'] ?> </span>
                                                <?php endif; ?>
                                            </h1>
                                        </div>
                                    </div>

                                </div>
                            </a>
                        </div>
                    </div>
                    <div class="col-sm-12 col-md-4">
                        <div class="card card-outline-primary">
                            <div class="card-header"><i class="text-white fas fa-chart-bar"></i> </div>
                            <a href="${baseUri}/produtos-lista">
                                <div class="card-body">
                                    <div class="row align-items-center">
                                        <div class="col-3 text-right"><i class="fa fa-archive fa-4x" aria-hidden="true"></i></div>
                                        <div class="col-9 text-left">
                                            <h4>Produtos Cadastrados</h4>
                                            <h1 class="counter">
                                                <?= $data['produtos'] ?>
                                                <?php if (intval($data['produtos_30_dias']) > 0) : ?>
                                                    &nbsp;<span style="color: #69ff5B; font-size: 20px !important;"><i class="fa fa-line-chart" aria-hidden="true"></i> +<?= $data['produtos_30_dias'] ?> </span>
                                                <?php endif; ?>
                                            </h1>
                                        </div>
                                    </div>
                                </div>
                            </a>
                        </div>
                    </div>
                    <div class="col-sm-12 col-md-4">
                        <div class="card card-outline-primary">
                            <div class="card-header"><i class="text-white fas fa-chart-bar"></i> </div>
                            <a href="${baseUri}/pedidos">
                                <div class="card-body">
                                    <div class="row align-items-center">
                                        <div class="col-3 text-right"><i class="fa fa-shopping-cart fa-4x" aria-hidden="true"></i></div>
                                        <div class="col-9 text-left">
                                            <h4>Pedidos Recebidos</h4>
                                            <h1 class="counter">
                                                <?= $data['pedidos'] ?>
                                                <?php if (intval($data['pedidos_30_dias']) > 0) : ?>
                                                    &nbsp;<span style="color: #69ff5B; font-size: 20px !important;"><i class="fa fa-line-chart" aria-hidden="true"></i> +<?= $data['pedidos_30_dias'] ?> </span>
                                                <?php endif; ?>
                                            </h1>
                                        </div>
                                    </div>
                                </div>
                            </a>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-sm-12">
                        <div class="card">
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-12">
                                        <div class="d-flex flex-wrap">
                                            <div>
                                                <h3 class="card-title">Vendas em
                                                    <select id="vendasAno" class="form-control">

                                                    </select>
                                                </h3>
                                                <h6 class="card-subtitle">Todas as vendas</h6>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-12">
                                        <div class="amp-pxl" style="height: 360px;"></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- End Page Content -->
                <!-- Config Tema botão float import -->

            </div>
            <!-- Footer import-->
            @(admin.layout.footer)
            <!-- End Footer -->
        </div>
        <!-- End Page wrapper  -->
    </div>
    <!-- All Jquery -->
    <script src="assets/plugins/jquery/jquery.min.js"></script>
    <script src="assets/plugins/jquery.mask.min.js"></script>
    <!-- Bootstrap tether Core JavaScript -->
    <script src="assets/plugins/popper/popper.min.js"></script>
    <script src="assets/plugins/bootstrap/js/bootstrap.min.js"></script>
    <!-- slimscrollbar scrollbar JavaScript -->
    <script src="assets/js/jquery.slimscroll.js"></script>
    <!--Wave Effects -->
    <script src="assets/js/waves.js"></script>
    <!--Menu sidebar -->
    <script src="assets/js/sidebarmenu.js"></script>

    <script src="assets/plugins/toast-master/js/jquery.toast.js"></script>
    <!--stickey kit -->
    <script src="assets/plugins/sticky-kit-master/dist/sticky-kit.min.js"></script>
    <script src="assets/plugins/sparkline/jquery.sparkline.min.js"></script>
    <!--Custom JavaScript -->
    <script src="assets/js/custom.min.js"></script>

    <!-- chartist chart -->
    <script src="assets/plugins/chartist-js/dist/chartist.min.js"></script>
    <script src="assets/plugins/chartist-plugin-tooltip-master/dist/chartist-plugin-tooltip.min.js"></script>
    <!--c3 JavaScript -->
    <script src="assets/plugins/d3/d3.min.js"></script>
    <script src="assets/plugins/c3-master/c3.min.js"></script>
    <!-- Style switcher -->
    <script src="assets/plugins/styleswitcher/jQuery.style.switcher.js"></script>
    <!-- PRINCIPAL JS -->
    <script src="assets/js/vue.min.js"></script>
    <script src="${baseUri}/view/admin/app-js/main.js"></script>
    <script src="assets/plugins/waypoint.min.js"></script>
    <script src="assets/plugins/counterup.min.js"></script>

    <script src="home.js"></script>
</body>

</html>