<!DOCTYPE html>
<html lang="pt-br">

<head>
    <base href="${baseUri}/view/admin/">
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="description" content="${config_site_description}">
    <meta name="author" content="${config_site_author}">
    <meta name="keywords" content="${config_site_keywords}">
    <link rel="icon" type="image/png" sizes="16x16" href="${baseUri}/media/site/${config_site_favicon}">
    <title>${config_site_title} - Frete</title>
    <link href="assets/plugins/bootstrap/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="assets/plugins/toast-master/css/jquery.toast.css">
    <link href="assets/plugins/bootstrap-select/bootstrap-select.min.css" rel="stylesheet" />
    <link href="assets/plugins/select2/dist/css/select2.min.css" rel="stylesheet" type="text/css" />
    <link href="assets/plugins/bootstrap-tagsinput/dist/bootstrap-tagsinput.css" rel="stylesheet" />
    <link href="assets/css/style.css" rel="stylesheet">
    <link href="assets/css/colors/${config_tema_color}.css" id="theme" rel="stylesheet">
</head>

<body class="fix-header card-no-border logo-center">
    <div class="preloader">
        <svg class="circular" viewBox="25 25 50 50">
            <circle class="path" cx="50" cy="50" r="20" fill="none" stroke-width="2" stroke-miterlimit="10" />
        </svg>
    </div>

    <div id="main-wrapper">
        @(admin.layout.topo)
        @(admin.layout.topo-menu)
        <div class="page-wrapper">
            <div class="container-fluid">
                <div class="row page-titles">
                    <div class="col-md-5 col-8 align-self-center">
                        <h3 class="text-themecolor m-b-0 m-t-0">Gerenciar Frete</h3>
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="javascript:void(0);">Loja</a></li>
                            <li class="breadcrumb-item"><a href="javascript:void(0)">Frete</a></li>
                            <li class="breadcrumb-item active">Gerenciar frete</li>
                        </ol>
                    </div>
                    @(admin.layout.topo-info)
                </div>

                <div class="row">
                    <div class="col-12">
                        <div class="card card-outline-primary">
                            <div class="card-header"><i class="text-white fas fa-th-list"></i>

                            </div>
                            <div class="card-body" id="vm">
                                <div class="content">
                                    <section>
                                        <ul class="nav nav-tabs">
                                            <li class="nav-item">
                                                <a class="nav-link active" style="cursor: pointer;" id="navGerais" data-id="partialGerais|navGerais">Geral</a>
                                            </li>
                                            <li class="nav-item">
                                                <a class="nav-link" style="cursor: pointer;" id="navKangu" data-id="partialKangu|navKangu">Kangu (Mercado Livre)</a>
                                            </li>
                                            <!--
                                            <li class="nav-item">
                                                <a class="nav-link" style="cursor: pointer;" id="navFrenet" data-id="partialFrenet|navFrenet">Frenet</a>
                                            </li>
                                            -->
                                            <li class="nav-item">
                                                <a class="nav-link" style="cursor: pointer;" id="navMelhorEnvio" data-id="partialMelhorEnvio|navMelhorEnvio">Melhor Envio</a>
                                            </li>
                                            <li class="nav-item">
                                                <a class="nav-link" style="cursor: pointer;" id="navFrete" data-id="partialFrete|navFrete">Frete Grátis</a>
                                            </li>
                                            <!--
                                            <li class="nav-item">
                                                <a class="nav-link" style="cursor: pointer;" id="navCorreios" data-id="partialCorreios|navCorreios">Correios</a>
                                            </li>    
                                            -->
                                            <li class="nav-item">
                                                <a class="nav-link" style="cursor: pointer;" id="navFaixa" data-id="partialFaixa|navFaixa">Faixa de Cep</a>
                                            </li>

                                        </ul>
                                        <br>
                                        <form action="${baseUri}/Frete/gravar" method="post">
                                            <input type="hidden" name="frete_id" value="${frete_id}">
                                            <div id="partialGerais" class="partials">
                                                @(admin.frete.partials.gerais)
                                            </div>
                                            <div id="partialFrete" class="partials">
                                                @(admin.frete.partials.frete)
                                            </div>
                                            <!--
                                            <div id="partialFrenet" class="partials">
                                                @(admin.frete.partials.frenet)
                                            </div>
                                            -->
                                            <div id="partialKangu" class="partials">
                                                @(admin.frete.partials.kangu)
                                            </div>
                                            <div id="partialMelhorEnvio" class="partials">
                                                @(admin.frete.partials.melhorenvio)
                                            </div>
                                            <div id="partialCorreios" class="partials">
                                                @(admin.frete.partials.correios)
                                            </div>
                                            <div class="row">
                                                <div class="col-sm-12 col-md-12 text-center">
                                                    <br>
                                                    <button class="btn btn-primary text-white btn-submit" type="submit" style="cursor: pointer;">Gravar Dados</button>
                                                </div>
                                            </div>
                                        </form>
                                        <div id="partialFaixa" class="partials">
                                            @(admin.frete.partials.faixa)
                                        </div>
                                    </section>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            @(admin.layout.footer)

        </div>
        @(admin.produto.modal-novo)
        @(admin.layout.modal-remove)
    </div>
    <script src="assets/plugins/jquery/jquery.min.js"></script>
    <script src="assets/plugins/popper/popper.min.js"></script>
    <script src="assets/plugins/bootstrap/js/bootstrap.min.js"></script>
    <script src="assets/js/jquery.slimscroll.js"></script>
    <script src="assets/js/waves.js"></script>
    <script src="assets/js/sidebarmenu.js"></script>
    <script src="assets/plugins/sticky-kit-master/dist/sticky-kit.min.js"></script>
    <script src="assets/plugins/sparkline/jquery.sparkline.min.js"></script>
    <script src="assets/js/custom.min.js"></script>
    <script src="assets/plugins/toast-master/js/jquery.toast.js"></script>
    <script src="assets/plugins/styleswitcher/jQuery.style.switcher.js"></script>
    <script src="assets/plugins/datatables.net/js/jquery.dataTables.min.js"></script>
    <script src="assets/plugins/datatables.net/js/dataTables.rowReorder.min.js"></script>
    <script src="assets/plugins/bootstrap-select/bootstrap-select.min.js" type="text/javascript"></script>
    <script src="assets/plugins/select2/dist/js/select2.full.min.js" type="text/javascript"></script>
    <script src="assets/plugins/bootstrap-tagsinput/dist/bootstrap-tagsinput.min.js" type="text/javascript"></script>
    <script src="assets/plugins/jquery.mask.min.js"></script>
    <script src="assets/js/jquery.cookie.js"></script>
    <script src="assets/js/vue.min.js"></script>
    <script src="${baseUri}/view/admin/app-js/datatable.js"></script>
    <script src="${baseUri}/view/admin/app-js/main.js"></script>
    <script src="${baseUri}/view/admin/frete/faixa/index.js"></script>
    <script type="text/javascript">
        var melhorenvio_servicos = '${frete_melhorenvio_servicos}';

        $('#frete_melhorenvio_servicos').val(melhorenvio_servicos.split(','));
        $('.menu-transportadoras').addClass('active');
        $('#frete_melhorenvio_servicos').select2();
        loadPartials();

        function loadPartials() {
            $(".partials").hide();
            $("#partialGerais").show();
        }
        $(".nav-link").click((e) => {
            if ($(e.target).attr('data-id')) {
                let target = $(e.target).attr('data-id').split('|');
                $(".nav-link").removeClass('active');
                $("#" + target[1]).addClass('active');
                $('.partials').hide();
                $("#" + target[0]).show();
                if (target[1] == 'navFaixa' || target[1] == 'navDif') {
                    $('.btn-submit').hide();
                } else {
                    $('.btn-submit').show();
                }
            }
        });

        $('#frete_opcoes').val('${frete_opcoes}');
        $('#frete_show_free').val('${frete_show_free}');
        $('#frete_frenet').val("${frete_frenet}").trigger("change");
        if ('${frete_pac}' == '1') {
            $('#frete_pac').attr('checked', 'checked');
        }
        if ('${frete_sedex}' == '1') {
            $('#frete_sedex').attr('checked', 'checked');
        }
        if ('${frete_sedex10}' == '1') {
            $('#frete_sedex10').attr('checked', 'checked');
        }
        $('.money').mask('000.000.000.000.000,00', {
            reverse: true
        });
        $("#frete_gratis_ativo").val("${frete_gratis_ativo}").trigger('change');
        $('#frete_melhorenvio').val("${frete_melhorenvio}").trigger("change");
        $('#frete_kangu').val("${frete_kangu}").trigger("change");

        /*
        $('#frete_braspress').mask('99999999999999');
        $('#frete_braspress_ativo').val('${frete_braspress_ativo}').trigger('change');
        $('#frete_jadlog_cnpj').mask('99999999999999');
        $('#frete_jamef_cnpj').mask('99999999999999');frete_gratis_ativo
        $('#frete_jadlog_ativo').val('${frete_jadlog_ativo}').trigger('change');
        $('#frete_redecargo_ativo').val('${frete_redecargo_ativo}').trigger('change');
        $('#frete_jamef_ativo').val('${frete_jamef_ativo}').trigger('change');
        $('#frete_tnt_ativo').val('${frete_tnt_ativo}').trigger('change');
        $('#frete_dlog_ativo').val('${frete_dlog_ativo}').trigger('change');
        */
    </script>

    <script>

    </script>
</body>

</html>