<!DOCTYPE html>
<html lang="pt-br">

<head>
    <base href="${baseUri}/view/admin/">
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="description" content="${config_site_description}">
    <meta name="author" content="${config_site_author}">
    <meta name="keywords" content="${config_site_keywords}">
    <link rel="icon" type="image/png" sizes="16x16" href="${baseUri}/media/site/${config_site_favicon}">
    <title>${config_site_title} - Faixa de Cep</title>
    <link href="assets/plugins/bootstrap/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="assets/plugins/toast-master/css/jquery.toast.css">
    <link href="assets/plugins/bootstrap-select/bootstrap-select.min.css" rel="stylesheet" />
    <link href="assets/plugins/bootstrap-tagsinput/dist/bootstrap-tagsinput.css" rel="stylesheet" />
    <link href="assets/css/style.css" rel="stylesheet">
    <!-- You can change the theme colors from here -->
    <link href="assets/css/colors/${config_tema_color}.css" id="theme" rel="stylesheet">
    <!--[if lt IE 9]>
    <script src="assets/plugins/html5shiv.js"></script>
    <script src="assets/plugins/respond.min.js"></script>

    <![endif]-->
</head>

<body class="fix-header card-no-border logo-center">
    <div class="preloader">
        <svg class="circular" viewBox="25 25 50 50">
            <circle class="path" cx="50" cy="50" r="20" fill="none" stroke-width="2" stroke-miterlimit="10" />
        </svg>
    </div>

    <div id="main-wrapper">
        @(admin.layout.topo)
        @(admin.layout.topo-menu)
        <div class="page-wrapper">
            <div class="container-fluid">
                <div class="row page-titles">
                    <div class="col-md-5 col-8 align-self-center">
                        <h3 class="text-themecolor m-b-0 m-t-0">Faixas de CEP</h3>
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="javascript:void(0);">Loja</a></li>
                            <li class="breadcrumb-item"><a href="javascript:void(0);">Frete</a></li>
                            <li class="breadcrumb-item active">Faixas de CEP</li>
                        </ol>
                    </div>
                    @(admin.layout.topo-info)
                    <div class="col-md-7 col-4 align-self-center">
                        <h6 class="float-right" style="padding-top: 20px">
                            <a id="novo-slide" data-id="ProdutosAdmin:G" class="btn btn-primary waves-effect waves-light text-white menu-access" href="${baseUri}/faixa-novo/">
                                <i class="fa fa-plus-circle"></i> Novo
                            </a>
                        </h6>
                    </div>
                </div>

                <div class="row">
                    <div class="col-12">
                        <div class="card card-outline-primary">
                            <div class="card-header"><i class="text-white fas fa-th-list"></i>

                            </div>
                            <div class="card-body" id="vm">
                                <div class="content">
                                    <div id="tbl-splash" class="spinner-border" style="width: 5rem; height: 5rem; margin-top: 5%; margin-left: 50%" role="status"></div>
                                    <div id="tbl-div" class="table-responsive m-ts-40">
                                        <table id="datatable" class="datatable display nowrap table table-hover table-striped table-bordered" cellspacing="0" width="100%">
                                            <thead>
                                                <tr>
                                                    <th class="">Serviço <i class="fa fa-sort" aria-hidden="true" style="cursor: pointer"></i></th>
                                                    <th class="">CEP Início <i class="fa fa-sort" aria-hidden="true" style="cursor: pointer"></i></th>
                                                    <th class="">CEP Final <i class="fa fa-sort" aria-hidden="true" style="cursor: pointer"></i></th>
                                                    <th class="">Peso De (g) <i class="fa fa-sort" aria-hidden="true" style="cursor: pointer"></i></th>
                                                    <th class="">Peso Até (g) <i class="fa fa-sort" aria-hidden="true" style="cursor: pointer"></i></th>
                                                    <th class="">Valor <i class="fa fa-sort" aria-hidden="true" style="cursor: pointer"></i></th>
                                                    <th class="">Prazo <i class="fa fa-sort" aria-hidden="true" style="cursor: pointer"></i></th>
                                                    <th class="d-print-none text-right">Ações</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <tr v-for="post in faixas" :class="'faixas-editar-' + post.faixa_cep_id" :id="'faixa-id-' + post.faixa_cep_id">
                                                    <td class="">{{post.faixa_cep_desc}}</td>
                                                    <td class="">{{post.faixa_cep_inicio}}</td>
                                                    <td class="">{{post.faixa_cep_final}}</td>
                                                    <td class="">{{post.faixa_cep_peso_de}}</td>
                                                    <td class="">{{post.faixa_cep_peso_ate}}</td>
                                                    <td class="">R$ {{post.faixa_cep_valor}}</td>
                                                    <td class="">{{post.faixa_cep_prazo}}</td>
                                                    <td class="d-print-none text-right">
                                                        <a class="btn btn-sm text-white btn-primary waves-effect waves-light  menu-acces" title="editar" data-toggle="tooltip" data-id="ProdutosAdmin:G" :href="'${baseUri}/faixa-editar/id/' + post.faixa_cep_id">
                                                            <i class="fas fa-edit"></i>
                                                        </a>
                                                        <button class="btn btn-sm btn-danger menu-access" data-id="ProdutosAdmin:G" data-toggle="tooltip" title="remover" v-on:click="remover(post)">
                                                            <i class="fas fa-trash"></i>
                                                        </button>
                                                    </td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </div>

                                    <div class="row " id="mob-tbl">
                                        <div class="row" v-if="faixas == null">
                                            <div class="col-12 text-center">
                                                <label>Nenhum registro encontrado</label>
                                            </div>
                                        </div>
                                        <div v-for="post in faixas" v-else>
                                            <div class="col-12">
                                                <div class="row">
                                                    <div class="col-10 align-self-center">
                                                        <h3>CEP de {{post.faixa_cep_inicio}} <br>Até {{post.faixa_cep_final}}</h3>
                                                        <label>Peso de {{post.faixa_cep_peso_de}}(g) até {{post.faixa_cep_peso_ate}}(g)</label>
                                                        <br>
                                                        <label>Valor: R${{post.faixa_cep_valor}}</label>
                                                        <br>

                                                        <label>Prazo: {{post.faixa_cep_prazo}}</label>
                                                        <br>
                                                    </div>
                                                    <div class="col-2 align-self-start pt-0 mt-0 text-right">
                                                        <div class="row align-items-start">
                                                            <div class="col-12 align-self-start pb-4">
                                                                <div class="dropdown">
                                                                    <button class="btn dropdown-toggle" type="button" id="dropdownMenuButton" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"></button>
                                                                    <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                                                                        <a class="dropdown-item" :href="'${baseUri}/faixa-editar/id/' + post.faixa_cep_id" data-id="BlogAdmin:G">
                                                                            <i class="fas fa-edit"></i>
                                                                            Editar</a>
                                                                        <a class="dropdown-item" v-on:click="remover(post)" data-id="BlogAdmin:G">
                                                                            <i class="fas fa-trash"></i>
                                                                            Excluir</a>

                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>

                                                        <div class="row">
                                                            <div class="col-12 align-self-end">
                                                                <a v-on:click="prepare_muda_status(dt)" style="cursor: pointer" data-toggle="tooltip" :title="post.status_nome">
                                                                    <span v-if="post.status == 1"><i class="fa fa-2x fa-toggle-on text-primary"></i></span>
                                                                    <span v-else><i class="fa fa-toggle-off fa-2x "></i></span>
                                                                </a>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="row">
                                                    <div class="col-12">
                                                        <hr>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            @(admin.layout.footer)

        </div>
        @(admin.layout.modal-remove)
    </div>
    <script src="assets/plugins/jquery/jquery.min.js"></script>
    <!-- Bootstrap tether Core JavaScript -->
    <script src="assets/plugins/popper/popper.min.js"></script>
    <script src="assets/plugins/bootstrap/js/bootstrap.min.js"></script>
    <!-- slimscrollbar scrollbar JavaScript -->
    <script src="assets/js/jquery.slimscroll.js"></script>
    <!--Wave Effects -->
    <script src="assets/js/waves.js"></script>
    <!--Menu sidebar -->
    <script src="assets/js/sidebarmenu.js"></script>
    <!--stickey kit -->
    <script src="assets/plugins/sticky-kit-master/dist/sticky-kit.min.js"></script>
    <script src="assets/plugins/sparkline/jquery.sparkline.min.js"></script>
    <!--Custom JavaScript -->
    <script src="assets/js/custom.min.js"></script>
    <script src="assets/plugins/toast-master/js/jquery.toast.js"></script>
    <!-- Style switcher -->
    <script src="assets/plugins/styleswitcher/jQuery.style.switcher.js"></script>
    <!-- This is data table -->
    <script src="assets/plugins/datatables.net/js/jquery.dataTables.min.js"></script>
    <script src="assets/plugins/bootstrap-select/bootstrap-select.min.js" type="text/javascript"></script>
    <!-- start - This is for export functionality only -->
    <script src="assets/plugins/datatables-button/dataTables.buttons.min.js"></script>
    <script src="assets/plugins/datatables-button/buttons.flash.min.js"></script>
    <script src="assets/plugins/datatables-button/jszip.min.js"></script>
    <script src="assets/plugins/datatables-button/pdfmake.min.js"></script>
    <script src="assets/plugins/datatables-button/vfs_fonts.js"></script>
    <script src="assets/plugins/datatables-button/buttons.html5.min.js"></script>
    <script src="assets/plugins/datatables-button/buttons.print.min.js"></script>
    <script src="assets/plugins/jquery.mask.min.js"></script>
    <script src="assets/js/jquery.cookie.js"></script>
    <!-- PRINCIPAL JS -->
    <script src="assets/js/vue.min.js"></script>
    <script src="assets/plugins/dropify/dist/js/dropify.min.js"></script>
    <script src="${baseUri}/view/admin/app-js/datatable.js"></script>
    <script src="${baseUri}/view/admin/app-js/main.js"></script>
    <script src="frete/faixa/index.js"></script>
    <script type="text/javascript">
        $(".menu-frete").addClass('active');
        $(".menu-faixa").addClass('active');
        // loadPartials();

        function loadPartials() {
            $(".partials").hide();
            $("#partialGerais").show();
        }

        $(".nav-link").click((e) => {
            if ($(e.target).attr('data-id')) {
                let target = $(e.target).attr('data-id').split('|');
                $(".nav-link").removeClass('active');
                $("#" + target[1]).addClass('active');

                $('.partials').hide();
                $("#" + target[0]).show();
            }
        });
    </script>

    <script>

    </script>
</body>

</html>