var table;
var vm = new Vue({
    el: '#vm',
    data:{
        categoria: null,
        rm: null,
        url: null,
    },
    methods:{
        listar: function () {
            var url = baseUri + '/FaqAdmin/lista_categoria/';
            var self = this;
            $.getJSON(url, {}, function (dados) {
                splash_dt();
            }).then(function (dados) {
                self.categoria = dados;
                setTimeout(function () {
                    $('#tbl-splash').hide().promise().done($('#tbl-div').show());
                    table = $('#datatable').DataTable({
                        language: datatable_ptbr,
                        aaSorting: [],
                        retrieve: true,
                        responsive: true,
                        rowReorder: true,
                        "displayLength": 100,
                        "pageLength": 100,
                    });
                    reload_dt_vue();
                }, 500);
              
            });
        },
        
        editar: function (cat) {
            this.limpar();
            $('.categoria-acao').html('Alterar');
            $('#modal-categoria').modal('show');
            $('#categoria_faq_nome').val(cat.categoria_faq_nome);
            $('#categoria_faq_id').val(cat.categoria_faq_id);
        },
        limpar: function () {
            $('.categoria-acao').html('Incluir');
            $('#categoria_faq_nome').val('');
            $('#categoria_faq_id').val('');
        },
        remover: function (dt) {
            vm.$data.rm = dt.categoria_faq_id;
            $('#modal-remove').modal('show');
        },
        remove: function (id) {
            var url_remove = baseUri + '/FaqAdmin/remover_categoria/';
            $.post(url_remove, {id: id}).then(function (rs) {
                if(rs == 1){
                    alert_success('Ação realizada com sucesso!', 'Item removido');
                    vm.listar();
                }else{
                    alert_error('Ação não pode ser realizada!');
                }
            });
            $('#modal-remove').modal('hide');
        }
    },
    created: function () {
        $('#tbl-div').hide().promise().done($('#tbl-splash').show());
        this.listar();
    }
});
// click do modal
$('#btn-remove').on('click', function () {
    if(vm.$data.rm !== null){
        vm.remove(vm.$data.rm, vm.$data.url);
    }
});
$('#nova-categoria').on('click', function () {
    vm.limpar();
    $('#modal-categoria').modal('show');
});

$(document).ready(function () {
    setTimeout(function () {
        table.on('row-reorder', function (e, diff, edit,) {
            var url = baseUri + '/faqAdmin/ordenar/';
            if (diff.length > 0) {
                $.post(url, { diff: JSON.stringify(diff) }).then(function (rs) {
                    vm.listar();
               
                });
            }
        });
    }, 1200);
});